package com.mapr.baseutils.audit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import com.mapr.fs.proto.Common.IPAddress;
import com.mapr.fs.proto.Security.CredentialsMsg;

public class AuditRecord {

  final TimeZone tz = TimeZone.getTimeZone("UTC");
  final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
  
  public enum Op {
    passwordAuth,
    kerberosAuth,
    generateTicket,
    renewTicket,
    volumeCreate,
    volumeModify,
    volumeRemove,
    volumeRename,
    volumeMount,
    volumeUnmount,
    volumeConvert,
    volumePutInGfsck,
    volumeLookup,
    volumeList,
    volumePromote,
    volumeRemoveFromGfsck,
    volumeShowMounts,
    volumePropertiesLookup,
    volumeMove,
    volumeMirrorStart,
    volumeMirrorStop,
    volumeMirrorPermCheck,
    volumeMirrorRestoreInit,
    volumeMirrorRestoreUpdate,
    snapshotRemove,
    fileServerRemove,
    fileServerMove,
    fileServerModify,
    fileServerAllowInCluster,
    fileServerMaintenance,
    fileServerLookup,
    fileServerList,
    clusterUpgrade,
    clusterInfo,
    getClusterTopology,
    changeLogLevel,
    policyCreate,
    policyModify,
    policyRemove,
    policyGet,
    alarmAdd,
    alarmRemove,
    alarmEdit,
    alarmView,
    alarmLookup,
    alarmUpdate,
    aeLookup,
    aeModify,
    dumpInfo,
    aclShow,
    aclModify,
    configRead,
    configTest,
    configModify,
    licenseAdd,
    licenseRemove,
    licenseShow,
    addCRL,
    showCRL,
    eulaAccept,
    eulaShowAccept,
    dialhomeEnable,
    dialhomeStatus,
    dialhomeSuccessfulAck,
    dialhomeLastDialedResp,
    rlimitGet,
    rlimitSet,
    getTabletInfo,
    gatewayConfigSet,
    gatewayConfigGet,
    gatewayConfigList,
    gatewayConfigDelete,
    getLicenseId,
    getServerKey,
    getServerTicket,
    getClusterKey,
    getMapRUserTicket,
    blacklist,
    listBlacklist,
    dbreplGatewayConfigSet,
    dbreplGatewayConfigGet,
    dbreplGatewayConfigList,
    dbreplGatewayConfigDelete,
    addVirtualIps,
    listVirtualIps,
    moveVirtualIps,
    removeVirtualIps,
    modifyVirtualIps,
    fetchPolicies,
    enableFeatures,
    listFeatures,
    clientAuthorizationRequest,
    canRemoveSp,
    mirrorValidateStart,
    aeRemove;
   }
 
  private boolean forceAudit;
  private long epoch;
  private String isoDate;
  private String resource;
  private Op op;
  private String clientIp;
  private int uid;
  private int gid;
  private int status;
  private String username;
  private boolean populateTargetUser;
  private int targetUid;
  private int targetGid;
  private KeyValue keyValue;
  private List<KeyValue> keyValues;
  private boolean keyValuesSR;

  private void setDate() {
    epoch = System.currentTimeMillis();
    isoDate = df.format(new Date(epoch));
  }

  public AuditRecord() {
    df.setTimeZone(tz);
    setDate();
    this.clientIp = null;
    this.resource = null;
    this.op = null;
    this.keyValue = new KeyValue();
    this.keyValues = null;
    this.uid = -1;
    this.gid = -1;
    this.status = -1;
    this.populateTargetUser = false;
    this.targetUid = -1;
    this.targetGid = -1;
    this.username = null;
    this.forceAudit = false;
    this.keyValuesSR = false;
  }

  public void init(IPAddress ip) {
    String ipAddr = intToIp(ip.getHost());
    init(ipAddr);
  }
  
  public void init(String ip) {
    setDate();
    this.clientIp = ip;
  }

  public void setCreds(CredentialsMsg creds) {
    if (creds == null) {
      return;
    }
    if (creds.hasUid()) {
      this.uid = creds.getUid();
    }
    if (creds.getGidsCount() > 0) {
      this.gid = creds.getGids(0);
    }
  }

  public void clear() {
    this.keyValue.reInit();
    this.clientIp = null;
    this.resource = null;
    this.op = null;
    this.keyValues = null;
    this.uid = -1;
    this.gid = -1;
    this.status = -1;
    this.populateTargetUser = false;
    this.targetUid = -1;
    this.targetGid = -1;
    this.username = null;
    this.forceAudit = false;
    this.keyValuesSR = false;
  }

  public String getResource() {
    return resource;
  }

  public void setResource(String resource) {
    this.resource = resource;
  }

  public Op getOp() {
    return op;
  }

  public void setOp(Op op) {
    this.op = op;
  }

  public String getClientIp() {
    return clientIp;
  }

  public void setKeyValuesSR(boolean val) {
    keyValuesSR = val;
  }

  public boolean getKeyValuesSR() {
    return keyValuesSR;
  }

  public void setValues(String key, String oldValue, String newValue) {
    keyValue.setValues(key, oldValue, newValue);
  }

  public KeyValue getKeyValue() {
    return keyValue;
  }

  public List<KeyValue> getKeyValues() {
    return keyValues;
  }

  public void addAllKeyValues(List<KeyValue> keyValues) {
    if (keyValues == null) 
      return;

    if (this.keyValues == null)
      this.keyValues = new ArrayList<KeyValue>();

    this.keyValues.addAll(keyValues);
  }

  public void setKeyValues(List<KeyValue> keyValues) {
    this.keyValues = keyValues;
  }

  public void addKeyValue(KeyValue keyValue) {
    if (keyValues == null)
      keyValues = new ArrayList<KeyValue>();

    keyValues.add(keyValue);
  }

  public long getEpoch() {
    return epoch;
  }

  public String getIsoDate() {
    return isoDate;
  }

  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public int getUid() {
    return uid;
  }

  public void setUid(int uid) {
    this.uid = uid;
  }

  public int getGid() {
    return gid;
  }

  public void setGid(int gid) {
    this.gid = gid;
  }

  public boolean populateTargetUser() {
    return populateTargetUser;
  }

  public void setPopulateTargetUser(boolean val) {
    populateTargetUser = val;
  }

  public int getTargetUid() {
    return targetUid;
  }

  public void setTargetUid(int uid) {
    targetUid = uid;
  }

  public int getTargetGid() {
    return targetGid;
  }

  public void setTargetGid(int gid) {
    targetGid = gid;
  }

  public int getStatus() {
    return status;
  }

  public void setStatus(int status) {
    this.status = status;
  }

  public boolean getForceAudit() {
    return forceAudit;
  }

  public void setForceAudit(boolean forceAudit) {
    this.forceAudit = forceAudit;
  }
  
  private String intToIp(int i) {
    StringBuilder sb = new StringBuilder();
    sb.append((i >> 24 ) & 0xFF);
    sb.append(".");
    sb.append((i >> 16 ) & 0xFF);
    sb.append(".");
    sb.append((i >>  8 ) & 0xFF);
    sb.append(".");
    sb.append(i & 0xFF);
    return sb.toString();
  }

}
