package com.mapr.baseutils.audit;

import static com.mapr.baseutils.audit.AuditConstants.*;

public class AclKeyValue extends KeyValue {
  private int id;
  private boolean isUid;
  private String oldPerm;
  private String newPerm;

  public AclKeyValue(int id, String oldPerm, String newPerm, boolean isUid) {
    this.id = id;
    this.oldPerm = oldPerm;
    this.newPerm = newPerm;
    this.isUid = isUid;
  }

  public boolean hasValues() {
    return true;
  }

  /**
   * Example output :
   * "resource":"cluster","values":{"uid":1000,"oldValue":["a"],"newValue":["a","fc"]}
   */
  public String toJsonString() {
    StringBuilder sb = new StringBuilder();
    sb.append(QUOTE);
    sb.append(PROPERTIES);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(OPENFLOWER);
    sb.append(QUOTE);
    if (isUid)
      sb.append(UID);
    else
      sb.append(GID);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(id);
    sb.append(COMMA);
    sb.append(QUOTE);
    sb.append(OLDVALUE);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(OPENSQUARE);
    if (oldPerm != null)
      sb.append(oldPerm);
    sb.append(CLOSEDSQUARE);
    sb.append(COMMA);
    sb.append(QUOTE);
    sb.append(NEWVALUE);
    sb.append(QUOTE);
    sb.append(COLON);
    sb.append(OPENSQUARE);
    if (newPerm != null)
      sb.append(newPerm);
    sb.append(CLOSEDSQUARE);
    sb.append(CLOSEDFLOWER);

    return sb.toString();
  }
}
