package com.mapr.baseutils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;

import org.apache.log4j.Logger;

public class URLProbingUtility {

	private static final Logger LOG = Logger.getLogger(URLProbingUtility.class);
	
	/**
	 * Utility to test URL validity
	 * @param testUrl - has to be URL decoded
	 * @return
	 */
	public static boolean isURLReachable(String testUrl) {
		try {
		   URL url = new URL(testUrl);
		   String protocol = url.getProtocol();

		   HttpURLConnection connection;
		   if ( "http".equalsIgnoreCase(protocol) ) {
			    connection = (HttpURLConnection) url.openConnection();  
		   } else if ("https".equalsIgnoreCase(protocol) ){
			    connection = (HttpsURLConnection) url.openConnection();  
		   } else {
			   LOG.error("URL has to be either http or https. No other formats are supported");
			   return false;			   
		   }
		    HttpsURLConnection.setFollowRedirects(true);
		    
		    int responseCode = connection.getResponseCode();
		    if ( responseCode != 200 ) {
		      if ( responseCode > 400 && responseCode < 500 ) {
		        // we may be asked for Authentication and confuse it with 
		        Map<String, List<String>> headers = connection.getHeaderFields();
		        if ( headers.containsKey("WWW-Authenticate")) {
		          // authentication is required
		          LOG.warn(testUrl + " requires authentication");
		          return true;
		        }
		      }
		    	LOG.error("URL: " + testUrl + " returns invalid code: " + responseCode);
		    	return false;
		    }
		} catch (MalformedURLException e) {
			LOG.error("URL: " + testUrl + " is malformed", e);
			return false;
		} catch (IOException x) {
			LOG.error("URL: " + testUrl + " can not be reached", x);
			return false;
		}

		return true;
	}
	
	/**
	 * Test function
	 * @param args
	 */
	public static void main(String [] args) {
		if ( args == null || args.length == 0 ) {
			return;
		}
		System.out.println(isURLReachable(args[0]));
	}
}
