package com.mapr.baseutils;

import java.util.BitSet;

public class BitSetBytesHelperUtils {

  /**
   * Convert BitSet to byte array
   * @param bits
   * @return
   */
  public static byte[] toByteArray(BitSet bits) {
    byte[] bytes = new byte[(bits.length() + 7)/8];
    for (int i=0; i<bits.length(); i++) {
        if (bits.get(i)) {
            bytes[bytes.length-i/8-1] |= 1<<(i%8);
        }
    }
    return bytes;
  }
  
  /**
   * Convert byte array to BitSet
   * @param bytes
   * @return
   */
  public static BitSet fromByteArray(byte[] bytes) {
    BitSet bits = new BitSet();
    for (int i=0; i<bytes.length*8; i++) {
        if ((bytes[bytes.length-i/8-1]&(1<<(i%8))) != 0) {
            bits.set(i);
        }
    }
    return bits;
  }

  // method to help maintaining backward compatibility
  // between "old" CLDB and "new CLI"
  public static long convert(BitSet bits) {
    long value = 0L;
    for (int i = 0; i < bits.length() && i < 64; ++i) {
      value |= bits.get(i) ? (1L << i) : 0L;
    }
    // for bits that go beyond 64 (long limit)
    // set "rotating" bits if not set yet
    // that is exactly what we are trying to fix
    // but need to pass to CLDB this way in old field 
    for ( int i = 64; i < bits.length(); i++) {
      int j = i - 64;
      if ( bits.get(i) && !bits.get(j)) {
        value |= (1L << j);
      }
    }
    return value;
  }
  
  // method to help maintaining backward compatibility
  // between "old" maprcli and "new" CLDB
  // in case old "columns" field" set, but noew one is not
  public static BitSet convert(long value) {
    BitSet bits = new BitSet();
    int index = 0;
    while (value != 0L) {
      if (value % 2L != 0) {
        bits.set(index);
      }
      ++index;
      value = value >>> 1;
    }
    return bits;
  }

}
