/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.audit;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentFIFOHashMap<K,V> {

  private ConcurrentHashMap<K, V> map;
  private ConcurrentLinkedQueue<K> queue;

  private final int maxSize;

  ConcurrentFIFOHashMap(int maxSize)
  {
    this.maxSize = maxSize;
    map = new ConcurrentHashMap<K, V>(maxSize);
    queue = new ConcurrentLinkedQueue<K>();
  }

  synchronized public void put(K key, V value)
  {
    if (map.containsKey(key)) return; 

    while (queue.size() >= maxSize) {
      K oldestKey = queue.poll();
      if (oldestKey != null) map.remove(oldestKey);
    }
    queue.add(key);
    map.put(key, value);
  }

  public V get(K key) 
  {
    return map.get(key);
  }
}
