/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class RemoteCommandExecutor {
    private static final Logger LOG = Logger.getLogger(RemoteCommandExecutor.class);
    private static final int HOSTSTATS_RPC_PORT = 1111;
    private static final String CLUSTER = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    private static Map<String, String> hostNameToMapRIpCache = new ConcurrentHashMap<String, String>();

    public static List<String> execute(String remoteHost, ClusterMetricsProto.ExecuteCommandRequest request) throws CLIProcessingException {
        try {
            MapRLoginHttpsClient loginClient = new MapRLoginHttpsClient();
            loginClient.authenticateIfNeeded(CLUSTER);
            String hostName = remoteHost;
            if (hostNameToMapRIpCache.containsKey(remoteHost)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will use " + hostNameToMapRIpCache.get(remoteHost) + " instead of " + remoteHost + " for RPC"));
                }
                remoteHost = hostNameToMapRIpCache.get(remoteHost);
            }
            ClusterMetricsProto.CommandId commandId = request.getCommandId();
            long hsBinding = RemoteCommandExecutor.createBinding(remoteHost);
            byte[] retBytes = Rpc.sendRequest((long)hsBinding, (int)Common.MapRProgramId.HoststatsProgramId.getNumber(), (int)ClusterMetricsProto.MetricProcId.ExecuteCommandProc.getNumber(), (MessageLite)request);
            if (retBytes == null) {
                Common.IPAddress.Builder ipAddressBuilder = Common.IPAddress.newBuilder();
                ipAddressBuilder.setHostname(remoteHost);
                Common.IPAddress fileServer = ipAddressBuilder.build();
                CLDBProto.FileServerInfo remoteFsInfo = NodesCommonUtils.getFileServerInfo(fileServer, request.getCreds(), null);
                if (remoteFsInfo == null || remoteFsInfo.getAddressCount() == 0) {
                    LOG.error((Object)("FileServerLookup for " + remoteHost + " did not return any valid ip addresses." + " The node possibly does not belong to cluster '" + CLUSTER + "'"));
                    throw new CLIProcessingException("RPC to execute '" + commandId.name() + "' on node: " + remoteHost + " returned no data. The node may no longer be part of cluster '" + CLUSTER + "'");
                }
                for (Common.IPAddress server : remoteFsInfo.getAddressList()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Trying RPC to hoststats on " + Util.intToIp((int)server.getHost())));
                    }
                    if ((retBytes = Rpc.sendRequest((long)(hsBinding = RemoteCommandExecutor.createBinding(Util.intToIp((int)server.getHost()))), (int)Common.MapRProgramId.HoststatsProgramId.getNumber(), (int)ClusterMetricsProto.MetricProcId.ExecuteCommandProc.getNumber(), (MessageLite)request)) == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Caching entry " + hostName + " -> " + Util.intToIp((int)server.getHost())));
                    }
                    hostNameToMapRIpCache.put(hostName, Util.intToIp((int)server.getHost()));
                    break;
                }
            }
            if (retBytes != null) {
                ClusterMetricsProto.ExecuteCommandResponse response = ClusterMetricsProto.ExecuteCommandResponse.parseFrom((byte[])retBytes);
                int status = response.getStatus();
                if (status != 0) {
                    String msg = "Operation '" + commandId.name() + "' on node: " + remoteHost + " failed with status: " + status;
                    if (response.hasErrorMsg()) {
                        msg = msg + ". Reason: '" + response.getErrorMsg() + "'";
                    }
                    throw new CLIProcessingException(msg);
                }
                return response.getStdoutLinesList();
            }
            throw new CLIProcessingException("RPC to execute '" + commandId.name() + "' on node: " + remoteHost + " returned no data.");
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("Error parsing the RPC response");
        }
        catch (Exception e) {
            if (e instanceof CLIProcessingException) {
                throw (CLIProcessingException)e;
            }
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private static long createBinding(String remoteHost) throws Exception {
        int host = CLDBRpcCommonUtils.ipToInt(CLDBRpcCommonUtils.convertHostToIp(remoteHost));
        try {
            int result = Rpc.initialize((int)0, (int)0, (String)CLUSTER);
            if (result < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            throw new IOException("Exception in Rpc.initialize " + e);
        }
        if (JNISecurity.IsSecurityEnabled(CLUSTER)) {
            MutableInt mErr = new MutableInt();
            Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, CLUSTER, mErr);
            if (mErr.GetValue() != 0 || !Security.IsTicketAndKeyUsable(ticketAndKey)) {
                LOG.warn((Object)("Error while trying to get correct Ticket with errorCode: " + mErr.GetValue()));
                return -1L;
            }
        }
        return Rpc.createBindingFor((int)host, (int)1111, (String)CLUSTER, (int)Security.ServerKeyType.ServerKey.getNumber());
    }
}

