/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.DateInputParameter;
import com.mapr.fs.cldb.dialhome.metrics.MetricsReader;
import com.mapr.fs.cldb.dialhome.metrics.MetricsUtil;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.dialhome.MetricsProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import com.mapr.util.MapRFSUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.zip.Deflater;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DialHomeCommands
extends CLIBaseClass {
    private static final Logger LOG = Logger.getLogger(DialHomeCommands.class);
    private static final String FOR_DAY = "forDay";
    private static final String ENABLE = "enable";
    static final CLICommand metricsCmd = new CLICommand("metrics", "get dialhome metrics", DialHomeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"forDay", (Object)new DateInputParameter("forDay", "Date for which metrics are being queried. Accepted values: UTC timestamp in millisecond or a UTC date in MM/DD/YY format", true, (Object)DialHomeCommands.getYesterday())).build(), null).setShortUsage("dialhome metrics -forDay <MM/DD/YY>");
    static final CLICommand enableCmd = new CLICommand("enable", "enable/disable dialhome", DialHomeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"enable", (Object)new BooleanInputParameter("enable", "enable/disable dialhome", true, Boolean.valueOf(true))).build(), null).setShortUsage("dialhome metrics -enable <true/false>");
    static final CLICommand statusCmd = new CLICommand("status", "query if dial home is enabled/disabled", DialHomeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null);
    static final CLICommand ackDialCmd = new CLICommand("ackdial", "ack a successful dial home", DialHomeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"forDay", (Object)new DateInputParameter("forDay", "Date for which the recorded metrics were successfully dialed home. Accepted values: UTC timestamp in millisecond or a UTC date in MM/DD/YY format", true, (Object)DialHomeCommands.getYesterday())).build(), null).setShortUsage("dialhome ackdial -forDay <MM/DD/YY>");
    static final CLICommand lastDialedCmd = new CLICommand("lastdialed", "query the last successful dial home date", DialHomeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null);
    public static final CLICommand dialhomeCmds = new CLICommand("dialhome", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{metricsCmd, enableCmd, statusCmd, ackDialCmd, lastDialedCmd}).setShortUsage("dialhome [metrics|enable|status|ackdial|lastdialed]");

    public DialHomeCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("metrics")) {
            this.getDialHomeMetrics(out);
        } else if (cmd.equalsIgnoreCase(ENABLE)) {
            this.enableDialHome(out, this.getParamBooleanValue(ENABLE, 0));
        } else if (cmd.equalsIgnoreCase("status")) {
            this.getDialHomeStatus(out);
        } else if (cmd.equalsIgnoreCase("ackdial")) {
            this.ackDialHome(out);
        } else if (cmd.equalsIgnoreCase("lastdialed")) {
            this.getLastDialedDate(out);
        }
        return output;
    }

    private void getDialHomeMetrics(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.DialHomeStatusResponse resp = this.getDialHomeStatusResponse();
        if (resp == null || resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Couldn't retrieve metrics as the request to fetch dial home status failed"));
        } else if (!resp.hasDialHomeStatus()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Couldn't retrieve metrics as the dial home status could not be known"));
        } else if (resp.getDialHomeStatus().equals((Object)CLDBProto.DialHomeStatus.ENABLED)) {
            Date forDay = this.getParamDateValue(FOR_DAY, 0);
            MetricsProto.DayMetrics metricsForDay = this.getMetricsForDay(forDay.getTime());
            if (metricsForDay != null) {
                byte[] unCompressedDayMetrics = metricsForDay.toByteArray();
                byte[] compressedDayMetrics = this.compress(unCompressedDayMetrics);
                MetricsProto.MetricsData metricsData = MetricsProto.MetricsData.newBuilder().setCompressedDayMetrics(ByteString.copyFrom((byte[])compressedDayMetrics)).setRawDayMetricsSize(unCompressedDayMetrics.length).build();
                CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("metrics", (Object)metricsData.toByteArray()));
                out.addNode(outputNode);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10014, Errno.toString(10014)));
            }
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10013, "Couldn't retrieve metrics. " + Errno.toString(10013)));
        }
    }

    private void enableDialHome(CommandOutput.OutputHierarchy out, boolean enable) throws CLIProcessingException {
        CLDBProto.DialHomeEnableRequest.Builder req = CLDBProto.DialHomeEnableRequest.newBuilder().setEnable(enable).setCreds(this.getUserCredentials());
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeEnableRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.DialHomeEnableResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeEnableRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.DialHomeEnableResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.DialHomeEnableResponse resp = CLDBProto.DialHomeEnableResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                if (resp.hasFailureReason()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Request to " + (enable ? ENABLE : "disable") + " failed. Reason: " + resp.getFailureReason()));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Request to " + (enable ? ENABLE : "disable") + " failed."));
                }
            } else {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("enabled", enable ? 1 : 0));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("InvalidProtocolBufferException  Exception", (Throwable)e);
        }
    }

    private void getDialHomeStatus(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.DialHomeStatusResponse resp = this.getDialHomeStatusResponse();
        if (resp == null || resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Request to fetch dial home status failed"));
        } else if (!resp.hasDialHomeStatus()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "No dial home status in the response"));
        } else {
            CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", this.getStatusAsInt(resp.getDialHomeStatus())));
            out.addNode(outputNode);
        }
    }

    private void ackDialHome(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Date forDay = this.getParamDateValue(FOR_DAY, 0);
        if (!forDay.before(new Date())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Date cannot be in future"));
            return;
        }
        try {
            if (!forDay.after(DateFormat.getDateInstance(3).parse("1/1/70"))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Date cannot be before unix epoch (1/1/70)"));
                return;
            }
        }
        catch (ParseException e) {
            LOG.error((Object)"Date cannot be before unix epoch (1/1/70)", (Throwable)e);
        }
        LOG.info((Object)("Sending RPC to CLDB to set lastdialed to " + forDay.getTime()));
        CLDBProto.DialHomeSuccessfulAckRequest req = CLDBProto.DialHomeSuccessfulAckRequest.newBuilder().setForDay(forDay.getTime()).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeSuccessfulAckRequestProc.getNumber(), (MessageLite)req, CLDBProto.DialHomeSuccessfulAckResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeSuccessfulAckRequestProc.getNumber(), (MessageLite)req, CLDBProto.DialHomeSuccessfulAckResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.DialHomeSuccessfulAckResponse resp = CLDBProto.DialHomeSuccessfulAckResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Request to get metrics failed. Reason: " + Errno.toString(resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("InvalidProtocolBufferException  Exception", (Throwable)e);
        }
    }

    private void getLastDialedDate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.DialHomeLastDialedRequest.Builder req = CLDBProto.DialHomeLastDialedRequest.newBuilder().setCreds(this.getUserCredentials());
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeLastDialedRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.DialHomeLastDialedResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeLastDialedRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.DialHomeLastDialedResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.DialHomeLastDialedResponse resp = CLDBProto.DialHomeLastDialedResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Request to fetch last dialed date failed. Reason: " + Errno.toString(resp.getStatus())));
            } else {
                CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("date", resp.getLastDialedDate()));
                out.addNode(outputNode);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("InvalidProtocolBufferException  Exception", (Throwable)e);
        }
    }

    private CLDBProto.DialHomeStatusResponse getDialHomeStatusResponse() throws CLIProcessingException {
        CLDBProto.DialHomeStatusRequest.Builder req = CLDBProto.DialHomeStatusRequest.newBuilder().setCreds(this.getUserCredentials());
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeStatusRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.DialHomeEnableResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DialHomeStatusRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.DialHomeStatusResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return null;
            }
            return CLDBProto.DialHomeStatusResponse.parseFrom((byte[])replyData);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("InvalidProtocolBufferException  Exception", (Throwable)e);
        }
    }

    private MetricsProto.DayMetrics getMetricsForDay(long timeOfDay) {
        String metricsFilePath = MetricsUtil.getMetricsFilePath((long)timeOfDay);
        LOG.info((Object)("Retrieving metrics. Timestamp received: " + timeOfDay + ". Metrics file path: " + metricsFilePath));
        if (!MapRFSUtil.pathExists((String)metricsFilePath)) {
            LOG.error((Object)("Read Failed. Unable to find metrics file with path: " + metricsFilePath));
            return null;
        }
        long fileSize = 0L;
        try {
            FileStatus fileStatus = MapRFSUtil.getMapRFileSystem().getFileStatus(new Path(metricsFilePath));
            fileSize = fileStatus.getLen();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to fetch the size of the metrics file. Path: " + metricsFilePath));
            return null;
        }
        if (fileSize > 0L) {
            MetricsProto.DayMetrics.Builder dayMetricsBuilder = MetricsReader.readDayMetricsFromFile((String)metricsFilePath);
            if (dayMetricsBuilder == null) {
                return null;
            }
            return dayMetricsBuilder.build();
        }
        LOG.warn((Object)("Size of the metrics file is zero. Path: " + metricsFilePath));
        return null;
    }

    private static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        return cal.getTime();
    }

    private int getStatusAsInt(CLDBProto.DialHomeStatus status) {
        switch (status) {
            case ENABLED: {
                return 1;
            }
            case DISABLED: {
                return 0;
            }
        }
        return -1;
    }

    private byte[] compress(byte[] input) {
        byte[] output = new byte[input.length];
        Deflater compresser = new Deflater(9);
        compresser.setInput(input);
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compression. Input size: " + input.length + ", output size: " + compressedDataLength));
        }
        return Arrays.copyOf(output, compressedDataLength);
    }
}

