/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.bulk;

import com.mapr.baseutils.Errno;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.bulk.AbstractTask;
import com.mapr.cli.bulk.TaskResult;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import org.apache.log4j.Logger;

public class VolumeUnMountTask
extends AbstractTask {
    private static Logger LOG = Logger.getLogger(VolumeUnMountTask.class);
    private static final String TASK_NAME = "VolumeUnMount";
    private CLDBProto.VolumeProperties volProps;
    private String cluster;
    private String user;

    public VolumeUnMountTask(CLDBProto.VolumeProperties volProps, String cluster, String user) {
        super(TASK_NAME);
        this.volProps = volProps;
        this.cluster = cluster;
        this.user = user;
    }

    @Override
    public TaskResult executeTask() {
        String volumeName = this.volProps.getVolumeName();
        TaskResult result = new TaskResult();
        result.setEntityName(volumeName);
        try {
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
            Common.FidMsg parentFid = this.volProps.getParentFid();
            int status = fs.unmountVolume(this.cluster, volumeName, this.volProps.getMountDir(), this.user, parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
            result.setStatus(0);
            if (status != 0) {
                String failureMsg = "Volume unmount failed for volume: " + volumeName + ". Error: " + (status > 0 ? Errno.toString(status) : "");
                result.setFailureMsg(failureMsg);
                LOG.warn((Object)failureMsg);
            }
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception while unmounting volume: " + volumeName), (Throwable)e);
        }
        return result;
    }

    @Override
    public TaskResult validateInput() {
        String volumeName = this.volProps.getVolumeName();
        TaskResult result = new TaskResult();
        result.setStatus(0);
        result.setEntityName(volumeName);
        if (volumeName.equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
            String failureMsg = "Cannot unmount volume " + volumeName + ". Error: " + Errno.toString(22);
            result.setStatus(22);
            result.setFailureMsg(failureMsg);
            LOG.warn((Object)failureMsg);
            return result;
        }
        if (!this.volProps.getMounted()) {
            String failureMsg = "Volume " + volumeName + " is not mounted.";
            result.setStatus(22);
            result.setFailureMsg(failureMsg);
            LOG.warn((Object)failureMsg);
        }
        return result;
    }
}

