/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.GetStringsForAuditOps;
import com.mapr.cli.AclCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.SnapshotCommands;
import com.mapr.cli.VolumeContainerCommands;
import com.mapr.cli.VolumeDumpFileCommands;
import com.mapr.cli.VolumeLinkCommands;
import com.mapr.cli.VolumeMirrorCommands;
import com.mapr.cli.bulk.TaskCompletionService;
import com.mapr.cli.bulk.VolumeRemoveTask;
import com.mapr.cli.bulk.VolumeUnMountTask;
import com.mapr.cli.common.AuthManager;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cli.common.VolumeField;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class VolumeCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeCommands.class);
    private static final int NUM_VOLUMES_PER_RPC = 512;
    private static final int VOLUME_OP_DELAY = 2;
    private static final int VOLUME_OP_ATTEMPTS = 60;
    public static final String RW_VOLUME_PARAM_OP_NODELAY = "nodelay";
    public static final String RW_VOLUME_PARAM_NAME = "name";
    public static final String RW_VOLUME_PARAM_NEW_NAME = "newname";
    public static final String RW_VOLUME_PARAM_MOUNTDIR = "path";
    public static final String RW_VOLUME_PARAM_MOUNT = "mount";
    public static final String RW_VOLUME_PARAM_CREATE_PARENT = "createparent";
    public static final String RW_VOLUME_PARAM_REPLICATION = "replication";
    public static final String RW_VOLUME_PARAM_MIN_REPLICATION = "minreplication";
    public static final String RW_VOLUME_PARAM_DCREPLTYPE = "replicationtype";
    public static final String RW_VOLUME_PARAM_NAMESPACE_REPLICATION = "nsreplication";
    public static final String RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION = "nsminreplication";
    public static final String RW_VOLUME_PARAM_READONLY = "readonly";
    public static final String RW_VOLUME_PARAM_MIRRORTHROTTLE = "mirrorthrottle";
    public static final String RW_VOLUME_PARAM_LOCALVOLUMEHOST = "localvolumehost";
    public static final String RW_VOLUME_PARAM_LOCALVOLUMEPORT = "localvolumeport";
    public static final String RW_VOLUME_PARAM_SHUFFLEVOLUME = "shufflevolume";
    public static final String RW_VOLUME_PARAM_FORCE = "force";
    public static final String RW_VOLUME_PARAM_AETYPE = "aetype";
    public static final String RW_VOLUME_PARAM_AE = "ae";
    public static final String RW_VOLUME_PARAM_QUOTA = "quota";
    public static final String RW_VOLUME_PARAM_ADVISORY_QUOTA = "advisoryquota";
    public static final String RW_VOLUME_PARAM_TOPOLOGY = "topology";
    public static final String MIRROR_VOLUME = "type";
    public static final String MIRROR_VOLUME_SRC_VOLUMENAME = "source";
    public static final String RW_VOLUME_ROOT_DIR_PERM = "rootdirperms";
    public static final String RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC = "rereplicationtimeoutsec";
    public static final String RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD = "maxinodesalarmthreshold";
    public static final String RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH = "dbrepllagsecalarmthresh";
    public static final String RW_FIX_CREATOR_ID = "fixcreatorid";
    public static final String PRESERVE_VOLUME = "preserve";
    public static final String CHECKIN_TIME_MIN = "commitTime";
    public static final String RETENTION_PERIOD_DAYS = "retain";
    public static final String ADD_VOLUME_NOTE = "addNote";
    public static final String RESOLVE_VOLUME_NOTE = "resolveNote";
    public static final String NOTE_COMMENT = "comment";
    public static final String USERPERM_PARAM_NAME = "user";
    public static final String GROUPPERM_PARAM_NAME = "group";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String ALARMEDVOLUMES_PARAM_NAME = "alarmedvolumes";
    public static final String RW_VOLUME_NODES = "nodes";
    public static final String VOLUME_LIMIT_SPREAD = "limitspread";
    public static final String ALLOW_GRANT = "allowgrant";
    public static final String INHERIT_SOURCE = "inherit";
    public static final String ALLOW_INHERIT = "allowinherit";
    public static final String VOLUME_SCHEDULE = "schedule";
    public static final String VOLUME_MIRROR_SCHEDULE = "mirrorschedule";
    public static final String MULTI_ARG_SEP = ",";
    public static final String REPL_TYPE_STAR = "low_latency";
    public static final String REPL_TYPE_CASCADE = "high_throughput";
    public static final String REPL_TYPE_UNKNOWN = "unknown";
    private final int VOLUME_ON_FILESERVER_TIMEOUT_SEC = 60;
    private static int MAX_VOLUMEFIELDINFO = 0;
    public static final String VOL_READACE_PARAM = "readAce";
    public static final String VOL_WRITEACE_PARAM = "writeAce";
    public static final String AUDIT_VOLUME = "isauditvolume";
    public static final String VOLUME_AUDIT_ENABLED = "enabled";
    public static final String AUDIT_ENABLED = "auditenabled";
    public static final String AUDIT_COALESCE_INTERVAL = "coalesce";
    public static final String FSAUDIT_OPS = "dataauditops";
    public static final String volumeRemoveUsage = "volume remove -name volumeName [-cluster clustername -force <true|false> -filter <filters>]";
    public static final String volumeMoveUsage = "volume move -name volumeName -topology topology [-cluster clustername]";
    public static final String volumeRenameUsage = "volume rename -name volumeNmae -newname newVolName [-cluster clustername]";
    public static final String volumeUpgradeformatUsage = "volume upgradeformat -name volumeNames";
    public static final String aclUsageString = "-user space separated list of user:permissions,perimssions,.. to be set-group space separated list of group:permissions,permissions,.. to be set";
    public static final String dataAceUsageString = "-readAceaceexpression-writeAceaceexpression";
    public static final Map<String, Common.VolumeActions> volumeAceParameterMap = new ImmutableMap.Builder().put((Object)"readAce", (Object)Common.VolumeActions.VOLUME_READ).put((Object)"writeAce", (Object)Common.VolumeActions.VOLUME_WRITE).build();
    public static final String volumeModifyUsage = "volume modify -name volumeName [-replication <repl> -minreplication <minrepl> -readonly <false|true> -nsreplication <repl> -nsminreplication <minrepl> -cluster clustername -mirrorthrottle <false|true> -user space separated list of user:permissions,perimssions,.. to be set-group space separated list of group:permissions,permissions,.. to be set-readAceaceexpression-writeAceaceexpression-source <sourcevol@sourcecluster>-aetype <0(user)|1(group)> -ae <name>-maxinodesalarmthreshold <val> -dbrepllagsecalarmthresh <val>]-quota <val> -advisoryquota <val> -maxinodesalarmthreshold <val>-limitspread <true|false> -type type of volume: rw or mirror]-allowgrant <true|false> [-auditenabled <true|false> ][-coalesce <val in mins> ][-rereplicationtimeoutsec <val in sec> ]";
    public static final String volumeListUsage = "volume list [-filter <filters>][-cluster clustername]";
    public static final String volumeInfoUsage = "volume info -volumename volName";
    public static final String volumeCreateUsage = "volume create -name volumeName [-path mountDir -mount <true|false> -createparent <false|true> -replication <repl> -minreplication <minrepl> -readonly <false|true> -nsreplication <repl> -nsminreplication <minrepl> -cluster clustername -localvolumehost fileserverhost -mirrorthrottle <false|true> -localvolumeport fileserverport -user space separated list of user:permissions,perimssions,.. to be set-group space separated list of group:permissions,permissions,.. to be set-readAceaceexpression-writeAceaceexpression-aetype <0(user)|1(group)> -ae aename-quota <quotaval> -advisoryquota <val> -maxinodesalarmthreshold <val> -dbrepllagsecalarmthresh <val> -type type of volume: normal(0) or mirror(1) -source <srcvolume@srccluster> -limitspread <true|false> -rootdirperms 0777][-allowgrant <true|false> ][-inherit <existing volume name> ][-allowinherit <true|false> ][-auditenabled <true|false> ][-coalesce <val in mins> ]";
    public static final String volumeAuditUsage = "volume audit -name volumeName [-enabled <true|false> ] [-coalesce in mins][-enabledataaudit <list of data audit operations>[-disabledataaudit <list of data audit operations>";
    public static final String volumeUnMountUsage = "volume unmount -name volumeName [-cluster clustername]";
    public static final String volumeShowMountsUsage = "volume showmounts -name volumeName [-cluster clustername]";
    public static final String volumeMountUsage = "volume mount -name volumeName -path mountDir [-createparent <false|true> -cluster clustername]";
    public static final String volumeFixMntPathUsage = "volume fixmountpath -name volumeName [-cluster clustername]";
    public static Map<VolumeField, FieldInfo> fieldTable;
    public static ImmutableMap.Builder<VolumeField, FieldInfo> fieldTableBuilder;
    public static Map<String, BaseInputParameter> baseParams;
    public static Map<String, BaseInputParameter> aclParams;
    public static final CLICommand volumeAuditCommand;
    public static final CLICommand volumeUnMountCommand;
    public static final CLICommand volumeShowMountsCommand;
    public static final CLICommand volumeMountCommand;
    public static final CLICommand volumeCreateCommand;
    public static final CLICommand[] volumeCommands;
    UnixUserGroupHelper uInfo;
    int maxVolumeReplicationFactor;
    private List<CLDBProto.VolumeInfo> listedVolumes = Lists.newArrayList();
    private AuthManager authManager = AuthManager.getInstance();

    void init() throws CLIProcessingException {
        this.uInfo = new UnixUserGroupHelper();
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while initializing RPC " + e));
        }
        fieldTable = PluggableAlarmUtil.appendVolumeMap(this.getUserCredentials(), fieldTableBuilder);
        MAX_VOLUMEFIELDINFO = PluggableAlarmUtil.getMaxNumNodes(this.getUserCredentials(), MAX_VOLUMEFIELDINFO);
        this.maxVolumeReplicationFactor = Common.MapRClusterDefaults.getDefaultInstance().getMaxVolumeReplication();
    }

    private boolean sleepAndCheckMountedDir(MapRFileSystem fs, String cluster, String dir) {
        String fullDir = dir;
        if (cluster != null && !dir.startsWith("maprfs://")) {
            fullDir = "maprfs://" + cluster + ":" + dir;
        }
        Path fullPath = new Path(fullDir);
        for (int nAttempts = 0; nAttempts < 60; ++nAttempts) {
            try {
                FileStatus fStatus = fs.getFileStatus(fullPath);
                if (fStatus != null) {
                    return true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    private List<String> getUserGroupsNames(List<String> perms) {
        ArrayList permissions = new ArrayList();
        ArrayList<String> userGroups = new ArrayList<String>();
        for (String perm : perms) {
            Collections.addAll(permissions, perm.split(" "));
        }
        for (String perm : permissions) {
            List<String> userPerm = Arrays.asList(perm.split(AclCommands.ALLOW_MASK_SEP));
            userGroups.add(userPerm.get(0));
        }
        return userGroups;
    }

    private Common.ContainerReplType getContainerReplType(String type) {
        if (type.equalsIgnoreCase(REPL_TYPE_STAR)) {
            return Common.ContainerReplType.STAR;
        }
        if (type.equalsIgnoreCase(REPL_TYPE_CASCADE)) {
            return Common.ContainerReplType.CASCADE;
        }
        return Common.ContainerReplType.INVALID;
    }

    private String getContainerReplTypeString(Common.ContainerReplType type) {
        if (type == Common.ContainerReplType.STAR) {
            return REPL_TYPE_STAR;
        }
        if (type == Common.ContainerReplType.CASCADE) {
            return REPL_TYPE_CASCADE;
        }
        return REPL_TYPE_UNKNOWN;
    }

    public VolumeCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                if (!this.getParamTextValue(FILTER_PARAM_NAME, 0).equals("none")) {
                    return this.removeFilteredVolumes();
                }
                return this.volumeRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("move")) {
            try {
                return this.volumeMove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("audit")) {
            try {
                return this.volumeModify();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rename")) {
            try {
                return this.volumeRename();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("upgradeformat")) {
            try {
                return this.volumeUpgradeformat();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            try {
                CommandOutput output = new CommandOutput();
                CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
                output.setOutput(out);
                if (!super.validateInput()) {
                    return output;
                }
                if (this.isParamPresent(ALARMEDVOLUMES_PARAM_NAME) && this.getAlarmedVolumesParamValue() && this.isParamPresent(RW_VOLUME_NODES) && !this.getParamTextValue(RW_VOLUME_NODES, 0).isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot use both -alarmedvolumes and -nodes parameters."));
                    return output;
                }
                this.list(out);
                return output;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
            try {
                return this.volumeInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("modify")) {
            try {
                return this.volumeModify();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.volumeCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("unmount")) {
            try {
                return this.volumeUnMount();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(RW_VOLUME_PARAM_MOUNT)) {
            try {
                return this.volumeMount();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("showmounts")) {
            try {
                return this.volumeShowMounts();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("fixmountpath")) {
            try {
                return this.volumeFixMountPath();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Volume command failed".getBytes());
    }

    public boolean validateInput() throws IllegalArgumentException {
        if (this.cliCommand.getCommandName().equals("remove")) {
            return this.input.getAllParameters().size() > 1 && super.validateInput();
        }
        return super.validateInput();
    }

    CommandOutput volumeMount() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        ArrayList<String> volumeNames = new ArrayList<String>();
        ArrayList<String> mountedVolumePaths = new ArrayList<String>();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        for (String volName : volumeNames) {
            int status;
            CLDBProto.VolumeProperties volProps;
            if (volName.equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot mount root volume " + volName + " " + Errno.toString(22)));
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to mount volume " + volName));
            }
            String rwVolumeMountDir = null;
            if (this.isParamPresent(RW_VOLUME_PARAM_MOUNTDIR)) {
                rwVolumeMountDir = this.getParamTextValue(RW_VOLUME_PARAM_MOUNTDIR, 0).replaceAll("\\/+$", "");
            }
            if ((volProps = this.volumePropetiesLookup(volName)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + volName + ", " + Errno.toString(2)));
                LOG.error((Object)("VolumeMount : Could not find volume properties for " + volName));
                continue;
            }
            if (volProps.getMounted()) {
                LOG.warn((Object)("VolumeMount : Volume already mounted at " + volProps.getMountDir()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, volName + " " + Errno.toString(22) + " already mounted"));
                continue;
            }
            if (rwVolumeMountDir == null) {
                rwVolumeMountDir = volProps.getMountDir();
            }
            if (!MapRCliUtil.parentDirExists(fs, cluster, rwVolumeMountDir)) {
                if (this.getParamBooleanValue(RW_VOLUME_PARAM_CREATE_PARENT, 0)) {
                    if (!MapRCliUtil.createParentDir(fs, cluster, rwVolumeMountDir)) {
                        LOG.error((Object)("Volume Mount: Volume " + volName + ", failed to mount, " + "could not create parent directory for mount dir " + rwVolumeMountDir));
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + volName + ", could not create parent directory for mount dir " + rwVolumeMountDir));
                        continue;
                    }
                } else {
                    LOG.error((Object)("Volume Mount: Volume " + volName + " parent of mount dir " + rwVolumeMountDir + " does not exist"));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + volName + ", parent of mount dir " + rwVolumeMountDir + " does not exist, " + Errno.toString(2)));
                    continue;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Mounting volume " + volName + " at " + rwVolumeMountDir));
            }
            if ((status = fs.mountVolume(cluster, volName, rwVolumeMountDir, this.getUserLoginId())) == 0) {
                mountedVolumePaths.add(rwVolumeMountDir);
                continue;
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to mount volume " + rwVolumeName + ", " + Errno.toString(status)));
            LOG.error((Object)("Unable to mount volume " + volName + " at " + rwVolumeMountDir));
        }
        if (!mountedVolumePaths.isEmpty() && !this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
            for (String dir : mountedVolumePaths) {
                if (this.sleepAndCheckMountedDir(fs, cluster, dir)) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume mount for " + dir + " failed, Could not get status of mount path"));
            }
        }
        return output;
    }

    CommandOutput volumeShowMounts() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(RW_VOLUME_PARAM_NAME, 0);
        byte[] data = null;
        CLDBProto.VolumeShowMountsRequest volShowMountsReq = CLDBProto.VolumeShowMountsRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        try {
            CommandOutput.OutputHierarchy.OutputNode cOut;
            CLDBProto.VolumeShowMountsResponse resp;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeShowMountsProc.getNumber(), (MessageLite)volShowMountsReq, CLDBProto.VolumeShowMountsResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeShowMountsProc.getNumber(), (MessageLite)volShowMountsReq, CLDBProto.VolumeShowMountsResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. volumeShowMounts response null for volume " + volumeName));
                LOG.error((Object)("VolumeShowMounts response null for volume " + volumeName));
            }
            if ((resp = CLDBProto.VolumeShowMountsResponse.parseFrom((byte[])data)).getStatus() == 0) {
                cOut = new CommandOutput.OutputHierarchy.OutputNode();
                CommandOutput.OutputHierarchy.OutputNode mountedVolumes = new CommandOutput.OutputHierarchy.OutputNode("MountedVolumes");
                cOut.addChild(mountedVolumes);
                for (String volName : resp.getVolumesList()) {
                    mountedVolumes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Name", (Object)volName));
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume ShowMounts: " + Errno.toString(resp.getStatus())));
                LOG.error((Object)("ShowMounts of volume failed, " + Errno.toString(resp.getStatus())));
                return output;
            }
            out.addNode(cOut);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume showMounts:  Operation failed"));
            LOG.error((Object)("Exception during volume show Mounts" + e));
            return output;
        }
        return output;
    }

    CommandOutput volumeUnMount() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> volumeNames = new ArrayList<String>();
        String rwVolumeName = this.getRwVolumeName();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        boolean forceUnMount = false;
        if (this.isParamPresent(RW_VOLUME_PARAM_FORCE)) {
            forceUnMount = this.getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        boolean unmountedOne = false;
        for (String volName : volumeNames) {
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volName, false);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Cannot find volume properties for " + volName + " " + Errno.toString(2)));
                LOG.error((Object)("VolumeUnmount : Could not find volume properties for " + volName));
                continue;
            }
            if (!volProps.getMounted()) {
                LOG.warn((Object)("VolumeUnmount : Volume " + volName + " already unmounted"));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volName + "already unmounted, " + Errno.toString(22)));
                continue;
            }
            boolean rootVolUnMount = false;
            if (volProps.getVolumeName().equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
                rootVolUnMount = true;
                forceUnMount = true;
            }
            String rwVolumeMountDir = volProps.getMountDir();
            Common.FidMsg parentFid = volProps.getParentFid();
            int status = 0;
            if (!rootVolUnMount) {
                status = fs.unmountVolume(cluster, volName, rwVolumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
            }
            if (rootVolUnMount || status != 0 && forceUnMount) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ForceUnmount volume " + volName));
                }
                byte[] data = null;
                CLDBProto.VolumeUnMountRequest volUnMount = CLDBProto.VolumeUnMountRequest.newBuilder().setVolumeName(volName).setCreds(this.getUserCredentials()).setForce(true).build();
                try {
                    CLDBProto.VolumeUnMountResponse resp;
                    data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUnMountProc.getNumber(), (MessageLite)volUnMount, CLDBProto.VolumeUnMountResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUnMountProc.getNumber(), (MessageLite)volUnMount, CLDBProto.VolumeUnMountResponse.class);
                    if (data == null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. Force volumeUnmount response null for volume " + volName));
                        LOG.error((Object)("Force volumeUnmount response null for volume " + volName));
                    }
                    if ((resp = CLDBProto.VolumeUnMountResponse.parseFrom((byte[])data)).getStatus() == 0) {
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)("Force unmount volume " + volName));
                        continue;
                    }
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume UnMount: " + Errno.toString(resp.getStatus())));
                    LOG.error((Object)("Forceunmount of volume failed, " + Errno.toString(resp.getStatus())));
                    continue;
                }
                catch (MaprSecurityException e) {
                    throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume unMount:  Operation failed"));
                    LOG.error((Object)("Exception during volume force unmount " + e));
                    continue;
                }
            }
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to unmount volume " + Errno.toString(status)));
                LOG.error((Object)("Volume unmount " + rwVolumeMountDir + " failed, " + Errno.toString(status)));
                continue;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Volume unmount " + rwVolumeMountDir + " successful"));
            }
            unmountedOne = true;
        }
        if (unmountedOne && !this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput volumeCreate() throws CLIProcessingException {
        String fsOperations;
        int minRepl;
        int mode;
        String rootDirPerms;
        CLDBProto.VolumeLookupResponse lookupResp;
        List<Security.AclEntry> elements;
        List perms;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        boolean rootVolume = rwVolumeName.equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName());
        boolean permsPresent = false;
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        if (this.isParamPresent(USERPERM_PARAM_NAME)) {
            permsPresent = true;
            perms = this.input.getParameterByName(USERPERM_PARAM_NAME).getParamValues();
            List<String> userNames = this.getUserGroupsNames(perms);
            for (String userName : userNames) {
                if (this.checkEntityExists(false, userName)) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - user " + userName + " not found").setField(USERPERM_PARAM_NAME));
                return output;
            }
            elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, true, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - invalid list of user permissions - " + perms).setField(USERPERM_PARAM_NAME));
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (this.isParamPresent(GROUPPERM_PARAM_NAME)) {
            permsPresent = true;
            perms = this.input.getParameterByName(GROUPPERM_PARAM_NAME).getParamValues();
            List<String> groupNames = this.getUserGroupsNames(perms);
            for (String groupName : groupNames) {
                if (this.checkEntityExists(true, groupName)) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - group " + groupName + " not found").setField(USERPERM_PARAM_NAME));
                return output;
            }
            elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, false, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - invalid list of group permissions - " + perms).setField(GROUPPERM_PARAM_NAME));
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (rootVolume) {
            try {
                CLDBProto.VolumeCreateRequest.Builder volumeCreate = CLDBProto.VolumeCreateRequest.newBuilder();
                CLDBProto.VolumeProperties volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName()).setMounted(true).setMountDir(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootPath()).setAcl(aclBuilder.build()).build();
                volumeCreate.setVolProperties(volProps);
                volumeCreate.setCreds(this.getUserCredentials());
                byte[] data = null;
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeCreateResponse resp = CLDBProto.VolumeCreateResponse.parseFrom((byte[])data);
                LOG.info((Object)resp.getErrMsg());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception while sending RPC to CLDB");
            }
        }
        String rwVolumeMountDir = null;
        if (this.isParamPresent(RW_VOLUME_PARAM_MOUNTDIR)) {
            rwVolumeMountDir = this.getParamTextValue(RW_VOLUME_PARAM_MOUNTDIR, 0).replaceAll("\\/+$", "");
        }
        boolean mount = true;
        if (this.isParamPresent(RW_VOLUME_PARAM_MOUNT)) {
            mount = this.getParamBooleanValue(RW_VOLUME_PARAM_MOUNT, 0);
        }
        if (!VolumeUtils.isValidVolumeNameLength((String)rwVolumeName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name " + rwVolumeName + ", Exceeds allowed length of " + VolumeUtils.validVolumeNameLength() + " characters").setField(RW_VOLUME_PARAM_NEW_NAME));
            return output;
        }
        if (!VolumeUtils.isValidVolumeName((String)rwVolumeName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name " + rwVolumeName + ", Allowed characters " + VolumeUtils.getValidName()).setField(RW_VOLUME_PARAM_NEW_NAME));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((lookupResp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), rwVolumeName, null, this.isServerCall)) != null && lookupResp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Volume name " + rwVolumeName + ", already in use.").setField(RW_VOLUME_PARAM_NEW_NAME).setPropagateErrorSupport(true));
            return output;
        }
        CLDBProto.VolumeCreateRequest.Builder volumeCreate = CLDBProto.VolumeCreateRequest.newBuilder();
        CLDBProto.VolumeProperties.Builder volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(rwVolumeName);
        if (permsPresent) {
            volProps.setAcl(aclBuilder);
        }
        CLDBProto.ReplicationPolicy.Builder replPolicy = null;
        if (this.isParamPresent(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC)) {
            int timeout = this.getParamIntValue(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, 0);
            volProps.setReReplicationTimeOutSec(timeout);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_READONLY)) {
            boolean readOnly = this.getParamBooleanValue(RW_VOLUME_PARAM_READONLY, 0);
            volProps.setReadOnly(readOnly);
        }
        boolean allowInherit = true;
        if (this.isParamPresent(ALLOW_INHERIT)) {
            allowInherit = this.getParamBooleanValue(ALLOW_INHERIT, 0);
        }
        if (this.isParamPresent(INHERIT_SOURCE) && allowInherit) {
            String src = this.getParamTextValue(INHERIT_SOURCE, 0);
            volumeCreate.setInheritPropsSource(src);
        }
        if (this.isParamPresent(ALLOW_GRANT)) {
            boolean val = this.getParamBooleanValue(ALLOW_GRANT, 0);
            volProps.setAllowGrant(val);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_LOCALVOLUMEHOST) && this.isParamPresent(RW_VOLUME_PARAM_LOCALVOLUMEPORT)) {
            Common.IPAddress fileServer;
            CLDBProto.FileServerInfo fsInfo;
            String fsHost = this.getParamTextValue(RW_VOLUME_PARAM_LOCALVOLUMEHOST, 0);
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(fsHost));
            int localFSPort = this.getParamIntValue(RW_VOLUME_PARAM_LOCALVOLUMEPORT, 0);
            Common.IPAddress.Builder ipAddressBuilder = Common.IPAddress.newBuilder();
            ipAddressBuilder.setHostname(fsHost).setPort(localFSPort);
            if (!ips.isEmpty()) {
                ipAddressBuilder.setHost(Util.ipToInt((String)ips.get(0)));
            }
            if ((fsInfo = NodesCommonUtils.getFileServerInfo(fileServer = ipAddressBuilder.build(), this.getUserCredentials(), cluster)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "FileServer " + fsHost + ":" + localFSPort + " has not registered with CLDB"));
                return output;
            }
            if (fsInfo.getLastHeartbeatSec() > 60) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "FileServer " + fsHost + ":" + localFSPort + " has not heartbeated with CLDB for " + fsInfo.getLastHeartbeatSec()));
                return output;
            }
            if (replPolicy == null) {
                replPolicy = CLDBProto.ReplicationPolicy.newBuilder();
            }
            replPolicy.setNumReplicas(1);
            replPolicy.setGuaranteedMinReplicas(1);
            volProps.setLocalVolume(true);
            volumeCreate.setLocalFileServer(fileServer);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_SHUFFLEVOLUME)) {
            boolean shuffleVol = this.getParamBooleanValue(RW_VOLUME_PARAM_SHUFFLEVOLUME, 0);
            volProps.setShuffleVolume(shuffleVol);
        }
        volProps.setOwnerId((int)super.getUserId());
        if (this.isParamPresent(RW_VOLUME_PARAM_AE) || this.isParamPresent(RW_VOLUME_PARAM_AETYPE)) {
            boolean type;
            if (this.isParamPresent(RW_VOLUME_PARAM_AETYPE) && !this.isParamPresent(RW_VOLUME_PARAM_AE)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify both aetype and ae while creating volume " + rwVolumeName));
                return output;
            }
            String name = this.getParamTextValue(RW_VOLUME_PARAM_AE, 0);
            boolean bl = type = this.isParamPresent(RW_VOLUME_PARAM_AETYPE) ? this.getParamBooleanValue(RW_VOLUME_PARAM_AETYPE, 0) : false;
            if (!this.checkEntityExists(type, name)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid AE specified while trying to create Volume " + rwVolumeName));
                LOG.error((Object)"Volume create with invalid AE ");
                return output;
            }
            CLDBProto.AeKey.Builder keyBuilder = CLDBProto.AeKey.newBuilder();
            keyBuilder.setName(name);
            keyBuilder.setType(type);
            volProps.setVolumeAe(keyBuilder);
        }
        long quotaInMB = 0L;
        if (this.isParamPresent(RW_VOLUME_PARAM_QUOTA)) {
            String quota = this.getParamTextValue(RW_VOLUME_PARAM_QUOTA, 0);
            quotaInMB = MapRCliUtil.quotaStringToMB(quota);
            if (quotaInMB == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create with invalid quota " + quota + ", Should be either an Integer, or a decimal value " + "followed by one of (M,MB,G,GB,T,TB,P,PB)").setField(RW_VOLUME_PARAM_QUOTA));
                return output;
            }
            volProps.setVolumeQuotaSizeMB(quotaInMB);
        }
        if (this.isParamPresent(RW_VOLUME_ROOT_DIR_PERM)) {
            rootDirPerms = this.getParamTextValue(RW_VOLUME_ROOT_DIR_PERM, 0);
        } else {
            try {
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                rootDirPerms = String.format("%04o", MapRClientImpl.getModeBits((FsPermission)FsPermission.getDefault(), (Configuration)fs.getConf()));
            }
            catch (IllegalArgumentException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error parsing \"dfs.umaskmode\" property from core-site.xml."));
                return output;
            }
        }
        try {
            mode = Integer.parseInt(rootDirPerms, 8);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("VolumeCreate: Volumename : " + rwVolumeName + " Invalid " + "rootdirperms specified. Should be valid octal string"));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Create for " + rwVolumeName + " failed, Invalid " + "rootdirperms specified. Should be valid octal string").setField(RW_VOLUME_ROOT_DIR_PERM));
            return output;
        }
        if ((mode & 0xFFFFF000) != 0) {
            LOG.error((Object)("VolumeCreate: Volumename : " + rwVolumeName + " Invalid " + "rootdirperms specified. Should be a subset of 07777"));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Create for " + rwVolumeName + " failed, Invalid " + "rootdirperms specified. Should be a subset of 07777").setField(RW_VOLUME_ROOT_DIR_PERM));
            return output;
        }
        volProps.setRootDirPerms(mode);
        long advisoryQuotaInMB = 0L;
        if (this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA)) {
            String quota = this.getParamTextValue(RW_VOLUME_PARAM_ADVISORY_QUOTA, 0);
            advisoryQuotaInMB = MapRCliUtil.quotaStringToMB(quota);
            if (advisoryQuotaInMB == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + "with invalid advisory quota " + quota + ", Should be either an Integer, or a decimal value " + "followed by one of (M,MB,G,GB,T,TB,P,PB)").setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));
                return output;
            }
            volProps.setVolumeQuotaAdvisorySizeMB(advisoryQuotaInMB);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA) && this.isParamPresent(RW_VOLUME_PARAM_QUOTA) && quotaInMB > 0L && advisoryQuotaInMB > quotaInMB) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " with invalid advisory quota greater than volume quota").setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));
            return output;
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
            if (this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION) && !this.isParamPresent(RW_VOLUME_PARAM_REPLICATION)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " insufficient arguments. Please specify " + "replication along with minreplication"));
                return output;
            }
            if (replPolicy == null) {
                replPolicy = CLDBProto.ReplicationPolicy.newBuilder();
            }
            int repl = 0;
            if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION)) {
                repl = this.getParamIntValue(RW_VOLUME_PARAM_REPLICATION, 0);
                if (repl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid replication " + repl));
                    return output;
                }
                if (repl > this.maxVolumeReplicationFactor) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " failed. " + "The maximum value allowed for the replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                    return output;
                }
                replPolicy.setNumReplicas(repl);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION)) {
                minRepl = this.getParamIntValue(RW_VOLUME_PARAM_MIN_REPLICATION, 0);
                if (minRepl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid minreplication " + repl));
                    return output;
                }
                if (repl > 0 && minRepl > repl) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, minreplication " + repl + " greater than replicaton"));
                    return output;
                }
                replPolicy.setGuaranteedMinReplicas(minRepl);
            } else if (repl == 1) {
                replPolicy.setGuaranteedMinReplicas(repl);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
                String stype = this.getParamTextValue(RW_VOLUME_PARAM_DCREPLTYPE, 0);
                Common.ContainerReplType rtype = this.getContainerReplType(stype);
                if (rtype == Common.ContainerReplType.INVALID) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid replicationtype " + stype));
                    return output;
                }
                replPolicy.setDataContainerReplType(rtype);
            }
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION) && !this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " insufficient arguments. Please specify " + "namespace replication along with namespace minreplication"));
                return output;
            }
            int repl = 0;
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
                repl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, 0);
                if (repl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid namespace replication " + repl));
                    return output;
                }
                if (repl > this.maxVolumeReplicationFactor) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " failed. " + "The maximum value allowed for the namespace replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                    return output;
                }
                volProps.setNumNamespaceReplicas(repl);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
                minRepl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, 0);
                if (minRepl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid namespace minreplication " + repl));
                    return output;
                }
                if (minRepl > repl) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, namespace minreplication " + minRepl + " can not be more than namespace replicaton " + repl));
                    return output;
                }
                volProps.setGuaranteedMinNamespaceReplicas(minRepl);
            }
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MIRRORTHROTTLE)) {
            boolean mirrorThrottle = this.getParamBooleanValue(RW_VOLUME_PARAM_MIRRORTHROTTLE, 0);
            volProps.setMirrorThrottle(mirrorThrottle);
        }
        if (this.isParamPresent(VOLUME_LIMIT_SPREAD)) {
            boolean limitSpread = this.getParamBooleanValue(VOLUME_LIMIT_SPREAD, 0);
            volProps.setLimitVolumeSpread(limitSpread);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_TOPOLOGY)) {
            String topology = this.getParamTextValue(RW_VOLUME_PARAM_TOPOLOGY, 0);
            if (!topology.startsWith("/")) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid topology(rackpath) specified" + topology + ". It should start with \"/\"").setField(RW_VOLUME_PARAM_TOPOLOGY).setFieldValue(topology));
                return output;
            }
            CLDBProto.VolumeTopology topo = CLDBProto.VolumeTopology.newBuilder().setTopologyRestricted(topology).build();
            volProps.setTopology(topo);
        }
        if (this.isParamPresent(VOLUME_SCHEDULE)) {
            int scheduleId = this.getParamIntValue(VOLUME_SCHEDULE, 0);
            volProps.setSchedulingPolicyId(scheduleId);
        }
        if (this.isParamPresent(VOLUME_MIRROR_SCHEDULE)) {
            int scheduleId = this.getParamIntValue(VOLUME_MIRROR_SCHEDULE, 0);
            volProps.setMirrorSchedulingPolicyId(scheduleId);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD)) {
            long maxInodes = this.getParamLongValue(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, 0);
            volProps.setMaxInodesAlarmThreshold(maxInodes);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH)) {
            int thresh = this.getParamIntValue(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, 0);
            volProps.setDbReplLagSecAlarmThresh(thresh);
        }
        if (this.isParamPresent(MIRROR_VOLUME)) {
            int mirrorFlag = 3;
            String mirrorType = this.getParamTextValue(MIRROR_VOLUME, 0);
            if (!(mirrorType.equalsIgnoreCase("rw") || mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("0") || mirrorType.equalsIgnoreCase("1"))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + mirrorType + " specified. Please specify rw/mirror").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                return output;
            }
            if (mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("1")) {
                mirrorFlag = 2;
            }
            if (mirrorFlag == 1 || mirrorFlag == 2) {
                boolean isDestClusterSecure;
                boolean isSourceClusterSecure;
                boolean isAuditVolume;
                if (this.isParamPresent(AUDIT_VOLUME) && (isAuditVolume = this.getParamBooleanValue(AUDIT_VOLUME, 0))) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Mirror volume cannot be audit volume").setField(AUDIT_VOLUME));
                    return output;
                }
                volProps.setReadOnly(true);
                LOG.info((Object)("Setting readonly to true for Mirror Volume " + volProps.getVolumeName()));
                if (!this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name is not specified.").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                String srcVolumeFullName = this.getParamTextValue(MIRROR_VOLUME_SRC_VOLUMENAME, 0);
                int index = srcVolumeFullName.indexOf(64);
                if (index == -1 || index == 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name is not specified in format srcvolume@srccluster").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                String srcVolumeName = srcVolumeFullName.substring(0, index);
                String srcClusterName = srcVolumeFullName.substring(index + 1, srcVolumeFullName.length());
                if (srcClusterName == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name " + srcVolumeName + " is " + "not specified in format srcvolume@srccluster").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(srcClusterName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster name " + srcClusterName).setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                String destClusterName = null;
                destClusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                if (rwVolumeName.equalsIgnoreCase(srcVolumeName) && destClusterName.equalsIgnoreCase(srcClusterName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specified source " + srcVolumeFullName + " is same as destination").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                if (!destClusterName.equalsIgnoreCase(srcClusterName) && (isSourceClusterSecure = JNISecurity.IsSecurityEnabled(srcClusterName)) ^ (isDestClusterSecure = JNISecurity.IsSecurityEnabled(destClusterName))) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "In cross cluster mirroring, both clusters must be either secure or unsecure. Other combination is not allowed."));
                    return output;
                }
                CLDBProto.MirrorInfo.Builder mirror = CLDBProto.MirrorInfo.newBuilder();
                mirror.setSrcVolumeName(srcVolumeName).setSrcClusterName(srcClusterName);
                CLDBProto.MirrorInfo destMirrorInfo = mirror.build();
                volProps.setIsMirrorVol(true);
                volProps.setMirrorInfo(destMirrorInfo);
                CLDBProto.VolumeLookupResponse resp = VolumeCommands.volumeLookup(srcClusterName, this.getUserCredentials(), srcVolumeName, null, this.isServerCall);
                if (resp.hasStatus() && resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + srcVolumeName + "does not exist in cluster " + srcClusterName));
                    return output;
                }
                CLDBProto.VolumeProperties vProps = resp.getVolInfo().getVolProperties();
                int srcMirrorType = 0;
                if (vProps.hasVolumetype()) {
                    srcMirrorType = vProps.getVolumetype().getNumber();
                }
                boolean oldTypeVol = srcMirrorType == 0 || srcMirrorType == 1;
                mirrorFlag = oldTypeVol ? 1 : 2;
                volProps.setVolumetype(Common.VolumeType.values()[mirrorFlag]);
            } else if (this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source cannot be specified for rw volume"));
                return output;
            }
        } else if (this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source cannot be specified for rw volume"));
            return output;
        }
        if (this.isParamPresent(AUDIT_VOLUME)) {
            boolean isAuditVolume = this.getParamBooleanValue(AUDIT_VOLUME, 0);
            volProps.setIsAuditVolume(isAuditVolume);
        }
        if (this.isParamPresent(AUDIT_ENABLED)) {
            boolean audited = this.getParamBooleanValue(AUDIT_ENABLED, 0);
            volProps.setAudited(audited);
        }
        if (this.isParamPresent(AUDIT_COALESCE_INTERVAL)) {
            int coalesceInterval = this.getParamIntValue(AUDIT_COALESCE_INTERVAL, 0);
            if (coalesceInterval < 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Coalesce interval cannot be negative"));
                return output;
            }
            if (coalesceInterval != volProps.getCoalesceInterval()) {
                volProps.setCoalesceInterval(coalesceInterval);
            }
        }
        ArrayList<Common.FSAuditOperations> fsAuditEnableOperations = new ArrayList<Common.FSAuditOperations>();
        ArrayList<Common.FSAuditOperations> fsAuditDisableOperations = new ArrayList<Common.FSAuditOperations>();
        if (this.isParamPresent(FSAUDIT_OPS) && !this.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations = this.getParamTextValue(FSAUDIT_OPS, 0))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid dataauditops text specified, text = " + fsOperations));
            return output;
        }
        if (fsAuditEnableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditEnableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying +all,  cannot enable any other operation"));
            return output;
        }
        if (fsAuditDisableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditDisableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying -all,  cannot disable any other operation"));
            return output;
        }
        if (fsAuditEnableOperations.size() > 0 && fsAuditDisableOperations.size() > 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot mix enable and disable dataaudit ops"));
            return output;
        }
        volumeCreate.addAllFsAuditEnableOperations(fsAuditEnableOperations);
        volumeCreate.addAllFsAuditDisableOperations(fsAuditDisableOperations);
        for (Common.FSAuditOperations op : fsAuditEnableOperations) {
            LOG.info((Object)("Enable Op = " + op.toString()));
        }
        for (Common.FSAuditOperations op : fsAuditDisableOperations) {
            LOG.info((Object)("Disable Op = " + op.toString()));
        }
        if (rwVolumeMountDir != null) {
            volProps.setMountDir(rwVolumeMountDir);
        }
        if (replPolicy != null) {
            volProps.setReplicationPolicy(replPolicy);
        }
        Common.VolumeAces volumeAces = null;
        try {
            volumeAces = this.buildVolumeAcesProtobuf(volumeAceParameterMap);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to parse volume ace arguments");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error Parsing Volume Aces: " + e.getMessage()));
            return output;
        }
        if (volumeAces != null) {
            volumeCreate.setVolumeAces(volumeAces);
        }
        volumeCreate.setVolProperties(volProps.build());
        volumeCreate.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
            if (rwVolumeMountDir != null) {
                if (!MapRCliUtil.parentDirExists(fs, cluster, rwVolumeMountDir)) {
                    if (!this.getParamBooleanValue(RW_VOLUME_PARAM_CREATE_PARENT, 0)) {
                        LOG.error((Object)("Volume Mount: Volume " + rwVolumeName + " parent of mount dir " + rwVolumeMountDir + " does not exist"));
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + rwVolumeName + ", parent of mount dir " + rwVolumeMountDir + " does not exist, " + Errno.toString(2)));
                        return output;
                    }
                    if (!MapRCliUtil.createParentDir(fs, cluster, rwVolumeMountDir)) {
                        LOG.error((Object)("Volume Mount: Volume " + rwVolumeName + ", failed to mount, " + "could not create parent directory for mount dir " + rwVolumeMountDir));
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + rwVolumeName + ", could not create parent directory for mount dir " + rwVolumeMountDir));
                        return output;
                    }
                }
                if (allowInherit) {
                    int parentCid = MapRCliUtil.getParentCid(fs, cluster, rwVolumeMountDir);
                    if (parentCid == 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Name " + rwVolumeName + ", could not get parent volume cid for mountpath " + rwVolumeMountDir).setField(RW_VOLUME_PARAM_MOUNTDIR));
                        return output;
                    }
                    volumeCreate.setParentNamespaceCID(parentCid);
                }
            }
            if ((data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.VolumeCreateResponse resp = CLDBProto.VolumeCreateResponse.parseFrom((byte[])data);
            int mountStatus = -1;
            if (resp.getStatus() == 0) {
                out.addMessage("Successfully created volume: '" + rwVolumeName + "'");
            }
            if (resp.getStatus() == 0 && rwVolumeMountDir != null && mount) {
                mountStatus = fs.mountVolume(cluster, rwVolumeName, rwVolumeMountDir, this.getUserLoginId());
                if (mountStatus != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume mount for " + rwVolumeMountDir + " failed, " + Errno.toString(mountStatus)).setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
                    return output;
                }
                if (!this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0) && !this.sleepAndCheckMountedDir(fs, cluster, rwVolumeMountDir)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create for " + rwVolumeMountDir + " failed, Could not get status of mount path").setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
                    return output;
                }
            }
            if (resp.getStatus() == 0) {
                return output;
            }
            CommandOutput.OutputHierarchy.OutputError procssobj = new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg());
            if (resp.getStatus() == 2) {
                procssobj.setField(RW_VOLUME_PARAM_NAME);
                procssobj.setFieldValue(rwVolumeName);
            } else if (resp.getStatus() != 10011) {
                procssobj.setPropagateErrorSupport(true);
                procssobj.setField(RW_VOLUME_PARAM_NAME);
                procssobj.setFieldValue(rwVolumeName);
            }
            out.addError(procssobj);
            return output;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    boolean validateAndAddFsOperations(List<Common.FSAuditOperations> fsAuditEnableOperations, List<Common.FSAuditOperations> fsAuditDisableOperations, String fsOperations) {
        if (fsOperations.charAt(0) == '-') {
            if (fsOperations.length() <= 1) {
                return false;
            }
            fsOperations = fsOperations.substring(1, fsOperations.length());
        }
        fsOperations = fsOperations.toLowerCase();
        String[] tokens = fsOperations.split("[,]");
        for (int i = 0; i < tokens.length; ++i) {
            List<Common.FSAuditOperations> list = null;
            String next = tokens[i];
            if (next.length() == 0) {
                return false;
            }
            String op = null;
            char first = next.charAt(0);
            if (first == '+') {
                list = fsAuditEnableOperations;
                op = next.substring(1, next.length());
            } else if (first == '-') {
                list = fsAuditDisableOperations;
                op = next.substring(1, next.length());
            } else {
                list = fsAuditEnableOperations;
                op = next;
            }
            if (op.length() == 0) {
                return false;
            }
            if (op.equals("all")) {
                list.add(Common.FSAuditOperations.AuditAll);
                continue;
            }
            if (op.equals("getattr")) {
                list.add(Common.FSAuditOperations.AuditGetattr);
                continue;
            }
            if (op.equals("setattr")) {
                list.add(Common.FSAuditOperations.AuditSetattr);
                list.add(Common.FSAuditOperations.AuditChown);
                list.add(Common.FSAuditOperations.AuditChperm);
                list.add(Common.FSAuditOperations.AuditChgrp);
                continue;
            }
            if (op.equals("chown")) {
                list.add(Common.FSAuditOperations.AuditChown);
                continue;
            }
            if (op.equals("chperm")) {
                list.add(Common.FSAuditOperations.AuditChperm);
                continue;
            }
            if (op.equals("chgrp")) {
                list.add(Common.FSAuditOperations.AuditChgrp);
                continue;
            }
            if (op.equals("getxattr")) {
                list.add(Common.FSAuditOperations.AuditGetxattr);
                continue;
            }
            if (op.equals("listxattr")) {
                list.add(Common.FSAuditOperations.AuditListxattr);
                continue;
            }
            if (op.equals("setxattr")) {
                list.add(Common.FSAuditOperations.AuditSetxattr);
                continue;
            }
            if (op.equals("removexattr")) {
                list.add(Common.FSAuditOperations.AuditRemovexattr);
                continue;
            }
            if (op.equals("getperm")) {
                list.add(Common.FSAuditOperations.AuditGetperm);
                continue;
            }
            if (op.equals("read")) {
                list.add(Common.FSAuditOperations.AuditRead);
                continue;
            }
            if (op.equals("write")) {
                list.add(Common.FSAuditOperations.AuditWrite);
                continue;
            }
            if (op.equals("create")) {
                list.add(Common.FSAuditOperations.AuditCreate);
                continue;
            }
            if (op.equals("mkdir")) {
                list.add(Common.FSAuditOperations.AuditMkdir);
                continue;
            }
            if (op.equals("delete")) {
                list.add(Common.FSAuditOperations.AuditDelete);
                continue;
            }
            if (op.equals("rmdir")) {
                list.add(Common.FSAuditOperations.AuditRmdir);
                continue;
            }
            if (op.equals("readdir")) {
                list.add(Common.FSAuditOperations.AuditReaddir);
                continue;
            }
            if (op.equals("createsym")) {
                list.add(Common.FSAuditOperations.AuditCreatesym);
                continue;
            }
            if (op.equals("lookup")) {
                list.add(Common.FSAuditOperations.AuditLookup);
                continue;
            }
            if (op.equals("rename")) {
                list.add(Common.FSAuditOperations.AuditRename);
                continue;
            }
            if (op.equals("createdev")) {
                list.add(Common.FSAuditOperations.AuditCreatedev);
                continue;
            }
            if (op.equals("truncate")) {
                list.add(Common.FSAuditOperations.AuditTruncate);
                continue;
            }
            if (op.equals("getpathforfid")) {
                list.add(Common.FSAuditOperations.AuditGetpathforfid);
                continue;
            }
            if (op.equals("tablecfcreate")) {
                list.add(Common.FSAuditOperations.AuditDbCfcreate);
                continue;
            }
            if (op.equals("tablecfdelete")) {
                list.add(Common.FSAuditOperations.AuditDbCfdelete);
                continue;
            }
            if (op.equals("tablecfmodify")) {
                list.add(Common.FSAuditOperations.AuditDbCfmodify);
                continue;
            }
            if (op.equals("tablecfscan")) {
                list.add(Common.FSAuditOperations.AuditDbCfscan);
                continue;
            }
            if (op.equals("tableget")) {
                list.add(Common.FSAuditOperations.AuditDbGet);
                continue;
            }
            if (op.equals("tableput")) {
                list.add(Common.FSAuditOperations.AuditDbPut);
                continue;
            }
            if (op.equals("tablescan")) {
                list.add(Common.FSAuditOperations.AuditDbScan);
                continue;
            }
            if (op.equals("tablecreate")) {
                list.add(Common.FSAuditOperations.AuditDbTablecreate);
                continue;
            }
            if (op.equals("tablemodify")) {
                list.add(Common.FSAuditOperations.AuditDbTablemodify);
                continue;
            }
            if (op.equals("tableinfo")) {
                list.add(Common.FSAuditOperations.AuditDbTableinfo);
                continue;
            }
            if (op.equals("hardlink")) {
                list.add(Common.FSAuditOperations.AuditHardLink);
                continue;
            }
            return false;
        }
        return true;
    }

    CommandOutput volumeRename() throws CLIProcessingException {
        int status;
        String cluster;
        MapRFileSystem fs;
        boolean wasMounted;
        String newVolumeName;
        CLDBProto.VolumeProperties volProps;
        String volumeName;
        CommandOutput.OutputHierarchy out;
        CommandOutput output;
        block26: {
            output = new CommandOutput();
            out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            volumeName = this.getRwVolumeName();
            volProps = this.volumePropetiesLookup(volumeName);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume rename failed, could not fetch properties for volume " + volumeName + ", " + Errno.toString(2)));
                LOG.error((Object)("VolumeRename : Could not find volume properties for " + volumeName));
                return output;
            }
            newVolumeName = this.getParamTextValue(RW_VOLUME_PARAM_NEW_NAME, 0);
            if (volumeName.equals(newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume rename failed, Volume " + newVolumeName + " same as old volume name"));
                LOG.error((Object)("VolumeRename : Volume " + newVolumeName + " same as old volume name"));
                return output;
            }
            if (!VolumeUtils.isValidVolumeNameLength((String)newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name " + newVolumeName + ", Exceeds allowed length of " + VolumeUtils.validVolumeNameLength() + " characters").setField(RW_VOLUME_PARAM_NEW_NAME));
                return output;
            }
            if (!VolumeUtils.isValidVolumeName((String)newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name  Allowed characters " + VolumeUtils.getValidName()).setField(RW_VOLUME_PARAM_NEW_NAME));
                return output;
            }
            CLDBProto.VolumeProperties newVolProps = this.volumePropetiesLookup(newVolumeName);
            if (newVolProps != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume rename failed, Volume " + newVolumeName + " already exists "));
                LOG.error((Object)("VolumeRename : Volume " + newVolumeName + " already exists"));
                return output;
            }
            wasMounted = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to rename volume " + volumeName + " to new name " + newVolumeName));
            }
            CLDBProto.VolumeRenameRequest volumeRename = CLDBProto.VolumeRenameRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).setNewVolumeName(newVolumeName).build();
            fs = MapRCliUtil.getMapRFileSystem();
            cluster = null;
            if (this.isParamPresent("cluster")) {
                cluster = this.getParamTextValue("cluster", 0);
            }
            if (volProps.getMounted()) {
                wasMounted = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume " + volumeName + " is mounted at " + volProps.getMountDir() + ". Trying to unmount before renaming"));
                }
                String volumeMountDir = volProps.getMountDir();
                Common.FidMsg parentFid = volProps.getParentFid();
                status = fs.unmountVolume(cluster, volumeName, volumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
                if (status != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume Unmount before rename failed : " + Errno.toString(status)));
                    LOG.error((Object)("Volume unmount " + volumeName + " before rename" + " failed, " + Errno.toString(status)));
                    return output;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume unmount " + volumeName + " successful before rename"));
                }
                if (!this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Renaming volume " + volumeName + " to new name " + newVolumeName));
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRenameProc.getNumber(), (MessageLite)volumeRename, CLDBProto.VolumeRenameResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRenameProc.getNumber(), (MessageLite)volumeRename, CLDBProto.VolumeRenameResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeRenameResponse resp = CLDBProto.VolumeRenameResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Renamed volume " + volumeName + " to new name " + newVolumeName));
                    }
                    break block26;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Rename: " + Errno.toString(resp.getStatus())));
                LOG.error((Object)("Rename of volume failed, " + Errno.toString(resp.getStatus())));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Rename:  Operation failed"));
                LOG.error((Object)("Exception during volume rename " + e));
                return output;
            }
        }
        if (wasMounted) {
            String volumeMountDir;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Volume " + newVolumeName + ". Trying to mount after renaming from " + volumeName));
            }
            if ((status = fs.mountVolume(cluster, newVolumeName, volumeMountDir = volProps.getMountDir(), this.getUserLoginId())) != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume mount after rename failed : " + Errno.toString(status)));
                LOG.error((Object)("Volume mount " + newVolumeName + " after rename" + " failed, " + Errno.toString(status)));
                return output;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Volume Mount " + volumeName + " successful after rename"));
            }
            if (!this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0) && !this.sleepAndCheckMountedDir(fs, cluster, volumeMountDir)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume rename for " + volumeMountDir + " failed, Could not get status of mount path").setField(RW_VOLUME_PARAM_NAME).setFieldValue(newVolumeName));
                return output;
            }
        }
        return output;
    }

    CommandOutput volumeUpgradeformat() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        ArrayList<String> volumeNames = new ArrayList<String>();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        for (String volumeName : volumeNames) {
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volumeName);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume upgradeformat failed, could not fetch properties for volume " + volumeName + ", " + Errno.toString(2)));
                LOG.error((Object)("VolumeUpgradeformat : Could not find volume properties for " + volumeName));
                continue;
            }
            if (volProps.getVolumetype() != Common.VolumeType.VTRW) {
                if (volProps.getVolumetype() == Common.VolumeType.VTMirror || volProps.getVolumetype() == Common.VolumeType.VTRwConvertibleMirror) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume upgradeformat failed: " + volumeName + " mirror volumes can not be upgraded to new format. " + Errno.toString(22)));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume upgradeformat failed: " + volumeName + " is already in new type. " + Errno.toString(22)));
                }
                LOG.error((Object)("VolumeUpgradeformat : Can not upgrade the format of volume " + volumeName));
                continue;
            }
            CLDBProto.VolumePromoteRequest volumePromote = CLDBProto.VolumePromoteRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Promoting volume " + volumeName));
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumePromoteProc.getNumber(), (MessageLite)volumePromote, CLDBProto.VolumePromoteResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumePromoteProc.getNumber(), (MessageLite)volumePromote, CLDBProto.VolumePromoteResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumePromoteResponse resp = CLDBProto.VolumePromoteResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Upgraded volume " + volumeName + " to new format"));
                    continue;
                }
                if (resp.hasErrMsg()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume upgradeformat failed, for volume " + volumeName + ", " + resp.getErrMsg()));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Upgradeformat: " + Errno.toString(resp.getStatus())));
                }
                LOG.error((Object)("Upgrade of volume to new format failed, " + Errno.toString(resp.getStatus())));
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Upgradeformat:  Operation failed"));
                LOG.error((Object)("Exception during volume upgradeformat " + e));
            }
        }
        return output;
    }

    CommandOutput removeFilteredVolumes() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        boolean forceRemove = false;
        if (this.isParamPresent(RW_VOLUME_PARAM_FORCE)) {
            forceRemove = this.getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        this.list(new CommandOutput.OutputHierarchy());
        if (this.listedVolumes.size() > 0) {
            ArrayList tasks = Lists.newArrayList();
            for (CLDBProto.VolumeInfo volume : this.listedVolumes) {
                CLDBProto.VolumeProperties volProps = volume.getVolProperties();
                VolumeRemoveTask removeTask = new VolumeRemoveTask(volProps, forceRemove, this.getUserCredentials(), cluster);
                if (volProps.getMounted()) {
                    removeTask.setDependencies(new VolumeUnMountTask(volProps, cluster, this.getUserLoginId()));
                }
                tasks.add(removeTask);
            }
            TaskCompletionService service = TaskCompletionService.getInstance();
            service.submitTasks(tasks);
            service.fetchResults();
            this.listedVolumes.clear();
        }
        output.setOutput(out);
        return output;
    }

    CommandOutput volumeRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        ArrayList<String> volumeNames = new ArrayList<String>();
        if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        } else {
            volumeNames.add(rwVolumeName);
        }
        boolean forceRemove = false;
        if (this.isParamPresent(RW_VOLUME_PARAM_FORCE)) {
            forceRemove = this.getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        boolean unmountedOne = false;
        for (String volumeName : volumeNames) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to remove volume " + volumeName));
            }
            CLDBProto.VolumeRemoveRequest volumeRemove = CLDBProto.VolumeRemoveRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).setForceRemove(forceRemove).build();
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volumeName, false);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume Remove: " + Errno.toString(2)));
                LOG.error((Object)("VolumeRemove : Could not find volume properties for " + volumeName));
                continue;
            }
            if (volProps.getNumSnapshots() > 0 && !forceRemove) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(39, "Volume Remove: " + Errno.toString(39) + " Volume has " + volProps.getNumSnapshots() + " Snapshots. " + "Please use -force option to remove Volume and Snapshots"));
                LOG.error((Object)("VolumeRemove: Volume has " + volProps.getNumSnapshots() + "snapshot(s)" + " Use -force option to remove snapshots and volume"));
                continue;
            }
            if (volProps.getMounted()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume " + volumeName + " is mounted at " + volProps.getMountDir() + ". Trying to unmount before removing"));
                }
                String volumeMountDir = volProps.getMountDir();
                Common.FidMsg parentFid = volProps.getParentFid();
                int status = fs.unmountVolume(cluster, volumeName, volumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
                if (status != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume UnMount: " + Errno.toString(status)));
                    LOG.error((Object)("Volume unmount " + volumeName + " before remove" + " failed, " + Errno.toString(status)));
                    continue;
                }
                unmountedOne = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume unmount " + volumeName + " successful before remove"));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing volume " + volumeName));
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRemoveProc.getNumber(), (MessageLite)volumeRemove, CLDBProto.VolumeRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRemoveProc.getNumber(), (MessageLite)volumeRemove, CLDBProto.VolumeRemoveResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeRemoveResponse resp = CLDBProto.VolumeRemoveResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Removed volume " + volumeName));
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Remove: " + Errno.toString(resp.getStatus())));
                LOG.error((Object)("Remove volume failed, " + Errno.toString(resp.getStatus())));
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Remove:  Operation failed"));
                LOG.error((Object)("Exception during volume remove " + e));
            }
        }
        if (unmountedOne && !this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        output.setOutput(out);
        return output;
    }

    CommandOutput volumeMove() throws CLIProcessingException {
        CommandOutput output;
        block8: {
            output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            String volumeName = this.getRwVolumeName();
            String topology = this.getParamTextValue(RW_VOLUME_PARAM_TOPOLOGY, 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to move volume " + volumeName));
            }
            CLDBProto.VolumeTopology topo = CLDBProto.VolumeTopology.newBuilder().setTopologyRestricted(topology).build();
            CLDBProto.VolumeMoveRequest volumeMove = CLDBProto.VolumeMoveRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).setNewTopology(topo).build();
            if (topology.equals("") || !topology.startsWith("/")) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Move: " + Errno.toString(22) + " Invalid topology specified"));
                LOG.error((Object)("VolumeMove: VolumeName: " + volumeName + " Invalid topology " + topology + " specified"));
                return output;
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMoveProc.getNumber(), (MessageLite)volumeMove, CLDBProto.VolumeMoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMoveProc.getNumber(), (MessageLite)volumeMove, CLDBProto.VolumeMoveResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeMoveResponse resp = CLDBProto.VolumeMoveResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("VolumeMove: Volumenaem: " + volumeName + " Updated topology"));
                    }
                    break block8;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Move: " + Errno.toString(resp.getStatus())));
                LOG.error((Object)("Volume move failed, " + Errno.toString(resp.getStatus())));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Move:  Operation failed"));
                LOG.error((Object)("Exception during volume move " + e));
                return output;
            }
        }
        return output;
    }

    public static CLDBProto.VolumeLookupResponse volumeLookup(String cluster, Security.CredentialsMsg creds, String name, String path, boolean isServerCall) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.VolumeLookupRequest volumeInfo = null;
        volumeInfo = name != null ? CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(name).setCreds(creds).build() : CLDBProto.VolumeLookupRequest.newBuilder().setMountDir(path).setCreds(creds).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volumeInfo, CLDBProto.VolumeLookupResponse.class, VolumeCommands.getKeyType((String)cluster, (boolean)isServerCall)) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volumeInfo, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing volume Lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    CommandOutput volumeInfo() throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = null;
        String rwMountDir = null;
        if (this.isParamPresent(RW_VOLUME_PARAM_NAME)) {
            rwVolumeName = this.getRwVolumeName();
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MOUNTDIR)) {
            rwMountDir = this.getParamTextValue(RW_VOLUME_PARAM_MOUNTDIR, 0);
        }
        if (rwVolumeName == null && rwMountDir == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Volume info arguments missing. Pass either volumename or mountdir"));
            return output;
        }
        if (rwVolumeName != null && rwMountDir != null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Volume info has both volumename and mountdir. Pass only one"));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), rwVolumeName, rwMountDir, this.isServerCall)).getStatus() == 0) {
            String opParam = this.getOutputParamValue();
            boolean terse = opParam.equals("terse");
            BitSet columns = this.getColumns();
            this.addVolumeInfo(resp.getVolInfo(), terse, columns, out);
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume lookup of " + (rwVolumeName != null ? rwVolumeName : rwMountDir) + " failed, " + (resp.getStatus() == 2 ? "No such volume" : Errno.toString(resp.getStatus()))).setPropagateErrorSupport(true).setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
        }
        return output;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.VolumeListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.VolumeListRequest.newBuilder((CLDBProto.VolumeListRequest)((CLDBProto.VolumeListRequest)prevReq)) : this.getVolumeListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.VolumeListResponse)prevResp).getVolumesCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 512));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((CLDBProto.VolumeListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.VolumeListResponse)prevResp).getVolumesCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.VolumeListResponse resp = (CLDBProto.VolumeListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        for (CLDBProto.VolumeInfo v : resp.getVolumesList()) {
            this.addVolumeInfo(v, terse, columns, out);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
        this.listedVolumes.addAll(resp.getVolumesList());
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        byte[] data;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeListProc.getNumber(), req, CLDBProto.VolumeListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeListProc.getNumber(), req, CLDBProto.VolumeListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data != null) {
            return this.getVolumeListResponse(data);
        }
        LOG.error((Object)"RPC Request to list volumes failed. No data returned");
        return null;
    }

    private CLDBProto.VolumeListRequest.Builder getVolumeListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM_NAME);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray(columns));
        long columnsOld = BitSetBytesHelperUtils.convert(columns);
        boolean alarmedVolumes = this.getAlarmedVolumesParamValue();
        CLDBProto.VolumeListRequest.Builder req = CLDBProto.VolumeListRequest.newBuilder();
        if (this.isParamPresent(RW_VOLUME_NODES)) {
            String nodesString = this.getParamTextValue(RW_VOLUME_NODES, 0);
            ArrayList<String> nodes = new ArrayList<String>();
            if (nodesString.contains(MULTI_ARG_SEP)) {
                nodes.addAll(Arrays.asList(nodesString.split(MULTI_ARG_SEP)));
            } else {
                nodes.add(nodesString);
            }
            for (String node : nodes) {
                List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(node));
                if (ips.isEmpty()) {
                    LOG.error((Object)("Can not get valid IP address out of provided name: " + node));
                    throw new CLIProcessingException("Invalid Node specified. Could not resolve IP for node : " + node);
                }
                String ipAddress = ips.get(0);
                if (ipAddress == null) continue;
                try {
                    int ip = Util.ipToInt((String)ipAddress);
                    req.addNodeIps(ip);
                }
                catch (NumberFormatException e) {
                    throw new CLIProcessingException("Invalid Node specified. Could not resolve IP for node : " + node);
                }
            }
        }
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 512);
        return req.setCreds(this.getUserCredentials()).addAllFilter(filters).setColumns(columnsOld).setColumnsAdd(bString).setAlarmedvolumes(alarmedVolumes).setLimiter(limiter);
    }

    private boolean getAlarmedVolumesParamValue() throws CLIProcessingException {
        return this.isParamPresent(ALARMEDVOLUMES_PARAM_NAME) ? this.getParamBooleanValue(ALARMEDVOLUMES_PARAM_NAME, 0) : false;
    }

    private BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet();
        columns.set(0, MAX_VOLUMEFIELDINFO + 1);
        String columnsString = this.getColumnsParamValue();
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    private CLDBProto.VolumeListResponse getVolumeListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.VolumeListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into VolumeListResponse proto object.", (Throwable)ipbe);
        }
    }

    void addVolumeInfo(CLDBProto.VolumeInfo volInfo, boolean terse, BitSet columns, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode volumeInfo = new CommandOutput.OutputHierarchy.OutputNode();
        ArrayList<String> messages = new ArrayList<String>();
        this.formatVolumeInfo(volInfo, terse, columns, volumeInfo, messages);
        out.addNode(volumeInfo);
        for (String msg : messages) {
            out.addMessage(msg);
        }
    }

    private static CommandOutput.OutputHierarchy.OutputNode formatNoteState(CLDBProto.NoteStateInfo nsInfo) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Uid", nsInfo.getUid()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Date", (Object)nsInfo.getDate()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Comment", (Object)nsInfo.getComment()));
        return out;
    }

    private static CommandOutput.OutputHierarchy.OutputNode formatNote(CLDBProto.Note note) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NoteState", (Object)note.getState()));
        if (note.hasAdded()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NoteAdded", (Object)VolumeCommands.formatNoteState(note.getAdded())));
        }
        if (note.hasResolved()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NoteResolved", (Object)VolumeCommands.formatNoteState(note.getResolved())));
        }
        return out;
    }

    private static CommandOutput.OutputHierarchy formatNoteEntryList(List<CLDBProto.NoteEntry> noteEntryList) {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.NoteEntry ne : noteEntryList) {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Notename", (Object)ne.getNoteName()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Note", (Object)VolumeCommands.formatNote(ne.getNote())));
            oh.addNode(out);
        }
        return oh;
    }

    void formatVolumeInfo(CLDBProto.VolumeInfo volInfo, boolean terse, BitSet columns, CommandOutput.OutputHierarchy.OutputNode volumeInfo, ArrayList<String> messages) {
        Integer ro;
        String rp;
        CLDBProto.VolumeProperties props = volInfo.getVolProperties();
        List<Common.PluggableAlarm> pluggableAlarms = null;
        try {
            pluggableAlarms = PluggableAlarmUtil.getVolumeAlarms(this.getUserCredentials(), 0, 50);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Error getting alarms. Alarm message might be incomplete: " + e.getMessage()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.noteEntries.getNumber())) {
            CommandOutput.OutputHierarchy oh = VolumeCommands.formatNoteEntryList(volInfo.getNotesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : oh.getOutputNodes()) {
                volumeInfo.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.noteEntries)).getName(terse), (Object)a));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.acl.getNumber())) {
            String format = terse ? "terse" : "short";
            CommandOutput.OutputHierarchy volAcl = AclCommands.formatAcl(props.getAcl(), CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, format, this.uInfo, null, null);
            for (CommandOutput.OutputHierarchy.OutputError e : volAcl.getOutputErrors()) {
                LOG.info((Object)("Error in volume output:" + e.toString()));
            }
            for (CommandOutput.OutputHierarchy.OutputNode a : volAcl.getOutputNodes()) {
                LOG.info((Object)("Output Node:" + a.toJSONString()));
                volumeInfo.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.acl)).getName(terse), (Object)a));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.owner.getNumber())) {
            int ownerId = props.getOwnerId();
            String ownerName = null;
            try {
                ownerName = this.uInfo.getUsername(ownerId);
            }
            catch (SecurityException se) {
                ownerName = "Uid " + ownerId;
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.owner)).getName(terse), (Object)ownerName));
        }
        if (props.hasVolumeAe() && (columns.get(CLDBProto.VolumeInfoFields.aeName.getNumber()) || columns.get(CLDBProto.VolumeInfoFields.aeType.getNumber()))) {
            CLDBProto.AeKey key = props.getVolumeAe();
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.aeName)).getName(terse), (Object)key.getName()));
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.aeType)).getName(terse), key.getType() ? 1 : 0));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.numReplicas.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numReplicas)).getName(terse), (Object)Integer.toString(props.getReplicationPolicy().getNumReplicas())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.minReplicas.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.minReplicas)).getName(terse), (Object)Integer.toString(props.getReplicationPolicy().getGuaranteedMinReplicas())));
        }
        if (props.hasNumNamespaceReplicas() && columns.get(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas)).getName(terse), (Object)Integer.toString(props.getNumNamespaceReplicas())));
        }
        if (props.hasGuaranteedMinNamespaceReplicas() && columns.get(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas)).getName(terse), (Object)Integer.toString(props.getGuaranteedMinNamespaceReplicas())));
        }
        if (props.hasAllowGrant() && columns.get(CLDBProto.VolumeInfoFields.allowGrant.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.allowGrant)).getName(terse), (Object)Boolean.toString(props.getAllowGrant())));
        }
        if (props.hasReReplicationTimeOutSec() && columns.get(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec)).getName(terse), (Object)Integer.toString(props.getReReplicationTimeOutSec())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dataContainerRepltype.getNumber())) {
            Common.ContainerReplType type = Common.ContainerReplType.CASCADE;
            if (props.getReplicationPolicy().hasDataContainerReplType()) {
                type = props.getReplicationPolicy().getDataContainerReplType();
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dataContainerRepltype)).getName(terse), (Object)this.getContainerReplTypeString(type)));
        }
        boolean localVolumeReplOne = false;
        String topo = props.getTopology().getTopologyRestricted();
        if (props.getLocalVolume() && props.getReplicationPolicy().getNumReplicas() == 1) {
            localVolumeReplOne = true;
            if (props.hasLocalTopology()) {
                topo = props.getLocalTopology().getTopologyRestricted();
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.rackPath.getNumber())) {
            rp = topo.equals("") ? "/" : topo;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.rackPath)).getName(terse), (Object)rp));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.localPath.getNumber()) && props.hasLocalTopology() && !localVolumeReplOne) {
            rp = props.getLocalTopology().getTopologyRestricted().equals("") ? "/" : props.getLocalTopology().getTopologyRestricted();
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.localPath)).getName(terse), (Object)rp));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mirrorThrottle.getNumber()) && props.hasMirrorThrottle()) {
            ro = props.getMirrorThrottle() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorThrottle)).getName(terse), (Object)Integer.toString(ro)));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeAccessTime.getNumber())) {
            DateFormat formatter = DateFormat.getDateInstance(1, Locale.getDefault());
            String rp2 = volInfo.hasAtime() ? formatter.format(new Date(volInfo.getAtime())) : "Missing Atime";
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeAccessTime)).getName(terse), (Object)rp2));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.readOnly.getNumber())) {
            ro = props.getReadOnly() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.readOnly)).getName(terse), (Object)Integer.toString(ro)));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mountDir.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mountDir)).getName(terse), (Object)props.getMountDir()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeName.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeName)).getName(terse), (Object)props.getVolumeName()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mounted.getNumber())) {
            Integer m = props.getMounted() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mounted)).getName(terse), (Object)m));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.quota.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.quota)).getName(terse), (Object)Long.toString(props.getVolumeQuotaSizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.advisoryquota.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.advisoryquota)).getName(terse), (Object)Long.toString(props.getVolumeQuotaAdvisorySizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.snapshotcount.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotcount)).getName(terse), (Object)Integer.toString(props.getNumSnapshots())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.logicalUsed.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.logicalUsed)).getName(terse), (Object)Long.toString(volInfo.getVolQuota().getVolumeLogicalUsedSizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.used)).getName(terse), (Object)Long.toString(volInfo.getVolQuota().getVolumeUsedSizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.snapshotUsed.getNumber())) {
            long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
            if ((snapSize -= volInfo.getVolQuota().getVolumeSharedSizeMB()) < 0L) {
                snapSize = 0L;
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotUsed)).getName(terse), (Object)Long.toString(snapSize)));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.totalUsed.getNumber())) {
            long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
            if (snapSize < 0L) {
                snapSize = 0L;
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.totalUsed)).getName(terse), (Object)Long.toString(snapSize + volInfo.getVolQuota().getVolumeOwnedSizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.schedule.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.schedule)).getName(terse), (Object)volInfo.getVolProperties().getSchedulingPolicyId()));
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.scheduleName)).getName(terse), (Object)volInfo.getVolProperties().getSchedulingPolicyName()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mirrorSchedule.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSchedule)).getName(terse), (Object)volInfo.getVolProperties().getMirrorSchedulingPolicyId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeType.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeType)).getName(terse), props.getIsMirrorVol() ? 1 : 0));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mirrorType.getNumber())) {
            int mtype;
            int n = mtype = props.getIsMirrorVol() ? 1 : 0;
            if (props.hasVolumetype() && props.getVolumetype().getNumber() != 0) {
                mtype = props.getVolumetype().getNumber();
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorType)).getName(terse), mtype));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.CreatorContainerId.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CreatorContainerId)).getName(terse), props.getCreatorContainerId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.CreatorVolumeUuid.getNumber())) {
            StringBuilder creatorVolUuid = new StringBuilder();
            if (props.hasCreatorVolumeUuid()) {
                creatorVolUuid.append(props.getCreatorVolumeUuid().getId640());
                creatorVolUuid.append(":");
                creatorVolUuid.append(props.getCreatorVolumeUuid().getId641());
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CreatorVolumeUuid)).getName(terse), (Object)creatorVolUuid.toString()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeId.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeId)).getName(terse), volInfo.getVolumeId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.listReplicas.getNumber())) {
            if (volInfo.getVolumeReplicationList().size() > 0) {
                for (CLDBProto.VolumeReplicationInfo vrInfo : volInfo.getVolumeReplicationList()) {
                    volumeInfo.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.listReplicas)).getName(terse), (Object)vrInfo.getPercent()));
                }
            } else if (props.getVolumeName() != null && props.getVolumeName().length() != 0) {
                volumeInfo.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.listReplicas)).getName(terse), (Object)("Information is not yet available for volume '" + props.getVolumeName() + "'. Please try again.")));
            } else {
                volumeInfo.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.listReplicas)).getName(terse), (Object)"Information is not yet available for volume. Please try again."));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.nameContainerSize.getNumber()) && volInfo.getRootContainerSizeMB() >= 0L) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerSize)).getName(terse), volInfo.getRootContainerSizeMB()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.nameContainerId.getNumber()) && volInfo.hasRootContainer()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerId)).getName(terse), volInfo.getRootContainer().getContainerId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.needsGfsck.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.needsGfsck)).getName(terse), (Object)props.getNeedsGfsck()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold)).getName(terse), (Object)Long.toString(props.getMaxInodesAlarmThreshold())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh)).getName(terse), (Object)Integer.toString(props.getDbReplLagSecAlarmThresh())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.limitSpread.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.limitSpread)).getName(terse), (Object)Boolean.toString(props.getLimitVolumeSpread())));
        }
        if (volInfo.hasPartlyOutOfTopology() && columns.get(CLDBProto.VolumeInfoFields.partlyOutOfTopology.getNumber())) {
            Integer poot = volInfo.getPartlyOutOfTopology() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.partlyOutOfTopology)).getName(terse), (Object)poot));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.isAuditVolume.getNumber())) {
            Integer isAudited = props.getIsAuditVolume() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.isAuditVolume)).getName(terse), (Object)isAudited));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.audited.getNumber())) {
            Integer auditEnabled = props.getAudited() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.audited)).getName(terse), (Object)auditEnabled));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.coalesceInterval.getNumber())) {
            Integer coalesceInterval = props.getCoalesceInterval();
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.coalesceInterval)).getName(terse), (Object)coalesceInterval));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations)).getName(terse), (Object)GetStringsForAuditOps.getEnabledOps(props.getFsAuditDisabledOperations())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations)).getName(terse), (Object)GetStringsForAuditOps.getDisabledOps(props.getFsAuditDisabledOperations())));
        }
        if (props.hasMirrorInfo()) {
            CLDBProto.MirrorInfo mirrorInfo = props.getMirrorInfo();
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorSrcVolume.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolume)).getName(terse), (Object)mirrorInfo.getSrcVolumeName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId)).getName(terse), mirrorInfo.getSrcVolumeId()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorSrcClusterName.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcClusterName)).getName(terse), (Object)mirrorInfo.getSrcClusterName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName)).getName(terse), (Object)mirrorInfo.getDataGeneratorSrcVolumeName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId)).getName(terse), mirrorInfo.getDataGeneratorSrcVolumeId()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName)).getName(terse), (Object)mirrorInfo.getDataGeneratorSrcClusterName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime)).getName(terse), mirrorInfo.getLastSuccessfulMirrorTime()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorPercentComplete.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorPercentComplete)).getName(terse), mirrorInfo.getPercentComplete()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorId.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorId)).getName(terse), mirrorInfo.getMirrorId()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.nextMirrorId.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nextMirrorId)).getName(terse), mirrorInfo.getNextMirrorId()));
            }
            int mirrorStatus = 0;
            mirrorStatus = mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE || mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_CONVERT_COMPLETE ? 0 : (mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED ? 2 : 1);
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorStatus.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorStatus)).getName(terse), mirrorStatus));
            }
            if (mirrorStatus == 2 && columns.get(CLDBProto.VolumeInfoFields.mirrorErrorCode.getNumber())) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorErrorCode)).getName(terse), mirrorInfo.getErrorCode()));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.numContainers.getNumber()) && props.hasNumContainers()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numContainers)).getName(terse), (Object)Integer.toString(props.getNumContainers())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeAces.getNumber()) && volInfo.hasVolumeAces()) {
            CommandOutput.OutputHierarchy.OutputNode volumeAcesNode = new CommandOutput.OutputHierarchy.OutputNode("volumeAces");
            try {
                for (Common.VolumeAceEntry aceEntry : volInfo.getVolumeAces().getAcesList()) {
                    if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_READ) {
                        volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(VOL_READACE_PARAM, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                        continue;
                    }
                    if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_WRITE) {
                        volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(VOL_WRITEACE_PARAM, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                        continue;
                    }
                    Assert.assertNotNull(null);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to parse volume aces");
            }
            volumeInfo.addChild(volumeAcesNode);
        }
        if (columns.get(CLDBProto.VolumeInfoFields.fixCreatorId.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.fixCreatorId)).getName(terse), (Object)Boolean.toString(props.getUseActualCreatorId())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.replTypeConversionInProgress.getNumber())) {
            Integer inProgress = props.getReplTypeConversionInProgress() ? 1 : 0;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.replTypeConversionInProgress)).getName(terse), (Object)Integer.toString(inProgress)));
        }
        block11: for (Common.AlarmMsg vAlarm : volInfo.getVolumeAlarmsList()) {
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_SNAPSHOT_FAILURE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_MIRROR_FAILURE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.MirrorFailureAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.MirrorFailureAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DATA_UNAVAILABLE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.DataUnavailableAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.DataUnavailableAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DATA_UNDER_REPLICATED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_ADVISORY_QUOTA_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_QUOTA_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.QuotaExceededAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.QuotaExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_NO_NODES_IN_TOPOLOGY) {
                if (!columns.get(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_TOPOLOGY_ALMOST_FULL) {
                if (!columns.get(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_TOPOLOGY_FULL) {
                if (!columns.get(CLDBProto.VolumeInfoFields.FullTopologyAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.FullTopologyAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_INODES_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.InodesExceededAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.InodesExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DATA_CONTAINERS_NONLOCAL) {
                if (!columns.get(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_CANNOT_MIRROR) {
                if (!columns.get(CLDBProto.VolumeInfoFields.CannotMirrorAlarm.getNumber())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CannotMirrorAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            for (Common.PluggableAlarm pluggableAlarm : pluggableAlarms) {
                if (!vAlarm.getAlarmName().equals(pluggableAlarm.getName())) continue;
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(terse ? pluggableAlarm.getTerse() : pluggableAlarm.getDisplayName(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue block11;
            }
        }
    }

    String GetVolumeNameFromVolAndClusterName(String fullName) {
        int index = fullName.indexOf(64);
        if (index == -1 || index == 0) {
            return null;
        }
        return fullName.substring(0, index);
    }

    String GetClusterNameFromVolAndClusterName(String fullName) {
        int index = fullName.indexOf(64);
        if (index == -1 || index == 0) {
            return null;
        }
        return fullName.substring(index + 1, fullName.length());
    }

    String CldbIPFromClusterName(String ClusterName) {
        int index = ClusterName.indexOf(58);
        if (index == -1 || index == 0) {
            return null;
        }
        return ClusterName.substring(0, index);
    }

    int CldbPortFromClusterName(String ClusterName) {
        int index = ClusterName.indexOf(58);
        if (index == -1 || index == 0) {
            return 0;
        }
        try {
            int cldbPort = Integer.parseInt(ClusterName.substring(index + 1, ClusterName.length()));
            return cldbPort;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    boolean IsItConvertibleVolume(Common.VolumeType type) {
        return type != Common.VolumeType.VTRW && type != Common.VolumeType.VTMirror;
    }

    int UpdateMirrorSourceVolumeName(String destVolumeName, CLDBProto.VolumeProperties.Builder volProps, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.MirrorInfo.MirrorStatus mStatus;
        boolean isDestClusterSecure;
        boolean isSourceClusterSecure;
        String srcVolumeFullName = this.getParamTextValue(MIRROR_VOLUME_SRC_VOLUMENAME, 0);
        String srcVolumeName = this.GetVolumeNameFromVolAndClusterName(srcVolumeFullName);
        String srcClusterName = this.GetClusterNameFromVolAndClusterName(srcVolumeFullName);
        if (srcVolumeName == null || srcClusterName == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name " + srcVolumeName + " is " + "not specified in format srcvolume@srccluster").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 22;
        }
        if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(srcClusterName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster name " + srcClusterName).setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 22;
        }
        String destClusterName = null;
        destClusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (destVolumeName.equalsIgnoreCase(srcVolumeName) && destClusterName.equalsIgnoreCase(srcClusterName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specified source " + srcVolumeFullName + " is same as destination").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 22;
        }
        if (!destClusterName.equalsIgnoreCase(srcClusterName) && (isSourceClusterSecure = JNISecurity.IsSecurityEnabled(srcClusterName)) ^ (isDestClusterSecure = JNISecurity.IsSecurityEnabled(destClusterName))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "In cross cluster mirroring, both clusters must be either secure or unsecure. Other combination is not allowed."));
            return 22;
        }
        CLDBProto.VolumeLookupRequest.Builder srcVolumeLookupReq = CLDBProto.VolumeLookupRequest.newBuilder();
        CLDBProto.VolumeLookupResponse srcVolumeLookupResp = null;
        srcVolumeLookupReq.setVolumeName(srcVolumeName);
        srcVolumeLookupReq.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(srcClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)srcVolumeLookupReq.build(), CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            srcVolumeLookupResp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + srcClusterName, (Throwable)e);
        }
        if (!srcVolumeLookupResp.hasStatus() || srcVolumeLookupResp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Source volume " + srcVolumeName + " doesn't exist in cluster " + srcClusterName).setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 10003;
        }
        CLDBProto.VolumeLookupRequest.Builder destVolumeLookupReq = CLDBProto.VolumeLookupRequest.newBuilder();
        CLDBProto.VolumeLookupResponse destVolumeLookupResp = null;
        destVolumeLookupReq.setVolumeName(destVolumeName);
        destVolumeLookupReq.setCreds(this.getUserCredentials());
        data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)destVolumeLookupReq.build(), CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)destVolumeLookupReq.build(), CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(70, "Exception while communicating with CLDB for volume " + destVolumeName));
                return 70;
            }
            destVolumeLookupResp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (!destVolumeLookupResp.hasStatus() || destVolumeLookupResp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(destVolumeLookupResp.getStatus(), "volume " + destVolumeName + " doesn't exist "));
                return destVolumeLookupResp.getStatus();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(70, "Exception while communicating with CLDB for volume " + destVolumeName));
            return 70;
        }
        boolean isDestMirrorVol = destVolumeLookupResp.getVolInfo().getVolProperties().getIsMirrorVol();
        if (!this.isParamPresent(MIRROR_VOLUME) && !isDestMirrorVol) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot update the 'source' property of Volume '" + destVolumeName + "' because it is not a mirror volume"));
            return 22;
        }
        CLDBProto.MirrorInfo destVolMirrorInfo = null;
        if (isDestMirrorVol && (mStatus = (destVolMirrorInfo = destVolumeLookupResp.getVolInfo().getVolProperties().getMirrorInfo()).getMirrorStatus()) != CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE && mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_CONVERT_COMPLETE && mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(115, "Cannot update the 'source' property of Volume '" + destVolumeName + "' because mirroring is in progress on the volume"));
            return 115;
        }
        CLDBProto.VolumeProperties srcVolProp = srcVolumeLookupResp.getVolInfo().getVolProperties();
        CLDBProto.VolumeProperties destVolProp = destVolumeLookupResp.getVolInfo().getVolProperties();
        if (!this.canPerformVolumeAction(srcClusterName, srcVolumeName, srcVolProp, SecurityCommandHelper.VOLUME_DUMP_MASK, this.getUserCredentials(), out) && !this.canPerformVolumeAction(destClusterName, destVolumeName, destVolProp, SecurityCommandHelper.VOLUME_RESTORE_MASK, this.getUserCredentials(), out)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "User doesn't have permissions to update source mirror of " + destVolumeName + " to " + srcVolumeFullName));
            return 1;
        }
        if (srcVolProp.hasCreatorVolumeUuid() && destVolProp.hasCreatorVolumeUuid()) {
            Common.GuidMsg srcVolGuid = srcVolProp.getCreatorVolumeUuid();
            Common.GuidMsg destVolGuid = destVolProp.getCreatorVolumeUuid();
            if (srcVolGuid.getId640() != destVolGuid.getId640() || srcVolGuid.getId641() != destVolGuid.getId641()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not update the 'source' property of Volume '" + destVolumeName + "' because new source volume creator volumeuuid didn't match'"));
                return 22;
            }
        } else {
            int srcDataGeneratorVolumeId = 0;
            boolean hasVolumeUUID = false;
            long srcDataGeneratorVolumeUUID = 0L;
            long destDataGeneratorVolumeUUID = 0L;
            String srcDataGeneratorVolumeName = null;
            String srcDataGeneratorClusterName = null;
            if (srcVolProp.getIsMirrorVol()) {
                srcDataGeneratorVolumeId = srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeId();
                srcDataGeneratorClusterName = srcVolProp.getMirrorInfo().getDataGeneratorSrcClusterName();
                srcDataGeneratorVolumeName = srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeName();
                if (srcVolProp.getMirrorInfo().hasDataGeneratorSrcVolumeUUID()) {
                    hasVolumeUUID = true;
                    srcDataGeneratorVolumeUUID = srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeUUID();
                }
            } else {
                srcDataGeneratorVolumeId = srcVolProp.getVolumeId();
                srcDataGeneratorClusterName = srcClusterName;
                srcDataGeneratorVolumeName = srcVolumeName;
                if (srcVolProp.hasVolumeUUID()) {
                    hasVolumeUUID = true;
                    srcDataGeneratorVolumeUUID = srcVolProp.getVolumeUUID();
                }
            }
            boolean volumeUUIDMatched = true;
            if (hasVolumeUUID && isDestMirrorVol && destVolMirrorInfo.hasDataGeneratorSrcVolumeUUID() && srcDataGeneratorVolumeUUID != (destDataGeneratorVolumeUUID = destVolMirrorInfo.getDataGeneratorSrcVolumeUUID())) {
                volumeUUIDMatched = false;
            }
            if (isDestMirrorVol && (destVolMirrorInfo.getDataGeneratorSrcVolumeId() != srcDataGeneratorVolumeId || destVolMirrorInfo.getDataGeneratorSrcClusterName().compareTo(srcDataGeneratorClusterName) != 0 || !volumeUUIDMatched)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not update the 'source' property of Volume '" + destVolumeName + "' because new source volume '" + srcVolumeName + "' contains data originated " + " on volume " + srcDataGeneratorVolumeName + "(" + srcDataGeneratorVolumeId + ")@" + srcDataGeneratorClusterName + " volumeUUID " + srcDataGeneratorVolumeUUID + " and the volume '" + destVolumeName + "' contains data originated from " + destVolMirrorInfo.getDataGeneratorSrcVolumeName() + "(" + destVolMirrorInfo.getDataGeneratorSrcVolumeId() + ")@" + destVolMirrorInfo.getDataGeneratorSrcClusterName() + " volumeUUID " + destDataGeneratorVolumeUUID));
                return 22;
            }
        }
        if (srcVolProp.hasVolumetype() && destVolProp.hasVolumetype() && this.IsItConvertibleVolume(srcVolProp.getVolumetype()) != this.IsItConvertibleVolume(destVolProp.getVolumetype())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not update the 'source' property of Volume '" + destVolumeName + "' because new source volume type is not compatible."));
            return 22;
        }
        CLDBProto.MirrorInfo.Builder mirror = CLDBProto.MirrorInfo.newBuilder();
        mirror.setSrcVolumeId(srcVolumeLookupResp.getVolInfo().getVolumeId()).setSrcVolumeName(srcVolumeName).setSrcClusterName(srcClusterName);
        volProps.setMirrorInfo(mirror.build());
        return 0;
    }

    private boolean canPerformVolumeAction(String clusterName, String volumeName, CLDBProto.VolumeProperties volProps, int actionMask, Security.CredentialsMsg creds, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (clusterName == null) {
            clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        }
        return this.authManager.canPerformVolumeAction(clusterName, volumeName, volProps, actionMask, creds, out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput volumeModify() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String name = this.getRwVolumeName();
        ArrayList<String> rwVolumeNames = new ArrayList<String>();
        if (name.contains(MULTI_ARG_SEP)) {
            rwVolumeNames.addAll(Arrays.asList(name.split(MULTI_ARG_SEP)));
        } else {
            rwVolumeNames.add(name);
        }
        Iterator i$ = rwVolumeNames.iterator();
        while (i$.hasNext()) {
            List<Security.AclEntry> elements;
            boolean failed;
            List perms;
            String fsOperations;
            int scheduleId;
            String rwVolumeName = (String)i$.next();
            CLDBProto.VolumeUpdateRequest.Builder volumeUpdate = CLDBProto.VolumeUpdateRequest.newBuilder();
            CLDBProto.VolumeProperties.Builder volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(rwVolumeName);
            CLDBProto.VolumeProperties savedVolProps = this.volumePropetiesLookup(rwVolumeName);
            if (savedVolProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(2) + " Volume not found"));
                LOG.error((Object)("Volume  " + rwVolumeName + " Volume not found"));
                continue;
            }
            if (this.isParamPresent(VOLUME_SCHEDULE)) {
                scheduleId = this.getParamIntValue(VOLUME_SCHEDULE, 0);
                volProps.setSchedulingPolicyId(scheduleId);
            }
            if (this.isParamPresent(VOLUME_MIRROR_SCHEDULE)) {
                scheduleId = this.getParamIntValue(VOLUME_MIRROR_SCHEDULE, 0);
                volProps.setMirrorSchedulingPolicyId(scheduleId);
            }
            if (this.isParamPresent(VOLUME_LIMIT_SPREAD)) {
                boolean limitSpread = this.getParamBooleanValue(VOLUME_LIMIT_SPREAD, 0);
                volProps.setLimitVolumeSpread(limitSpread);
            }
            if (this.isParamPresent(ALLOW_GRANT)) {
                boolean grant = this.getParamBooleanValue(ALLOW_GRANT, 0);
                volProps.setAllowGrant(grant);
            }
            if (this.isParamPresent(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC)) {
                int timeout = this.getParamIntValue(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, 0);
                volProps.setReReplicationTimeOutSec(timeout);
            }
            if (this.isParamPresent(RW_FIX_CREATOR_ID)) {
                boolean val = this.getParamBooleanValue(RW_FIX_CREATOR_ID, 0);
                if (!val) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + " Invalid value for " + RW_FIX_CREATOR_ID));
                    continue;
                }
                volProps.setUseActualCreatorId(true);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
                CLDBProto.ReplicationPolicy.Builder replPolicy;
                block83: {
                    replPolicy = CLDBProto.ReplicationPolicy.newBuilder();
                    int repl = savedVolProps.getReplicationPolicy().getNumReplicas();
                    if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION)) {
                        repl = this.getParamIntValue(RW_VOLUME_PARAM_REPLICATION, 0);
                        if (repl > 0) {
                            replPolicy.setNumReplicas(repl);
                            if (repl > this.maxVolumeReplicationFactor) {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume modify of " + rwVolumeName + " failed. The maximum value allowed for the replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                                LOG.error((Object)("Requested replication factor too large for volume modify " + repl));
                                return output;
                            }
                        } else {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(22) + " Invalid replication"));
                            LOG.error((Object)("Invalid replication for Volume modify " + repl));
                            continue;
                        }
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION)) {
                        int minRepl = this.getParamIntValue(RW_VOLUME_PARAM_MIN_REPLICATION, 0);
                        if (minRepl > 0) {
                            if (repl > 0 && minRepl > repl) {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(22) + " Min replication greater than replication"));
                                LOG.error((Object)("Volume modify with minreplication " + repl + "greater than replicaton"));
                                continue;
                            }
                            replPolicy.setGuaranteedMinReplicas(minRepl);
                            break block83;
                        } else {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(22) + " Invalid min replication"));
                            LOG.error((Object)("Volume modify with invalid minreplication " + repl));
                            continue;
                        }
                    }
                    if (savedVolProps.getReplicationPolicy().getGuaranteedMinReplicas() > repl) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "VolumeModify: VolumeName: " + rwVolumeName + ". Replication is less than min replication of " + savedVolProps.getReplicationPolicy().getGuaranteedMinReplicas() + ". Please specify both replication and minreplication"));
                        continue;
                    }
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
                    String stype = this.getParamTextValue(RW_VOLUME_PARAM_DCREPLTYPE, 0);
                    Common.ContainerReplType rtype = this.getContainerReplType(stype);
                    if (rtype == Common.ContainerReplType.INVALID) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modification of " + rwVolumeName + " failed, due to invalid replicationtype " + stype));
                        continue;
                    }
                    replPolicy.setDataContainerReplType(rtype);
                }
                volProps.setReplicationPolicy(replPolicy.build());
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
                int repl = 0;
                if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
                    repl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, 0);
                    if (repl <= 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + ", " + Errno.toString(22) + " Invalid namespace replication"));
                        LOG.error((Object)("Invalid namespace replication for Volume modify " + repl));
                        continue;
                    }
                    if (repl > this.maxVolumeReplicationFactor) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume modify of " + rwVolumeName + " failed. The maximum value allowed for the namespace replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                        LOG.error((Object)("Requested namespace replication factor too large for volume modify " + repl));
                        return output;
                    }
                    volProps.setNumNamespaceReplicas(repl);
                } else {
                    repl = savedVolProps.getNumNamespaceReplicas();
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
                    int minRepl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, 0);
                    if (minRepl <= 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + ", " + Errno.toString(22) + " Invalid namespace min replication"));
                        LOG.error((Object)("Volume modify with invalid namespace minreplication " + repl));
                        return output;
                    }
                    if (minRepl > repl) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + ", " + Errno.toString(22) + " Min namespace replication greater than replication"));
                        LOG.error((Object)("Volume modify with namespace minreplication " + repl + "greater than replicaton"));
                        continue;
                    }
                    volProps.setGuaranteedMinNamespaceReplicas(minRepl);
                } else if (savedVolProps.getGuaranteedMinNamespaceReplicas() > repl) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "VolumeModify: VolumeName: " + rwVolumeName + ". namespace Replication is less than namespace min replication of " + savedVolProps.getGuaranteedMinNamespaceReplicas() + ". Please specify both namespace replication and namespace minreplication"));
                    continue;
                }
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_READONLY)) {
                boolean readOnly = this.getParamBooleanValue(RW_VOLUME_PARAM_READONLY, 0);
                volProps.setReadOnly(readOnly);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_MIRRORTHROTTLE)) {
                boolean mirrorThrottle = this.getParamBooleanValue(RW_VOLUME_PARAM_MIRRORTHROTTLE, 0);
                volProps.setMirrorThrottle(mirrorThrottle);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_AE) || this.isParamPresent(RW_VOLUME_PARAM_AETYPE)) {
                boolean aetype;
                if (this.isParamPresent(RW_VOLUME_PARAM_AETYPE) && !this.isParamPresent(RW_VOLUME_PARAM_AE)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify both aetype and ae while modifying AE for volume " + rwVolumeName));
                    continue;
                }
                String aename = this.getParamTextValue(RW_VOLUME_PARAM_AE, 0);
                boolean bl = aetype = this.isParamPresent(RW_VOLUME_PARAM_AETYPE) ? this.getParamBooleanValue(RW_VOLUME_PARAM_AETYPE, 0) : false;
                if (!this.checkEntityExists(aetype, aename)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid AE specified while trying to modify Volume " + rwVolumeName));
                    LOG.error((Object)"Volume modify with invalid AE ");
                    continue;
                }
                CLDBProto.AeKey.Builder keyBuilder = CLDBProto.AeKey.newBuilder();
                keyBuilder.setName(aename);
                keyBuilder.setType(aetype);
                volProps.setVolumeAe(keyBuilder);
            }
            long quotaMB = savedVolProps.getVolumeQuotaSizeMB();
            if (this.isParamPresent(RW_VOLUME_PARAM_QUOTA)) {
                String quotaString = this.getParamTextValue(RW_VOLUME_PARAM_QUOTA, 0);
                quotaMB = MapRCliUtil.quotaStringToMB(quotaString);
                if (quotaMB < 0L) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(22) + " Invalid quota size. Should be either an Integer, or a decimal value" + " followed by one of (M,MB,G,GB,T,TB,P,PB)"));
                    LOG.error((Object)("Invalid quota during Volume modify " + quotaString));
                    continue;
                }
                volProps.setVolumeQuotaSizeMB(quotaMB);
            }
            long advisoryQuotaMB = savedVolProps.getVolumeQuotaAdvisorySizeMB();
            if (this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA)) {
                String quotaString = this.getParamTextValue(RW_VOLUME_PARAM_ADVISORY_QUOTA, 0);
                advisoryQuotaMB = MapRCliUtil.quotaStringToMB(quotaString);
                if (advisoryQuotaMB == -1L) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(22) + " Invalid advisory quota size. Should be either an Integer, or a decimal value" + " followed by one of (M,MB,G,GB,T,TB,P,PB)"));
                    LOG.error((Object)("Invalid advisory quota during Volume modify " + quotaString));
                    continue;
                }
                volProps.setVolumeQuotaAdvisorySizeMB(advisoryQuotaMB);
            }
            if ((this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA) || this.isParamPresent(RW_VOLUME_PARAM_QUOTA)) && quotaMB > 0L && advisoryQuotaMB > quotaMB) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify of " + rwVolumeName + " with advisory quota greater than volume quota").setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));
                return output;
            }
            if (this.isParamPresent(ADD_VOLUME_NOTE) && this.isParamPresent(RESOLVE_VOLUME_NOTE)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify: Volumename " + rwVolumeName + " failed. Only one of addNotes or resolveNote can be specified at a time."));
                return output;
            }
            if (this.isParamPresent(ADD_VOLUME_NOTE) || this.isParamPresent(RESOLVE_VOLUME_NOTE)) {
                StringBuilder msg = new StringBuilder();
                CLDBProto.NoteOperation noteOper = this.getNoteOperation(msg);
                if (noteOper == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify: Volumename " + rwVolumeName + " failed. " + msg.toString()));
                    return output;
                }
                volumeUpdate.setNoteOp(noteOper);
            }
            if (this.isParamPresent(PRESERVE_VOLUME)) {
                if (savedVolProps.hasIsWorm() && savedVolProps.getIsWorm()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify: Volumename " + rwVolumeName + " already a worm volume."));
                    return output;
                }
                boolean preserve = this.getParamBooleanValue(PRESERVE_VOLUME, 0);
                CLDBProto.WormSettings.Builder wsb = CLDBProto.WormSettings.newBuilder();
                if (preserve) {
                    if (this.isParamPresent(CHECKIN_TIME_MIN)) {
                        int checkin = this.getParamIntValue(CHECKIN_TIME_MIN, 0);
                        wsb.setCommitTimeMinutes(checkin);
                    }
                    if (this.isParamPresent(RETENTION_PERIOD_DAYS)) {
                        int retain = this.getParamIntValue(RETENTION_PERIOD_DAYS, 0);
                        wsb.setRetentionPeriodDays(retain);
                    }
                }
                volProps.setIsWorm(true);
                volProps.setWormConfig(wsb.build());
            }
            if (this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                int err = this.UpdateMirrorSourceVolumeName(rwVolumeName, volProps, out);
                if (err != 0) {
                    LOG.error((Object)("Failed to update the mirror source volume inforation  for volume " + rwVolumeName + " input source volume name " + this.getParamTextValue(MIRROR_VOLUME_SRC_VOLUMENAME, 0)));
                    continue;
                }
                volumeUpdate.setMirrorOp(CLDBProto.VolumeUpdateRequest.MirrorOp.MIRROR_SRC_UPDATE);
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("audit")) {
                if (this.isParamPresent(VOLUME_AUDIT_ENABLED)) {
                    boolean audited = this.getParamBooleanValue(VOLUME_AUDIT_ENABLED, 0);
                    volProps.setAudited(audited);
                }
            } else if (this.isParamPresent(AUDIT_ENABLED)) {
                boolean audited = this.getParamBooleanValue(AUDIT_ENABLED, 0);
                volProps.setAudited(audited);
            }
            if (this.isParamPresent(AUDIT_COALESCE_INTERVAL)) {
                int coalesceInterval = this.getParamIntValue(AUDIT_COALESCE_INTERVAL, 0);
                if (coalesceInterval < 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Coalesce interval cannot be negative"));
                    return output;
                }
                volProps.setCoalesceInterval(coalesceInterval);
            }
            ArrayList<Common.FSAuditOperations> fsAuditEnableOperations = new ArrayList<Common.FSAuditOperations>();
            ArrayList<Common.FSAuditOperations> fsAuditDisableOperations = new ArrayList<Common.FSAuditOperations>();
            if (this.isParamPresent(FSAUDIT_OPS) && !this.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations = this.getParamTextValue(FSAUDIT_OPS, 0))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid dataauditops text specified, text = " + fsOperations));
                return output;
            }
            if (fsAuditEnableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditEnableOperations.size() > 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying +all,  cannot enable any other operation"));
                return output;
            }
            if (fsAuditDisableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditDisableOperations.size() > 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying -all,  cannot disable any other operation"));
                return output;
            }
            for (int i = 0; i < fsAuditEnableOperations.size(); ++i) {
                if (!fsAuditDisableOperations.contains(fsAuditEnableOperations.get(i))) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot specify an audit operation both for enable and disable"));
                return output;
            }
            for (Common.FSAuditOperations op : fsAuditEnableOperations) {
                LOG.info((Object)("Enable Op = " + op.toString()));
            }
            for (Common.FSAuditOperations op : fsAuditDisableOperations) {
                LOG.info((Object)("Disable Op = " + op.toString()));
            }
            volumeUpdate.addAllFsAuditEnableOperations(fsAuditEnableOperations);
            volumeUpdate.addAllFsAuditDisableOperations(fsAuditDisableOperations);
            boolean permsPresent = false;
            Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
            if (this.isParamPresent(USERPERM_PARAM_NAME)) {
                permsPresent = true;
                perms = this.input.getParameterByName(USERPERM_PARAM_NAME).getParamValues();
                List<String> userNames = this.getUserGroupsNames(perms);
                failed = false;
                for (String userName : userNames) {
                    if (this.checkEntityExists(false, userName)) continue;
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify for volume " + rwVolumeName + " failed - user " + userName + " not found").setField(USERPERM_PARAM_NAME));
                    failed = true;
                }
                if (failed) continue;
                elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, true, out);
                if (elements == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify failed - invalid list of user permissions - " + perms).setField(USERPERM_PARAM_NAME));
                    continue;
                }
                aclBuilder.addAllAcl(elements);
            }
            if (this.isParamPresent(GROUPPERM_PARAM_NAME)) {
                permsPresent = true;
                perms = this.input.getParameterByName(GROUPPERM_PARAM_NAME).getParamValues();
                List<String> groupNames = this.getUserGroupsNames(perms);
                failed = false;
                for (String groupname : groupNames) {
                    if (this.checkEntityExists(true, groupname)) continue;
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify for volume " + rwVolumeName + " failed - group " + groupname + " not found").setField(USERPERM_PARAM_NAME));
                    failed = true;
                }
                if (failed) continue;
                elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, false, out);
                if (elements == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - invalid list of group permissions - " + perms).setField(GROUPPERM_PARAM_NAME));
                    continue;
                }
                aclBuilder.addAllAcl(elements);
            }
            if (permsPresent) {
                volProps.setAcl(aclBuilder);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD)) {
                long maxInodes = this.getParamLongValue(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, 0);
                volProps.setMaxInodesAlarmThreshold(maxInodes);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH)) {
                int thresh = this.getParamIntValue(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, 0);
                volProps.setDbReplLagSecAlarmThresh(thresh);
            }
            volumeUpdate.setVolProperties(volProps.build());
            volumeUpdate.setCreds(this.getUserCredentials());
            boolean failed2 = this.volumeChangeMirrorMode(rwVolumeName, savedVolProps, out);
            if (failed2) continue;
            Common.VolumeAces volumeAces = null;
            try {
                volumeAces = this.buildVolumeAcesProtobuf(volumeAceParameterMap);
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to parse volume ace arguments");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error Parsing Volume Aces: " + e.getMessage()));
                return output;
            }
            if (volumeAces != null) {
                volumeUpdate.setVolumeAces(volumeAces);
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volumeUpdate.build(), CLDBProto.VolumeUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volumeUpdate.build(), CLDBProto.VolumeUpdateResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeUpdateResponse resp = CLDBProto.VolumeUpdateResponse.parseFrom((byte[])data);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)resp.getErrMsg());
                }
                if (resp.getStatus() == 0) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                continue;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString(10003) + " Volume modify failed"));
                LOG.error((Object)"Exception during Volume modify ", (Throwable)e);
                continue;
            }
            break;
        }
        return output;
    }

    private CLDBProto.NoteOperation getNoteOperation(StringBuilder msg) throws CLIProcessingException {
        CLDBProto.NoteOperation.Builder noBuilder = CLDBProto.NoteOperation.newBuilder();
        if (this.isParamPresent(ADD_VOLUME_NOTE)) {
            noBuilder.setOper(CLDBProto.NoteOperationEnum.NOTE_OP_ADD).setNoteName(this.getParamTextValue(ADD_VOLUME_NOTE, 0));
        } else if (this.isParamPresent(RESOLVE_VOLUME_NOTE)) {
            noBuilder.setOper(CLDBProto.NoteOperationEnum.NOTE_OP_RESOLVE).setNoteName(this.getParamTextValue(RESOLVE_VOLUME_NOTE, 0));
        } else {
            msg.append("invalid operation for volumenote.");
            return null;
        }
        if (!this.isParamPresent(NOTE_COMMENT)) {
            msg.append("Volumenote cannot be modified without comments.");
            return null;
        }
        return noBuilder.setComment(this.getParamTextValue(NOTE_COMMENT, 0)).build();
    }

    private CLDBProto.VolumeProperties volumePropetiesLookup(String volumeName) throws CLIProcessingException {
        return this.volumePropetiesLookup(volumeName, true);
    }

    private CLDBProto.VolumeProperties volumePropetiesLookup(String volumeName, boolean needsRootCid) throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp = null;
        byte[] data = null;
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setNeedsRootCid(needsRootCid).setCreds(this.getUserCredentials()).build();
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                LOG.error((Object)("volumePropetiesLookup RPC to CLDB failed for volume " + volumeName));
                return null;
            }
            resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getVolInfo().getVolProperties();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during volumePropetiesLookup RPC to CLDB " + e.getLocalizedMessage()));
            return null;
        }
        return null;
    }

    CommandOutput volumeFixMountPath() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> volumeNames = new ArrayList<String>();
        String rwVolumeName = this.getRwVolumeName();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        Common.MapRClusterDefaults mapRClusterDefaults = Common.MapRClusterDefaults.getDefaultInstance();
        for (String volName : volumeNames) {
            String msg;
            String msg2;
            String msg3;
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volName);
            if (volProps == null) {
                msg3 = "could not find volume properties for " + volName;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, msg3));
                LOG.error((Object)msg3);
                continue;
            }
            if (!volProps.getMounted()) {
                msg3 = String.format("volume: %s not mounted", volName);
                LOG.warn((Object)msg3);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg3));
                continue;
            }
            String rwVolumeMountDir = volProps.getMountDir();
            Common.FidMsg parentFid = volProps.getParentFid();
            if (mapRClusterDefaults.getClusterRootName().equals(volName)) {
                String msg4 = String.format("volume %s found mounted at: %s (no change required)", rwVolumeName, rwVolumeMountDir);
                out.addMessage(msg4);
                LOG.info((Object)msg4);
                continue;
            }
            int index = rwVolumeMountDir.lastIndexOf(47);
            if (index == -1) {
                String msg5 = "Could not determine mount filename in dir: " + rwVolumeMountDir;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg5));
                LOG.error((Object)msg5);
            }
            String mntName = rwVolumeMountDir.substring(index);
            String newPath = fs.getMountPath(cluster, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
            if (newPath == null) {
                msg2 = String.format("could not find mountPath for volume %s (fs.getMountPath() returned null)", volName);
                LOG.error((Object)msg2);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg2));
                continue;
            }
            LOG.debug((Object)("Volume fixmountpath: getNewMountPath returned: " + newPath));
            newPath = newPath + mntName;
            if (newPath.equals(rwVolumeMountDir)) {
                msg2 = String.format("volume %s found mounted at: %s (no change required)", rwVolumeName, rwVolumeMountDir);
                out.addMessage(msg2);
                LOG.info((Object)msg2);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("volume fixmountpath" + volName));
            }
            byte[] data = null;
            CLDBProto.VolumeProperties newVolProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(volName).setMountDir(newPath).build();
            CLDBProto.VolumeUpdateRequest volReq = CLDBProto.VolumeUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setVolProperties(newVolProps).build();
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeUpdateResponse.class);
                if (data == null) {
                    String msg6 = "volume fixmountpath response null for volume " + volName;
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg6));
                    LOG.error((Object)msg6);
                    continue;
                }
                CLDBProto.VolumeUnMountResponse resp = CLDBProto.VolumeUnMountResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    msg = String.format("volume: %s, corrected mountpath to: %s (old=%s)", volName, newPath, rwVolumeMountDir);
                    out.addMessage(msg);
                    LOG.info((Object)msg);
                    continue;
                }
                msg = "Volume fixmountpath: " + Errno.toString(resp.getStatus());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
                LOG.error((Object)msg);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                msg = "Volume fixmountpath: Operation failed: " + e;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
                LOG.error((Object)msg);
            }
        }
        return output;
    }

    boolean checkEntityExists(boolean type, String name) {
        String cmd = null;
        if (name.equals("allusers")) {
            return true;
        }
        cmd = !type ? "getent passwd " + name : "getent group " + name;
        try {
            String result = new TextCommandOutput(this.executeSimpleSHHCommand(6000L, cmd)).toString();
            return result != null && !result.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getIPAddress(String host) {
        String ipAddress = null;
        try {
            InetAddress addr = InetAddress.getByName(host);
            ipAddress = addr.getHostAddress();
            if (ipAddress.equalsIgnoreCase("127.0.0.1") || ipAddress.equalsIgnoreCase("127.0.1.1")) {
                return null;
            }
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Unknown host exception " + e));
        }
        return ipAddress;
    }

    private String getRwVolumeName() throws CLIProcessingException {
        return this.isParamPresent(RW_VOLUME_PARAM_NAME) ? this.getParamTextValue(RW_VOLUME_PARAM_NAME, 0) : null;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getColumnsParamValue() throws CLIProcessingException {
        return this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
    }

    private boolean volumeChangeMirrorMode(String rwVolumeName, CLDBProto.VolumeProperties oldVolProps, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        boolean failed = false;
        if (this.isParamPresent(MIRROR_VOLUME)) {
            boolean convertToMirror;
            int volTargettype = 3;
            String mirrorType = this.getParamTextValue(MIRROR_VOLUME, 0);
            if (!(mirrorType.equalsIgnoreCase("rw") || mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("0") || mirrorType.equalsIgnoreCase("1"))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + mirrorType + " specified. Please specify rw/mirror").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                return true;
            }
            boolean isVolumeMirror = oldVolProps.getIsMirrorVol();
            int oldVolType = 0;
            if (oldVolProps.hasVolumetype()) {
                oldVolType = oldVolProps.getVolumetype().getNumber();
            }
            if (oldVolType == 0 || oldVolType == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is a standard volume"));
                return true;
            }
            boolean bl = convertToMirror = mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("1");
            if (isVolumeMirror && convertToMirror) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is already a mirror volume"));
                return true;
            }
            if (!isVolumeMirror && !convertToMirror) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is already a rw volume"));
                return true;
            }
            if (convertToMirror && oldVolProps.getMirrorInfo().getSrcVolumeId() == 0 && !this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " does not have source volume." + " Please specify the source volume"));
                return true;
            }
            if (convertToMirror && oldVolProps.getIsAuditVolume()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is an audit volume." + " Cannot convert to mirror volume"));
                return true;
            }
            if (convertToMirror) {
                volTargettype = 2;
            }
            boolean ismirror = volTargettype == 1 || volTargettype == 2;
            CLDBProto.VolumeChangeMirrorModeRequest.Builder volumeCmmr = CLDBProto.VolumeChangeMirrorModeRequest.newBuilder();
            volumeCmmr.setVolumeName(rwVolumeName);
            volumeCmmr.setMirrorMode(ismirror);
            volumeCmmr.setCreds(this.getUserCredentials());
            byte[] data = null;
            try {
                CLDBProto.VolumeChangeMirrorModeResponse resp;
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeChangeMirrorModeProc.getNumber(), (MessageLite)volumeCmmr.build(), CLDBProto.VolumeChangeMirrorModeResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeChangeMirrorModeProc.getNumber(), (MessageLite)volumeCmmr.build(), CLDBProto.VolumeChangeMirrorModeResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Volume mode change: Couldn't connect to the CLDB service"));
                    failed = true;
                }
                if ((resp = CLDBProto.VolumeChangeMirrorModeResponse.parseFrom((byte[])data)).getStatus() == 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Volume mode changed for " + rwVolumeName));
                    }
                } else if (resp.getStatus() == 115) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Cannot convert volume " + rwVolumeName + " as mirror op is in progress"));
                    LOG.error((Object)("Cannot convert volume " + rwVolumeName + " as mirror op is in progress"));
                    failed = true;
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume mode change:  VolumeName: " + rwVolumeName + " " + Errno.toString(resp.getStatus())));
                    LOG.error((Object)("Volume mode change failed, " + Errno.toString(resp.getStatus())));
                    failed = true;
                }
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume mode change:  VolumeName: " + rwVolumeName + Errno.toString(10003) + " Volume mode change failed"));
                LOG.error((Object)"Exception during Volume mode change ", (Throwable)e);
                failed = true;
            }
        }
        return failed;
    }

    private Common.VolumeAces buildVolumeAcesProtobuf(Map<String, Common.VolumeActions> volumeAceParameterMap) throws IOException, CLIProcessingException {
        Common.VolumeAces.Builder acesBuilder = Common.VolumeAces.newBuilder();
        for (String param : volumeAceParameterMap.keySet()) {
            if (!this.isParamPresent(param)) continue;
            String arg = this.getParamTextValue(param, 0);
            acesBuilder.addAces(Common.VolumeAceEntry.newBuilder().setAccessType(volumeAceParameterMap.get(param)).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)arg))).build());
        }
        return acesBuilder.getAcesCount() > 0 ? acesBuilder.build() : null;
    }

    static {
        fieldTableBuilder = new ImmutableMap.Builder().put((Object)new VolumeField(CLDBProto.VolumeInfoFields.owner), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.owner.getNumber(), "on", "creator", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dataContainerRepltype), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dataContainerRepltype.getNumber(), "dcr", RW_VOLUME_PARAM_DCREPLTYPE, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numReplicas.getNumber(), "drf", "numreplicas", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.minReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.minReplicas.getNumber(), "mrf", "minreplicas", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.rackPath), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.rackPath.getNumber(), "rp", "rackpath", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.localPath), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.localPath.getNumber(), "lp", "localpath", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.readOnly), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.readOnly.getNumber(), "ro", RW_VOLUME_PARAM_READONLY, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mountDir), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mountDir.getNumber(), "p", "mountdir", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeName.getNumber(), "n", "volumename", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mounted), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mounted.getNumber(), "mt", "mounted", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.quota), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.quota.getNumber(), "qta", RW_VOLUME_PARAM_QUOTA, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.used), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.used.getNumber(), "dsu", "used", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.logicalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.logicalUsed.getNumber(), "dlu", "logicalUsed", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.advisoryquota), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.advisoryquota.getNumber(), "aqt", RW_VOLUME_PARAM_ADVISORY_QUOTA, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.aeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.aeName.getNumber(), "aen", "aename", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.aeType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.aeType.getNumber(), "aet", RW_VOLUME_PARAM_AETYPE, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.schedule), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.schedule.getNumber(), "sid", "scheduleid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSchedule), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSchedule.getNumber(), "msid", "mirrorscheduleid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeType.getNumber(), "t", "volumetype", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorType.getNumber(), "mrt", "mirrortype", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CreatorContainerId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CreatorContainerId.getNumber(), "ccid", "creatorcontainerid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CreatorVolumeUuid), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CreatorVolumeUuid.getNumber(), "cvid", "creatorvolumeuuid", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolume), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSrcVolume.getNumber(), "src", "mirrorSrcVolume", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorStatus), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorStatus.getNumber(), "mst", "mirrorstatus", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime.getNumber(), "lmt", "lastSuccessfulMirrorTime", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorPercentComplete), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorPercentComplete.getNumber(), "mpc", "mirror-percent-complete", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorErrorCode), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorErrorCode.getNumber(), "mer", "mirror errorcode", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.snapshotcount), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.snapshotcount.getNumber(), "sc", "snapshotcount", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeId.getNumber(), "id", "volumeid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.snapshotUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.snapshotUsed.getNumber(), "ssu", "snapshotused", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.totalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.totalUsed.getNumber(), "tsu", "totalused", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.listReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.listReplicas.getNumber(), "arf", "actualreplication", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.scheduleName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.scheduleName.getNumber(), "sn", "schedulename", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm.getNumber(), "sfa", "SnapshotFailureAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.MirrorFailureAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.MirrorFailureAlarm.getNumber(), "mfa", "MirrorFailureAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm.getNumber(), "rfa", "DataUnderReplicatedAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.DataUnavailableAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.DataUnavailableAlarm.getNumber(), "dua", "DataUnavailableAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm.getNumber(), "aqa", "AdvisoryQuotaExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.QuotaExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.QuotaExceededAlarm.getNumber(), "qa", "QuotaExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm.getNumber(), "nna", "NoNodesInTopologyAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm.getNumber(), "afta", "AlmostFullTopologyAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.FullTopologyAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.FullTopologyAlarm.getNumber(), "fta", "FullTopologyAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.InodesExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.InodesExceededAlarm.getNumber(), "ia", "InodesExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm.getNumber(), "cnla", "ContainersNonLocalAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CannotMirrorAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CannotMirrorAlarm.getNumber(), "cma", "CannotMirrorAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.acl), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.acl.getNumber(), "acl", "acl", CommandOutput.OutputHierarchy.OutputNode.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcClusterName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSrcClusterName.getNumber(), "msc", "mirrorSrcCluster", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId.getNumber(), "msi", "mirrorSrcVolumeId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName.getNumber(), "mds", "mirrorDataSrcVolume", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId.getNumber(), "mdi", "mirrorDataSrcVolumeId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName.getNumber(), "mdc", "mirrorDataSrcCluster", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorId.getNumber(), "mid", "mirrorId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nextMirrorId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nextMirrorId.getNumber(), "nmid", "nextMirrorId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nameContainerSize), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nameContainerSize.getNumber(), "ncsmb", "nameContainerSizeMB", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nameContainerId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nameContainerId.getNumber(), "ncid", "nameContainerId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.needsGfsck), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.needsGfsck.getNumber(), "nfsck", "needsGfsck", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold.getNumber(), "miath", RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh.getNumber(), "dlsat", RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.partlyOutOfTopology), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.partlyOutOfTopology.getNumber(), "poot", "partlyOutOfTopology", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.isAuditVolume), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.isAuditVolume.getNumber(), "av", "auditVolume", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.audited), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.audited.getNumber(), "ea", "audited", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.coalesceInterval), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.coalesceInterval.getNumber(), "ci", "coalesceInterval", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations.getNumber(), "edao", "enableddataauditoperations", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations.getNumber(), "ddao", "disableddataauditoperations", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numContainers), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numContainers.getNumber(), "nc", "numcontainers", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorThrottle), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorThrottle.getNumber(), "dt", RW_VOLUME_PARAM_MIRRORTHROTTLE, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeAccessTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeAccessTime.getNumber(), "va", "accesstime", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.limitSpread), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.limitSpread.getNumber(), "ls", VOLUME_LIMIT_SPREAD, Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas.getNumber(), "nsnr", "nsNumReplicas", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas.getNumber(), "nsmr", "nsMinReplicas", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.allowGrant), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.allowGrant.getNumber(), "ag", "allowGrant", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec.getNumber(), "rto", "reReplTimeOutSec", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.fixCreatorId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.fixCreatorId.getNumber(), "fcid", "fixCreatorId", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.noteEntries), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.noteEntries.getNumber(), "vn", "volumeNote", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.isWorm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.isWorm.getNumber(), "iw", "isWorm", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.wormConfig), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.wormConfig.getNumber(), "worm", "wormSettings", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.commitMinutes), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.commitMinutes.getNumber(), "cm", "commitMinutes", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.retentionDays), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.retentionDays.getNumber(), "rd", "retentionDays", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.hasNotes), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.hasNotes.getNumber(), "hn", "hasNotes", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.unresolvedNotes), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.unresolvedNotes.getNumber(), "un", "unresolvedNotes", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.replTypeConversionInProgress), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.replTypeConversionInProgress.getNumber(), "rtip", "ReplTypeConversionInProgress", Integer.class));
        CLDBProto.VolumeInfoFields[] values = CLDBProto.VolumeInfoFields.values();
        int max = 0;
        for (CLDBProto.VolumeInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_VOLUMEFIELDINFO = max;
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        aclParams = new ImmutableMap.Builder().put((Object)USERPERM_PARAM_NAME, (Object)new TextInputParameter(USERPERM_PARAM_NAME, "space separated list of user:permissions,perimssions,.. to be set", false, null)).put((Object)GROUPPERM_PARAM_NAME, (Object)new TextInputParameter(GROUPPERM_PARAM_NAME, "space separated list of user:permissions,perimssions,.. to be set", false, null)).build();
        volumeAuditCommand = new CLICommand("audit", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)VOLUME_AUDIT_ENABLED, (Object)new BooleanInputParameter(VOLUME_AUDIT_ENABLED, "<true|false>", false, null)).put((Object)AUDIT_COALESCE_INTERVAL, (Object)new IntegerInputParameter(AUDIT_COALESCE_INTERVAL, "interval in mins", false, null)).put((Object)FSAUDIT_OPS, (Object)new TextInputParameter(FSAUDIT_OPS, "data audit operations", false, null)).build(), null).setShortUsage(volumeAuditUsage);
        volumeUnMountCommand = new CLICommand("unmount", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, RW_VOLUME_PARAM_NAME, true, null)).put((Object)RW_VOLUME_PARAM_FORCE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_FORCE, RW_VOLUME_PARAM_FORCE, false, (Object)0)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeUnMountUsage);
        volumeShowMountsCommand = new CLICommand("showmounts", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, RW_VOLUME_PARAM_NAME, true, null)).build(), null).setShortUsage(volumeShowMountsUsage);
        volumeMountCommand = new CLICommand(RW_VOLUME_PARAM_MOUNT, "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, RW_VOLUME_PARAM_NAME, true, null)).put((Object)RW_VOLUME_PARAM_MOUNTDIR, (Object)new TextInputParameter(RW_VOLUME_PARAM_MOUNTDIR, RW_VOLUME_PARAM_MOUNTDIR, false, null)).put((Object)RW_VOLUME_PARAM_CREATE_PARENT, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_CREATE_PARENT, RW_VOLUME_PARAM_CREATE_PARENT, false, Boolean.valueOf(false))).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeMountUsage);
        volumeCreateCommand = new CLICommand("create", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)RW_VOLUME_PARAM_MOUNTDIR, (Object)new TextInputParameter(RW_VOLUME_PARAM_MOUNTDIR, "mountdir", false, null)).put((Object)RW_VOLUME_PARAM_CREATE_PARENT, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_CREATE_PARENT, RW_VOLUME_PARAM_CREATE_PARENT, false, Boolean.valueOf(false))).put((Object)RW_VOLUME_PARAM_MOUNT, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_MOUNT, RW_VOLUME_PARAM_MOUNT, false, Boolean.valueOf(true))).put((Object)RW_VOLUME_ROOT_DIR_PERM, (Object)new TextInputParameter(RW_VOLUME_ROOT_DIR_PERM, RW_VOLUME_ROOT_DIR_PERM, false, null)).put((Object)RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, (Object)new IntegerInputParameter(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, false, Integer.valueOf(0))).put((Object)RW_VOLUME_PARAM_LOCALVOLUMEHOST, (Object)new TextInputParameter(RW_VOLUME_PARAM_LOCALVOLUMEHOST, RW_VOLUME_PARAM_LOCALVOLUMEHOST, false, null)).put((Object)RW_VOLUME_PARAM_LOCALVOLUMEPORT, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_LOCALVOLUMEPORT, RW_VOLUME_PARAM_LOCALVOLUMEPORT, false, Integer.valueOf(5660))).put((Object)RW_VOLUME_PARAM_SHUFFLEVOLUME, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_SHUFFLEVOLUME, RW_VOLUME_PARAM_SHUFFLEVOLUME, false, (Object)0).setInvisible(true)).put((Object)RW_VOLUME_PARAM_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_REPLICATION, RW_VOLUME_PARAM_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_MIN_REPLICATION, RW_VOLUME_PARAM_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_DCREPLTYPE, (Object)new TextInputParameter(RW_VOLUME_PARAM_DCREPLTYPE, "replicationtype: low_latency or high_throughput. default: high_throughput", false, null)).putAll(aclParams).put((Object)RW_VOLUME_PARAM_AETYPE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_AETYPE, RW_VOLUME_PARAM_AETYPE, false, null)).put((Object)RW_VOLUME_PARAM_AE, (Object)new TextInputParameter(RW_VOLUME_PARAM_AE, RW_VOLUME_PARAM_AE, false, null)).put((Object)RW_VOLUME_PARAM_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_QUOTA, RW_VOLUME_PARAM_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_ADVISORY_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_ADVISORY_QUOTA, RW_VOLUME_PARAM_ADVISORY_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_TOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_TOPOLOGY, RW_VOLUME_PARAM_TOPOLOGY, false, null)).put((Object)RW_VOLUME_PARAM_READONLY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_READONLY, RW_VOLUME_PARAM_READONLY, false, null)).put((Object)RW_VOLUME_PARAM_MIRRORTHROTTLE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_MIRRORTHROTTLE, RW_VOLUME_PARAM_MIRRORTHROTTLE, false, null)).put((Object)MIRROR_VOLUME, (Object)new TextInputParameter(MIRROR_VOLUME, "type of volume: rw or mirror", false, null)).put((Object)MIRROR_VOLUME_SRC_VOLUMENAME, (Object)new TextInputParameter(MIRROR_VOLUME_SRC_VOLUMENAME, MIRROR_VOLUME_SRC_VOLUMENAME, false, null)).put((Object)VOLUME_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_SCHEDULE, "schedule ID", false, null)).put((Object)VOLUME_MIRROR_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_MIRROR_SCHEDULE, "mirror schedule ID", false, null)).put((Object)VOLUME_LIMIT_SPREAD, (Object)new BooleanInputParameter(VOLUME_LIMIT_SPREAD, VOLUME_LIMIT_SPREAD, false, null).setInvisible(true)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).put((Object)RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, (Object)new LongInputParameter(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, false, null)).put((Object)RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, false, null)).put((Object)AUDIT_ENABLED, (Object)new BooleanInputParameter(AUDIT_ENABLED, "<true|false>", false, null)).put((Object)AUDIT_COALESCE_INTERVAL, (Object)new IntegerInputParameter(AUDIT_COALESCE_INTERVAL, "interval in mins", false, null)).put((Object)AUDIT_VOLUME, (Object)new BooleanInputParameter(AUDIT_VOLUME, AUDIT_VOLUME, false, null).setInvisible(true)).put((Object)FSAUDIT_OPS, (Object)new TextInputParameter(FSAUDIT_OPS, "data audit operations", false, null)).put((Object)ALLOW_GRANT, (Object)new BooleanInputParameter(ALLOW_GRANT, ALLOW_GRANT, false, null)).put((Object)INHERIT_SOURCE, (Object)new TextInputParameter(INHERIT_SOURCE, "volume to copy properties from: defaults to parent volume", false, null)).put((Object)ALLOW_INHERIT, (Object)new BooleanInputParameter(ALLOW_INHERIT, ALLOW_INHERIT, false, null)).put((Object)VOL_READACE_PARAM, (Object)new TextInputParameter(VOL_READACE_PARAM, "<Acess Control Expression>", false, null)).put((Object)VOL_WRITEACE_PARAM, (Object)new TextInputParameter(VOL_WRITEACE_PARAM, "<Acess Control Expression>", false, null)).build(), null).setShortUsage(volumeCreateUsage);
        volumeCommands = new CLICommand[]{new CLICommand("remove", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", false, null)).put((Object)RW_VOLUME_PARAM_FORCE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_FORCE, RW_VOLUME_PARAM_FORCE, false, (Object)0)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).put((Object)FILTER_PARAM_NAME, (Object)new TextInputParameter(FILTER_PARAM_NAME, "remove volumes that match the filter", false, "none")).build(), null).setShortUsage(volumeRemoveUsage), new CLICommand("move", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)RW_VOLUME_PARAM_TOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_TOPOLOGY, RW_VOLUME_PARAM_TOPOLOGY, true, null)).build(), null).setShortUsage(volumeMoveUsage), new CLICommand("rename", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)RW_VOLUME_PARAM_NEW_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NEW_NAME, "newVolumeName", true, null)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeRenameUsage), new CLICommand("upgradeformat", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeNames", true, null)).build(), null).setShortUsage(volumeUpgradeformatUsage), new CLICommand("modify", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)MIRROR_VOLUME_SRC_VOLUMENAME, (Object)new TextInputParameter(MIRROR_VOLUME_SRC_VOLUMENAME, MIRROR_VOLUME_SRC_VOLUMENAME, false, null)).put((Object)RW_VOLUME_PARAM_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_REPLICATION, RW_VOLUME_PARAM_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_MIN_REPLICATION, RW_VOLUME_PARAM_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, false, null)).putAll(aclParams).put((Object)RW_VOLUME_PARAM_AETYPE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_AETYPE, RW_VOLUME_PARAM_AETYPE, false, null)).put((Object)RW_VOLUME_PARAM_AE, (Object)new TextInputParameter(RW_VOLUME_PARAM_AE, RW_VOLUME_PARAM_AE, false, null)).put((Object)RW_VOLUME_PARAM_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_QUOTA, RW_VOLUME_PARAM_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_ADVISORY_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_ADVISORY_QUOTA, RW_VOLUME_PARAM_ADVISORY_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_READONLY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_READONLY, RW_VOLUME_PARAM_READONLY, false, null)).put((Object)RW_VOLUME_PARAM_MIRRORTHROTTLE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_MIRRORTHROTTLE, RW_VOLUME_PARAM_MIRRORTHROTTLE, false, null)).put((Object)VOLUME_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_SCHEDULE, "schedule ID", false, null)).put((Object)VOLUME_MIRROR_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_MIRROR_SCHEDULE, "mirror schedule ID", false, null)).put((Object)RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, (Object)new LongInputParameter(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, false, null)).put((Object)RW_VOLUME_PARAM_DCREPLTYPE, (Object)new TextInputParameter(RW_VOLUME_PARAM_DCREPLTYPE, "<low_latency | high_throughput>", false, null).setInvisible(true)).put((Object)RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, false, null)).put((Object)MIRROR_VOLUME, (Object)new TextInputParameter(MIRROR_VOLUME, "type of volume: rw or mirror", false, null)).put((Object)VOLUME_LIMIT_SPREAD, (Object)new BooleanInputParameter(VOLUME_LIMIT_SPREAD, VOLUME_LIMIT_SPREAD, false, null).setInvisible(true)).put((Object)AUDIT_ENABLED, (Object)new BooleanInputParameter(AUDIT_ENABLED, "<true|false>", false, null)).put((Object)AUDIT_COALESCE_INTERVAL, (Object)new IntegerInputParameter(AUDIT_COALESCE_INTERVAL, "interval in mins", false, null)).put((Object)FSAUDIT_OPS, (Object)new TextInputParameter(FSAUDIT_OPS, "data audit operations", false, null)).put((Object)ALLOW_GRANT, (Object)new BooleanInputParameter(ALLOW_GRANT, "let child volume inherit volume properties <true|false>", false, null)).put((Object)RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, (Object)new IntegerInputParameter(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, "<Integer Value>", false, null)).put((Object)RW_FIX_CREATOR_ID, (Object)new BooleanInputParameter(RW_FIX_CREATOR_ID, RW_FIX_CREATOR_ID, false, null).setInvisible(true)).put((Object)VOL_READACE_PARAM, (Object)new TextInputParameter(VOL_READACE_PARAM, "<Acess Control Expression>", false, null)).put((Object)VOL_WRITEACE_PARAM, (Object)new TextInputParameter(VOL_WRITEACE_PARAM, "<Acess Control Expression>", false, null)).build(), null).setShortUsage(volumeModifyUsage), new CLICommand("info", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)RW_VOLUME_PARAM_MOUNTDIR, (Object)new TextInputParameter(RW_VOLUME_PARAM_MOUNTDIR, "mountdir", false, null)).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", false, null)).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated list of column names", false, "all")).build(), null).setShortUsage(volumeInfoUsage), new CLICommand("list", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SORT_PARAM_NAME, (Object)new TextInputParameter(SORT_PARAM_NAME, "none", false, "volumename").setInvisible(true)).put((Object)SORT_DIRECTION_PARAM_NAME, (Object)new TextInputParameter(SORT_DIRECTION_PARAM_NAME, "none", false, "ASC").setInvisible(true)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM_NAME, (Object)new TextInputParameter(FILTER_PARAM_NAME, "none", false, "none")).put((Object)RW_VOLUME_NODES, (Object)new TextInputParameter(RW_VOLUME_NODES, RW_VOLUME_NODES, false, null)).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated list of column names", false, "all")).put((Object)ALARMEDVOLUMES_PARAM_NAME, (Object)new BooleanInputParameter(ALARMEDVOLUMES_PARAM_NAME, "alarmsonly", false, (Object)0)).build(), null).setShortUsage(volumeListUsage), new CLICommand("fixmountpath", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).build(), null).setShortUsage(volumeFixMntPathUsage), VolumeLinkCommands.VolumeLinkCommands, SnapshotCommands.snapshotCommands, VolumeMirrorCommands.mirrorCommands, VolumeDumpFileCommands.dumpCommands, VolumeContainerCommands.containerCommands};
    }

    class VolumeAclHelper {
        Integer bitPos;
        Integer bitMask;
        int fieldPos;
        CLDBProto.VolumeInfoFields fieldNum;

        VolumeAclHelper(int bitPos, CLDBProto.VolumeInfoFields fieldNum) {
            this.bitPos = new Integer(bitPos);
            this.fieldPos = fieldNum.getNumber();
            this.fieldNum = fieldNum;
        }

        Integer getBitPos() {
            return this.bitPos;
        }

        int getFieldPos() {
            return this.fieldPos;
        }

        CLDBProto.VolumeInfoFields getFieldNum() {
            return this.fieldNum;
        }
    }
}

