/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.GetStringsForAuditOps;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.dialhome.MetricsProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class DumpCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String CHANGE_LOG_PARAM_NAME = "loglevel";
    public static final String CHANGE_LOG_CLASSNAME_PARAM_NAME = "classname";
    private static final String DUMP_CONTAINER_ID_PARAM_NAME = "ids";
    private static final String DUMP_CONTAINER_TYPE_PARAM_NAME = "type";
    private static final String DUMP_VOLUME_NAME_PARAM_NAME = "volumename";
    private static final String DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME = "queue";
    private static final String DUMP_FILESERVER_IP_PARAM_NAME = "fileserverip";
    private static final String DUMP_FILESERVER_PORT_PARAM_NAME = "fileserverport";
    public static final String ENODES_PARAM = "enodes";
    public static final String DUMP_PARAMS = "params";
    private static final String RBALINFO_STATS_OPT = "stats";
    private static final String RBALINFO_VOLUME_OPT = "volumeinfo";
    private static final String RBALINFO_NAMECNTRS_OPT = "namecntrinfo";
    public static final String MULTI_ARG_SEP = ",";
    private static final Logger LOG = Logger.getLogger(DumpCommands.class);
    static String dumpFileServerWorkInfoUsage = "fileserverworkinfo -cldbip cldbip -cldbport cldbport -fileserverip ip/host -fileserverport port";
    static String dumpContainerInfoUsage = "containerinfo -cldbip cldbip -cldbport  cldbport -ids id1,id2,id3";
    static String dumpReplicationManagerQueueInfoUsage = "replicationmanagerqueueinfo -queue <queue>";
    static String dumpVolumeInfoUsage = "volumeinfo -cldbip cldbip -cldbport cldbport -volumename <volume name>";
    static String dumpVolumeNodesUsage = "volumenodes -cldbip cldbip -cldbport cldbport -volumename <volume name>";
    static String dumpReplicationManagerUsage = "replicationmanager -cldbip cldbip -cldbport cldbport";
    static String dumpRereplicationUsage = "rereplication -cldbip cldbip -cldbport cldbport";
    static String dumpBalancerUsage = "balancerinfo -cldbip cldbip -cldbport cldbport";
    static String dumpRoleBalancerUsage = "rolebalancerinfo [-stats] [-volumeinfo -volumename<name>]";
    static String dumpBalancerMetricsUsage = "balancermetrics -cldbip cldbip -cldbport cldbport";
    static String dumpRoleBalancerMetricsUsage = "rolebalancermetrics -cldbip cldbip -cldbport cldbport";
    static String dumpRereplicationMetricsUsage = "rereplicationmetrics -cldbip cldbip -cldbport cldbport";
    static String cldbNodesUsage = " cldbnodes -zkconnect <zkconnectstring>";
    static String containersType = "<offline|resync|bm|waiting|unused>";
    static String dumpContainersUsage = "containers -type " + containersType;
    static String dumpAssignVouchersUsage = "assignvouchers -volumename volumename";
    static String dumpActiveWritersUsage = "activewriters";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand cldbNodesCommand = new CLICommand("cldbnodes", "usage : " + cldbNodesUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZK Connect String", true, null)).build(), null).setShortUsage(cldbNodesUsage);
    static final CLICommand dumpContainersCommand = new CLICommand("containers", "", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"type", (Object)new TextInputParameter("type", containersType, true, null)).build(), null).setShortUsage(dumpContainersUsage);
    static final CLICommand dumpContainerInfo = new CLICommand("containerinfo", "usage : " + dumpContainerInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"ids", (Object)new TextInputParameter("ids", "ids", true, null)).build(), null).setShortUsage(dumpContainerInfoUsage);
    static final CLICommand dumpReplicationManagerInfo = new CLICommand("replicationmanagerinfo", "usage : " + dumpContainerInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"volumename", (Object)new TextInputParameter("volumename", "volumename", true, null)).build(), null).setShortUsage(dumpReplicationManagerUsage);
    static final CLICommand dumpReplicationManagerQueueInfo = new CLICommand("replicationmanagerqueueinfo", "usage : " + dumpReplicationManagerQueueInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"queue", (Object)new IntegerInputParameter("queue", "queue", true, null)).build(), null).setShortUsage(dumpReplicationManagerQueueInfoUsage);
    static final CLICommand dumpRereplicationInfo = new CLICommand("rereplicationinfo", "usage : " + dumpRereplicationUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpRereplicationUsage);
    static final CLICommand dumpBalancerInfo = new CLICommand("balancerinfo", "usage : " + dumpBalancerUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpBalancerUsage);
    static final CLICommand dumpBalancerMetrics = new CLICommand("balancermetrics", "usage : " + dumpBalancerMetricsUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpBalancerMetricsUsage);
    static final CLICommand dumpRoleBalancerMetrics = new CLICommand("rolebalancermetrics", "usage : " + dumpRoleBalancerMetricsUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpRoleBalancerMetricsUsage);
    static final CLICommand dumpRereplicationMetrics = new CLICommand("rereplicationmetrics", "usage : " + dumpRereplicationMetricsUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpRereplicationMetricsUsage);
    static final CLICommand dumpAssignVouchers = new CLICommand("assignvouchers", "usage : " + dumpAssignVouchersUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"volumename", (Object)new TextInputParameter("volumename", "volumename", true, null)).build(), null).setShortUsage(dumpAssignVouchersUsage);
    static final CLICommand dumpActiveWriters = new CLICommand("activewriters", "usage : " + dumpActiveWritersUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpActiveWritersUsage);
    static final CLICommand dumpFileServerWorkInfo = new CLICommand("fileserverworkinfo", "usage : " + dumpFileServerWorkInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fileserverip", (Object)new TextInputParameter("fileserverip", "fileserverip/host", true, "127.0.0.1")).put((Object)"fileserverport", (Object)new IntegerInputParameter("fileserverport", "fileserverport", true, Integer.valueOf(5660))).build(), null).setShortUsage(dumpFileServerWorkInfoUsage);
    static final CLICommand dumpVolumeInfo = new CLICommand("volumeinfo", "usage : " + dumpVolumeInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"volumename", (Object)new TextInputParameter("volumename", "volumename", true, null)).build(), null).setShortUsage(dumpVolumeInfoUsage);
    static final CLICommand dumpVolumeNodes = new CLICommand("volumenodes", "usage : " + dumpVolumeNodesUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"volumename", (Object)new TextInputParameter("volumename", "volumename", true, null)).build(), null).setShortUsage(dumpVolumeNodesUsage);
    static final CLICommand dumpZKInfo = new CLICommand("zkinfo", "Dumping whole ZK Hierarchy into output", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZK Connect String", false, null)).build(), null).setShortUsage("Dumping ZK hierarchy info");
    static final CLICommand supportDumpTrigger = new CLICommand("supportdump", "Triggering nodes to gather support dump", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names for which support dump is needed. Space separated. Will be all if parameter is not given", false, null)).put((Object)"params", (Object)new TextInputParameter("params", "parameters string to create a dump", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZK Connect String", false, null)).build(), null).setShortUsage("Triggering nodes to gather support dump");
    static final CLICommand dumpRoleBalancerInfo = new CLICommand("rolebalancerinfo", "usage : " + dumpRoleBalancerUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"stats", (Object)new NoValueInputParameter("stats", "Gets RoleBalancer AcitveSwitches Info", false, false)).put((Object)"volumeinfo", (Object)new NoValueInputParameter("volumeinfo", "Gets Balancing Info for Volumes(s)", false, false)).put((Object)"volumename", (Object)new TextInputParameter("volumename", "Specifies the name of the volumes", false, null)).put((Object)"namecntrinfo", (Object)new NoValueInputParameter("namecntrinfo", "Get NameContainers Info", false, false)).build(), null).setShortUsage(dumpRoleBalancerUsage);
    private static String SUPPORT_DUMP_ACTION = "sdump";

    public DumpCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase("zkinfo")) {
            return this.dumpZKInfo();
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("supportdump")) {
            return this.supportDumpTrigger();
        }
        this.init();
        if (!super.validateInput()) {
            return this.output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("containerinfo")) {
            try {
                return this.dumpContainerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("containers")) {
            try {
                return this.dumpContainers();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("volumenodes")) {
            try {
                return this.dumpVolumeNodes();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(RBALINFO_VOLUME_OPT)) {
            try {
                return this.dumpVolumeInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("replicationmanagerinfo")) {
            try {
                return this.dumpReplicationManagerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rereplicationinfo")) {
            try {
                return this.dumpRereplicationInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("replicationmanagerqueueinfo")) {
            try {
                return this.dumpReplicationManagerQueueInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("balancerinfo")) {
            try {
                return this.dumpBalancerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rolebalancerinfo")) {
            try {
                return this.dumpRoleBalancerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("balancermetrics")) {
            try {
                return this.dumpBalancerMetrics();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rolebalancermetrics")) {
            try {
                return this.dumpRoleBalancerMetrics();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rereplicationmetrics")) {
            try {
                return this.dumpRereplicationMetrics();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("assignvouchers")) {
            try {
                return this.dumpAssignVouchers();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("activewriters")) {
            try {
                return this.dumpActiveWriters();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("fileserverworkinfo")) {
            try {
                return this.dumpFileServerWorkInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("cldbnodes")) {
            try {
                return this.dumpKvStoreCidInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Dump command failed".getBytes());
    }

    private CommandOutput dumpFileServerWorkInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fileServerIpString = this.getParamTextValue(DUMP_FILESERVER_IP_PARAM_NAME, 0);
        if (fileServerIpString.equalsIgnoreCase("localhost") || fileServerIpString.equalsIgnoreCase("127.0.0.1")) {
            fileServerIpString = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(fileServerIpString));
            if (ips.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + fileServerIpString));
                return output;
            }
            fileServerIpString = ips.get(0);
        }
        int fileServerIp = Util.ipToInt((String)fileServerIpString);
        int fileServerPort = this.getParamIntValue(DUMP_FILESERVER_PORT_PARAM_NAME, 0);
        Common.IPAddress fileServer = Common.IPAddress.newBuilder().setHost(fileServerIp).setPort(fileServerPort).build();
        LOG.info((Object)"dumpFileServerWorkInfo : Dumping FileServerWorkInfo");
        boolean hasMore = false;
        int lastContainerId = 0;
        String lastSpId = "";
        do {
            LOG.info((Object)"dumpFileServerWorkInfo : Dumping fileServer Work Units");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.FILESERVER_WORK_QUEUE_OP).setFileServer(fileServer).setFileServerLastContainer(lastContainerId).setCreds(this.getUserCredentials()).setFileServerLastSpId(lastSpId).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump fileserverworkinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump fileserverworkinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.FileServerPendingWork cmd : resp.getFileServerCommandsList()) {
                    out.addNode(this.formatFileServerCommand(cmd));
                    lastContainerId = cmd.getCmd().getContainerId();
                    lastSpId = cmd.getSpId();
                }
                hasMore = resp.getFileServerHasMore();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump fileServerWorkInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpReplicationManagerQueueInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int queueNumber = this.getParamIntValue(DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME, 0);
        if (queueNumber < 0 || queueNumber > 5) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid queue number " + queueNumber + ". Valid values are 0 to 5"));
            output.setOutput(out);
            return output;
        }
        LOG.info((Object)"dumpReplicationManagerQueueInfo : Dumping ReplicationManagerQueueInfo");
        boolean hasMore = false;
        int lastContainerId = 0;
        do {
            LOG.info((Object)"dumpReplicationManagerQueueInfo: Request ReplicationmanagerQueue info");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.REPLICATION_MANAGER_QUEUE_OP).setReplicationQueue(queueNumber).setReplicationLastContainer(lastContainerId).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump replicationmanagerqueueinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump replicationmanagerqueueinfo  failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ContainerInfo id : resp.getReplicationContainersList()) {
                    out.addNode(this.formatContainerInfo(id, null));
                    lastContainerId = id.getContainerId();
                }
                hasMore = resp.getReplicationHasMore();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump replicationmanagerqueueinfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpReplicationManagerInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        try {
            CLDBProto.VolumeInfo volInfo = this.lookupVolumeInfo(volumeName);
            if (volInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatVolumeInfo(volInfo));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName + ", Error: " + e.getLocalizedMessage()));
            output.setOutput(out);
            return output;
        }
        LOG.info((Object)"dumpReplicationManagerInfo : Dumping ReplicationManagerInfo");
        boolean hasMore = false;
        int lastContainerId = 0;
        do {
            LOG.info((Object)"dumpReplicationManagerInfo: Request Replicationmanager info");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.REPLICATION_MANAGER_OP).setReplicationVolumeName(volumeName).setReplicationLastContainer(lastContainerId).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump replicationmanagerinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump replicationmanagerinfo volume containersmap failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ContainerInfo id : resp.getReplicationContainersList()) {
                    out.addNode(this.formatContainerInfo(id, null));
                    lastContainerId = id.getContainerId();
                }
                hasMore = resp.getReplicationHasMore();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump replicationmanager failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpRereplicationInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpRereplicationInfo : Dumping Rereplication info");
        boolean hasMore = false;
        int lastCid = 0;
        int ncontainers = 0;
        do {
            LOG.info((Object)"dumpReplicationInfo : Dumping Active Container Copy Creates");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.ACTIVE_REREPL_OP).setLastCopyingCid(lastCid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rereplicationinfo  RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rereplication failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveContainerCopyCreate ac : resp.getActiveCopyCreatesList()) {
                    out.addNode(this.formatActiveCopyCreate(ac));
                    lastCid = ac.getContainerId();
                    ++ncontainers;
                }
                hasMore = resp.getMoreActiveRoleSwitches();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rereplication failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        if (ncontainers == 0) {
            return new TextCommandOutput("No active rereplications".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpRereplicationMetrics() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpRereplicationMetrics : Dumping Rereplication metrics");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.METRICS_REREPLICATION_OP).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rereplicationmetrics RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rereplicationmetrics failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatRereplicationMetrics(resp.getRereplicationMetrics()));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rereplicationInfo failed"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpAssignVouchers() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.debug((Object)"dumpAssignVouchers : Dumping assign vouchers");
        int nvouchers = 0;
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.ASSIGN_VOUCHER_DUMP_OP).setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump assignvouchers RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump assignvouchers failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            for (CLDBProto.ActiveAssignVoucher av : resp.getVouchersList()) {
                out.addNode(this.formatActiveAssignVoucher(av));
                ++nvouchers;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump assignvouchers failed"));
            output.setOutput(out);
            return output;
        }
        if (nvouchers == 0) {
            return new TextCommandOutput("No active assign vouchers".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpActiveWriters() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.debug((Object)"dumpActiveWriters : Dumping active writers");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.ACTIVE_WRITERS_DUMP_OP).setCreds(this.getUserCredentials()).build();
        byte[] replyData = null;
        int numWriters = 0;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump activewriters RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump activewriters failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            for (CLDBProto.ActiveWriter w : resp.getWritersList()) {
                out.addNode(this.formatActiveWriter(w));
                ++numWriters;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump activewriters failed"));
            output.setOutput(out);
            return output;
        }
        if (numWriters == 0) {
            return new TextCommandOutput("No active writers".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpBalancerInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpBalancerInfo : Dumping Balancer info");
        boolean hasMore = false;
        String lastSpid = null;
        do {
            LOG.info((Object)"dumpBalancerInfo : Dumping Active Storage Pools");
            CLDBProto.DumpInfoRequest.Builder reqBuilder = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.BALANCER_SP_OP).setCreds(this.getUserCredentials());
            if (lastSpid != null) {
                reqBuilder.setLastSpId(lastSpid);
            }
            CLDBProto.DumpInfoRequest req = reqBuilder.build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump balancerinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump balancerinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveStoragePool sp : resp.getActiveSpsList()) {
                    out.addNode(this.formatActiveSp(sp));
                    lastSpid = sp.getSpid();
                }
                hasMore = resp.getMoreActiveSps();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump balancerInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        hasMore = false;
        int lastCid = 0;
        int ncontainers = 0;
        do {
            LOG.info((Object)"dumpBalancerInfo : Dumping Active Container Moves");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.BALANCER_MOVE_OP).setLastMovingCid(lastCid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump balancerinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump balancerinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveContainerMove am : resp.getActiveMovesList()) {
                    out.addNode(this.formatActiveMove(am));
                    lastCid = am.getContainerId();
                    ++ncontainers;
                }
                hasMore = resp.getMoreActiveMoves();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump balancerInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        if (ncontainers == 0) {
            out.addMessage("No active container moves");
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpBalancerMetrics() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpBalancerMetrics : Dumping Balancer metrics");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.METRICS_DISKBALANCER_OP).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump balancermetrics RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump balancermetrics failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatDiskBalancerMetrics(resp.getDiskBalancerMetrics()));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump balancerInfo failed"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpRoleBalancerInfo() throws CLIProcessingException {
        if (this.isParamPresent(RBALINFO_VOLUME_OPT) || this.isParamPresent(RBALINFO_NAMECNTRS_OPT)) {
            return this.getRBalBalancingInfo();
        }
        return this.getRoleBalancerStats();
    }

    CommandOutput getRoleBalancerStats() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        LOG.info((Object)"dumpRoleBalancerInfo : Dumping RoleBalancer info");
        boolean hasMore = false;
        int lastCid = 0;
        int ncontainers = 0;
        do {
            LOG.info((Object)"dumpRoleBalancerInfo : Dumping Active Container Role switches");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.BALANCER_ROLESWITCH_OP).setLastRoleSwitchCid(lastCid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rolebalancerinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rolebalancerinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveContainerRoleSwitch am : resp.getActiveRoleSwitchesList()) {
                    out.addNode(this.formatActiveRoleSwitch(am));
                    lastCid = am.getContainerId();
                    ++ncontainers;
                }
                hasMore = resp.getMoreActiveRoleSwitches();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rolebalancerInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        if (ncontainers == 0) {
            return new TextCommandOutput("No active role switches".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput getRBalBalancingInfo() throws CLIProcessingException {
        CLDBProto.DumpInfoResponse resp;
        byte[] replyData;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.DumpInfoRequest.Builder dumpinfoReqBuilder = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.RBAL_BALANCING_INFO_OP);
        CLDBProto.RBalBalancingInfoRequest.Builder balancingInfoReqBuilder = CLDBProto.RBalBalancingInfoRequest.newBuilder();
        String volumeName = null;
        if (this.isParamPresent(RBALINFO_VOLUME_OPT)) {
            if (!this.isParamPresent(DUMP_VOLUME_NAME_PARAM_NAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Volume Name Opt. Check usage info"));
                return output;
            }
            volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
            if (volumeName == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Volume Name. Check usage info"));
                return output;
            }
            dumpinfoReqBuilder.setVolumeName(volumeName);
            balancingInfoReqBuilder.setNeedVolumeInfo(true);
        }
        if (this.isParamPresent(RBALINFO_NAMECNTRS_OPT)) {
            balancingInfoReqBuilder.setNeedNameCntrsInfo(true);
        }
        dumpinfoReqBuilder.setRbalBalancingInfoRequest(balancingInfoReqBuilder.build());
        CLDBProto.DumpInfoRequest req = dumpinfoReqBuilder.build();
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rolebalancerinfo RPC failed"));
                return output;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "RPC Error"));
            return output;
        }
        try {
            resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rolebalancerinfo failed with status : " + resp.getStatus()));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while trying to parse container info", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Error Parsing Balacing Info Response"));
            return output;
        }
        if (!resp.hasBalancingInfo()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Missing Balancing Info in the response"));
            return output;
        }
        CLDBProto.RBalBalancingInfo balancingInfo = resp.getBalancingInfo();
        if (balancingInfo.hasVolumeBalancingInfo()) {
            CLDBProto.BalancingInfo volumeBalancingInfo = balancingInfo.getVolumeBalancingInfo();
            if (volumeBalancingInfo.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(volumeBalancingInfo.getStatus(), "Error Obtaining Volume Balancing Info"));
            } else {
                CommandOutput.OutputHierarchy.OutputNode volInfoOutputNode = new CommandOutput.OutputHierarchy.OutputNode();
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Volume", (Object)volumeName));
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Count", volumeBalancingInfo.getAssignCacheCntrsCount()));
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Size", volumeBalancingInfo.getAssignCacheCntrsSize()));
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Zero Size Containers Count", volumeBalancingInfo.getZeroSizeCntrsCount()));
                for (CLDBProto.RBalSpBalancingInfo spInfo : volumeBalancingInfo.getSpBalancingInfoList()) {
                    volInfoOutputNode.addChild(this.getFormattedSpInfo(spInfo));
                }
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("VolumeBalancingInfo", (Object)volInfoOutputNode));
            }
        }
        if (balancingInfo.hasNameCntrsBalancingInfo()) {
            CLDBProto.BalancingInfo nameCntrsBalancingInfo = balancingInfo.getNameCntrsBalancingInfo();
            if (nameCntrsBalancingInfo.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(nameCntrsBalancingInfo.getStatus(), "Error Obtaining NameCntrs Balancing Info"));
            } else {
                CommandOutput.OutputHierarchy.OutputNode nameCntrsInfoOutputNode = new CommandOutput.OutputHierarchy.OutputNode();
                for (CLDBProto.RBalSpBalancingInfo spInfo : nameCntrsBalancingInfo.getSpBalancingInfoList()) {
                    nameCntrsInfoOutputNode.addChild(this.getFormattedSpInfo(spInfo));
                }
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NameCntrsBalancingInfo", (Object)nameCntrsInfoOutputNode));
            }
        }
        return output;
    }

    CommandOutput.OutputHierarchy.OutputNode getFormattedSpInfo(final CLDBProto.RBalSpBalancingInfo spInfo) {
        return new CommandOutput.OutputHierarchy.OutputNode("Storage Pools"){
            {
                super(x0);
                if (spInfo.hasSpId()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SpId", (Object)spInfo.getSpId()));
                }
                if (spInfo.hasHostAddress()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("HostAddress", (Object)spInfo.getHostAddress()));
                }
                if (spInfo.hasNumContainers()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumContainers", (Object)new Integer(spInfo.getNumContainers())));
                }
                if (spInfo.hasNumMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumMasters", (Object)new Integer(spInfo.getNumMasters())));
                }
                if (spInfo.hasDesiredNumMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredNumMasters", (Object)new Integer(spInfo.getDesiredNumMasters())));
                }
                if (spInfo.hasNumTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumTails", (Object)new Integer(spInfo.getNumTails())));
                }
                if (spInfo.hasDesiredNumTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredNumTails", (Object)new Integer(spInfo.getDesiredNumTails())));
                }
                if (spInfo.hasSizeofContainers()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SizeOfContainers", (Object)new Long(spInfo.getSizeofContainers())));
                }
                if (spInfo.hasSizeofMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SizeOfMasters", (Object)new Long(spInfo.getSizeofMasters())));
                }
                if (spInfo.hasDesiredSizeofMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredSizeOfMasters", (Object)new Long(spInfo.getDesiredSizeofMasters())));
                }
                if (spInfo.hasSizeofTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SizeOfTails", (Object)new Long(spInfo.getSizeofTails())));
                }
                if (spInfo.hasDesiredSizeofTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredSizeOfTails", (Object)new Long(spInfo.getDesiredSizeofTails())));
                }
                if (spInfo.hasAssignCacheCntrsCount()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Count", spInfo.getAssignCacheCntrsCount()));
                }
                if (spInfo.hasAssignCacheCntrsSize()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Size", spInfo.getAssignCacheCntrsSize()));
                }
            }
        };
    }

    private CommandOutput dumpRoleBalancerMetrics() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpRoleBalancerMetrics : Dumping RoleBalancer metrics");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.METRICS_ROLEBALANCER_OP).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rolebalancermetrics RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rolebalancermetrics failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatRoleBalancerMetrics(resp.getRoleBalancerMetrics()));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rolebalancermetrics failed"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpVolumeNodes() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        try {
            CLDBProto.VolumeInfo volInfo = this.lookupVolumeInfo(volumeName);
            if (volInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName));
                output.setOutput(out);
                return output;
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName + ", Error:" + e.getLocalizedMessage()));
            output.setOutput(out);
            return output;
        }
        HashMap<Long, Common.Server> nodes = new HashMap<Long, Common.Server>();
        boolean hasMore = false;
        int startId = 0;
        do {
            CLDBProto.VolumeContainersMapRequest volReq = CLDBProto.VolumeContainersMapRequest.newBuilder().setVolumeName(volumeName).setStartContainerId(startId).setNumContainers(10).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump volumenodes rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.VolumeContainersMapResponse resp = CLDBProto.VolumeContainersMapResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump volumenodes volume containersmap failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                int lastId = 0;
                for (CLDBProto.ContainerInfo cInfo : resp.getContainersList()) {
                    for (Common.Server ip : cInfo.getAServersList()) {
                        if (nodes.get(ip.getServerId()) != null) continue;
                        nodes.put(ip.getServerId(), ip);
                    }
                    for (Common.Server ip : cInfo.getIServersList()) {
                        if (nodes.get(ip.getServerId()) != null) continue;
                        nodes.put(ip.getServerId(), ip);
                    }
                    for (Common.Server ip : cInfo.getUServersList()) {
                        if (nodes.get(ip.getServerId()) != null) continue;
                        nodes.put(ip.getServerId(), ip);
                    }
                    lastId = cInfo.getContainerId();
                }
                hasMore = resp.getHasMoreContainers();
                if (!hasMore) continue;
                startId = lastId + 1;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump volumenodes failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        CommandOutput.OutputHierarchy.OutputNode empty = new CommandOutput.OutputHierarchy.OutputNode();
        CommandOutput.OutputHierarchy.OutputNode s = new CommandOutput.OutputHierarchy.OutputNode("Servers");
        for (Common.Server n : nodes.values()) {
            s.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP:Port", (Object)Util.printServerWithStateForCLI((Common.Server)n)));
        }
        empty.addChild(s);
        out.addNode(empty);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpVolumeInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        try {
            CLDBProto.VolumeInfo volInfo = this.lookupVolumeInfo(volumeName);
            if (volInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatVolumeInfo(volInfo));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName + ", Error: " + e.getLocalizedMessage()));
            output.setOutput(out);
            return output;
        }
        boolean hasMore = false;
        int startId = 0;
        do {
            LOG.info((Object)"dumpVolumeInfo : Requesting VolumeContainersMap");
            CLDBProto.VolumeContainersMapRequest volReq = CLDBProto.VolumeContainersMapRequest.newBuilder().setVolumeName(volumeName).setStartContainerId(startId).setNumContainers(10).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump volumeinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.VolumeContainersMapResponse resp = CLDBProto.VolumeContainersMapResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump volumeinfo volume containersmap failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                int lastId = 0;
                for (CLDBProto.ContainerInfo cInfo : resp.getContainersList()) {
                    out.addNode(this.formatContainerInfo(cInfo, null));
                    lastId = cInfo.getContainerId();
                }
                hasMore = resp.getHasMoreContainers();
                if (!hasMore) continue;
                startId = lastId + 1;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump volumeinfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatContainerInfo(CLDBProto.ContainerInfo cInfo, CLDBProto.VolumeInfo vInfo) {
        return this.formatContainerInfo(cInfo, vInfo, null);
    }

    private CommandOutput.OutputHierarchy.OutputNode formatContainerInfo(CLDBProto.ContainerInfo cInfo, CLDBProto.VolumeInfo vInfo, String type) {
        CommandOutput.OutputHierarchy.OutputNode cOut = new CommandOutput.OutputHierarchy.OutputNode();
        if (type != null && (type.equalsIgnoreCase("waiting") || type.equalsIgnoreCase("unused") || type.equalsIgnoreCase("resync") || type.equalsIgnoreCase("bm"))) {
            int count = 0;
            if (type.equalsIgnoreCase("waiting")) {
                count = cInfo.getIServersCount();
            } else if (type.equalsIgnoreCase("unused")) {
                count = cInfo.getUServersCount();
            } else if (type.equalsIgnoreCase("resync")) {
                for (Common.Server s : cInfo.getAServersList()) {
                    if (s.getState() != Common.Server.ReplicaState.RESYNC) continue;
                    ++count;
                }
            } else {
                count = 1;
            }
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("InstanceCount", count));
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ContainerId", cInfo.getContainerId()));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Epoch", cInfo.getLatestEpoch()));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Master", (Object)Util.printServerWithStateForCLI((Common.Server)cInfo.getMServer())));
        CommandOutput.OutputHierarchy.OutputNode activeServers = new CommandOutput.OutputHierarchy.OutputNode("ActiveServers");
        cOut.addChild(activeServers);
        for (Common.Server ip : cInfo.getAServersList()) {
            activeServers.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP:Port", (Object)Util.printServerWithStateForCLI((Common.Server)ip)));
        }
        CommandOutput.OutputHierarchy.OutputNode inactiveServer = new CommandOutput.OutputHierarchy.OutputNode("InactiveServers");
        cOut.addChild(inactiveServer);
        for (Common.Server ip : cInfo.getIServersList()) {
            inactiveServer.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP:Port", (Object)Util.printServerWithNoStateForCLI((Common.Server)ip)));
        }
        CommandOutput.OutputHierarchy.OutputNode unUsedServer = new CommandOutput.OutputHierarchy.OutputNode("UnusedServers");
        cOut.addChild(unUsedServer);
        for (Common.Server ip : cInfo.getUServersList()) {
            unUsedServer.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP:Port", (Object)Util.printServerWithNoStateForCLI((Common.Server)ip)));
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("OwnedSizeMB", (Object)Util.readableSizeMB((long)cInfo.getOwnedSizeMB())));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("SharedSizeMB", (Object)Util.readableSizeMB((long)cInfo.getSharedSizeMB())));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("LogicalSizeMB", (Object)Util.readableSizeMB((long)cInfo.getLogicalSizeMB())));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("TotalSizeMB", (Object)Util.readableSizeMB((long)cInfo.getChainSizeMB())));
        if (cInfo.hasNumInumUsed()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumInodesInUse", cInfo.getNumInumUsed()));
        }
        if (cInfo.hasMtime()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Mtime", (Object)new Date(cInfo.getMtime()).toString()));
        }
        if (cInfo.getNameContainer()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameContainer", (Object)"true"));
        } else {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameContainer", (Object)"false"));
        }
        if (cInfo.hasRwContainerId()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("RW ContainerId", cInfo.getRwContainerId()));
        }
        if (cInfo.hasRwVolumeId()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("RW VolumeId", cInfo.getRwVolumeId()));
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreatorContainerId", cInfo.getCreatorContainerId()));
        StringBuilder creatorVolUuid = new StringBuilder();
        if (cInfo.hasCreatorVolumeUuid()) {
            creatorVolUuid.append(cInfo.getCreatorVolumeUuid().getId640());
            creatorVolUuid.append(":");
            creatorVolUuid.append(cInfo.getCreatorVolumeUuid().getId641());
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreatorVolumeUuid", (Object)creatorVolUuid.toString()));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("UseActualCreatorId", (Object)cInfo.getUseActualCreatorId()));
        if (vInfo != null) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)vInfo.getVolProperties().getVolumeName()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vInfo.getVolProperties().getVolumeId()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeReplication", vInfo.getVolProperties().getReplicationPolicy().getNumReplicas()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameSpaceReplication", vInfo.getVolProperties().getNumNamespaceReplicas()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeMounted", (Object)vInfo.getVolProperties().getMounted()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AccessTime", (Object)(vInfo.hasAtime() ? new Date(vInfo.getAtime()).toString() : "Missing Atime")));
        }
        return cOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatVolumeInfo(CLDBProto.VolumeInfo volInfo) {
        CommandOutput.OutputHierarchy.OutputNode vOut = new CommandOutput.OutputHierarchy.OutputNode();
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)volInfo.getVolProperties().getVolumeName()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", volInfo.getVolProperties().getVolumeId()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeTopology", (Object)volInfo.getVolProperties().getTopology().getTopologyRestricted()));
        if (volInfo.getVolProperties().hasLocalTopology()) {
            vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeLocalTopology", (Object)volInfo.getVolProperties().getLocalTopology().getTopologyRestricted()));
        }
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeUsedSizeMB", volInfo.getVolQuota().getVolumeUsedSizeMB()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeReplication", volInfo.getVolProperties().getReplicationPolicy().getNumReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeMinReplication", volInfo.getVolProperties().getReplicationPolicy().getGuaranteedMinReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameSpaceReplication", volInfo.getVolProperties().getNumNamespaceReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameSpaceMinReplication", volInfo.getVolProperties().getGuaranteedMinNamespaceReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReReplicationTimeOutSec", volInfo.getVolProperties().getReReplicationTimeOutSec()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorThrottle", (Object)volInfo.getVolProperties().getMirrorThrottle()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AccessTime", (Object)(volInfo.hasAtime() ? new Date(volInfo.getAtime()).toString() : "Missing Atime")));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AuditVolume", (Object)(volInfo.getVolProperties().getIsAuditVolume() ? "1" : "0")));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Audited", (Object)(volInfo.getVolProperties().getAudited() ? "1" : "0")));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("CoalesceInterval", volInfo.getVolProperties().getCoalesceInterval()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("EnabledDataAuditOperations", (Object)GetStringsForAuditOps.getEnabledOps(volInfo.getVolProperties().getFsAuditDisabledOperations())));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("DisabledDataAuditOperations", (Object)GetStringsForAuditOps.getDisabledOps(volInfo.getVolProperties().getFsAuditDisabledOperations())));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("limitSpread", (Object)(volInfo.getVolProperties().hasLimitVolumeSpread() ? volInfo.getVolProperties().getLimitVolumeSpread() : true)));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("allowGrant", (Object)(volInfo.getVolProperties().hasAllowGrant() ? volInfo.getVolProperties().getAllowGrant() : false)));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("fixCreatorId", (Object)volInfo.getVolProperties().getUseActualCreatorId()));
        return vOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatFileServerCommand(CLDBProto.FileServerPendingWork cmd) {
        CommandOutput.OutputHierarchy.OutputNode fsOut = new CommandOutput.OutputHierarchy.OutputNode();
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ContainerId", cmd.getCmd().getContainerId()));
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Command", (Object)cmd.getCmd().getWork()));
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ExpectingReply", (Object)cmd.getExpectingReply()));
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("StoragePool", (Object)cmd.getSpId()));
        return fsOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveSp(CLDBProto.ActiveStoragePool sp) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid", (Object)sp.getSpid()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fsid", sp.getFsid()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip:port", (Object)Util.printIPAddressesForCLI((Common.Server)sp.getServer())));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("capacityMB", sp.getCapacityMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("usedMB", sp.getUsedMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("percentage", sp.getPercentUsed()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fullnessLevel", (Object)sp.getFullness()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("inTransitMB", sp.getInTransitMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("outTransitMB", sp.getOutTransitMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("topology", (Object)sp.getTopology()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastHeartBeatSec", sp.getLastHeartBeat()));
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveMove(CLDBProto.ActiveContainerMove am) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", am.getContainerId()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("sizeMB", am.getSizeMB()));
        if (am.hasFrom()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("From fsid", am.getFrom().getServerId()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("From IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)am.getFrom())));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("From SP", (Object)am.getFrom().getSpInfo().getSpId()));
        }
        if (am.hasTo()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("To fsid", am.getTo().getServerId()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("To IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)am.getTo())));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("To SP", (Object)am.getTo().getSpInfo().getSpId()));
        }
        if (am.hasUpdatesBlocked() && am.getUpdatesBlocked() && am.hasUpdatesBlockedSince()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Updates blocked Since", (Object)new Date(am.getUpdatesBlockedSince()).toString()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveRoleSwitch(CLDBProto.ActiveContainerRoleSwitch am) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", am.getContainerId()));
        if (am.hasTail()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Tail IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)am.getTail())));
        }
        if (am.hasUpdatesBlockedSince() && am.getUpdatesBlockedSince() != 0L) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Updates blocked Since", (Object)new Date(am.getUpdatesBlockedSince()).toString()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveCopyCreate(CLDBProto.ActiveContainerCopyCreate am) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", am.getContainerId()));
        for (CLDBProto.ActiveContainerCopyReplica repl : am.getReplicasList()) {
            CommandOutput.OutputHierarchy.OutputNode rout = new CommandOutput.OutputHierarchy.OutputNode("replica");
            rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("sizeMB", repl.getSizeMB()));
            if (repl.hasTo()) {
                rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("To fsid", repl.getTo().getServerId()));
                rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("To IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)repl.getTo())));
                rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("To SP", (Object)repl.getTo().getSpInfo().getSpId()));
            }
            out.addChild(rout);
        }
        if (am.hasStartTime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("startTime", (Object)new Date(am.getStartTime()).toString()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatDiskBalancerMetrics(MetricsProto.DiskBalancerMetrics dm) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (dm.hasNumContainersMoved()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numContainersMoved", dm.getNumContainersMoved()));
        }
        if (dm.hasNumMBMoved()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numMBMoved", dm.getNumMBMoved()));
        }
        if (dm.hasTimeOfLastMove() && dm.getTimeOfLastMove() > 0L) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("timeOfLastMove", (Object)new Date(dm.getTimeOfLastMove()).toString()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatRoleBalancerMetrics(MetricsProto.RoleBalancerMetrics rm) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (rm.hasNumNameContainerSwitches()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numNameContainerSwitches", rm.getNumNameContainerSwitches()));
        }
        if (rm.hasNumDataContainerSwitches()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numDataContainerSwitches", rm.getNumDataContainerSwitches()));
        }
        if (rm.hasTimeOfLastSwitch() && rm.getTimeOfLastSwitch() > 0L) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("timeOfLastMove", (Object)new Date(rm.getTimeOfLastSwitch()).toString()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatRereplicationMetrics(MetricsProto.RereplicationMetrics rr) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (rr.hasNumContainersCopied()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numContainersCopied", rr.getNumContainersCopied()));
        }
        if (rr.hasNumMBCopied()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numMBCopied", rr.getNumMBCopied()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveAssignVoucher(CLDBProto.ActiveAssignVoucher av) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", av.getContainerId()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("activeSizeMB", av.getActiveSizeMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("inactiveSizeMB", av.getInactiveSizeMB()));
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveWriter(CLDBProto.ActiveWriter w) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)w.getHostname()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volume", (Object)w.getVolumeName()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numAssigns", w.getNumContainerAssignCalls()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numInactiveAssigns", w.getNumContainerAssignCallsInactive()));
        return out;
    }

    private CLDBProto.VolumeInfo lookupVolumeInfo(int volumeId) throws Exception {
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeId(volumeId).setCreds(this.getUserCredentials()).build();
        return this.lookupVolumeInfoInternal(req);
    }

    private CLDBProto.VolumeInfo lookupVolumeInfo(String volumeName) throws Exception {
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        return this.lookupVolumeInfoInternal(req);
    }

    private CLDBProto.VolumeInfo lookupVolumeInfoInternal(CLDBProto.VolumeLookupRequest req) throws Exception {
        byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class);
        if (data == null) {
            throw new CLIProcessingException("Exception while processing RPC");
        }
        CLDBProto.VolumeLookupResponse resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            throw new IOException(resp.getStatus() == 2 ? "No such volume" : Errno.toString(resp.getStatus()));
        }
        return resp.getVolInfo();
    }

    private CLDBProto.ContainerInfo lookupContainerInfo(int containerId) throws Exception {
        LOG.info((Object)("Lookup for container " + containerId));
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.CONTAINER_DUMP_OP).setContainerId(containerId).setCreds(this.getUserCredentials()).build();
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (data == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                throw new CLIProcessingException("Couldn't connect to the CLDB service");
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getContainerInfo();
            }
            return null;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private CommandOutput dumpContainerInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String containerIds = this.getParamTextValue(DUMP_CONTAINER_ID_PARAM_NAME, 0);
        ArrayList<Integer> cIds = new ArrayList<Integer>();
        if (!containerIds.contains(MULTI_ARG_SEP)) {
            cIds.add(Integer.parseInt(containerIds));
        } else {
            String[] cs;
            for (String cId : cs = containerIds.split(MULTI_ARG_SEP)) {
                cIds.add(Integer.parseInt(cId));
            }
        }
        for (Integer cid : cIds) {
            try {
                CLDBProto.ContainerInfo cInfo = this.lookupContainerInfo(cid);
                if (cInfo == null) continue;
                int volumeId = cInfo.hasRwVolumeId() ? cInfo.getRwVolumeId() : cInfo.getVolumeId();
                CLDBProto.VolumeInfo vInfo = this.lookupVolumeInfo(volumeId);
                out.addNode(this.formatContainerInfo(cInfo, vInfo));
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump containerInfo failed"));
                output.setOutput(out);
                return output;
            }
        }
        return output;
    }

    private CommandOutput dumpContainers() throws CLIProcessingException {
        CLDBProto.DumpInfoRequest.DumpOp dumpOp;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String type = this.getParamTextValue(DUMP_CONTAINER_TYPE_PARAM_NAME, 0);
        long cookie = 0L;
        if (type.equalsIgnoreCase("offline")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_OFFLINE_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("resync")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_RESYNCING_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("bm")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_BECOME_MASTER_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("waiting")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_WAITING_FOR_ROLE_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("unused")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_UNUSED_CONTAINERS_OP;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + type));
            return output;
        }
        boolean hasMore = false;
        do {
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setCookie(cookie).setDumpOp(dumpOp).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump containers rpc failed"));
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump containers failed with status : " + resp.getStatus()));
                    return output;
                }
                boolean knownOp = resp.hasKnownOp();
                if (knownOp) {
                    knownOp = resp.getKnownOp();
                }
                if (!knownOp) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(38, "CLDB does not understand the dump containers command. Upgrade the CLDB and run the command again"));
                    return output;
                }
                for (CLDBProto.ContainerInfo cinfo : resp.getReplicationContainersList()) {
                    out.addNode(this.formatContainerInfo(cinfo, null, type));
                }
                hasMore = resp.getMoreCids();
                if (!hasMore) continue;
                cookie = resp.getCookie();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump containers failed"));
                return output;
            }
        } while (hasMore);
        return output;
    }

    private CommandOutput dumpZKInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        ZooKeeper s_zk = null;
        String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ZKConnectString: " + zkConnectString));
        }
        if (zkConnectString == null) {
            String errorMsg = "Unable to obtain the ZooKeeper connection string";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, errorMsg));
            return output;
        }
        zkConnectString = this.isParamPresent("zkconnect") ? this.getParamTextValue("zkconnect", 0) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        try {
            s_zk = NodesCommonUtils.connect(zkConnectString);
            CommandOutput.OutputHierarchy.OutputNode topNode = new CommandOutput.OutputHierarchy.OutputNode();
            this.getRecursiveZKInfo(s_zk, topNode, "/");
            out.addNode(topNode);
        }
        catch (KeeperException.NoAuthException e) {
            LOG.error((Object)"Pemission denied while trying to access ZooKeeper information", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(13, "Permission denied to access zookeeper information."));
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while trying to dump info from ZK. Check ZK connection", t);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Error while trying to dump info from ZK. Check ZK connection: " + zkConnectString));
        }
        return output;
    }

    private CommandOutput supportDumpTrigger() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput();
        co.setOutput(oh);
        String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ZKConnectString: " + zkConnectString));
        }
        if (zkConnectString == null) {
            String errorMsg = "Unable to obtain the ZooKeeper connection string";
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, errorMsg));
            return co;
        }
        ZooKeeper s_zk = NodesCommonUtils.connect(zkConnectString);
        ArrayList<String> nodeHostNames = new ArrayList();
        if (this.isParamPresent("nodes")) {
            nodeHostNames = this.input.getParameterByName("nodes").getParamValues();
            HashSet<String> hostNamesSet = new HashSet<String>(NodesCommonUtils.convertIpToHost(nodeHostNames));
            nodeHostNames.clear();
            nodeHostNames.addAll(hostNamesSet);
        } else {
            nodeHostNames = NodesCommonUtils.findNodeIps(zkConnectString);
        }
        try {
            for (String node : nodeHostNames) {
                CommandOutput.OutputHierarchy.OutputNode pNode = new CommandOutput.OutputHierarchy.OutputNode();
                oh.addNode(pNode);
                try {
                    s_zk.create("/nodes", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException e1) {
                    // empty catch block
                }
                try {
                    s_zk.create("/nodes/" + node, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException e1) {
                    // empty catch block
                }
                try {
                    byte[] data = String.valueOf(System.currentTimeMillis()).getBytes();
                    if (this.isParamPresent(DUMP_PARAMS)) {
                        String dumpParams = this.getParamTextValue(DUMP_PARAMS, 0);
                        data = dumpParams.getBytes();
                    }
                    s_zk.create("/nodes/" + node + "/" + SUPPORT_DUMP_ACTION, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    pNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("node", (Object)node));
                }
                catch (KeeperException.NodeExistsException e1) {
                    LOG.warn((Object)("Please wait. The previous " + SUPPORT_DUMP_ACTION + " is executing."));
                }
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"KeeperException while trying to create ZK struct for support dump", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "KeeperException while trying to create ZK struct for support dump" + e.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException while trying to create ZK struct for support dump", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "InterruptedException while trying to create ZK struct for support dump" + e.getLocalizedMessage()));
        }
        return co;
    }

    private CommandOutput dumpKvStoreCidInfo() throws CLIProcessingException {
        CommandOutput output;
        block6: {
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output = new CommandOutput();
            output.setOutput(out);
            ZooKeeper s_zk = null;
            String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
            if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
                zkConnectString = this.getParamTextValue("zkconnect", 0);
            }
            try {
                s_zk = NodesCommonUtils.connect(zkConnectString);
                Stat stat = new Stat();
                byte[] data = s_zk.getData("/datacenter/controlnodes/cldb/epoch/1/KvStoreContainerInfo", false, stat);
                if (data != null) {
                    CLDBProto.ContainerInfo kvStoreContainerInfo = CLDBProto.ContainerInfo.parseFrom((byte[])data);
                    LOG.info((Object)("ContainerInfo : " + Util.printContainerInfoForCLI((CLDBProto.ContainerInfo)kvStoreContainerInfo)));
                    for (Common.Server s : kvStoreContainerInfo.getAServersList()) {
                        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("valid", (Object)Util.printIPAddressesForCLI((Common.Server)s)));
                    }
                    for (Common.Server s : kvStoreContainerInfo.getIServersList()) {
                        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("invalid", (Object)Util.printIPAddressesForCLI((Common.Server)s)));
                    }
                    break block6;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Error while trying to trying to read ZooKeeper Information. Please Check ZooKeeper connection: " + zkConnectString));
                return output;
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while trying to dump info from ZK. Check ZK connection", t);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Error while trying to dump info from ZooKeeper. Please Check ZooKeeper connection: " + zkConnectString));
            }
        }
        return output;
    }

    private void getRecursiveZKInfo(ZooKeeper s_zk, CommandOutput.OutputHierarchy.OutputNode parentNode, String zkParentPath) throws KeeperException, InterruptedException {
        List children = s_zk.getChildren(zkParentPath, null);
        Stat stat = new Stat();
        byte[] data = s_zk.getData(zkParentPath, false, stat);
        parentNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(zkParentPath + "_Stats", (Object)DumpCommands.printStat(stat)));
        if (children.isEmpty()) {
            String dataStr = new String(data);
            if (zkParentPath.equalsIgnoreCase("/datacenter/controlnodes/cldb/epoch/1/KvStoreContainerInfo")) {
                try {
                    CLDBProto.ContainerInfo kvStoreContainerInfo = CLDBProto.ContainerInfo.parseFrom((byte[])data);
                    dataStr = Util.printContainerInfoForCLI((CLDBProto.ContainerInfo)kvStoreContainerInfo);
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error((Object)"Exception while trying to parse container info", (Throwable)e);
                }
            }
            parentNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(zkParentPath, (Object)dataStr));
        } else {
            parentNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(zkParentPath));
            for (String child : children) {
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode(zkParentPath);
                String newPath = zkParentPath;
                newPath = !zkParentPath.endsWith("/") ? newPath + "/" + child : newPath + child;
                this.getRecursiveZKInfo(s_zk, node, newPath);
                parentNode.addChild(node);
            }
        }
    }

    private static String printStat(Stat stat) {
        StringBuilder statB = new StringBuilder();
        statB.append("\ncZxid = " + stat.getCzxid());
        statB.append(",ctime = " + new Date(stat.getCtime()).toString());
        statB.append(",mZxid = " + stat.getMzxid());
        statB.append(",mtime = " + new Date(stat.getMtime()).toString());
        statB.append(",pZxid = " + stat.getPzxid());
        statB.append(",cversion = " + stat.getCversion());
        statB.append(",dataVersion = " + stat.getVersion());
        statB.append(",aclVersion = " + stat.getAversion());
        statB.append(",ephemeralOwner = " + stat.getEphemeralOwner());
        statB.append(",dataLength = " + stat.getDataLength());
        statB.append(",numChildren = " + stat.getNumChildren());
        return statB.toString();
    }
}

