/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.audit;

import com.mapr.audit.ConcurrentFIFOHashMap;
import com.mapr.audit.CreateRecordHandling;
import com.mapr.audit.DeleteRecordHandling;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ExpandAuditLogCluster {
    private static final String MAPRFS_URI = "maprfs:///";
    private MapRFileSystem fs;
    private int volId;
    private String volIdStr;
    private String volName;
    private String cluster;
    private boolean vollistCheck;
    private boolean expandToolLogs;
    private boolean deleted;
    private boolean verbose;
    private String inputDir;
    private String outputDir;
    private ExecutorService expandAuditLogClusterPool;
    private Path outputPath;
    private ConcurrentFIFOHashMap<String, String> fidPathMap = null;
    private ConcurrentHashMap<String, String> failedAttrFid = null;
    private ConcurrentHashMap<Integer, String> userMap = new ConcurrentHashMap();
    private static final Logger LOG = Logger.getLogger(ExpandAuditLogCluster.class);
    static final String FSAUDITPREFIX = "FSAudit";
    static final String DBAUDITPREFIX = "DBAudit";
    static final String EXPANDAUDITLOGPREFIX = "ExpandAudit";
    static final String JSONSUFFIX = ".json";
    static final String VOLUMEID = "volumeId";
    static final String CHILDFID = "childFid";
    static final String TABLEFID = "tableFid";
    static final String PARENTFID = "parentFid";
    static final String CHILDNAME = "childName";
    static final String SRCNAME = "srcName";
    ContainerFactory orderedKeyFactory = new ContainerFactory(){

        public List createArrayContainer() {
            return new LinkedList();
        }

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }
    };
    CreateRecordHandling createRecordHandling;
    DeleteRecordHandling deleteRecordHandling;
    long numRecords = 0L;
    long processingTime = 0L;
    long convertedSize = 0L;
    long parsingTime = 0L;

    void LogErrorAndExit(String string) {
        LOG.error((Object)string);
        System.out.println(string);
        System.exit(1);
    }

    void LogErrorAndContinue(String string) {
        LOG.error((Object)string);
        System.out.println(string);
    }

    void LogInfo(String string) {
        LOG.info((Object)string);
        System.out.println(string);
    }

    public void initialize(String outputDir, String inputDir, int volId, String volName, boolean vollistCheck, String cluster, int threadCount, boolean deleted, boolean verbose, boolean expandToolLogs) throws Exception {
        Configuration conf = new Configuration();
        String uri = MAPRFS_URI;
        if (cluster.length() > 0) {
            uri = uri + "mapr/" + cluster;
        }
        conf.set("fs.default.name", uri);
        this.fs = new MapRFileSystem();
        this.fs.initialize(URI.create(uri), conf, true);
        this.volId = volId;
        this.volName = volName;
        this.outputDir = outputDir;
        this.inputDir = inputDir;
        this.vollistCheck = vollistCheck;
        this.deleted = deleted;
        this.verbose = verbose;
        this.cluster = cluster;
        this.expandToolLogs = expandToolLogs;
        this.LogInfo("ExpandAuditLogs with args:");
        if (volId != 0) {
            this.LogInfo("volId = " + volId);
        }
        if (volName != null) {
            this.LogInfo("volumeName = " + volName);
        }
        this.LogInfo("Output Directory for expanded audit logs = " + outputDir);
        this.LogInfo("Input Directory for audit logs = " + inputDir);
        String hostName = null;
        try {
            InetAddress myIP = InetAddress.getLocalHost();
            if (myIP != null) {
                hostName = myIP.getHostName();
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (hostName != null) {
            this.LogInfo("HostName = " + hostName);
        } else {
            this.LogInfo("Unable to retrieve HostName");
        }
        this.LogInfo("Please look in mapr logs location for errlog");
        if (verbose) {
            LOG.info((Object)("Number of threads = " + threadCount));
        }
        int fidPathMapSize = 65536;
        Runtime runtime = Runtime.getRuntime();
        if ((int)(runtime.freeMemory() >> 12) > fidPathMapSize) {
            fidPathMapSize = (int)(runtime.freeMemory() >> 12);
        }
        if (verbose) {
            LOG.info((Object)("Setting fidcache size = " + fidPathMapSize));
        }
        this.fidPathMap = new ConcurrentFIFOHashMap(fidPathMapSize);
        this.failedAttrFid = new ConcurrentHashMap(fidPathMapSize * 10);
        this.createRecordHandling = new CreateRecordHandling(this.fs);
        this.deleteRecordHandling = new DeleteRecordHandling(this.fidPathMap, this.fs);
        this.expandAuditLogClusterPool = Executors.newFixedThreadPool(threadCount);
        StringBuilder sb = new StringBuilder();
        if (volId != 0) {
            sb.append("maprcli volume list");
            if (cluster.length() > 0) {
                sb.append(" -cluster " + cluster);
            }
            sb.append(" -filter volumeid==" + this.volId);
            sb.append(" -columns volumename -noheader");
            String cldbVolName = this.ExecuteCommand(sb.toString());
            if (cldbVolName.length() > 0) {
                if (deleted) {
                    this.LogErrorAndExit("-d option specified, but volumeid = " + volId + " exists with volumename = " + cldbVolName);
                }
                this.LogInfo("Using CLDB Extracted VolumeName = " + cldbVolName);
                this.volName = cldbVolName;
            } else if (this.volName.length() > 0 && deleted) {
                this.LogInfo("Using user specified volumeName = " + this.volName + "for VolumeId = " + this.volId);
            } else if (this.volName.length() == 0 && !deleted) {
                this.LogErrorAndExit("Unable to Extract VolumeName for specified VolumeId = " + volId + ". If deleted volume, please " + "re-run the tool with -d option");
            }
            this.volIdStr = String.valueOf(volId);
        } else {
            sb.append("maprcli volume info");
            if (cluster.length() > 0) {
                sb.append(" -cluster " + cluster);
            }
            sb.append(" -name " + this.volName);
            sb.append(" -columns volumeid -noheader");
            String volIdStr = this.ExecuteCommand(sb.toString());
            try {
                this.volId = Integer.parseInt(volIdStr);
            }
            catch (NumberFormatException e) {
                String userMsg = "Unable to convert specified VolumeName = " + this.volName + " to " + "VolumeId. Probably volume is deleted or cldb not accessible." + " VolumeName from CLDB = " + volIdStr + "\n";
                this.LogErrorAndExit(userMsg);
            }
            this.volIdStr = volIdStr;
            this.LogInfo("Using CLDB Extracted VolumeId = " + this.volIdStr);
        }
    }

    void ShutDown() {
        this.expandAuditLogClusterPool.shutdown();
    }

    public void Phase1Expand() throws Exception {
        Path clusterNodesDir;
        long beginTime = System.currentTimeMillis();
        Path outputDirPath = new Path(this.outputDir);
        if (!this.fs.exists(outputDirPath) || !this.fs.isDirectory(outputDirPath)) {
            this.LogErrorAndExit("Output Directory = " + this.outputDir + " is invalid");
        }
        this.outputPath = new Path(this.outputDir + "/" + this.volId + "/");
        if (!this.fs.exists(this.outputPath) && !this.fs.mkdirs(this.outputPath)) {
            this.LogErrorAndExit("create output directory = " + this.outputPath.toString() + " failed");
        }
        if (!this.fs.exists(clusterNodesDir = new Path(this.inputDir)) || !this.fs.isDirectory(clusterNodesDir)) {
            this.LogErrorAndExit("Invalid Input cluster audit log location = " + this.inputDir);
        }
        MapRFileStatus[] fileStatus = this.fs.listStatus(clusterNodesDir);
        Path[] paths = FileUtil.stat2Paths((FileStatus[])fileStatus);
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        for (Path path : paths) {
            String pathStr = path.toString();
            String nodeName = pathStr.substring(pathStr.lastIndexOf(47) + 1, pathStr.length());
            Path auditPath = new Path(path + "/audit/");
            if (this.fs.exists(auditPath)) {
                MapRFileStatus[] instances;
                this.LogInfo("Processing audit logs from Node = " + nodeName + "\naudit logs path = " + auditPath);
                ExpandAuditLogNodePhase1ExecutorService workItem = new ExpandAuditLogNodePhase1ExecutorService(this, nodeName, auditPath);
                futures.add(this.expandAuditLogClusterPool.submit(workItem));
                for (MapRFileStatus s : instances = this.fs.listStatus(auditPath)) {
                    if (!s.isDirectory()) continue;
                    Path[] instancePathArr = FileUtil.stat2Paths((FileStatus[])new FileStatus[]{s});
                    Path instancePath = instancePathArr[0];
                    this.LogInfo("Processing audit logs from Node = " + nodeName + "\naudit logs path = " + instancePath);
                    nodeName = nodeName + "/" + instancePath.getName();
                    ExpandAuditLogNodePhase1ExecutorService instanceWorkItem = new ExpandAuditLogNodePhase1ExecutorService(this, nodeName, instancePath);
                    futures.add(this.expandAuditLogClusterPool.submit(instanceWorkItem));
                }
                continue;
            }
            LOG.info((Object)("Missing audit log directory for node = " + nodeName));
        }
        for (Future future : futures) {
            future.get();
        }
        long endTime = System.currentTimeMillis();
        if (this.verbose) {
            if (endTime > beginTime) {
                this.processingTime = endTime - beginTime;
            }
            this.LogInfo("Phase1 Summary:\nProcessing time (secs) = " + this.processingTime / 1000L + "\nConverted size = " + this.convertedSize + "\nNumRecords = " + this.numRecords);
            this.LogInfo("Phase1 JsonParsing time (secs) = " + this.parsingTime / 1000L);
        }
        this.processingTime = 0L;
        this.convertedSize = 0L;
        this.numRecords = 0L;
        this.parsingTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ExpandAuditLogNodePhase1(Path auditPath, String nodeName) throws Exception {
        String outputDir = this.outputPath.toString() + "/" + nodeName + "/";
        Path outputPath = new Path(outputDir);
        MapRFileStatus[] fileStatus = this.fs.listStatus(auditPath);
        String curDayFSLogFile = "";
        Path curDayFSLogFileOutPath = null;
        String curDayDBLogFile = "";
        Path curDayDBLogFileOutPath = null;
        String curDayExpandAuditLogFile = "";
        Path curDayExpandAuditLogFileOutPath = null;
        Metrics metrics = new Metrics();
        long beginTime = System.currentTimeMillis();
        for (int i = 0; i < fileStatus.length; ++i) {
            Path ipath;
            String pathStr;
            String fileName;
            if (fileStatus[i].getLen() == 0L || !(fileName = (pathStr = (ipath = fileStatus[i].getPath()).toString()).substring(pathStr.lastIndexOf(47) + 1, pathStr.length())).startsWith(FSAUDITPREFIX) && !fileName.startsWith(DBAUDITPREFIX) && (!this.expandToolLogs || !fileName.startsWith(EXPANDAUDITLOGPREFIX)) || !fileName.endsWith(JSONSUFFIX)) continue;
            fileName = fileName.substring(0, fileName.lastIndexOf(JSONSUFFIX));
            String vollistPathStr = pathStr.substring(0, pathStr.lastIndexOf(47)) + "Vollist_" + fileName;
            if (this.vollistCheck && !this.checkVolListFile(vollistPathStr, this.volId)) continue;
            Path opath = new Path(outputDir + "/" + fileName + JSONSUFFIX);
            Path opathp = new Path(outputDir + "/" + fileName + ".pending.json");
            boolean readOnly = false;
            if ((this.fs.exists(opath) || this.fs.exists(opathp)) && !this.deleted) {
                if (!this.deleted) {
                    if (!this.verbose) continue;
                    LOG.info((Object)("Skipping Expanding AuditLog = " + pathStr));
                    continue;
                }
                readOnly = true;
            }
            Path opathpart = new Path(outputDir + "/" + fileName + ".part.json");
            Path opathpartp = new Path(outputDir + "/" + fileName + ".part.pending.json");
            if (this.fs.exists(opathpart)) {
                this.fs.delete(opathpart, false);
            }
            if (this.fs.exists(opathpartp)) {
                this.fs.delete(opathpartp, false);
            }
            Path otpath = new Path(opath.toString() + ".inPhase1");
            LOG.info((Object)("Processing Audit Log File = " + pathStr));
            FileParseResult res = this.ExpandAuditLogFilePhase1(ipath, otpath, readOnly, metrics);
            if (res == FileParseResult.NONE) continue;
            if (res == FileParseResult.PENDING) {
                this.fs.rename(otpath, opathp);
                opath = opathp;
            } else {
                this.fs.rename(otpath, opath);
            }
            if (fileName.startsWith(FSAUDITPREFIX) && curDayFSLogFile.compareTo(ipath.toString()) < 0) {
                curDayFSLogFile = ipath.toString();
                curDayFSLogFileOutPath = opath;
            }
            if (fileName.startsWith(DBAUDITPREFIX) && curDayDBLogFile.compareTo(ipath.toString()) < 0) {
                curDayDBLogFile = ipath.toString();
                curDayDBLogFileOutPath = opath;
            }
            if (!fileName.startsWith(EXPANDAUDITLOGPREFIX) || curDayExpandAuditLogFile.compareTo(ipath.toString()) >= 0) continue;
            curDayExpandAuditLogFile = ipath.toString();
            curDayExpandAuditLogFileOutPath = opath;
        }
        String strippedCurDayFSLogFile = "";
        String strippedCurDayDBLogFile = "";
        String strippedCurDayExpandAuditLogFile = "";
        if (curDayFSLogFile.length() > 0) {
            strippedCurDayFSLogFile = curDayFSLogFile.substring(curDayFSLogFile.lastIndexOf(FSAUDITPREFIX) + FSAUDITPREFIX.length(), curDayFSLogFile.length());
        }
        if (curDayDBLogFile.length() > 0) {
            strippedCurDayDBLogFile = curDayDBLogFile.substring(curDayDBLogFile.lastIndexOf(DBAUDITPREFIX) + DBAUDITPREFIX.length(), curDayDBLogFile.length());
        }
        if (curDayExpandAuditLogFile.length() > 0) {
            strippedCurDayExpandAuditLogFile = curDayExpandAuditLogFile.substring(curDayExpandAuditLogFile.lastIndexOf(EXPANDAUDITLOGPREFIX) + EXPANDAUDITLOGPREFIX.length(), curDayExpandAuditLogFile.length());
        }
        boolean renameFSFile = true;
        boolean renameDBFile = true;
        boolean renameExpandAuditFile = true;
        if (strippedCurDayFSLogFile.compareTo(strippedCurDayDBLogFile) > 0) {
            renameDBFile = false;
        } else if (strippedCurDayFSLogFile.compareTo(strippedCurDayDBLogFile) < 0) {
            renameExpandAuditFile = false;
            renameFSFile = false;
        }
        if (strippedCurDayFSLogFile.length() == 0) {
            renameFSFile = false;
        }
        if (strippedCurDayDBLogFile.length() == 0) {
            renameDBFile = false;
        }
        if (strippedCurDayExpandAuditLogFile.length() == 0) {
            renameExpandAuditFile = false;
        }
        if (renameFSFile) {
            this.RenameCurDayFile(curDayFSLogFileOutPath);
        }
        if (renameDBFile) {
            this.RenameCurDayFile(curDayDBLogFileOutPath);
        }
        if (renameExpandAuditFile) {
            this.RenameCurDayFile(curDayExpandAuditLogFileOutPath);
        }
        long endTime = System.currentTimeMillis();
        if (this.verbose && endTime > beginTime) {
            LOG.info((Object)("Phase1 Summary for NodeName = " + nodeName + "\nProcessingTime (in ms) = " + (endTime - beginTime) + "\nNumber of audit logs read = " + metrics.nCount + "\nSize of audit logs processed = " + metrics.nSize));
        }
        ExpandAuditLogCluster expandAuditLogCluster = this;
        synchronized (expandAuditLogCluster) {
            this.convertedSize += metrics.nSize;
            this.numRecords += metrics.nCount;
        }
    }

    void RenameCurDayFile(Path opath) throws Exception {
        Path newopath;
        if (!this.fs.exists(opath)) {
            return;
        }
        if (opath.toString().endsWith(".pending.json")) {
            int last = opath.toString().lastIndexOf(".pending.json");
            newopath = new Path(opath.toString().substring(0, last) + ".part.pending.json");
        } else {
            int last = opath.toString().lastIndexOf(JSONSUFFIX);
            newopath = new Path(opath.toString().substring(0, last) + ".part.json");
        }
        this.fs.rename(opath, newopath);
    }

    boolean checkVolListFile(String pathStr, int volId) {
        Path volListPath = new Path(pathStr);
        try {
            String line;
            if (!this.fs.exists(volListPath) || !this.fs.isFile(volListPath)) {
                return true;
            }
            FSDataInputStream in = this.fs.open(volListPath);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
            boolean res = false;
            int fileVolId = 0;
            long lineNumber = 0L;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                try {
                    fileVolId = Integer.parseInt(line);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Found Invalid VolId = " + volId + " in vollist file = " + volListPath + " at line number = " + lineNumber));
                    res = true;
                    break;
                }
                if (volId != fileVolId) continue;
                res = true;
                break;
            }
            reader.close();
            in.close();
            if (lineNumber == 0L) {
                LOG.error((Object)("Found Invalid vollist file = " + volListPath + " with zero size"));
                return true;
            }
            return res;
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", (Throwable)e);
            return true;
        }
    }

    FileParseResult ExpandAuditLogFilePhase1(Path ipath, Path opath, boolean readOnly, Metrics metrics) throws Exception {
        String line;
        FSDataInputStream in = null;
        FSDataOutputStream out = null;
        try {
            in = this.fs.open(ipath);
        }
        catch (IOException e) {
            LOG.error((Object)"Audit Log File Open Exception", (Throwable)e);
            return FileParseResult.NONE;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in), 0x400000);
        BufferedWriter writer = null;
        if (!readOnly) {
            out = this.fs.create(opath);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out), 0x200000);
        }
        boolean logsWritten = false;
        boolean pending = false;
        long linenum = 0L;
        JSONParser jsonParser = new JSONParser();
        while ((line = reader.readLine()) != null) {
            ++metrics.nCount;
            metrics.nSize += (long)line.length();
            LogParseResult res = this.ExpandAuditLogPhase1(writer, jsonParser, line, readOnly, ipath.toString(), ++linenum);
            if (res == LogParseResult.FIDEXPANDED) {
                logsWritten = true;
                continue;
            }
            if (res == LogParseResult.FIDEXPANDFAILED) {
                logsWritten = true;
                pending = true;
                continue;
            }
            if (res != LogParseResult.JSONPARSEFAILED) continue;
            LOG.error((Object)("Failure Json Decode: Log file = " + ipath.toString() + "\nLog = " + line));
        }
        reader.close();
        in.close();
        if (readOnly) {
            return FileParseResult.NONE;
        }
        writer.close();
        out.close();
        if (!logsWritten) {
            this.fs.delete(opath, false);
            return FileParseResult.NONE;
        }
        if (pending) {
            return FileParseResult.PENDING;
        }
        return FileParseResult.COMPLETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogParseResult ExpandAuditLogPhase1(BufferedWriter writer, JSONParser parser, String line, boolean readOnly, String ipathStr, long linenum) throws Exception {
        LinkedHashMap ijsonObj;
        if (line.length() == 0 || !line.contains(this.volIdStr)) {
            return LogParseResult.VOLIDMISMATCH;
        }
        long beginTime = System.currentTimeMillis();
        try {
            ijsonObj = (LinkedHashMap)parser.parse(line, this.orderedKeyFactory);
        }
        catch (ParseException e) {
            this.LogErrorAndContinue("JsonParse Exception in Log File = " + ipathStr + ":" + linenum + "\nposition = " + e.getPosition());
            return LogParseResult.JSONPARSEFAILED;
        }
        catch (ClassCastException e) {
            this.LogErrorAndContinue("Unexpected Exception during json parse\nLog file = " + ipathStr + ":" + linenum + "\nmessage = " + e.toString());
            return LogParseResult.JSONPARSEFAILED;
        }
        long endTime = System.currentTimeMillis();
        if (endTime > beginTime) {
            ExpandAuditLogCluster expandAuditLogCluster = this;
            synchronized (expandAuditLogCluster) {
                this.parsingTime = this.parsingTime + endTime - beginTime;
            }
        }
        if (!ijsonObj.containsKey(VOLUMEID) || !this.volIdStr.equals(ijsonObj.get(VOLUMEID).toString())) {
            return LogParseResult.VOLIDMISMATCH;
        }
        String operation = null;
        if (ijsonObj.get("operation") != null) {
            operation = ijsonObj.get("operation").toString();
        }
        if (operation != null && (operation.equals("CREATE") || operation.equals("CREATESYM") || operation.equals("MKDIR") || operation.equals("DB_TABLECREATE"))) {
            this.HandleCreateRecord(ijsonObj, ipathStr);
        }
        if (readOnly) {
            return LogParseResult.READONLY;
        }
        if (operation != null && (operation.equals("DELETE") || operation.equals("RMDIR"))) {
            this.HandleDeleteRecord(ijsonObj, ipathStr);
        }
        boolean expFailed = false;
        LinkedHashMap<String, String> ojsonObj = new LinkedHashMap<String, String>();
        for (Map.Entry entry : ijsonObj.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.endsWith("Fid")) {
                String expandedFid = null;
                if (this.fidPathMap.get(value) != null) {
                    expandedFid = this.fidPathMap.get(value).toString();
                } else if (this.deleteRecordHandling.get(value) != null) {
                    expandedFid = this.deleteRecordHandling.get(value).toString();
                } else {
                    try {
                        expandedFid = null;
                        if (this.failedAttrFid.get(value) == null) {
                            expandedFid = this.fs.getMountPathFid(value);
                        }
                    }
                    catch (IOException e) {
                        this.LogErrorAndContinue("getMountPath failed for invalid fid = " + value + " in log file = " + ipathStr + "\naudit log = " + line);
                        expandedFid = null;
                    }
                    if (expandedFid != null) {
                        this.fidPathMap.put(value, expandedFid);
                    } else {
                        this.failedAttrFid.putIfAbsent(value, "1");
                    }
                }
                if (expandedFid != null) {
                    ojsonObj.put(key.replace("Fid", "Path"), expandedFid);
                    ojsonObj.put(key, value);
                    continue;
                }
                ojsonObj.put(key, value);
                expFailed = true;
                continue;
            }
            if (this.volName.length() != 0 && key.equals(VOLUMEID)) {
                ojsonObj.put("VolumeName", this.volName);
                ojsonObj.put(VOLUMEID, (String)entry.getValue());
                continue;
            }
            if (key.equals("uid")) {
                String userName = "";
                try {
                    int uidInt = Integer.parseInt(value);
                    if (this.userMap.get(uidInt) != null) {
                        userName = this.userMap.get(uidInt).toString();
                    } else {
                        userName = this.ExecuteCommand("getent passwd " + value);
                        if (userName.indexOf(58) != -1) {
                            userName = userName.substring(0, userName.indexOf(58));
                        }
                        if (userName.length() > 0) {
                            this.userMap.putIfAbsent(uidInt, userName);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Found Invalid userId = " + value));
                }
                if (userName.length() > 0) {
                    ojsonObj.put("user", userName);
                    ojsonObj.put("uid", (String)entry.getValue());
                    continue;
                }
                ojsonObj.put("uid", (String)entry.getValue());
                continue;
            }
            if (key.equals("accessReq") || key.equals("accessResp")) {
                StringBuilder expandedPerm = new StringBuilder();
                try {
                    int nfsPerm = Integer.parseInt(value, 8);
                    if ((nfsPerm & 1) == 1) {
                        expandedPerm.append("read,");
                    }
                    if ((nfsPerm & 2) == 2) {
                        expandedPerm.append("lookup,");
                    }
                    if ((nfsPerm & 4) == 4) {
                        expandedPerm.append("modify,");
                    }
                    if ((nfsPerm & 8) == 8) {
                        expandedPerm.append("extend,");
                    }
                    if ((nfsPerm & 0x10) == 16) {
                        expandedPerm.append("delete,");
                    }
                    if ((nfsPerm & 0x20) == 32) {
                        expandedPerm.append("execute,");
                    }
                    if (expandedPerm.length() > 0) {
                        expandedPerm.setLength(expandedPerm.length() - 1);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Found Invalid accessReq or accessResp = " + value));
                }
                if (expandedPerm.length() > 0) {
                    ojsonObj.put(key + "InText", expandedPerm.toString());
                }
                ojsonObj.put(key, value);
                continue;
            }
            ojsonObj.put(key, (String)entry.getValue());
        }
        String expandedLog = JSONValue.toJSONString(ojsonObj).replace("\\", "");
        writer.write(expandedLog + "\n");
        if (expFailed) {
            return LogParseResult.FIDEXPANDFAILED;
        }
        return LogParseResult.FIDEXPANDED;
    }

    void HandleCreateRecord(LinkedHashMap ijsonObj, String ipathStr) throws Exception {
        String cFid = null;
        String pFid = null;
        String cName = null;
        if (ijsonObj.get(CHILDFID) != null) {
            cFid = ijsonObj.get(CHILDFID).toString();
        }
        if (ijsonObj.get(TABLEFID) != null) {
            cFid = ijsonObj.get(TABLEFID).toString();
        }
        if (ijsonObj.get(PARENTFID) != null) {
            pFid = ijsonObj.get(PARENTFID).toString();
        }
        if (ijsonObj.get(CHILDNAME) != null) {
            cName = ijsonObj.get(CHILDNAME).toString();
        }
        if (ijsonObj.get(SRCNAME) != null) {
            cName = ijsonObj.get(SRCNAME).toString();
        }
        if (cFid == null || pFid == null || cName == null) {
            return;
        }
        if (!MapRFileSystem.isFidString((String)cFid)) {
            LOG.error((Object)("Invalid Child Fid = " + cFid + " in log file = " + ipathStr));
            return;
        }
        if (!MapRFileSystem.isFidString((String)pFid)) {
            LOG.error((Object)("Invalid parent Fid = " + pFid + " in log file = " + ipathStr));
            return;
        }
        this.createRecordHandling.ProcessCreateRecord(pFid, cFid, cName);
    }

    void HandleDeleteRecord(LinkedHashMap ijsonObj, String ipathStr) throws Exception {
        String cFid = null;
        String pFid = null;
        String cName = null;
        if (ijsonObj.get(CHILDFID) != null) {
            cFid = ijsonObj.get(CHILDFID).toString();
        }
        if (ijsonObj.get(PARENTFID) != null) {
            pFid = ijsonObj.get(PARENTFID).toString();
        }
        if (ijsonObj.get(CHILDNAME) != null) {
            cName = ijsonObj.get(CHILDNAME).toString();
        }
        if (cFid == null || pFid == null || cName == null) {
            return;
        }
        this.deleteRecordHandling.ProcessDeleteRecord(pFid, cFid, cName, ipathStr);
    }

    public void Phase2Expand() throws Exception {
        long beginTime = System.currentTimeMillis();
        this.createRecordHandling.ResolveAllFids();
        MapRFileStatus[] fileStatus = this.fs.listStatus(this.outputPath);
        Path[] paths = FileUtil.stat2Paths((FileStatus[])fileStatus);
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        for (Path path : paths) {
            MapRFileStatus[] instances;
            if (!this.fs.isDirectory(path)) {
                LOG.error((Object)("Unexpected non directory path at = " + path.toString()));
                continue;
            }
            ExpandAuditLogNodePhase2ExecutorService workItem = new ExpandAuditLogNodePhase2ExecutorService(this, path);
            futures.add(this.expandAuditLogClusterPool.submit(workItem));
            for (MapRFileStatus s : instances = this.fs.listStatus(path)) {
                if (!s.isDirectory()) continue;
                Path[] instancePathArr = FileUtil.stat2Paths((FileStatus[])new FileStatus[]{s});
                Path instancePath = instancePathArr[0];
                ExpandAuditLogNodePhase2ExecutorService instanceWorkItem = new ExpandAuditLogNodePhase2ExecutorService(this, instancePath);
                futures.add(this.expandAuditLogClusterPool.submit(instanceWorkItem));
            }
        }
        for (Future future : futures) {
            future.get();
        }
        long endTime = System.currentTimeMillis();
        if (this.verbose) {
            if (endTime > beginTime) {
                this.processingTime = endTime - beginTime;
            }
            LOG.info((Object)("Phase2 Summary:\nProcesing time (secs) = " + this.processingTime / 1000L + "\nConverted size = " + this.convertedSize + "\nNumRecords = " + this.numRecords));
        }
    }

    void ExpandAuditLogNodePhase2(Path nodePath) throws Exception {
        MapRFileStatus[] fileStatus = this.fs.listStatus(nodePath);
        Path[] paths = FileUtil.stat2Paths((FileStatus[])fileStatus);
        for (int i = 0; i < fileStatus.length; ++i) {
            Path ipath = fileStatus[i].getPath();
            if (!this.fs.isFile(ipath) || fileStatus[i].getLen() == 0L || !ipath.toString().endsWith(".pending.json")) continue;
            LOG.info((Object)("ExpandAuditLogNodePhase2: Processing pending file = " + ipath.toString()));
            int last = ipath.toString().lastIndexOf(".pending.json");
            Path opath = new Path(ipath.toString().substring(0, last) + JSONSUFFIX);
            Path otpath = new Path(ipath.toString().substring(0, last) + ".inPhase2");
            boolean res = this.ExpandAuditLogFilePhase2(ipath, otpath);
            this.fs.delete(ipath, false);
            if (res) {
                this.fs.rename(otpath, ipath);
                this.LogInfo("Pending fids after phase2 in file = " + ipath.toString());
                continue;
            }
            this.fs.rename(otpath, opath);
        }
    }

    boolean ExpandAuditLogFilePhase2(Path ipath, Path opath) throws Exception {
        String line;
        FSDataInputStream in = this.fs.open(ipath);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
        FSDataOutputStream out = this.fs.create(opath);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out));
        boolean pending = false;
        JSONParser jsonParser = new JSONParser();
        while ((line = reader.readLine()) != null) {
            if (!this.ExpandAuditLogPhase2(writer, jsonParser, line)) continue;
            pending = true;
        }
        reader.close();
        in.close();
        writer.close();
        out.close();
        return pending;
    }

    boolean ExpandAuditLogPhase2(BufferedWriter writer, JSONParser parser, String line) throws Exception {
        boolean pending = false;
        long beginTime = System.currentTimeMillis();
        LinkedHashMap ijsonObj = null;
        try {
            ijsonObj = (LinkedHashMap)parser.parse(line, this.orderedKeyFactory);
        }
        catch (ParseException e) {
            LOG.info((Object)("Phase2: JsonParse Exception Line = " + line + " position = " + e.getPosition()));
            throw e;
        }
        long endTime = System.currentTimeMillis();
        if (endTime > beginTime) {
            this.parsingTime = this.parsingTime + endTime - beginTime;
        }
        LinkedHashMap<String, String> ojsonObj = new LinkedHashMap<String, String>();
        for (Map.Entry entry : ijsonObj.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.endsWith("Fid") && !ijsonObj.containsKey(key.toString().replace("Fid", "Path"))) {
                String fidExpD = this.deleteRecordHandling.get(value);
                String fidExpC = this.createRecordHandling.GetFullPathForFid(value);
                String fidExp = null;
                fidExp = fidExpD == null ? fidExpC : (fidExpC == null ? fidExpD : (fidExpD.length() > fidExpC.length() ? fidExpD : fidExpC));
                if (fidExp != null) {
                    ojsonObj.put(key.toString().replace("Fid", "Path"), fidExp);
                    ojsonObj.put(key, value);
                    continue;
                }
                pending = true;
                ojsonObj.put(key, value);
                continue;
            }
            ojsonObj.put(key, (String)entry.getValue());
        }
        String expandedLog = JSONValue.toJSONString(ojsonObj).replace("\\", "");
        writer.write(expandedLog + "\n");
        return pending;
    }

    String ExecuteCommand(String command) {
        StringBuffer output = new StringBuffer();
        try {
            Process p = Runtime.getRuntime().exec(command);
            int status = p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            if (status == 0) {
                line = reader.readLine();
                if (line != null) {
                    output.append(line);
                }
            } else {
                LOG.error((Object)("execute Command = " + command + " status = " + status));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"ExecuteCommand Exception", (Throwable)e);
        }
        return output.toString().trim();
    }

    class ExpandAuditLogNodePhase2ExecutorService
    implements Callable<Void> {
        ExpandAuditLogCluster expandAuditLogCluster;
        Path nodePath;

        ExpandAuditLogNodePhase2ExecutorService(ExpandAuditLogCluster expandAuditLogCluster2, Path nodePath) {
            this.expandAuditLogCluster = expandAuditLogCluster2;
            this.nodePath = nodePath;
        }

        @Override
        public Void call() throws Exception {
            this.expandAuditLogCluster.ExpandAuditLogNodePhase2(this.nodePath);
            return null;
        }
    }

    class ExpandAuditLogNodePhase1ExecutorService
    implements Callable<Void> {
        ExpandAuditLogCluster expandAuditLogCluster;
        Path auditPath;
        String nodeName;

        ExpandAuditLogNodePhase1ExecutorService(ExpandAuditLogCluster expandAuditLogCluster2, String nodeName, Path auditPath) {
            this.expandAuditLogCluster = expandAuditLogCluster2;
            this.nodeName = nodeName;
            this.auditPath = auditPath;
        }

        @Override
        public Void call() throws Exception {
            this.expandAuditLogCluster.ExpandAuditLogNodePhase1(this.auditPath, this.nodeName);
            return null;
        }
    }

    private class Metrics {
        long nCount = 0L;
        long nSize = 0L;

        Metrics() {
        }
    }

    private static enum FileParseResult {
        NONE,
        PENDING,
        COMPLETED;

    }

    private static enum LogParseResult {
        JSONPARSEFAILED,
        VOLIDMISMATCH,
        FIDEXPANDED,
        FIDEXPANDFAILED,
        READONLY;

    }
}

