/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;

public class ZookeeperServerSetup {
    static ZooKeeperServer s_zk;
    static String s_zkdataDirName;
    static final int testZKPort = 6181;

    public static void setUpZKServer() throws Exception {
        File s_zkdataDir = File.createTempFile("unittest", null, new File("/tmp"));
        s_zkdataDirName = s_zkdataDir.getAbsolutePath();
        s_zkdataDir.delete();
        File dataDir = new File(s_zkdataDirName);
        File dataLogDir = new File(s_zkdataDirName);
        dataDir.mkdirs();
        dataLogDir.mkdirs();
        ZookeeperServerSetup.startSingleZkServer(2000, dataDir, dataLogDir, 6181);
    }

    public static void tearDownZKServer() throws Exception {
        ZookeeperServerSetup.stopZkServer();
        File dataDir = new File(s_zkdataDirName);
        Thread.sleep(500L);
        ZookeeperServerSetup.delete(dataDir);
    }

    static void startSingleZkServer(int tickTime, File dataDir, File dataLogDir, int port) {
        try {
            s_zk = new ZooKeeperServer(dataDir, dataLogDir, tickTime);
            InetSocketAddress addr = new InetSocketAddress("localhost", port);
            NIOServerCnxnFactory nioFactory = (NIOServerCnxnFactory)NIOServerCnxnFactory.createFactory((InetSocketAddress)addr, (int)200);
            nioFactory.startup(s_zk);
            Thread.sleep(500L);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start single ZooKeeper server.", e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    static void stopZkServer() {
        if (s_zk != null) {
            s_zk.shutdown();
            s_zk = null;
        }
    }

    private static void delete(File dataDir) {
        if (dataDir == null) {
            return;
        }
        if (dataDir.isDirectory()) {
            File[] subDirs;
            for (File subDir : subDirs = dataDir.listFiles()) {
                ZookeeperServerSetup.delete(subDir);
            }
        }
        if (!dataDir.delete()) {
            System.out.println("Can not delete: " + dataDir);
        }
    }
}

