/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.DbReplicaCommands;
import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.MapRDBTableImplHelper;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ojai.FieldPath;

public class JsonFieldPathTest {
    @Test
    public void testCfFieldPathInterconversion() throws IOException, Exception {
        TableDescriptor ts = MapRDB.newTableDescriptor();
        String tableName = "/multiCFGet-TestMapRDBWithCluster";
        ts.setPath("/multiCFGet-TestMapRDBWithCluster").addFamily(MapRDB.newDefaultFamilyDescriptor()).addFamily(MapRDB.newFamilyDescriptor().setName("f1").setJsonFieldPath("a.b")).addFamily(MapRDB.newFamilyDescriptor().setName("f2").setJsonFieldPath("a.b.c.d")).addFamily(MapRDB.newFamilyDescriptor().setName("f3").setJsonFieldPath("a.b.c")).addFamily(MapRDB.newFamilyDescriptor().setName("f4").setJsonFieldPath("x.a.b.c"));
        Admin admin = MapRDB.newAdmin();
        if (admin.tableExists("/multiCFGet-TestMapRDBWithCluster")) {
            admin.deleteTable("/multiCFGet-TestMapRDBWithCluster");
        }
        Table multiCFTable = admin.createTable(ts);
        String userName = System.getProperty("user.name");
        List cfList = DbReplicaCommands.getAllFamilies((String)multiCFTable.getPath().toString(), (String)userName);
        String jsonPath = "a.b.c[10].d";
        String cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, (List)cfList);
        String[] cfQual = cfCol.split(":");
        Assert.assertEquals((Object)"f3", (Object)cfQual[0]);
        Assert.assertEquals((Object)"v[10].d", (Object)cfQual[1]);
        jsonPath = "a.b.c.d";
        cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, (List)cfList);
        cfQual = cfCol.split(":");
        Assert.assertEquals((Object)"f2", (Object)cfQual[0]);
        Assert.assertEquals((long)1L, (long)cfQual.length);
        jsonPath = "a.bb.c";
        cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, (List)cfList);
        cfQual = cfCol.split(":");
        Assert.assertEquals((Object)"default", (Object)cfQual[0]);
        Assert.assertEquals((Object)"a.bb.c", (Object)cfQual[1]);
        jsonPath = "a.b.c.dd";
        cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, (List)cfList);
        cfQual = cfCol.split(":");
        Assert.assertEquals((Object)"f3", (Object)cfQual[0]);
        Assert.assertEquals((Object)"v.dd", (Object)cfQual[1]);
        jsonPath = "";
        cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, (List)cfList);
        cfQual = cfCol.split(":");
        Assert.assertEquals((Object)"default", (Object)cfQual[0]);
        Assert.assertEquals((long)1L, (long)cfQual.length);
        jsonPath = "x.a.b.c[9]";
        cfCol = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, (List)cfList);
        cfQual = cfCol.split(":");
        Assert.assertEquals((Object)"f4", (Object)cfQual[0]);
        Assert.assertEquals((Object)"v[9]", (Object)cfQual[1]);
        String cf = "f1";
        String qual = "v.c.d[10]";
        FieldPath path = MapRDBTableImplHelper.cfQualifierToJsonPath((String)cf, (String)qual, (List)cfList);
        Assert.assertEquals((Object)FieldPath.parseFrom((String)"a.b.c.d[10]"), (Object)path);
        cf = "default";
        qual = "v.a.c.d";
        path = MapRDBTableImplHelper.cfQualifierToJsonPath((String)cf, (String)qual, (List)cfList);
        Assert.assertEquals((Object)FieldPath.parseFrom((String)"v.a.c.d"), (Object)path);
        cf = "f3";
        qual = "v[10].d.e.f";
        path = MapRDBTableImplHelper.cfQualifierToJsonPath((String)cf, (String)qual, (List)cfList);
        Assert.assertEquals((Object)FieldPath.parseFrom((String)"a.b.c[10].d.e.f"), (Object)path);
    }
}

