/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.schedulepolicy.commands;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.JSONObjectInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SchedulePolicyCreateCommand
extends CLIBaseClass
implements CLIInterface {
    private static final String SCHEDULE_CREATE_PARAM = "create";
    private static final String SCHEDULE_PARAM = "schedule";
    public static final String CLDB_HOST = "cldbip";
    public static final String CLDB_PORT = "cldbport";
    public static final Log LOG = LogFactory.getLog(SchedulePolicyCreateCommand.class);
    public static Pattern p = Pattern.compile("(\\d+)|(\\w+)");
    public static final CLICommand schedulePolicyCreateCommand = new CLICommand("create", "create schedule ", SchedulePolicyCreateCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"schedule", (Object)new JSONObjectInputParameter("schedule", "JSON Object to denote all the schedule properties", true)).build(), null);

    public SchedulePolicyCreateCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String scheduleName;
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        CLDBProto.SchedulePolicyProcRequest.Builder scheduleRequestBuilder = CLDBProto.SchedulePolicyProcRequest.newBuilder();
        scheduleRequestBuilder.setPolicyOp(CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP.CREATE);
        CLDBProto.Policy.Builder policyBuilder = CLDBProto.Policy.newBuilder();
        String jSonString = (String)this.input.getParameterByName(SCHEDULE_PARAM).getParamValues().get(0);
        try {
            JSONObject jO = new JSONObject(jSonString);
            scheduleName = jO.getString("name");
            policyBuilder.setPolicyName(scheduleName);
            JSONArray jRules = jO.optJSONArray("rules");
            ArrayList<CLDBProto.PolicyRule> rules = new ArrayList<CLDBProto.PolicyRule>();
            for (int i = 0; i < jRules.length(); ++i) {
                CLDBProto.PolicyRule.Builder ruleBuilder = CLDBProto.PolicyRule.newBuilder();
                JSONObject jRO = jRules.getJSONObject(i);
                String jFreq = jRO.getString("frequency");
                ruleBuilder.setFrequency(CLDBProto.PolicyFrequencyEnum.valueOf((String)jFreq));
                String date = jRO.optString("date");
                if (date != null && date.length() > 0) {
                    ruleBuilder.setDate(date);
                }
                if (!jRO.isNull("time")) {
                    int time = jRO.optInt("time");
                    ruleBuilder.setTime(time);
                }
                if (!jRO.isNull("minute")) {
                    int minutes = jRO.optInt("minute");
                    ruleBuilder.setMinutes(minutes);
                }
                String retain = jRO.getString("retain");
                ArrayList<String> groups = new ArrayList<String>();
                Matcher m = p.matcher(retain);
                while (m.find()) {
                    groups.add(m.group().trim());
                }
                if (groups.size() != 2) {
                    LOG.error((Object)("retain portion of the input is invalid: " + retain));
                    ch.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retain portion of the input is invalid: " + retain).setField("retain").setFieldValue(retain));
                    continue;
                }
                CLDBProto.PolicyRule.RetainPeriod.Builder retainBuilder = CLDBProto.PolicyRule.RetainPeriod.newBuilder();
                retainBuilder.setNumberOfUnits(Integer.valueOf((String)groups.get(0)).intValue());
                retainBuilder.setTimeUnitsEnum(CLDBProto.RetainTimeUnitsEnum.valueOf((String)((String)groups.get(1))));
                ruleBuilder.setRetainTime(retainBuilder);
                rules.add(ruleBuilder.build());
            }
            policyBuilder.addAllPolicyRules(rules);
            scheduleRequestBuilder.setPolicy(policyBuilder.build());
        }
        catch (JSONException e) {
            LOG.error((Object)("Provided Input cannot be converted to JSONObject: " + jSonString));
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Provided Input can not be converted to JSONObject: " + jSonString));
            return co;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Provided Input is not compliant with enums: " + jSonString));
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Provided Input is not compliant with enums: " + jSonString));
            return co;
        }
        byte[] data = null;
        try {
            scheduleRequestBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class);
            if (data == null) {
                LOG.error((Object)"RPC Request to create Schedule Policy failed. No data returned");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return co;
            }
            CLDBProto.SchedulePolicyProcResponse resp = CLDBProto.SchedulePolicyProcResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                if (resp.getStatus() == 17 && scheduleName != null) {
                    String error = "A schedule policy with name '" + scheduleName + "' already exists.";
                    LOG.error((Object)error);
                    ch.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), error));
                } else {
                    LOG.error((Object)("Request to create Schedule Policy failed with error: " + Errno.toString(resp.getStatus())));
                    ch.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Request to create Schedule Policy failed with error: " + Errno.toString(resp.getStatus())));
                }
                return co;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"RPC Request to create Schedule Policy failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to create Schedule Policy failed. No data returned"));
            return co;
        }
        return co;
    }
}

