/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodeField;
import com.mapr.cli.common.VolumeField;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.cldb.alarms.PluggableAlarms;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluggableAlarmUtil {
    private static final int NUM_ALARMS_PER_RPC = 100;
    private static final Logger LOG = Logger.getLogger(PluggableAlarmUtil.class);
    private static List<VolumeField> volumeAlarmsAdded = new ArrayList<VolumeField>();
    private static List<NodeField> nodeAlarmsAdded = new ArrayList<NodeField>();
    private static List<Common.PluggableAlarm> pluggableAlarms = null;

    public static List<Common.PluggableAlarm> getAlarms(Security.CredentialsMsg creds, String alarmName, int start, int limit) throws CLIProcessingException {
        if (pluggableAlarms == null) {
            CLDBProto.AlarmViewRequest req = CLDBProto.AlarmViewRequest.newBuilder().setAlarmname(alarmName).setCreds(creds).setLimiter(CLIProto.Limiter.newBuilder().setStart(start).setLimit(limit > 100 ? 100 : limit).build()).build();
            CLDBProto.AlarmViewResponse resp = null;
            try {
                byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmViewProc.getNumber(), (MessageLite)req, CLDBProto.AlarmViewResponse.class);
                if (replyData == null) {
                    throw new CLIProcessingException("Failed to connect to CLDB");
                }
                resp = CLDBProto.AlarmViewResponse.parseFrom((byte[])replyData);
                if (resp == null) {
                    throw new CLIProcessingException("Reply data did not get retrieved properly.");
                }
                pluggableAlarms = resp.getAlarmsList();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmViewResponse proto object.", (Throwable)ipbe);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
                throw new CLIProcessingException("Failed due to exception", (Throwable)e);
            }
        }
        return pluggableAlarms;
    }

    public static List<Common.PluggableAlarm> getAlarms(Security.CredentialsMsg creds, int start, int end) throws CLIProcessingException {
        return PluggableAlarmUtil.getAlarms(creds, "", start, end);
    }

    public static List<Common.PluggableAlarm> getAlarmsByType(Security.CredentialsMsg creds, int start, int end, String type) throws CLIProcessingException {
        ArrayList<Common.PluggableAlarm> returnAlarms = new ArrayList<Common.PluggableAlarm>();
        for (Common.PluggableAlarm pluggableAlarm : PluggableAlarmUtil.getAlarms(creds, start, end)) {
            if (!PluggableAlarms.checkType((Common.PluggableAlarm)pluggableAlarm, (String)type)) continue;
            returnAlarms.add(pluggableAlarm);
        }
        return returnAlarms;
    }

    public static List<Common.PluggableAlarm> getVolumeAlarms(Security.CredentialsMsg creds, int start, int end) throws CLIProcessingException {
        return PluggableAlarmUtil.getAlarmsByType(creds, start, end, "VOLUME");
    }

    public static List<Common.PluggableAlarm> getNodeAlarms(Security.CredentialsMsg creds, int start, int end) throws CLIProcessingException {
        return PluggableAlarmUtil.getAlarmsByType(creds, start, end, "NODE");
    }

    public static List<Common.PluggableAlarm> getAlarms(Security.CredentialsMsg creds, String alarmName) throws CLIProcessingException {
        return PluggableAlarmUtil.getAlarms(creds, alarmName, 0, 1);
    }

    private static List<Common.PluggableAlarm> getAlarmsInternally(Security.CredentialsMsg creds) {
        List<Common.PluggableAlarm> pluggableAlarmsList;
        try {
            pluggableAlarmsList = PluggableAlarmUtil.getAlarms(creds, "", 0, 50);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)e.getMessage());
            pluggableAlarmsList = new ArrayList<Common.PluggableAlarm>();
        }
        return pluggableAlarmsList;
    }

    private static void logMaps(Map<VolumeField, FieldInfo> volMap, Map<NodeField, FieldInfo> nodeMap) {
        LOG.error((Object)("logMaps: entries in pluggableAlarms " + pluggableAlarms.size()));
        StringBuilder msgStr = new StringBuilder();
        for (Common.PluggableAlarm pa : pluggableAlarms) {
            msgStr.append("logMaps: PluggableAlarms dump: id:" + pa.getId() + ", name(key):" + pa.getName() + ", display:" + pa.getDisplayName());
            if (volMap != null) {
                VolumeField vf = new VolumeField(pa);
                msgStr.append(", VolumeField hash:[" + vf.hashCode() + "]");
            }
            if (nodeMap != null) {
                NodeField nf = new NodeField(pa);
                msgStr.append(", NodeField hash:[" + nf.hashCode() + "]");
            }
            LOG.error((Object)("logMaps: " + msgStr.toString()));
            msgStr.setLength(0);
        }
        if (volMap != null) {
            LOG.error((Object)("logMaps: entries in volumeMap " + volMap.size()));
            for (VolumeField vf : volMap.keySet()) {
                LOG.error((Object)("logMaps: volumeMap dump: id:" + vf.getId() + ", lable:" + vf.getLabel() + ", hash:[" + vf.hashCode() + "]"));
            }
        }
        if (nodeMap != null) {
            LOG.error((Object)("logMaps: entries in nodeMap " + nodeMap.size()));
            for (NodeField nf : nodeMap.keySet()) {
                LOG.error((Object)("logMaps: nodeMap dump: id:" + nf.getId() + ", lable:" + nf.getLabel() + ", hash:[" + nf.hashCode() + "]"));
            }
        }
    }

    public static Map<VolumeField, FieldInfo> appendVolumeMap(Security.CredentialsMsg creds, ImmutableMap.Builder<VolumeField, FieldInfo> table) {
        ImmutableMap volMap = table.build();
        List<Common.PluggableAlarm> pluggableAlarmList = PluggableAlarmUtil.getAlarmsInternally(creds);
        String type = "VOLUME";
        for (Common.PluggableAlarm pluggableAlarm : pluggableAlarmList) {
            VolumeField volumeField;
            if (!PluggableAlarms.checkType((Common.PluggableAlarm)pluggableAlarm, (String)type) || volumeAlarmsAdded.contains(volumeField = new VolumeField(pluggableAlarm))) continue;
            volumeAlarmsAdded.add(volumeField);
            table.put((Object)volumeField, (Object)new FieldInfo(pluggableAlarm.getId(), pluggableAlarm.getTerse(), pluggableAlarm.getDisplayName(), Integer.class));
        }
        try {
            return table.build();
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Exception: [bug 21946: contact mapr support] appendVolumeMap: " + e.getLocalizedMessage()));
            PluggableAlarmUtil.logMaps((Map<VolumeField, FieldInfo>)volMap, null);
            return table.build();
        }
    }

    public static Map<NodeField, FieldInfo> appendNodeMap(Security.CredentialsMsg creds, ImmutableMap.Builder<NodeField, FieldInfo> table) {
        ImmutableMap nodeMap = table.build();
        List<Common.PluggableAlarm> pluggableAlarmList = PluggableAlarmUtil.getAlarmsInternally(creds);
        String type = "NODE";
        for (Common.PluggableAlarm pluggableAlarm : pluggableAlarmList) {
            NodeField nodeField;
            if (!PluggableAlarms.checkType((Common.PluggableAlarm)pluggableAlarm, (String)type) || nodeAlarmsAdded.contains(nodeField = new NodeField(pluggableAlarm))) continue;
            nodeAlarmsAdded.add(nodeField);
            table.put((Object)nodeField, (Object)new FieldInfo(pluggableAlarm.getId(), pluggableAlarm.getTerse(), pluggableAlarm.getDisplayName(), Integer.class));
        }
        try {
            return table.build();
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Exception: [bug 21946: contact mapr support] appendNodeMap: " + e.getLocalizedMessage()));
            PluggableAlarmUtil.logMaps(null, (Map<NodeField, FieldInfo>)nodeMap);
            return table.build();
        }
    }

    public static Common.AlarmId getAlarmId(String alarmName) {
        for (Common.AlarmId aid : Common.AlarmId.values()) {
            if (!aid.name().equals(alarmName)) continue;
            return Common.AlarmId.valueOf((String)alarmName);
        }
        return null;
    }

    public static Common.PluggableAlarm getAlarmByName(Security.CredentialsMsg creds, String alarmName) {
        Common.PluggableAlarm ret = null;
        for (Common.PluggableAlarm pluggableAlarm : PluggableAlarmUtil.getAlarmsInternally(creds)) {
            if (!alarmName.equalsIgnoreCase(pluggableAlarm.getName())) continue;
            ret = pluggableAlarm;
            break;
        }
        return ret;
    }

    public static int getMaxNumNodes(Security.CredentialsMsg creds, int currentMax) {
        List<Common.PluggableAlarm> pluggableAlarmList = PluggableAlarmUtil.getAlarmsInternally(creds);
        for (Common.PluggableAlarm pluggableAlarm : pluggableAlarmList) {
            if (pluggableAlarm.getId() <= currentMax) continue;
            currentMax = pluggableAlarm.getId();
        }
        return currentMax;
    }

    public static void resetCache() {
        pluggableAlarms = null;
    }
}

