/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.marlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.marlin.StreamsCommands;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class StreamReplicaCommands
extends DbReplicaCommands {
    private static final Logger LOG = Logger.getLogger(StreamReplicaCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String REPLICA_PARAM_NAME = "replica";
    private static final String NEWREPLICA_PARAM_NAME = "newreplica";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final String THROTTLE_PARAM_NAME = "throttle";
    private static final String ENCRYPTION_PARAM_NAME = "networkencryption";
    private static final String SYNCHRONOUS_PARAM_NAME = "synchronous";
    private static final String COMPRESSION_PARAM_NAME = "networkcompression";
    private static final String MULTI_ARG_SEP = ",";
    private static final String COLUMN_SEP = ":";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String WAIT_FOR_COMPLETION_PARAM_NAME = "waitforcompletion";
    private static final String MULTI_MASTER_PARAM_NAME = "multimaster";
    private static final String TICKET_PATH_PARAM_NAME = "ticketpath";
    private static final CLICommand listCommand = new CLICommand("list", "usage: stream replica list -path <streampath>", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refreshnow", false, Boolean.valueOf(false))).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("stream replica list -path <tablepath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: stream replica add -path <streamPath> -replica <replicaPath> -paused <true|false> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lz4|lzf|zlib> ", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "remote stream path", true, null)).put((Object)"paused", (Object)new BooleanInputParameter("paused", "start replication in paused state", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication operations under load", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "replicate to remote stream before acknowledging producers", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|lz4|lzf|zlib default: compression setting on stream", false, null)).build(), null).setShortUsage("stream replica add -path <streamPath> -replica <replicaPath>");
    private static final CLICommand autoSetupCommand = new CLICommand("autosetup", "usage: stream replica autosetup -path <streamPath> -replica <replicaPath> -multimaster <true/false>-waitforcompletion <true/false>-throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|lz4|lzf|zlib> -ticketpath <path>", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "remote stream path", true, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "replicate to remote stream before acknowledging producers", false, Boolean.valueOf(false))).put((Object)"multimaster", (Object)new BooleanInputParameter("multimaster", "set up bi-directional replication", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication operations under load", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|lz4|lzf|zlib default: compression setting on stream", false, null)).put((Object)"waitforcompletion", (Object)new BooleanInputParameter("waitforcompletion", "wait for completion", false, Boolean.valueOf(true)).setInvisible(true)).put((Object)"ticketpath", (Object)new TextInputParameter("ticketpath", "ticket path", false, null).setInvisible(true)).build(), null).setShortUsage("stream replica autosetup -path <streamPath> -replica <replicaPath>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: stream replica edit -path <streamPath> -replica <replicaPath> -newreplica <newReplicaPath> -paused <true|false> -allowallcfs <true> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|lz4|lzf|zlib> ", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "remote stream path", true, null)).put((Object)"newreplica", (Object)new TextInputParameter("newreplica", "renamed stream path", false, null)).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication operations under load", false, null)).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "replicate to remote stream before acknowledging producers", false, null)).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|lz4|lzf|zlib", false, null)).build(), null).setShortUsage("stream replica edit -path <streamPath> -replica <replicaPath> -newreplica <newReplicaPath>-paused <true|false> -allowallcfs <true> -throttle <true|false>  -synchronous <true|false> -networkencryption <true|false -networkcompression <off|lz4|lzf|zlib>");
    private static final CLICommand pauseCommand = new CLICommand("pause", "usage: stream replica pause -path <streamPath> -replica <replicaPath>", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "remote stream path", true, null)).build(), null).setShortUsage("stream replica pause -path <streamPath> -replica <replicaPath>");
    private static final CLICommand resumeCommand = new CLICommand("resume", "usage: stream replica resume -path <streamPath> -replica <replicaPath>", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "remote stream path", true, null)).build(), null).setShortUsage("stream replica resume -path <streamPath> -replica <replicaPath>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: stream replica remove -path <streamPath> -replica <replicaPath>", StreamReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "stream path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "remote stream path", true, null)).build(), null).setShortUsage("stream replica remove -path <streamPath> -replica <replicaPath>");
    public static final CLICommand replicaCommands = new CLICommand("replica", "replica [add|edit|list|remove|pause|resume]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, editCommand, listCommand, removeCommand, pauseCommand, resumeCommand, autoSetupCommand}).setShortUsage("stream replica [add|edit|list|remove|pause|resume]");

    public StreamReplicaCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    @Override
    public String entityName() {
        return "stream";
    }

    @Override
    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String streamPath = this.getParamTextValue(PATH_PARAM_NAME, 0);
        try {
            if (!StreamsCommands.isStream(streamPath)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Path " + streamPath + " is not a valid stream"));
                return output;
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return output;
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addReplica(out);
        } else if (cname.equalsIgnoreCase(editCommand.getCommandName())) {
            this.editReplica(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listReplica(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeReplica(out);
        } else if (cname.equalsIgnoreCase(pauseCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, true);
        } else if (cname.equalsIgnoreCase(resumeCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, false);
        } else if (cname.equalsIgnoreCase(autoSetupCommand.getCommandName())) {
            this.autoSetup(out);
        }
        return output;
    }

    @Override
    protected void autoSetup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.autoSetup(out);
    }

    @Override
    protected void addReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.addReplica(out);
    }

    @Override
    protected void listReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.listReplica(out);
    }

    @Override
    protected void editReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.editReplica(out);
    }

    @Override
    protected void removeReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.removeReplica(out);
    }

    @Override
    protected void pauseOrResumeReplica(CommandOutput.OutputHierarchy out, boolean pause) throws CLIProcessingException {
        super.pauseOrResumeReplica(out, pause);
    }
}

