/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.common.JobExecutor;
import com.mapr.fs.AceHelper;
import com.mapr.fs.proto.Dbserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class CopyTableCallable
implements Callable<Integer> {
    private String srcTable;
    private String dstTable;
    private String user;
    private int maxVersions;
    private String columnSpec;
    private String ticketPath;
    private boolean isMultiMaster;
    private AceHelper.DBPermission dbPerm;
    private Dbserver.TableReplicaDesc.Builder replBuilder;
    private static final Logger LOG = Logger.getLogger(CopyTableCallable.class);

    public CopyTableCallable(String srcTable, String destTable, String user, int maxVersions, String columnSpec, String ticketPath, boolean isMultiMaster, AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder) {
        this.srcTable = srcTable;
        this.dstTable = destTable;
        this.user = user;
        this.maxVersions = maxVersions;
        this.columnSpec = columnSpec;
        this.ticketPath = ticketPath;
        this.isMultiMaster = isMultiMaster;
        this.dbPerm = dbPerm;
        this.replBuilder = replBuilder;
    }

    @Override
    public Integer call() throws Exception {
        try {
            LOG.info((Object)("Calling copy table script for tables: " + this.srcTable + "," + this.dstTable));
            if (this.srcTable == null || this.dstTable == null || this.user == null) {
                throw new Exception("Invalid input.Please check your input");
            }
            JobExecutor.setStatus(this.srcTable + "_" + this.dstTable, 2.0);
            ArrayList<String> command = new ArrayList<String>();
            command.add("/opt/mapr/bin/runcopytable");
            command.add(this.srcTable);
            command.add(this.dstTable);
            command.add(this.user);
            command.add(String.valueOf(this.maxVersions));
            if (this.columnSpec != null && this.columnSpec.length() > 0) {
                command.add(this.columnSpec);
            }
            LOG.info((Object)("Calling command: " + ((Object)command).toString()));
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new File("/opt/mapr/bin"));
            if (this.ticketPath != null) {
                builder.environment().put("MAPR_TICKETFILE_LOCATION", this.ticketPath);
            }
            Process p = builder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                if (s.trim().isEmpty()) continue;
                JobExecutor.setStatus(this.srcTable + "_" + this.dstTable, Double.valueOf(s.trim()));
            }
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdErr.readLine()) != null) {
                JobExecutor.setStatus(this.srcTable + "_" + this.dstTable, -1.0);
            }
            int status = p.waitFor();
            if (status != 0) {
                JobExecutor.setStatus(this.srcTable + "_" + this.dstTable, -1.0);
                throw new Exception("Copy Table script failed with status " + status);
            }
            LOG.info((Object)("Finished copy table script for tables: " + this.srcTable + "," + this.dstTable));
            try {
                if (this.isMultiMaster) {
                    DbReplicaCommands.setupMultiMaster(this.dbPerm, this.replBuilder, this.srcTable, this.dstTable, this.columnSpec, this.user);
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Failed to setup multi-master replication from table " + this.srcTable + " to " + this.dstTable + " with exception " + e.getMessage()));
                return null;
            }
            LOG.info((Object)("Resuming the replication from table: " + this.srcTable + " to " + this.dstTable));
            DbReplicaCommands.pauseOrResumeReplication(this.srcTable, this.dstTable, false, this.user);
            return status;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LOG.info((Object)("Failed with: " + sw.toString()));
            LOG.info((Object)("Failed to run the copytable script for tables: " + this.srcTable + "," + this.dstTable + " with error: " + e.getMessage()));
            JobExecutor.setStatus(this.srcTable + "_" + this.dstTable, -1.0);
            return null;
        }
        catch (Throwable t) {
            LOG.info((Object)"Throwable", t);
            JobExecutor.setStatus(this.srcTable + "_" + this.dstTable, -1.0);
            return null;
        }
    }
}

