/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.AceHelper;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class OffloadRuleCommands
extends ListCommand
implements CLIInterface {
    static String[] RulePropsFieldShortName = new String[]{"id", "n", "exp"};
    static String[] RulePropsFieldName = new String[]{"ruleid", "rulename", "expression"};
    public static final String RULENAME_PARAM_NAME = "name";
    public static final String EXPR_PARAM_NAME = "expr";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String ruleCreateUsage = "rule create -name ruleName -expr regular expression of rule [-cluster clustername]";
    public static final String ruleModifyUsage = "rule modify -name ruleName -expr regular expression of rule [-cluster clustername]";
    public static final String ruleListUsage = "rule list [-cluster clustername]";
    public static final String ruleInfoUsage = "rule info -name ruleName [-cluster clustername]";
    public static final String ruleRemoveUsage = "rule remove -name ruleName [-cluster clustername]";
    private static final Logger LOG = Logger.getLogger(OffloadRuleCommands.class);
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static Map<String, BaseInputParameter> ruleParams = new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "rule name", true, null)).put((Object)"expr", (Object)new TextInputParameter("expr", "regular expression of the rule", true, null)).putAll(baseParams).build();
    static final CLICommand ruleCreateCommand = new CLICommand("create", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(ruleParams).build(), null).setShortUsage("rule create -name ruleName -expr regular expression of rule [-cluster clustername]");
    static final CLICommand ruleModifyCommand = new CLICommand("modify", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(ruleParams).build(), null).setShortUsage("rule modify -name ruleName -expr regular expression of rule [-cluster clustername]");
    static final CLICommand ruleListCommand = new CLICommand("list", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"output", (Object)new TextInputParameter("output", "verbose", false, "verbose")).putAll(baseParams).build(), null).setShortUsage("rule list [-cluster clustername]");
    static final CLICommand ruleInfoCommand = new CLICommand("info", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "rule name", true, null)).put((Object)"output", (Object)new TextInputParameter("output", "verbose", false, "verbose")).putAll(baseParams).build(), null).setShortUsage("rule info -name ruleName [-cluster clustername]");
    static final CLICommand ruleRemoveCommand = new CLICommand("remove", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "rule name", true, null)).putAll(baseParams).build(), null).setShortUsage("rule info -name ruleName [-cluster clustername]");
    public static CLICommand[] ruleCommandsArray = new CLICommand[]{ruleCreateCommand, ruleModifyCommand, ruleRemoveCommand, ruleListCommand, ruleInfoCommand};
    public static final CLICommand ruleCommands = new CLICommand("rule", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{ruleCreateCommand, ruleModifyCommand, ruleRemoveCommand, ruleListCommand, ruleInfoCommand}).setShortUsage("rule [create|modify|remove|info|list]");

    public OffloadRuleCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            try {
                this.list(out);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
                return output;
            }
        }
        if (cmd.equalsIgnoreCase("create")) {
            try {
                this.ruleCreate(out);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
            }
        } else if (cmd.equalsIgnoreCase("modify")) {
            try {
                this.ruleModify(out);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
            }
        } else if (cmd.equalsIgnoreCase("info")) {
            try {
                this.ruleInfo(out);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
            }
        } else if (cmd.equalsIgnoreCase("remove")) {
            try {
                this.ruleRemove(out);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
            }
        }
        return output;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getRuleName() throws CLIProcessingException {
        return this.isParamPresent(RULENAME_PARAM_NAME) ? this.getParamTextValue(RULENAME_PARAM_NAME, 0) : null;
    }

    public static CLDBProto.OffloadRuleLookupResponse ruleLookup(String cluster, Security.CredentialsMsg creds, String ruleName) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.OffloadRuleLookupRequest req = CLDBProto.OffloadRuleLookupRequest.newBuilder().setRuleName(ruleName).setCreds(creds).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleLookupProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleLookupProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.OffloadRuleLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing rule lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    void ruleCreate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String ruleName = null;
        String cluster = null;
        Object credentials = null;
        String expr = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        ruleName = this.getRuleName();
        CLDBProto.OffloadRuleLookupResponse resp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), ruleName);
        if (resp.hasStatus() && resp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "OffloadRule " + ruleName + " already exists."));
            return;
        }
        if (this.isParamPresent(EXPR_PARAM_NAME)) {
            expr = this.getParamTextValue(EXPR_PARAM_NAME, 0);
        }
        try {
            CLDBProto.OffloadRuleCreateRequest.Builder ruleCreate = CLDBProto.OffloadRuleCreateRequest.newBuilder();
            CLDBProto.OffloadRuleProperties.Builder ruleProperties = CLDBProto.OffloadRuleProperties.newBuilder();
            ruleProperties.setRuleName(ruleName);
            ruleProperties.setExpression(AceHelper.toPostfix((String)expr));
            ruleCreate.setRuleProps(ruleProperties);
            ruleCreate.setCreds(this.getUserCredentials());
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleCreateProc.getNumber(), (MessageLite)ruleCreate.build(), CLDBProto.OffloadRuleCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleCreateProc.getNumber(), (MessageLite)ruleCreate.build(), CLDBProto.OffloadRuleCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.OffloadRuleCreateResponse createResp = CLDBProto.OffloadRuleCreateResponse.parseFrom((byte[])data);
            if (createResp.getStatus() == 0) {
                out.addMessage("Successfully created rule: '" + ruleName + "'");
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(createResp.getStatus(), Errno.toString(createResp.getStatus())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void ruleModify(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String ruleName = null;
        String cluster = null;
        Object credentials = null;
        String expr = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        ruleName = this.getRuleName();
        CLDBProto.OffloadRuleLookupResponse resp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), ruleName);
        if (resp.hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "OffloadRule " + ruleName + " does not exist."));
            return;
        }
        CLDBProto.OffloadRuleModifyRequest.Builder ruleModify = CLDBProto.OffloadRuleModifyRequest.newBuilder();
        CLDBProto.OffloadRuleProperties.Builder ruleProperties = CLDBProto.OffloadRuleProperties.newBuilder();
        ruleProperties.setRuleName(ruleName);
        expr = this.getParamTextValue(EXPR_PARAM_NAME, 0);
        try {
            if (this.isParamPresent(EXPR_PARAM_NAME)) {
                ruleProperties.setExpression(AceHelper.toPostfix((String)expr));
            }
            ruleModify.setRuleProps(ruleProperties);
            ruleModify.setCreds(this.getUserCredentials());
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleModifyProc.getNumber(), (MessageLite)ruleModify.build(), CLDBProto.OffloadRuleModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleModifyProc.getNumber(), (MessageLite)ruleModify.build(), CLDBProto.OffloadRuleModifyResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.OffloadRuleModifyResponse modifyResp = CLDBProto.OffloadRuleModifyResponse.parseFrom((byte[])data);
            if (modifyResp.getStatus() == 0) {
                out.addMessage("Successfully updated rule: '" + ruleName + "'");
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(modifyResp.getStatus(), Errno.toString(modifyResp.getStatus())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void ruleRemove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String ruleName = null;
        String cluster = null;
        byte[] data = null;
        ruleName = this.getRuleName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        CLDBProto.OffloadRuleRemoveRequest req = CLDBProto.OffloadRuleRemoveRequest.newBuilder().setRuleName(ruleName).setCreds(this.getUserCredentials()).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleRemoveProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleRemoveProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleRemoveResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.OffloadRuleRemoveResponse resp = CLDBProto.OffloadRuleRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Successfully deleted rule: '" + ruleName + "'");
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString(resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing rule lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    void ruleInfo(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.OffloadRuleLookupResponse resp;
        String ruleName = null;
        String cluster = null;
        ruleName = this.getRuleName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), ruleName)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "OffloadRule " + ruleName + " does not exist."));
            return;
        }
        boolean terse = this.getOutputParamValue().equals("terse");
        this.addOffloadRuleProps(resp.getRuleProps(), terse, out);
    }

    public CLDBProto.OffloadRuleListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.OffloadRuleListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.OffloadRuleListRequest.newBuilder((CLDBProto.OffloadRuleListRequest)((CLDBProto.OffloadRuleListRequest)prevReq)) : CLDBProto.OffloadRuleListRequest.newBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.OffloadRuleListResponse)prevResp).getTotal();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, 0, 1024, 25));
        }
        newReqBuilder.setCreds(this.getUserCredentials());
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(0, 1024, ((CLDBProto.OffloadRuleListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.OffloadRuleListResponse)prevResp).getTotal());
    }

    void addOffloadRuleProps(CLDBProto.OffloadRuleProperties ruleProperties, boolean terse, CommandOutput.OutputHierarchy out) {
        String[] columnName;
        CommandOutput.OutputHierarchy.OutputNode ruleNode = new CommandOutput.OutputHierarchy.OutputNode();
        String[] stringArray = columnName = terse ? RulePropsFieldShortName : RulePropsFieldName;
        if (ruleProperties.hasRuleId()) {
            ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[OffloadRulePropertiesField.id.ordinal()], (Object)Integer.toString(ruleProperties.getRuleId())));
        }
        if (ruleProperties.hasRuleName()) {
            ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[OffloadRulePropertiesField.n.ordinal()], (Object)ruleProperties.getRuleName()));
        }
        try {
            if (ruleProperties.hasExpression()) {
                ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[OffloadRulePropertiesField.exp.ordinal()], (Object)AceHelper.toInfix((String)ruleProperties.getExpression())));
            }
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            return;
        }
        out.addNode(ruleNode);
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.OffloadRuleListResponse resp = (CLDBProto.OffloadRuleListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        for (CLDBProto.OffloadRuleProperties ruleProperties : resp.getRulePropsList()) {
            this.addOffloadRuleProps(ruleProperties, terse, out);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
    }

    public CLDBProto.OffloadRuleListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.OffloadRuleListRequest req = (CLDBProto.OffloadRuleListRequest)request;
        byte[] replyData = null;
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                throw new CLIProcessingException("Invalid cluster: " + cluster);
            }
            try {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleListProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleListResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
        }
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleListProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.OffloadRuleListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into OffloadRuleListResponse proto object.", (Throwable)ipbe);
            }
        }
        throw new CLIProcessingException("Failed to get list of rules for this cluster");
    }

    static enum OffloadRulePropertiesField {
        id,
        n,
        exp;

    }
}

