/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.SetupJobLogLinks;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Logger;

public class JobCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(JobCommands.class);
    private static ExecutorService es = Executors.newFixedThreadPool(10);
    static final String JOBID_PARAM = "jobid";
    private static final String TAID_PARAM = "taskattemptid";
    private static final String JOB_PRIORITY_PARAM = "priority";
    static final String JOB_LOGVIEWROOT_PARAM = "todir";
    static final String JOB_CONF_PARAM = "jobconf";
    static final String MR2_PARAM = "mr2";
    private static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static final CLICommand killJobCmd = new CLICommand("kill", "kill a running mapreduce job", JobCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"jobid", (Object)new TextInputParameter("jobid", "job id", true, null)).put((Object)"mr2", (Object)new NoValueInputParameter("mr2", "Specify this if the job is running on Yarn/MR2", false, false)).build(), null);
    static final CLICommand modifyJobCmd = new CLICommand("changepriority", "change priority of a running mapreduce job", JobCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"jobid", (Object)new TextInputParameter("jobid", "job id", true, null)).put((Object)"priority", (Object)new TextInputParameter("priority", "priority NORMAL|LOW|VERY_LOW|HIGH|VERY_HIGH", true, null)).build(), null);
    static final CLICommand setupLogLinksJobCmd = new CLICommand("linklogs", "Creates symbolic links to all task log locations of jobs matching <jobPattern>", SetupJobLogLinks.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"jobid", (Object)new TextInputParameter("jobid", "job id", true, null)).put((Object)"todir", (Object)new TextInputParameter("todir", "job log view root directory", true, null)).put((Object)"jobconf", (Object)new TextInputParameter("jobconf", "path to job configuration (job.xml)", false, null)).build(), null);
    static final CLICommand killTaCmd = new CLICommand("killattempt", "kill a mapreduce task attempt", JobCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"taskattemptid", (Object)new TextInputParameter("taskattemptid", "task-attempt id", true, null)).build(), null);
    static final CLICommand failTaCmd = new CLICommand("failattempt", "fail a mapreduce task attempt", JobCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"taskattemptid", (Object)new TextInputParameter("taskattemptid", "task-attempt id", true, null)).build(), null);
    static final CLICommand statusJobCmd = new CLICommand("status", "get the status of a running mapreduce job", JobCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"jobid", (Object)new TextInputParameter("jobid", "job id", true, null)).build(), null);
    public static final CLICommand taskCmds = new CLICommand("task", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{killTaCmd, failTaCmd}).setShortUsage("task [killattempt|failattempt]");
    public static final CLICommand jobCmds = new CLICommand("job", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{killJobCmd, modifyJobCmd, setupLogLinksJobCmd, statusJobCmd}).setShortUsage("job [kill|changepriority|linklogs|status]");

    public JobCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private JobClient getJobClient(CommandOutput.OutputHierarchy out) {
        String zkConnectString = this.getZkConnectString();
        if (zkConnectString == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get a valid Zookeeper Connect string"));
            return null;
        }
        try {
            JobClient jc = this.getJobClient(zkConnectString);
            if (jc == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to jobtracker"));
                return null;
            }
            if (jc.getConf() == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get Jobclient configuration"));
                return null;
            }
            return jc;
        }
        catch (RemoteException re) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, this.getCauseFromExceptionMessage((Exception)((Object)re))));
            return null;
        }
    }

    private String getZkConnectString() {
        String zkConnectString;
        try {
            if (this.isParamPresent("zkconnect")) {
                zkConnectString = this.getParamTextValue("zkconnect", 0);
            } else if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect(cluster);
            } else {
                zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
            }
        }
        catch (CLIProcessingException e) {
            return null;
        }
        return zkConnectString;
    }

    private RunningJob getRunningJob(CommandOutput.OutputHierarchy out, final String jobid) {
        final JobClient jc = this.getJobClient(out);
        if (jc == null) {
            return null;
        }
        try {
            RunningJob rj = (RunningJob)this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RunningJob>(){

                @Override
                public RunningJob run() throws Exception {
                    RunningJob rj = jc.getJob(JobID.forName((String)jobid));
                    return rj;
                }
            });
            return rj;
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get Job information for " + jobid + ", Error: " + this.getCauseFromExceptionMessage(e)));
            return null;
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String cmd;
        final CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        if ((cmd = this.cliCommand.getCommandName()).equalsIgnoreCase("kill")) {
            String jobid = this.getParamTextValue(JOBID_PARAM, 0);
            if (jobid == null || jobid.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Job Id"));
                return output;
            }
            if (this.isParamPresent(MR2_PARAM)) {
                String appIdStr = jobid.startsWith("application") ? jobid : jobid.replaceFirst("job", "application");
                try {
                    final ApplicationId appid = ConverterUtils.toApplicationId((String)appIdStr);
                    this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            String zkConnectString = JobCommands.this.getZkConnectString();
                            if (zkConnectString != null) {
                                YarnClient yc = MapRCliUtil.getYarnClient(zkConnectString);
                                yc.killApplication(appid);
                            } else {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get a valid Zookeeper Connect string"));
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to kill Application with app id: " + appIdStr + ", Error: " + e.getMessage()));
                }
            } else {
                final RunningJob rj = this.getRunningJob(out, jobid);
                if (rj != null) {
                    try {
                        this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                rj.killJob();
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get kill job: " + jobid + ", Error: " + this.getCauseFromExceptionMessage(e)));
                    }
                }
            }
        } else if (cmd.equalsIgnoreCase("changepriority")) {
            String jobid = this.getParamTextValue(JOBID_PARAM, 0);
            if (jobid == null || jobid.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Job Id"));
                return output;
            }
            final String priority = this.getParamTextValue(JOB_PRIORITY_PARAM, 0);
            if (priority == null || priority.trim().isEmpty() || JobPriority.valueOf((String)priority) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid priority"));
                return output;
            }
            final RunningJob rj = this.getRunningJob(out, jobid);
            if (rj != null) {
                try {
                    this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            rj.setJobPriority(priority);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to change priority for job: " + jobid + ", Error: " + this.getCauseFromExceptionMessage(e)));
                }
            }
        } else if (cmd.equalsIgnoreCase("killattempt")) {
            final String taid = this.getParamTextValue(TAID_PARAM, 0);
            if (taid == null || taid.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Task Attempt Id"));
                return output;
            }
            final JobClient jc = this.getJobClient(out);
            if (jc != null) {
                try {
                    this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            TaskAttemptID taidObj = TaskAttemptID.forName((String)taid);
                            RunningJob rj = jc.getJob(taidObj.getJobID());
                            if (rj != null) {
                                rj.killTask(taidObj, false);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to kill task: " + taid + ", Error: " + this.getCauseFromExceptionMessage(e)));
                }
            }
        } else if (cmd.equalsIgnoreCase("failattempt")) {
            String jobid = this.getParamTextValue(JOBID_PARAM, 0);
            if (jobid == null || jobid.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Job Id"));
                return output;
            }
            final String taid = this.getParamTextValue(TAID_PARAM, 0);
            if (taid == null || taid.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Task Attempt Id"));
                return output;
            }
            final JobClient jc = this.getJobClient(out);
            if (jc != null) {
                try {
                    this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            TaskAttemptID taidObj = TaskAttemptID.forName((String)taid);
                            RunningJob rj = jc.getJob(taidObj.getJobID());
                            if (rj != null) {
                                rj.killTask(taidObj, true);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to fail task: " + taid + ", Error: " + this.getCauseFromExceptionMessage(e)));
                }
            }
        } else if (cmd.equalsIgnoreCase("status")) {
            String jobid = this.getParamTextValue(JOBID_PARAM, 0);
            if (jobid == null || jobid.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Job Id"));
                return output;
            }
            RunningJob rj = this.getRunningJob(out, jobid);
            try {
                if (rj != null && rj.getJobStatus() != null) {
                    CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode("Map Progress", (Object)Float.valueOf(rj.getJobStatus().mapProgress())));
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode("Reduce Progress", (Object)Float.valueOf(rj.getJobStatus().reduceProgress())));
                    out.addNode(node);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Error while getting the job status for job: " + jobid));
                throw new CLIProcessingException("Error while getting the job status for job: " + jobid);
            }
        }
        return output;
    }

    public JobClient getJobClient(final String zkConnectString) throws RemoteException {
        if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
            return null;
        }
        Callable<JobClient> jtStatisCallable = new Callable<JobClient>(){

            @Override
            public JobClient call() throws Exception {
                InetSocketAddress addr = null;
                Common.ServiceData hostInfo = NodesCommonUtils.getServiceMasterData(zkConnectString, ServicesEnum.jobtracker.name());
                if (hostInfo != null && hostInfo.hasIsRunning() && hostInfo.getIsRunning() && hostInfo.hasHost() && hostInfo.hasPort()) {
                    try {
                        addr = new InetSocketAddress(hostInfo.getHost(), hostInfo.getPort());
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.error((Object)("JT Info is not valid: " + hostInfo.getHost() + hostInfo.getPort()));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"getJobClient jt found");
                }
                if (addr == null) {
                    return null;
                }
                final InetSocketAddress jtAddr = addr;
                final Configuration conf = new Configuration();
                conf.setInt("ipc.client.connect.max.retries", 2);
                return (JobClient)JobCommands.this.getProxyUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobClient>(){

                    @Override
                    public JobClient run() throws Exception {
                        JobClient jc = new JobClient(jtAddr, conf);
                        jc.setConf(conf);
                        return jc;
                    }
                });
            }
        };
        ArrayList<7> callableList = new ArrayList<7>();
        callableList.add(jtStatisCallable);
        try {
            JobClient jc = (JobClient)es.invokeAny(callableList, 6000L, TimeUnit.MILLISECONDS);
            return jc;
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException during JT Status thread execution");
            return null;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                LOG.fatal((Object)"OutOfMemory Error. Application needs to be restarted", (Throwable)e);
                System.exit(1);
            }
            LOG.error((Object)"ExecutionException during JT Status thread execution", (Throwable)e);
            if (e.getCause() instanceof RemoteException) {
                throw (RemoteException)e.getCause();
            }
            return null;
        }
        catch (TimeoutException e) {
            LOG.error((Object)"TimeoutException during JT Status thread execution", (Throwable)e);
            return null;
        }
    }

    private UserGroupInformation getProxyUser() throws IOException {
        UserGroupInformation currUser = UserGroupInformation.getLoginUser();
        if (currUser.getUserName().equals(this.getUserLoginId())) {
            return currUser;
        }
        return UserGroupInformation.createProxyUser((String)this.getUserLoginId(), (UserGroupInformation)currUser);
    }

    private String getCauseFromExceptionMessage(Exception e) {
        String error = e.getMessage();
        if (error == null) {
            return "";
        }
        if (error.contains("\n")) {
            error = error.split("\n")[0];
        }
        if (error.contains(":")) {
            error = error.split(":")[1];
        }
        LOG.error((Object)e.getMessage());
        return error;
    }
}

