/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DumpCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbreplicator;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FidCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String FID_COMMAND_FID_PARAM_NAME = "fid";
    private static final String FID_COMMAND_HOST_PARAM_NAME = "host";
    private static final String FID_COMMAND_PORT_PARAM_NAME = "port";
    private static final String FID_COMMAND_TABLE_PARAM_NAME = "path";
    private static final String FID_COMMAND_CID_PARAM_NAME = "cid";
    private static final String FID_COMMAND_FTYPE_PARAM_NAME = "ftype";
    private static final String FID_COMMAND_DUMPFULLKEYS_PARAM_NAME = "dumpfullkeys";
    private static final String FID_COMMAND_KEYIDXVERSION_PARAM_NAME = "keyidxversion";
    private static final String FID_COMMAND_FID_PARAM_DESC = "fid";
    private static final String FID_COMMAND_HOST_PARAM_DESC = "IP/hostname";
    private static final String FID_COMMAND_PORT_PARAM_DESC = "port";
    private static final String FID_COMMAND_TABLE_PARAM_DESC = "table path";
    private static final String FID_COMMAND_CID_PARAM_DESC = "container id";
    private static final String FID_COMMAND_FTYPE_PARAM_DESC = "table|tabletmap|tablet|segmap|spillmap";
    private static final String FID_COMMAND_DUMPFULLKEYS_PARAM_DESC = "dump full keys <true|false>";
    private static final String FID_COMMAND_KEYIDXVERSION_PARAM_DESC = "key index version";
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMN_SEP = ":";
    private static final Logger LOG = Logger.getLogger(DumpCommands.class);
    private static Pattern printableStringName = Pattern.compile("\\p{Print}+");
    static String statUsage = "stat -fid fidx";
    static String dumpUsage = "dump -fid fid";
    private static final int DefaultGatewayPort = 7660;
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand dump = new CLICommand("dump", "Usage : " + dumpUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(dumpUsage);
    static final CLICommand blocks = new CLICommand("blocks", "Usage : " + dumpUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(dumpUsage);
    static final CLICommand stat = new CLICommand("stat", "usage : " + statUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(statUsage);
    String clusterName = null;

    public FidCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (!super.validateInput()) {
            return this.output;
        }
        this.clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase("dump")) {
                return this.dump();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("stat")) {
                return this.stat();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("blocks")) {
                return this.blocks();
            }
            return new TextCommandOutput("Fid unknown sub-command".getBytes());
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private Common.FidMsg stringToFid(String s) {
        String[] temp = s.split("\\.");
        if (temp.length != 3) {
            return null;
        }
        int cid = Integer.parseInt(temp[0]);
        int cinum = Integer.parseInt(temp[1]);
        int uniq = Integer.parseInt(temp[2]);
        return Common.FidMsg.newBuilder().setCid(cid).setCinum(cinum).setUniq(uniq).build();
    }

    private CommandOutput getDumpFromFid(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        KVFormatType ftype = KVFormatType.INVALID;
        if (this.isParamPresent(FID_COMMAND_FTYPE_PARAM_NAME)) {
            String ftypestr = this.getParamTextValue(FID_COMMAND_FTYPE_PARAM_NAME, 0);
            if (ftypestr.equalsIgnoreCase("table")) {
                ftype = KVFormatType.TABLE;
            } else if (ftypestr.equalsIgnoreCase("tabletmap")) {
                ftype = KVFormatType.TABLET_MAP;
            } else if (ftypestr.equalsIgnoreCase("tablet")) {
                ftype = KVFormatType.TABLET;
            } else if (ftypestr.equalsIgnoreCase("segmap")) {
                ftype = KVFormatType.SEGMENT_MAP;
            } else if (ftypestr.equalsIgnoreCase("spillmap")) {
                ftype = KVFormatType.SPILL_MAP;
            } else if (ftypestr.equalsIgnoreCase("dir")) {
                ftype = KVFormatType.DIR;
            } else if (ftypestr.equalsIgnoreCase("defermap")) {
                ftype = KVFormatType.DEFER_MAP;
            }
            if (ftype == KVFormatType.INVALID) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ftype " + ftypestr));
                this.output.setOutput(out);
                return this.output;
            }
        } else {
            Fileserver.GetattrResponse resp;
            long dbinding = this.getBindingForContainer(fid.getCid());
            if (dbinding == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
                return this.output;
            }
            Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                    return this.output;
                }
                resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString(resp.getStatus())));
                    return this.output;
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing stat command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return this.output;
            }
            Common.FileType itype = resp.getAttr().getType();
            Common.FileSubType subtype = resp.getAttr().getSubtype();
            if (itype == Common.FileType.FTDirectory) {
                ftype = KVFormatType.DIR;
            } else if (itype == Common.FileType.FTRegular) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype + " subtype " + subtype));
            } else if (itype == Common.FileType.FTKvstore) {
                ftype = subtype == Common.FileSubType.FSTKvTable ? KVFormatType.TABLE : (subtype == Common.FileSubType.FSTKvTabletMap ? KVFormatType.TABLET_MAP : (subtype == Common.FileSubType.FSTKvSchema ? KVFormatType.SCHEMA_INFO : (subtype == Common.FileSubType.FSTKvTablet ? KVFormatType.TABLET : (subtype == Common.FileSubType.FSTKvSegMap ? KVFormatType.SEGMENT_MAP : (subtype == Common.FileSubType.FSTKvSpillMap ? KVFormatType.SPILL_MAP : (fid.getCinum() == 22 ? KVFormatType.DEFER_MAP : KVFormatType.GENERIC_KV))))));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype));
                return this.output;
            }
        }
        Fileserver.KvStoreKey kstart = null;
        Fileserver.KvStoreKey kend = null;
        int maxkeys = 0;
        boolean idxoffset = false;
        boolean idxsize = false;
        if (ftype == KVFormatType.DIR) {
            this.dumpDir(fid, out);
        } else {
            this.dumpKeyValues(fid, ftype, kstart, kend, maxkeys, out);
        }
        return this.output;
    }

    private CommandOutput blocks() throws CLIProcessingException {
        long dbinding;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        long offset = 0L;
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((dbinding = this.getBindingForContainer(fid.getCid())) == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        while (true) {
            LOG.error((Object)("Scan file clusters from offset " + offset));
            Fileserver.ScanFileClustersRequest req = Fileserver.ScanFileClustersRequest.newBuilder().setFid(fid).setForOffload(true).setOffset(offset).setCreds(this.getUserCredentials()).build();
            Fileserver.ScanFileClustersResponse resp = null;
            try {
                byte[] replyData = null;
                replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.FileClusterScanProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "FileClusterScanProc rpc failed"));
                    return output;
                }
                resp = Fileserver.ScanFileClustersResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "FileClusterScanProc failed, Error : " + Errno.toString(resp.getStatus())));
                    return output;
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing blocks command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return output;
            }
            long last = 0L;
            if (resp.getOwnedBlocksCount() == 0) break;
            for (Fileserver.OwnedBlocks blks : resp.getOwnedBlocksList()) {
                CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", blks.getOffset()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", blks.getLen()));
                out.addNode(dout);
                last = blks.getOffset() + (long)blks.getLen();
            }
            if (!resp.getHasMore()) break;
            offset = last + 65536L;
        }
        return output;
    }

    private CommandOutput dump() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        this.getDumpFromFid(fid, out);
        return output;
    }

    private CommandOutput stat() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                return output;
            }
            Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)resp.getAttr().getType().toString()));
                String subtype = this.printableSubType(resp.getAttr().getType(), resp.getAttr().getSubtype());
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("subtype", (Object)subtype));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("parent", (Object)this.printableFid(resp.getAttr().getParent())));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", resp.getAttr().getSize()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nblocks", resp.getAttr().getNblocks()));
                String cs = "off";
                if (resp.getAttr().getCanCompress()) {
                    cs = this.getCompressionType(Common.FileCompressionType.valueOf((int)resp.getAttr().getCompressorType()));
                }
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compression", (Object)cs));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteFlags", (Object)resp.getAttr().getDeleteFlags()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("atime", resp.getAttr().getAtime().getSec()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", resp.getAttr().getMtime().getSec()));
                int mode = resp.getAttr().getMode();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)Integer.toOctalString(mode)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uid", resp.getAttr().getUid()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("gid", resp.getAttr().getGid()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nlink", resp.getAttr().getNlink()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrInum", resp.getAttr().getXattrInum()));
                if (resp.getAttr().hasVersion()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", resp.getAttr().getVersion()));
                }
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("networkencryption", (Object)resp.getAttr().getWireSecurityEnabled()));
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString(resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing stat command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput getHostNames() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String ipStr = this.getParamTextValue(FID_COMMAND_HOST_PARAM_NAME, 0);
        Common.IPAddress gatewayIp = this.buildIPFromString(ipStr);
        if (gatewayIp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid gateway host " + ipStr));
            output.setOutput(out);
            return output;
        }
        int gatewayPort = this.getParamIntValue("port", 0);
        long dbinding = this.getBindingForGateway(gatewayIp.getHost(), gatewayPort);
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Gateway connect failed"));
            return output;
        }
        Dbreplicator.GetHostNamesRequest req = Dbreplicator.GetHostNamesRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBReplicatorServerProgramId.getNumber(), (int)Dbreplicator.DBReplicatorProg.GetHostNamesProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "gethostnames rpc failed"));
                return output;
            }
            Dbreplicator.GetHostNamesResponse resp = Dbreplicator.GetHostNamesResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                for (String name : resp.getNamesList()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("HostNames", (Object)name));
                }
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetHostNames failed, Error : " + Errno.toString(resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing getHostNames command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private long getBindingForContainer(int cid) throws CLIProcessingException {
        int dbPort;
        int dbHost;
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return -1L;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                LOG.error((Object)("Container lookup failed : Error " + Errno.toString(resp.getStatus())));
                return -1L;
            }
            Common.Server server = resp.getContainers(0).getMServer();
            dbHost = server.getIps(0).getHost();
            dbPort = server.getIps(0).getPort();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            return -1L;
        }
        return Rpc.createBindingFor((int)dbHost, (int)dbPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private ByteString binaryKeyToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary(raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    private ByteString prepareVarKey(String raws) {
        return this.binaryKeyToByteString(raws);
    }

    private CommandOutput.OutputHierarchy.OutputNode formatDirEntry(MapRFileStatus d) {
        String childFid = d.getCid() + "." + d.getCinum() + "." + d.getUniq();
        String s = d.getPath().toString();
        int l = s.lastIndexOf(47);
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)s.substring(l + 1)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)childFid));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDir", (Object)(d.isDir() ? "true" : "false")));
        return dout;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKeyMapEntry(Dbserver.KeyMapEntry ent) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        Object bs = null;
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("shared", ent.getSharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nonshared", ent.getNonsharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", ent.getValueLen()));
        if (ent.hasBlkOff()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblockoffset", ent.getBlkOff()));
        }
        if (ent.hasBlkSize()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblocksize", ent.getBlkSize()));
        }
        if (!ent.hasBlkOff() && !ent.hasBlkSize()) {
            try {
                Dbserver.SpillKeyEntry spillVal = ent.hasKvalue() ? ent.getKvalue() : Dbserver.SpillKeyEntry.parseFrom((ByteString)ent.getValue());
                if (spillVal.hasInlineValue()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValue", (Object)this.printableKey(spillVal.getInlineValue().toByteArray())));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValueSz", spillVal.getInlineValue().size()));
                }
                int cnt = spillVal.getValuesCount();
                for (int index = 0; index < cnt; ++index) {
                    CommandOutput.OutputHierarchy.OutputNode valueout = new CommandOutput.OutputHierarchy.OutputNode("familyData");
                    boolean addFamily = false;
                    Dbserver.SpillKeyEntry.FamilyValue fv = spillVal.getValues(index);
                    if (fv.hasId()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fv.getId()));
                        addFamily = true;
                    }
                    if (fv.hasOffset()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fv.getOffset()));
                        addFamily = true;
                    }
                    if (fv.hasLength()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fv.getLength()));
                        addFamily = true;
                    }
                    if (fv.hasInlined()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlined", (Object)fv.getInlined()));
                        addFamily = true;
                    }
                    if (!addFamily) continue;
                    dout.addChild(valueout);
                }
            }
            catch (Throwable e) {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("error", (Object)"PARSE ERROR"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(ent.getKey().toByteArray())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)this.printableKey(ent.getValue().toByteArray())));
        return dout;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKV(KVFormatType type, Fileserver.KvMsg kv) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        String ks = null;
        switch (type) {
            case TABLE: 
            case SCHEMA_INFO: 
            case TABLET: 
            case SEGMENT_MAP: 
            case TABLET_MAP: 
            case DEFER_MAP: 
            case GENERIC_KV: {
                ByteString bs = kv.getKey().getVarKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(bs.toByteArray())));
                ks = bs.toStringUtf8();
                break;
            }
            case SPILL_MAP: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", kv.getKey().getIntKey()));
                break;
            }
            default: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)"UNKNOWN"));
            }
        }
        CommandOutput.OutputHierarchy.OutputNode vout = new CommandOutput.OutputHierarchy.OutputNode();
        switch (type) {
            case TABLE: {
                try {
                    Common.FidMsg f = Common.FidMsg.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SCHEMA_INFO: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getColFamilyIdPrefix())) {
                        Dbserver.SchemaFamily sf = Dbserver.SchemaFamily.parseFrom((ByteString)kv.getValue());
                        if (sf.hasName()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)sf.getName()));
                            break;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)"NONE"));
                        break;
                    }
                    if (ks.equals(dbi.getAttr())) {
                        Dbserver.TableAttr attr = Dbserver.TableAttr.parseFrom((ByteString)kv.getValue());
                        if (attr.hasAutoSplit()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:autoSplit", (Object)attr.getAutoSplit()));
                        }
                        if (attr.hasBulkLoad()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:bulkLoad", (Object)attr.getBulkLoad()));
                        }
                        if (attr.hasDeleteTTL()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:deleteTTL", attr.getDeleteTTL()));
                        }
                        if (attr.hasSyncReplTimeoutMillis()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:syncReplTimeoutMillis", attr.getSyncReplTimeoutMillis()));
                        }
                        if (attr.hasRegionSizeMB()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:regionSizeMB", attr.getRegionSizeMB()));
                        }
                        if (attr.hasMaxValueSzInMemIndex()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:maxValueSzInMemIndex", attr.getMaxValueSzInMemIndex()));
                        }
                        if (attr.hasReclaimThreshPcntForPack()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:reclaimThreshPcntForPack", attr.getReclaimThreshPcntForPack()));
                        }
                        if (attr.hasIsMarlinTable()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:isMarlinTable", (Object)attr.getIsMarlinTable()));
                        }
                        if (!attr.hasMarlinAttr()) break;
                        Marlincommon.MarlinTableAttr mtAttr = attr.getMarlinAttr();
                        if (mtAttr.hasAutoCreateTopics()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinAttr:autoCreateTopics", (Object)mtAttr.getAutoCreateTopics()));
                        }
                        if (!mtAttr.hasDefaultNumFeedsPerTopic()) break;
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinAttr:defaultNumFeedsPerTopic", mtAttr.getDefaultNumFeedsPerTopic()));
                        break;
                    }
                    if (ks.startsWith(dbi.getReplIdxPrefix())) {
                        Dbserver.TableReplicaDesc rd = Dbserver.TableReplicaDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("table", (Object)rd.getTablePath()));
                        byte[] uuid = rd.getTableUuid().toByteArray();
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString(uuid)));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("paused", (Object)rd.getIsPaused()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("synchronous", (Object)rd.getSynchronous()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                        if (rd.getQualifiersCount() <= 0) break;
                        String famList = "";
                        int idx = 0;
                        for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                            if (qual.getQualifiersCount() > 0) {
                                for (ByteString bstr : qual.getQualifiersList()) {
                                    famList = idx == 0 ? qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8() : famList + MULTI_ARG_SEP + qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8();
                                    ++idx;
                                }
                                continue;
                            }
                            if (idx == 0) {
                                famList = String.valueOf(qual.getFamily());
                                ++idx;
                                continue;
                            }
                            famList = famList + MULTI_ARG_SEP + qual.getFamily();
                            ++idx;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("columnfamilies", (Object)famList));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForPMap())) {
                        CommandOutput.OutputHierarchy.OutputNode buckets;
                        Dbserver.PartitionMapEntry p = Dbserver.PartitionMapEntry.parseFrom((ByteString)kv.getValue());
                        if (p.hasSegmapFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)this.printableFid(p.getSegmapFid())));
                        } else {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)"NONE"));
                        }
                        if (p.getBucketFidsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketfids");
                            vout.addChild(buckets);
                            for (Common.FidMsg f : p.getBucketFidsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isFrozen", (Object)p.getIsFrozen()));
                        if (p.getCidVNEntriesList().size() > 0) {
                            CommandOutput.OutputHierarchy.OutputNode cidVNs = new CommandOutput.OutputHierarchy.OutputNode("CidVNs");
                            vout.addChild(cidVNs);
                            for (Dbserver.CidVNEntry ce : p.getCidVNEntriesList()) {
                                cidVNs.addChild(new CommandOutput.OutputHierarchy.OutputNode("cid-minVN", (Object)(ce.getCid() + "-" + ce.getMinVN())));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inSplit", (Object)p.getInSplit()));
                        if (p.hasInImportBucket()) {
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inImportBucket", (Object)p.getInImportBucket()));
                        }
                        if (p.getBucketDescsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketdescs");
                            vout.addChild(buckets);
                            for (Dbserver.PartitionMapEntry.BucketDesc bd : p.getBucketDescsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(bd.getFid())));
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("needsRepl", (Object)bd.getNeedsRepl()));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("useBucketDesc", (Object)p.getUseBucketDesc()));
                        if (p.hasLastFlushedBucketFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastFlushedBucketFid", (Object)this.printableFid(p.getLastFlushedBucketFid())));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", p.getUsage().getNumLogicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", p.getUsage().getNumPhysicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", p.getUsage().getNumRows()));
                        if (p.getUsage().hasNumRowsWithDelete()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", p.getUsage().getNumRowsWithDelete()));
                        }
                        if (p.getUsage().hasNumRemoteBlocks()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRemoteBlocks", p.getUsage().getNumRemoteBlocks()));
                        }
                        if (p.getUsage().hasNumSpills()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSpills", p.getUsage().getNumSpills()));
                        }
                        if (p.getUsage().hasNumSegments()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSegments", p.getUsage().getNumSegments()));
                        }
                        if (p.getUsage().hasTimeRange()) {
                            Dbserver.TimeRange ts = p.getUsage().getTimeRange();
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", ts.getMinTS()));
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", ts.getMaxTS()));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinMaxSeq", p.getMarlinMaxSeq()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForSplit())) {
                        Dbserver.SplitDesc sd = Dbserver.SplitDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(sd.getDstFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("moveRightHalf", (Object)sd.getMoveRightHalf()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("endGame", (Object)sd.getEndGame()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForStartKey()) || ks.startsWith(dbi.getTabletKeyForEndKey())) break;
                    if (ks.startsWith(dbi.getTabletKeyForMerge())) {
                        Dbserver.MergeDesc md = Dbserver.MergeDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("peerFid", (Object)this.printableFid(md.getPeerFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDest", (Object)md.getIsDest()));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET_MAP: {
                try {
                    Dbserver.TabletMapEntry t = Dbserver.TabletMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(t.getTabletFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SEGMENT_MAP: {
                try {
                    Dbserver.SegmentMapEntry s = Dbserver.SegmentMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(s.getFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SPILL_MAP: {
                try {
                    Dbserver.SpillMapEntry s = Dbserver.SpillMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(s.getFid())));
                    if (s.hasSmeSize()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("smeSize", s.getSmeSize()));
                    }
                    if (s.hasMinVN()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minVN", s.getMinVN()));
                    }
                    if (s.hasMaxMarlinSeq()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxMarlinSeq", s.getMaxMarlinSeq()));
                    }
                    if (s.hasBackingBucketFid()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("backingBucketFid", (Object)this.printableFid(s.getBackingBucketFid())));
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxOffset", s.getKeyIdxOffset()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxLength", s.getKeyIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ldbIdxLength", s.getLdbIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bloomBitsPerKey", s.getBloomBitsPerKey()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", s.getUsage().getNumLogicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", s.getUsage().getNumPhysicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", s.getUsage().getNumRows()));
                    if (s.getUsage().hasNumRowsWithDelete()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", s.getUsage().getNumRowsWithDelete()));
                    }
                    CommandOutput.OutputHierarchy.OutputNode families = new CommandOutput.OutputHierarchy.OutputNode("families");
                    vout.addChild(families);
                    for (Dbserver.SpillMapEntry.FamilyEntry fe : s.getFamiliesList()) {
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fe.getId()));
                        if (fe.hasOffset()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fe.getOffset()));
                        }
                        if (fe.hasLength()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fe.getLength()));
                        }
                        if (!fe.hasTimeRange()) continue;
                        Dbserver.TimeRange tr = fe.getTimeRange();
                        if (tr.hasMinTS()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", tr.getMinTS()));
                        }
                        if (!tr.hasMaxTS()) continue;
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", tr.getMaxTS()));
                    }
                    break;
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyfid", (Object)"UNKNOWN"));
                    break;
                }
            }
            case DEFER_MAP: {
                try {
                    if (ks.startsWith("b")) {
                        Dbserver.ReplBucketDesc b = Dbserver.ReplBucketDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketFid", (Object)this.printableFid(b.getBucketFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableFid", (Object)this.printableFid(b.getTableFid())));
                        if (b.getSendAfterList().size() != 0) {
                            CommandOutput.OutputHierarchy.OutputNode sendAfter = new CommandOutput.OutputHierarchy.OutputNode("sendAfter");
                            vout.addChild(sendAfter);
                            for (Common.FidMsg f : b.getSendAfterList()) {
                                sendAfter.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                            }
                        }
                        if (b.getSendBeforeList().size() != 0) {
                            CommandOutput.OutputHierarchy.OutputNode sendBefore = new CommandOutput.OutputHierarchy.OutputNode("sendBefore");
                            vout.addChild(sendBefore);
                            for (Common.FidMsg f : b.getSendBeforeList()) {
                                sendBefore.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("flushed", (Object)b.getFlushed()));
                        CommandOutput.OutputHierarchy.OutputNode replicas = new CommandOutput.OutputHierarchy.OutputNode("replicas");
                        vout.addChild(replicas);
                        for (Dbserver.ReplBucketDesc.ReplicaInfo rs : b.getReplList()) {
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicaIdx", rs.getReplicaIdx()));
                            if (rs.hasDoneTillOffset()) {
                                replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("doneTillOffset", rs.getDoneTillOffset()));
                            }
                            if (!rs.hasDone()) continue;
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("done", (Object)rs.getDone()));
                        }
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            default: {
                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)vout));
        return dout;
    }

    private void dumpDir(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileStatus[] dirents;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            dirents = fs.scanDir(this.clusterName, "/.mapr::fid::" + this.printableFid(fid));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanDir failed"));
            return;
        }
        if (dirents == null) {
            return;
        }
        for (int i = 0; i < dirents.length; ++i) {
            out.addNode(this.formatDirEntry(dirents[i]));
        }
    }

    private void dumpRegKeyMap(Common.FidMsg fid, Integer idxoffset, Integer idxsize, boolean dumpFullKeys, int fmtVersion, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long dbinding = this.getBindingForContainer(fid.getCid());
        Dbserver.KeyMapCookie cookie = null;
        LOG.info((Object)("Getting regular key-map with idxsize " + idxsize + " dumpFullKeys " + dumpFullKeys + " keyIdxVersion " + fmtVersion));
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return;
        }
        while (true) {
            Dbserver.TestScanResponse resp;
            Dbserver.TestScanRequest req = cookie == null ? Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build() : Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setKmapCookie(cookie).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.TestScanProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "testscan rpc failed"));
                    return;
                }
                resp = Dbserver.TestScanResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "TestScan failed, Error : " + Errno.toString(resp.getStatus())));
                    return;
                }
                for (Dbserver.KeyMapEntry kment : resp.getKmapentriesList()) {
                    out.addNode(this.formatKeyMapEntry(kment));
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing testscan command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return;
            }
            if (!resp.getHasMoreKeys()) break;
            LOG.info((Object)("Setting cookie as " + resp.getKmapCookie().getOffset()));
            cookie = resp.getKmapCookie();
        }
        LOG.info((Object)"Done with scan");
    }

    private void dumpKeyValues(Common.FidMsg fid, KVFormatType type, Fileserver.KvStoreKey start, Fileserver.KvStoreKey end, int maxkeys, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] byteArr;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            byte[] kstart = null;
            if (start != null) {
                kstart = start.toByteArray();
            }
            byte[] kend = null;
            if (end != null) {
                kend = end.toByteArray();
            }
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(fid), kstart, kend, maxkeys);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed"));
            return;
        }
        if (byteArr == null) {
            return;
        }
        try {
            Fileserver.KvList kvlist = Fileserver.KvList.parseFrom((byte[])byteArr);
            for (Fileserver.KvMsg kvp : kvlist.getEntriesList()) {
                out.addNode(this.formatKV(type, kvp));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "failed to parse key-value list"));
            return;
        }
    }

    private String printableFid(Common.FidMsg f) {
        String cidStr = f.getCid() == -1 ? "<parentCID>." : f.getCid() + ".";
        return cidStr + f.getCinum() + "." + f.getUniq();
    }

    private String printableSubType(Common.FileType type, Common.FileSubType subtype) {
        String stype = subtype.toString();
        if (type == Common.FileType.FTKvstore) {
            if (subtype == Common.FileSubType.FSTKvTable) {
                stype = "FSTKvTable";
            } else if (subtype == Common.FileSubType.FSTKvTabletMap) {
                stype = "FSTKvTabletMap";
            } else if (subtype == Common.FileSubType.FSTKvSchema) {
                stype = "FSTKvSchema";
            } else if (subtype == Common.FileSubType.FSTKvTablet) {
                stype = "FSTKvTablet";
            } else if (subtype == Common.FileSubType.FSTKvSegMap) {
                stype = "FSTKvSegMap";
            } else if (subtype == Common.FileSubType.FSTKvSpillMap) {
                stype = "FSTKvSpillMap";
            } else if (subtype == Common.FileSubType.FSTKvKeyMap) {
                stype = "FSTKvKeyMap";
            }
        } else if (type == Common.FileType.FTRegular) {
            if (subtype == Common.FileSubType.FSTRegBucket) {
                stype = "FSTRegBucket";
            } else if (subtype == Common.FileSubType.FSTRegSortedBucket) {
                stype = "FSTRegSortedBucket";
            } else if (subtype == Common.FileSubType.FSTRegCF) {
                stype = "FSTRegCF";
            } else if (subtype == Common.FileSubType.FSTRegSpill) {
                stype = "FSTRegSpill";
            }
        }
        return stype;
    }

    private String printableKey(byte[] bytes) {
        return BinaryString.toStringBinary(bytes);
    }

    private String bytesToString(ByteString bs) {
        return BinaryString.toStringBinary(bs.toByteArray());
    }

    private long getBindingForGateway(int gIp, int gPort) throws CLIProcessingException {
        if (gPort == 0) {
            gPort = 7660;
        }
        return Rpc.createBindingFor((int)gIp, (int)gPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private String getCompressionType(Common.FileCompressionType ct) {
        if (ct == Common.FileCompressionType.FCT_OFF) {
            return "off";
        }
        if (ct == Common.FileCompressionType.FCT_LZ4) {
            return "lz4";
        }
        if (ct == Common.FileCompressionType.FCT_LZF) {
            return "lzf";
        }
        if (ct == Common.FileCompressionType.FCT_ZLIB) {
            return "zlib";
        }
        return "unknown";
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        int host = Util.ipToInt((String)ipstr);
        Common.IPAddress server = Common.IPAddress.newBuilder().setHost(host).build();
        return server;
    }

    public static enum KVFormatType {
        TABLE,
        TABLET_MAP,
        SCHEMA_INFO,
        TABLET,
        SEGMENT_MAP,
        SPILL_MAP,
        DEFER_MAP,
        GENERIC_KV,
        DIR,
        INVALID;

    }
}

