/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.RemoteCommandExecutor;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class DiskCommands
extends ListCommand
implements CLIInterface {
    public static final String HOST_PARAM_NAME = "host";
    public static final String STRIPEWIDTH_PARAM_NAME = "stripeWidth";
    public static final String DISK_PARAM_NAME = "disks";
    public static final String FORCE_PARAM_NAME = "force";
    public static final String SYSTEM_PARAM_NAME = "system";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String INSTALL_DIR = MapRCliUtil.getMapRInstallDir();
    public static final String DISKLIST_SH = INSTALL_DIR + "/server/disklist.sh ";
    public static final String DISKADD_SH = INSTALL_DIR + "/server/diskadd.sh ";
    public static final String DISKREMOVE_SH = INSTALL_DIR + "/server/diskremove ";
    private static final Logger LOG = Logger.getLogger(DiskCommands.class);
    private static final int ERR_CODE_VOLUMES_LOSS = 150;
    private static final int ERR_CODE_METADATA_LOSS = 151;
    private static final int ERR_CODE_GENERIC = 152;
    static final CLICommand listallCmd = new CLICommand("listall", "", DiskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"start", (Object)new IntegerInputParameter("start", "index of the first node (starting from 0)", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "number of nodes to query", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"output", (Object)new TextInputParameter("output", "<terse|verbose>", false, "verbose")).build(), null).setShortUsage("disk listall -cluster <clustername> -start <node index> -limit <number of nodes> -output terse|verbose");
    static final CLICommand listCmd = new CLICommand("list", "", DiskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"host", (Object)new TextInputParameter("host", "name/ip", true, null)).put((Object)"system", (Object)new BooleanInputParameter("system", "1/0", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "<terse|verbose>", false, "verbose")).build(), null).setShortUsage("disk list -host <name/ip> -output terse|verbose");
    static final CLICommand addCmd = new CLICommand("add", "", DiskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"host", (Object)new TextInputParameter("host", "name/ip", true, null)).put((Object)"disks", (Object)new TextInputParameter("disks", "comma-separated list of disks", true, null)).put((Object)"stripeWidth", (Object)new TextInputParameter("stripeWidth", "stripe-width", false, null)).build(), null).setShortUsage("disk add [-stripeWidth <stripe-width>] -host <name/ip> -disks <disks>");
    static final CLICommand removeCmd = new CLICommand("remove", "", DiskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"host", (Object)new TextInputParameter("host", "name/ip", true, null)).put((Object)"disks", (Object)new TextInputParameter("disks", "comma-separated list of disks", true, null)).put((Object)"force", (Object)new BooleanInputParameter("force", "<true|false OR 1|0>. Need this parameter to actually remove the disk, otherwise this command behaves like a test remove", false, Boolean.valueOf(false))).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build(), null).setShortUsage("disk remove [-force <true|false OR 1|0>] -host <name/ip> -disks <disks> -cluster <clustername>");
    public static final CLICommand diskCommands = new CLICommand("disk", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listallCmd, listCmd, addCmd, removeCmd}).setShortUsage("disk [list|listall|add|remove]");
    static String[] DiskEntryFieldLongName = new String[]{"hostname", "diskname", "mount", "vendor", "modelnum", "serialnum", "firmwareversion", "totalspace", "usedspace", "availablespace", "fstype", "powerstatus", "status", "errormsg", "storagepoolid", "failuretime"};
    long columns = -1L;
    DiskEntryField sortField = null;
    boolean asc = true;
    public static Map<DiskEntryField, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)DiskEntryField.hn, (Object)new FieldInfo(DiskEntryField.hn.ordinal(), DiskEntryField.hn.name(), DiskEntryFieldLongName[DiskEntryField.hn.ordinal()], String.class)).put((Object)DiskEntryField.n, (Object)new FieldInfo(DiskEntryField.n.ordinal(), DiskEntryField.n.name(), DiskEntryFieldLongName[DiskEntryField.n.ordinal()], String.class)).put((Object)DiskEntryField.mt, (Object)new FieldInfo(DiskEntryField.mt.ordinal(), DiskEntryField.mt.name(), DiskEntryFieldLongName[DiskEntryField.mt.ordinal()], String.class)).put((Object)DiskEntryField.vn, (Object)new FieldInfo(DiskEntryField.vn.ordinal(), DiskEntryField.vn.name(), DiskEntryFieldLongName[DiskEntryField.vn.ordinal()], String.class)).put((Object)DiskEntryField.mn, (Object)new FieldInfo(DiskEntryField.mn.ordinal(), DiskEntryField.mn.name(), DiskEntryFieldLongName[DiskEntryField.mn.ordinal()], String.class)).put((Object)DiskEntryField.sn, (Object)new FieldInfo(DiskEntryField.sn.ordinal(), DiskEntryField.sn.name(), DiskEntryFieldLongName[DiskEntryField.sn.ordinal()], String.class)).put((Object)DiskEntryField.fw, (Object)new FieldInfo(DiskEntryField.fw.ordinal(), DiskEntryField.fw.name(), DiskEntryFieldLongName[DiskEntryField.fw.ordinal()], String.class)).put((Object)DiskEntryField.dst, (Object)new FieldInfo(DiskEntryField.dst.ordinal(), DiskEntryField.dst.name(), DiskEntryFieldLongName[DiskEntryField.dst.ordinal()], Long.class)).put((Object)DiskEntryField.dsu, (Object)new FieldInfo(DiskEntryField.dsu.ordinal(), DiskEntryField.dsu.name(), DiskEntryFieldLongName[DiskEntryField.dsu.ordinal()], Long.class)).put((Object)DiskEntryField.dsa, (Object)new FieldInfo(DiskEntryField.dsa.ordinal(), DiskEntryField.dsa.name(), DiskEntryFieldLongName[DiskEntryField.dsa.ordinal()], Long.class)).put((Object)DiskEntryField.fs, (Object)new FieldInfo(DiskEntryField.fs.ordinal(), DiskEntryField.fs.name(), DiskEntryFieldLongName[DiskEntryField.fs.ordinal()], String.class)).put((Object)DiskEntryField.pst, (Object)new FieldInfo(DiskEntryField.pst.ordinal(), DiskEntryField.pst.name(), DiskEntryFieldLongName[DiskEntryField.pst.ordinal()], String.class)).put((Object)DiskEntryField.st, (Object)new FieldInfo(DiskEntryField.st.ordinal(), DiskEntryField.st.name(), DiskEntryFieldLongName[DiskEntryField.st.ordinal()], Integer.class)).put((Object)DiskEntryField.err, (Object)new FieldInfo(DiskEntryField.err.ordinal(), DiskEntryField.err.name(), DiskEntryFieldLongName[DiskEntryField.err.ordinal()], String.class)).put((Object)DiskEntryField.ft, (Object)new FieldInfo(DiskEntryField.ft.ordinal(), DiskEntryField.ft.name(), DiskEntryFieldLongName[DiskEntryField.ft.ordinal()], Long.class)).build();

    public DiskCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private boolean isSystemPartition(String fstype, int mount, String totalStr) {
        if (mount == 1) {
            return true;
        }
        try {
            if (!totalStr.startsWith("unknown") && Long.parseLong(totalStr) == 0L) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fstype = fstype.trim().toLowerCase();
        return fstype.contains("swap") || fstype.contains("lvm") || fstype.contains("raid");
    }

    private CommandOutput.OutputHierarchy.OutputNode PrintDiskInfo(String s, DiskPrintOption dp, boolean verbose) {
        try {
            String[] str = s.split("\\s");
            String fstype = str[DiskEntryField.fs.ordinal()];
            int mount = Integer.parseInt(str[DiskEntryField.mt.ordinal()]);
            String totalStr = str[DiskEntryField.dst.ordinal()];
            if (dp == DiskPrintOption.LIST_SYSTEM && !this.isSystemPartition(fstype, mount, totalStr) || dp == DiskPrintOption.LIST_NONSYSTEM && this.isSystemPartition(fstype, mount, totalStr)) {
                return null;
            }
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            DiskEntryField[] arr = DiskEntryField.values();
            for (int i = 0; i < str.length; ++i) {
                if (str[i].startsWith("unknown")) continue;
                if (str[i].startsWith("Run_`smartctl")) {
                    str[i] = str[i].replaceAll("_", " ");
                }
                if ((this.columns & 1L << i) == 0L) continue;
                String columnName = verbose ? DiskEntryFieldLongName[i] : arr[i].toString();
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName, (Object)str[i]));
            }
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void PrintDisksInfo(CommandOutput.OutputHierarchy out, ArrayList<String> ListOfDisks, DiskPrintOption dp) throws CLIProcessingException {
        boolean verbose = true;
        if (this.isParamPresent(OUTPUT_PARAM_NAME) && this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase("terse")) {
            verbose = false;
        }
        for (String s : ListOfDisks) {
            CommandOutput.OutputHierarchy.OutputNode node;
            if ((s = s.trim()).isEmpty() || (node = this.PrintDiskInfo(s, dp, verbose)) == null) continue;
            out.addNode(node);
        }
    }

    void FetchDisksInfo(String host, ArrayList<String> ListOfDisks) throws CLIProcessingException {
        ClusterMetricsProto.ExecuteCommandRequest.Builder requestBuilder = ClusterMetricsProto.ExecuteCommandRequest.newBuilder();
        requestBuilder.setCommandId(ClusterMetricsProto.CommandId.DISK_LIST);
        requestBuilder.setCreds(this.getUserCredentials());
        try {
            for (String s : RemoteCommandExecutor.execute(host, requestBuilder.build())) {
                ListOfDisks.add(host + " " + s);
            }
        }
        catch (CLIProcessingException e) {
            throw new CLIProcessingException("Error trying to reach host \"" + host + "\". Check if hostname is valid and up");
        }
    }

    public static String getHostname(CLDBProto.FileServerInfo fs) {
        if (fs == null) {
            return null;
        }
        try {
            Common.IPAddress ip = fs.getAddress(0);
            if (ip != null) {
                return ip.getHostname();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    void DiskAddRemove(CommandOutput.OutputHierarchy out, boolean add) throws CLIProcessingException {
        ClusterMetricsProto.CommandId commandId;
        String disklist;
        String host = this.getParamTextValue(HOST_PARAM_NAME, 0);
        if (host == null || host.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid host"));
            return;
        }
        String stripeWidth = null;
        if (this.isParamPresent(STRIPEWIDTH_PARAM_NAME)) {
            stripeWidth = this.getParamTextValue(STRIPEWIDTH_PARAM_NAME, 0);
        }
        if ((disklist = this.getParamTextValue(DISK_PARAM_NAME, 0)) == null || disklist.length() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid config"));
            return;
        }
        if (disklist.startsWith("[")) {
            disklist = disklist.substring(1, disklist.length() - 1);
        }
        disklist = disklist.replaceAll("'", "");
        disklist = disklist.replaceAll(",", " ");
        String commandArgs = "";
        if (add) {
            commandId = ClusterMetricsProto.CommandId.DISK_ADD;
            if (stripeWidth != null) {
                commandArgs = " -W " + stripeWidth + " ";
            }
            commandArgs = commandArgs + disklist;
        } else {
            commandId = ClusterMetricsProto.CommandId.DISK_REMOVE;
            StringBuffer options = new StringBuffer();
            if (this.isParamPresent(FORCE_PARAM_NAME) && this.getParamBooleanValue(FORCE_PARAM_NAME, 0)) {
                options.append("-f ");
            }
            CLDBRpcCommonUtils.IpPort ipPort = null;
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                    return;
                }
                ipPort = CLDBRpcCommonUtils.getInstance().getCurrentValidIpPort(cluster);
            } else {
                ipPort = CLDBRpcCommonUtils.getInstance().getCurrentValidIpPort();
            }
            if (ipPort != null) {
                for (String cldbip : ipPort.getAddr()) {
                    if (cldbip.isEmpty()) continue;
                    options.append("-i " + cldbip + " ");
                    options.append("-p " + ipPort.getPort() + " ");
                    break;
                }
            }
            commandArgs = options + disklist;
        }
        ClusterMetricsProto.ExecuteCommandRequest.Builder requestBuilder = ClusterMetricsProto.ExecuteCommandRequest.newBuilder();
        requestBuilder.setCommandId(commandId);
        requestBuilder.setArgs(commandArgs);
        requestBuilder.setCreds(this.getUserCredentials());
        for (String line : RemoteCommandExecutor.execute(host, requestBuilder.build())) {
            String[] words;
            if ((line = line.trim()).isEmpty() || (words = line.split("\\s+")).length < 2) continue;
            String disk = words[0];
            if (words[1].startsWith("added") || words[1].startsWith("removed")) {
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(HOST_PARAM_NAME, (Object)host));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("disk", (Object)disk));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("message", (Object)words[1]));
                out.addNode(node);
                continue;
            }
            int err = 10003;
            String errMsg = null;
            if (words.length > 3 && words[3] != null && !words[3].isEmpty()) {
                words[3] = words[3].replaceAll("[^0-9]+$", "");
                try {
                    err = Integer.parseInt(words[3]);
                }
                catch (Exception e) {
                    err = 10003;
                }
            }
            if (err == 150) {
                int lostVols = 0;
                if (words.length > 4 && words[4] != null && !words[4].isEmpty()) {
                    try {
                        lostVols = Integer.parseInt(words[4]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                errMsg = "Operation may cause loss of data due to under-replication";
                if (lostVols > 0) {
                    errMsg = errMsg + " of " + lostVols + " or more volumes";
                }
            } else {
                errMsg = err == 151 ? "Operation may bring down cluster due to loss of cluster meta-data" : (err == 152 ? words[3] : (err == 2 ? Errno.toString(err) + "\nThe disk was either removed from /opt/mapr/conf/disktab earlier, or is invalid" : Errno.toString(err)));
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err, "Failed operation for disk " + disk + ", " + errMsg));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("listall")) {
            try {
                this.list(out);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
                return output;
            }
        }
        if (cmd.equalsIgnoreCase("list")) {
            String host = this.getParamTextValue(HOST_PARAM_NAME, 0);
            if (host == null || host.isEmpty()) {
                return output;
            }
            ArrayList<String> ListOfDisks = new ArrayList<String>();
            try {
                this.FetchDisksInfo(host, ListOfDisks);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
                return output;
            }
            DiskPrintOption dp = DiskPrintOption.LIST_ALL;
            if (this.isParamPresent(SYSTEM_PARAM_NAME)) {
                dp = this.getParamBooleanValue(SYSTEM_PARAM_NAME, 0) ? DiskPrintOption.LIST_SYSTEM : DiskPrintOption.LIST_NONSYSTEM;
            }
            this.PrintDisksInfo(out, ListOfDisks, dp);
        } else if (cmd.equalsIgnoreCase("add")) {
            try {
                this.DiskAddRemove(out, true);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
            }
        } else if (cmd.equalsIgnoreCase("remove")) {
            try {
                this.DiskAddRemove(out, false);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(38, e.getLocalizedMessage()));
            }
        }
        return output;
    }

    private CLDBProto.FileServerListRequest.Builder getFileServerListRequestBuilder() throws CLIProcessingException {
        return CLDBProto.FileServerListRequest.newBuilder().setCreds(this.getUserCredentials()).setColumns(1L << CLDBProto.NodeInfo.Ip.getNumber()).setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 25));
    }

    public CLDBProto.FileServerListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.FileServerListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.FileServerListRequest.newBuilder((CLDBProto.FileServerListRequest)((CLDBProto.FileServerListRequest)prevReq)) : this.getFileServerListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.FileServerListResponse)prevResp).getInfoCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 25));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.FileServerListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.FileServerListResponse)prevResp).getInfoCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.FileServerListResponse resp = (CLDBProto.FileServerListResponse)response;
        ArrayList<String> ListOfDisks = new ArrayList<String>();
        String prevhost = null;
        for (int i = 0; i < resp.getInfoCount(); ++i) {
            String host = DiskCommands.getHostname(resp.getInfo(i));
            if (host == null || host.isEmpty() || prevhost != null && host.equalsIgnoreCase(prevhost)) continue;
            try {
                this.FetchDisksInfo(host, ListOfDisks);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Exception in FetchDisksInfo " + e));
            }
        }
        this.PrintDisksInfo(out, ListOfDisks, DiskPrintOption.LIST_ALL);
    }

    public CLDBProto.FileServerListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.FileServerListRequest req = (CLDBProto.FileServerListRequest)request;
        byte[] replyData = null;
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                throw new CLIProcessingException("Invalid cluster: " + cluster);
            }
            try {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
        }
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getFileServerListResponse(replyData);
        }
        throw new CLIProcessingException("Failed to get list of servers for this cluster");
    }

    private CLDBProto.FileServerListResponse getFileServerListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.FileServerListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into FileServerListResponse proto object.", (Throwable)ipbe);
        }
    }

    static enum DiskEntryField {
        hn,
        n,
        mt,
        vn,
        mn,
        sn,
        fw,
        dst,
        dsu,
        dsa,
        fs,
        pst,
        st,
        err,
        sp,
        ft;

    }

    static enum DiskPrintOption {
        LIST_SYSTEM,
        LIST_NONSYSTEM,
        LIST_ALL;

    }
}

