/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.cli.DbCfColCommands;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.AceHelper;
import com.mapr.fs.CompressionHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;

public class DbCfCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbCfCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String MIN_VERSIONS_PARAM_NAME = "minversions";
    private static final String MAX_VERSIONS_PARAM_NAME = "maxversions";
    private static final String TTL_PARAM_NAME = "ttl";
    private static final String IN_MEMORY_PARAM_NAME = "inmemory";
    private static final String COMPRESSION_PARAM_NAME = "compression";
    private static final String CFNAME_PARAM_NAME = "cfname";
    private static final String NEWCFNAME_PARAM_NAME = "newcfname";
    private static final String PERM_VERSIONS_PARAM_NAME = "versionperm";
    private static final String PERM_COMPRESSION_PARAM_NAME = "compressionperm";
    private static final String PERM_MEMORY_PARAM_NAME = "memoryperm";
    private static final String PERM_READ_PARAM_NAME = "readperm";
    private static final String PERM_WRITE_PARAM_NAME = "writeperm";
    private static final String PERM_APPEND_PARAM_NAME = "appendperm";
    private static final String PERM_ENCRYPT_PARAM_NAME = "encryptperm";
    private static final String PERM_TRAVERSE_PARAM_NAME = "traverseperm";
    private static final String COLUMN_PERMISSIONS_PARAM_NAME = "columnperm";
    private static final String JSON_FAMILY_PATH = "jsonpath";
    private static final String JSON_FORCE_CF_CREATE = "force";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String SHOW_COLUMNS_NAME = "showcol";
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    private static final CLICommand listCommand = new CLICommand("list", "usage: table cf list -path <tablepath>", DbCfCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).put((Object)"showcol", (Object)new BooleanInputParameter("showcol", "showcol", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("table cf list -path <tablepath>");
    private static final CLICommand createCommand = new CLICommand("create", "usage: table cf create -path <tablepath> -cfname <cfname> -minversions <minversions> -maxversions<maxversions> -ttl <ttl> -inmemory <inmemory> -compression <off|lzf|lz4|zlib> -jsonpath <dot.separated.path>", DbCfCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"minversions", (Object)new IntegerInputParameter("minversions", "Min versions to keep", false, Integer.valueOf(0))).put((Object)"maxversions", (Object)new IntegerInputParameter("maxversions", "Max versions to keep", false, Integer.valueOf(1))).put((Object)"ttl", (Object)new LongInputParameter("ttl", "Time to live. Enter 0 for forever. Otherwise enter time in seconds. default: 0", false, null)).put((Object)"inmemory", (Object)new BooleanInputParameter("inmemory", "In-memory", false, Boolean.valueOf(false))).put((Object)"compression", (Object)new TextInputParameter("compression", "off|lzf|lz4|zlib. default: table's compression setting is applied.", false, null)).put((Object)"versionperm", (Object)new TextInputParameter("versionperm", "Version Permissions for binary tabletype", false, null)).put((Object)"compressionperm", (Object)new TextInputParameter("compressionperm", "Compression Permissions", false, null)).put((Object)"memoryperm", (Object)new TextInputParameter("memoryperm", "Memory Permissions", false, null)).put((Object)"readperm", (Object)new TextInputParameter("readperm", "Read Permissions", false, null)).put((Object)"writeperm", (Object)new TextInputParameter("writeperm", "Write Permissions", false, null)).put((Object)"appendperm", (Object)new TextInputParameter("appendperm", "Append Permissions for binary tabletype", false, null)).put((Object)"traverseperm", (Object)new TextInputParameter("traverseperm", "Traverse Permissions for json tabletype", false, null)).put((Object)"jsonpath", (Object)new TextInputParameter("jsonpath", "Json Family Path - needed for JSON column family, like a.b.c", false, null)).put((Object)"force", (Object)new TextInputParameter("force", "Force create non-default column family for json tabletype. default: false", false, null)).put((Object)"encryptperm", (Object)new TextInputParameter("encryptperm", "Encrypt Permissions", false, null).setInvisible(true)).put((Object)"columnperm", (Object)new TextInputParameter("columnperm", "Column Specific Permissions", false, null).setInvisible(true)).build(), null).setShortUsage("table cf create -path <tablepath> -cfname <cfname>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table cf edit -path <tablepath> -cfname <cfname> -minversions <minversions> -maxversions<maxversions> -ttl <ttl> -inmemory <inmemory> -compression <off|lzf|lz4|zlib>", DbCfCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"newcfname", (Object)new TextInputParameter("newcfname", "New column family name", false, null)).put((Object)"minversions", (Object)new IntegerInputParameter("minversions", "Min versions to keep", false, null)).put((Object)"maxversions", (Object)new IntegerInputParameter("maxversions", "Max versions to keep", false, null)).put((Object)"ttl", (Object)new LongInputParameter("ttl", "Time to live (in seconds)", false, null)).put((Object)"inmemory", (Object)new BooleanInputParameter("inmemory", "In-memory", false, null)).put((Object)"compression", (Object)new TextInputParameter("compression", "off|lzf|lz4|zlib", false, null)).put((Object)"versionperm", (Object)new TextInputParameter("versionperm", "Version Permissions for binary tabletype", false, null)).put((Object)"compressionperm", (Object)new TextInputParameter("compressionperm", "Compression Permissions", false, null)).put((Object)"memoryperm", (Object)new TextInputParameter("memoryperm", "Memory Permissions", false, null)).put((Object)"readperm", (Object)new TextInputParameter("readperm", "Read Permissions", false, null)).put((Object)"writeperm", (Object)new TextInputParameter("writeperm", "Write Permissions", false, null)).put((Object)"appendperm", (Object)new TextInputParameter("appendperm", "Append Permissions for binary tabletype", false, null)).put((Object)"encryptperm", (Object)new TextInputParameter("encryptperm", "Encrypt Permissions", false, null).setInvisible(true)).put((Object)"columnperm", (Object)new TextInputParameter("columnperm", "Column Specific Permissions", false, null).setInvisible(true)).put((Object)"traverseperm", (Object)new TextInputParameter("traverseperm", "Traverse Permissions for json tabletype", false, null)).build(), null).setShortUsage("table cf edit -path <tablepath> -cfname <cfname> -minversions <minversions> -maxversions<maxversions> -ttl <ttl> -inmemory <inmemory> -compression <off|lzf|lz4|zlib>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: table cf delete -path <tablepath>", DbCfCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).build(), null).setShortUsage("table cf delete -path <tablepath> -cfname <cfname>");
    public static final CLICommand cfCommands = new CLICommand("cf", "cf [create|edit|delete|list|colperm]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{createCommand, editCommand, deleteCommand, listCommand, DbCfColCommands.cfColCommands}).setShortUsage("table cf [create|edit|delete|list|col]");
    private static final Map<String, String> verboseToTerseMap = new ImmutableMap.Builder().put((Object)"cfname", (Object)"n").put((Object)"maxversions", (Object)"vmax").put((Object)"minversions", (Object)"vmin").put((Object)"ttl", (Object)"ttl").put((Object)"inmemory", (Object)"inmem").put((Object)"compression", (Object)"comp").put((Object)"versionperm", (Object)"pver").put((Object)"compressionperm", (Object)"pcomp").put((Object)"memoryperm", (Object)"pmem").put((Object)"readperm", (Object)"pread").put((Object)"writeperm", (Object)"pwrite").put((Object)"columnperm", (Object)"pcol").put((Object)"appendperm", (Object)"papp").put((Object)"encryptperm", (Object)"penc").put((Object)"traverseperm", (Object)"ptraverse").put((Object)"jsonfamilypath", (Object)"jpath").build();

    public DbCfCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(createCommand.getCommandName())) {
            this.createCf(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(editCommand.getCommandName())) {
            this.editCf(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteCf(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(listCommand.getCommandName())) {
            this.listCf(out);
        }
        return output;
    }

    private Common.FileCompressionType getCompressionType(String cs) {
        if (cs.equalsIgnoreCase("off")) {
            return Common.FileCompressionType.FCT_OFF;
        }
        if (cs.equalsIgnoreCase("lz4")) {
            return Common.FileCompressionType.FCT_LZ4;
        }
        if (cs.equalsIgnoreCase("lzf")) {
            return Common.FileCompressionType.FCT_LZF;
        }
        if (cs.equalsIgnoreCase("zlib")) {
            return Common.FileCompressionType.FCT_ZLIB;
        }
        return null;
    }

    private String getCompressionName(Common.FileCompressionType ct) {
        if (ct == Common.FileCompressionType.FCT_OFF) {
            return "off";
        }
        if (ct == Common.FileCompressionType.FCT_LZ4) {
            return "lz4";
        }
        if (ct == Common.FileCompressionType.FCT_ZLIB) {
            return "zlib";
        }
        if (ct == Common.FileCompressionType.FCT_LZF || ct == Common.FileCompressionType.FCT_OLDLZF) {
            return "lzf";
        }
        return "unknown";
    }

    private boolean validateFamilyPath(String s) {
        try {
            if (s != null && s.length() == 0) {
                return false;
            }
            FieldPath fieldPath = FieldPath.parseFrom((String)s);
            for (FieldSegment seg : fieldPath) {
                if (!seg.isArray()) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void createCf(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        Integer minVersions = this.getParamIntValue(MIN_VERSIONS_PARAM_NAME, 0);
        Integer maxVersions = this.getParamIntValue(MAX_VERSIONS_PARAM_NAME, 0);
        Object columns = null;
        Long ttl = this.isParamPresent(TTL_PARAM_NAME) ? Long.valueOf(this.getParamLongValue(TTL_PARAM_NAME, 0)) : null;
        Boolean inMem = this.isParamPresent(IN_MEMORY_PARAM_NAME) ? Boolean.valueOf(this.getParamBooleanValue(IN_MEMORY_PARAM_NAME, 0)) : null;
        Common.FileCompressionType ctype = null;
        if (this.isParamPresent(COMPRESSION_PARAM_NAME) && (ctype = CompressionHelper.getCompressionType((String)this.getParamTextValue(COMPRESSION_PARAM_NAME, 0))) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid input values. The entered value for compression is not a supported type."));
            return;
        }
        final AtomicBoolean isJsonTable = new AtomicBoolean(false);
        final AtomicBoolean isStream = new AtomicBoolean(false);
        boolean isDefaultCf = cfName.equals(Dbserver.DBInternalDefaults.getDefaultInstance().getJsonDefaultCFName());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
                    isJsonTable.set(tableProp.getAttr().getJson());
                    isStream.set(tableProp.getAttr().getIsMarlinTable());
                }
            };
        }
        catch (IOException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        if (minVersions != null && maxVersions != null && minVersions > maxVersions) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid input values. The entered value for min versions: " + minVersions + " is greater than the value for max versions: " + maxVersions + "."));
            return;
        }
        Dbserver.ColumnFamilyAttr.Builder builder = Dbserver.ColumnFamilyAttr.newBuilder();
        Dbserver.SchemaFamily.Builder cfbuilder = Dbserver.SchemaFamily.newBuilder();
        cfbuilder.setName(cfName);
        if (maxVersions != null) {
            cfbuilder.setMaxVersions(maxVersions.intValue());
        }
        if (minVersions != null) {
            cfbuilder.setMinVersions(minVersions.intValue());
        }
        if (ttl != null) {
            if (isJsonTable.get() && !isStream.get()) {
                final AtomicInteger numCF = new AtomicInteger(0);
                try {
                    new FileclientRun(this.getUserLoginId()){

                        @Override
                        public void runAsProxyUser() throws IOException, CLIProcessingException {
                            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                            List cfa = mfs.listColumnFamily(new Path(tablePath), false);
                            numCF.set(cfa.size());
                        }
                    };
                }
                catch (IOException e) {
                    throw new CLIProcessingException(e.getMessage());
                }
                if (numCF.get() >= 1) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "TTL cannot be set when multiple column families present in json type of table."));
                    return;
                }
            }
            cfbuilder.setTtl(ttl * 1000L);
        }
        if (inMem != null) {
            cfbuilder.setInMemory(inMem.booleanValue());
        }
        if (ctype != null) {
            cfbuilder.setCompression(ctype);
        }
        builder.setSchFamily(cfbuilder.build());
        boolean isForceCreate = false;
        if (this.isParamPresent(JSON_FORCE_CF_CREATE)) {
            if (!isJsonTable.get()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameter force can only be set for json type of table"));
                return;
            }
            isForceCreate = true;
        }
        if (this.isParamPresent(JSON_FAMILY_PATH)) {
            String jsonFamilyPath = this.getParamTextValue(JSON_FAMILY_PATH, 0);
            if (!isJsonTable.get()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameter jsonpath can only be set for json type of table"));
                return;
            }
            if (isDefaultCf) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameter jsonpath can only be set for non default column family in json type of table"));
                return;
            }
            if (!isDefaultCf && !isForceCreate) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ERROR: Please ensure that none of the existing rows in the table " + tablePath + " contain data at path " + jsonFamilyPath + ". Use '-force true' option " + "to create the new column family " + "after ensuring no data exists at the " + "jsonpath. Creating a new column family " + "may leave any existing data at that path " + "inaccessible or cause unexpected " + "behavior."));
                return;
            }
            if (!this.validateFamilyPath(jsonFamilyPath)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Malformed path \"" + jsonFamilyPath + "\", valid format " + "is like \"a.b.c\"."));
                return;
            }
            builder.setJsonFamilyPath(jsonFamilyPath);
        } else if (isJsonTable.get() && !isDefaultCf) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameter jsonpath is required for non default column family " + cfName + " in json table " + tablePath));
            return;
        }
        try {
            if (this.isParamPresent(COLUMN_PERMISSIONS_PARAM_NAME)) {
                builder.addAllColumnAttr(this.getColumnList(this.toJSON(this.getParamTextValue(COLUMN_PERMISSIONS_PARAM_NAME, 0)), out));
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        catch (JSONException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        if (isJsonTable.get() && !isDefaultCf && !isStream.get()) {
            Dbserver.SchemaFamily defSF;
            try {
                Dbserver.ColumnFamilyAttr cfa = this.getColumnFamily(tablePath, Dbserver.DBInternalDefaults.getDefaultInstance().getJsonDefaultCFName());
                if (cfa == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family default is not defined for table '" + tablePath + "'."));
                    return;
                }
                defSF = cfa.getSchFamily();
            }
            catch (IOException ioe) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, ioe.getMessage()));
                return;
            }
            if (defSF.hasTtl()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Multiple column families cannot be created when TTL is present in default column family of json table."));
                return;
            }
        }
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final Dbserver.ColumnFamilyAttr cfattr = builder.build();
        final DbCfCommands self = this;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to create new column family -> Path: " + tablePath + ", Name: " + cfName));
            }
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        mfs.createColumnFamily(new Path(tablePath), cfName, cfattr, self);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void editCf(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Dbserver.SchemaFamily currentCf;
        Dbserver.ColumnFamilyAttr cfa;
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String currentCfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        String newCfName = this.isParamPresent(NEWCFNAME_PARAM_NAME) ? this.getParamTextValue(NEWCFNAME_PARAM_NAME, 0) : null;
        Integer minVersions = this.isParamPresent(MIN_VERSIONS_PARAM_NAME) ? Integer.valueOf(this.getParamIntValue(MIN_VERSIONS_PARAM_NAME, 0)) : null;
        Integer maxVersions = this.isParamPresent(MAX_VERSIONS_PARAM_NAME) ? Integer.valueOf(this.getParamIntValue(MAX_VERSIONS_PARAM_NAME, 0)) : null;
        ArrayList<Dbserver.ColumnAttr> colPerm = null;
        Object columns = null;
        try {
            cfa = this.getColumnFamily(tablePath, currentCfName);
            if (cfa == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + currentCfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            currentCf = cfa.getSchFamily();
        }
        catch (IOException ioe) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, ioe.getMessage()));
            return;
        }
        if (minVersions != null && maxVersions == null || minVersions == null && maxVersions != null) {
            minVersions = minVersions != null ? minVersions.intValue() : currentCf.getMinVersions();
            maxVersions = maxVersions != null ? maxVersions.intValue() : currentCf.getMaxVersions();
        }
        Long ttl = this.isParamPresent(TTL_PARAM_NAME) ? Long.valueOf(this.getParamLongValue(TTL_PARAM_NAME, 0)) : null;
        Boolean inMem = this.isParamPresent(IN_MEMORY_PARAM_NAME) ? Boolean.valueOf(this.getParamBooleanValue(IN_MEMORY_PARAM_NAME, 0)) : null;
        Common.FileCompressionType ctype = null;
        if (this.isParamPresent(COMPRESSION_PARAM_NAME) && (ctype = CompressionHelper.getCompressionType((String)this.getParamTextValue(COMPRESSION_PARAM_NAME, 0))) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid input values. The entered value for compression is not a supported type."));
            return;
        }
        if (minVersions != null && maxVersions != null && minVersions > maxVersions) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The value for min versions is greater than the value for max versions. Min versions: " + minVersions + ", Max versions: " + maxVersions + "."));
            return;
        }
        final AtomicBoolean isJsonTable = new AtomicBoolean(false);
        final AtomicBoolean isStream = new AtomicBoolean(false);
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
                    isJsonTable.set(tableProp.getAttr().getJson());
                    isStream.set(tableProp.getAttr().getIsMarlinTable());
                }
            };
        }
        catch (IOException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        Dbserver.SchemaFamily.Builder newCfBuilder = Dbserver.SchemaFamily.newBuilder();
        if (newCfName != null && !newCfName.equals(currentCfName)) {
            boolean isDefaultCf = currentCfName.equals(Dbserver.DBInternalDefaults.getDefaultInstance().getJsonDefaultCFName());
            if (isDefaultCf && isJsonTable.get()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "'default' column family of a JSON type table cannot be renamed."));
                return;
            }
            newCfBuilder.setName(newCfName);
        }
        if (minVersions != null) {
            newCfBuilder.setMinVersions(minVersions.intValue());
        }
        if (maxVersions != null) {
            newCfBuilder.setMaxVersions(maxVersions.intValue());
        }
        if (ttl != null) {
            if (isJsonTable.get() && !isStream.get()) {
                final AtomicInteger numCF = new AtomicInteger(0);
                try {
                    new FileclientRun(this.getUserLoginId()){

                        @Override
                        public void runAsProxyUser() throws IOException, CLIProcessingException {
                            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                            List cfa = mfs.listColumnFamily(new Path(tablePath), false);
                            numCF.set(cfa.size());
                        }
                    };
                }
                catch (IOException e) {
                    throw new CLIProcessingException(e.getMessage());
                }
                if (numCF.get() > 1) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "TTL cannot be edited when multiple column families present in json type of table."));
                    return;
                }
            }
            newCfBuilder.setTtl(ttl * 1000L);
        }
        if (inMem != null) {
            newCfBuilder.setInMemory(inMem.booleanValue());
        }
        if (ctype != null) {
            newCfBuilder.setCompression(ctype);
        }
        try {
            if (this.isParamPresent(COLUMN_PERMISSIONS_PARAM_NAME) && (colPerm = this.getColumnList(this.toJSON(this.getParamTextValue(COLUMN_PERMISSIONS_PARAM_NAME, 0)), out)).isEmpty()) {
                for (int i = 0; i < cfa.getColumnAttrCount(); ++i) {
                    Dbserver.ColumnAttr.Builder colAttrBuilder = cfa.getColumnAttr(i).toBuilder();
                    colAttrBuilder.clearAces();
                    colPerm.add(colAttrBuilder.build());
                }
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        catch (JSONException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        Dbserver.ColumnFamilyAttr.Builder builder = Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(newCfBuilder.build());
        if (colPerm != null) {
            builder.addAllColumnAttr(colPerm);
        }
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final Dbserver.ColumnFamilyAttr cfattr = builder.build();
        final DbCfCommands self = this;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to modify column family -> Path: " + tablePath + ", Name: " + currentCfName));
            }
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        mfs.modifyColumnFamily(new Path(tablePath), currentCfName, cfattr, self);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void deleteCf(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        boolean isDefaultCf = cfName.equals(Dbserver.DBInternalDefaults.getDefaultInstance().getJsonDefaultCFName());
        final AtomicBoolean isJsonTable = new AtomicBoolean(false);
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
                    isJsonTable.set(tableProp.getAttr().getJson());
                }
            };
        }
        catch (IOException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        if (isDefaultCf && isJsonTable.get()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "'default' column family of a JSON type table cannot be deleted."));
            return;
        }
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to delete column family -> Path: " + tablePath + ", Name: " + cfName));
            }
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        mfs.deleteColumnFamily(new Path(tablePath), cfName);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listCf(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        RecentTablesListManager manager;
        String tablePath;
        block14: {
            CommandOutput.OutputHierarchy.OutputNode cfNode;
            block12: {
                Dbserver.ColumnFamilyAttr cfa;
                block13: {
                    tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
                    try {
                        if (this.isParamPresent(CFNAME_PARAM_NAME)) {
                            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
                            cfa = this.getColumnFamily(tablePath, cfName);
                            if (cfa == null) {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                                return;
                            }
                            Dbserver.SchemaFamily cf = cfa.getSchFamily();
                            if (cf == null) {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                                return;
                            }
                            cfNode = new CommandOutput.OutputHierarchy.OutputNode();
                            cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(CFNAME_PARAM_NAME), (Object)cf.getName()));
                            cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MAX_VERSIONS_PARAM_NAME), cf.getMaxVersions()));
                            cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MIN_VERSIONS_PARAM_NAME), cf.getMinVersions()));
                            cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(TTL_PARAM_NAME), this.getTtl(cf)));
                            cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(IN_MEMORY_PARAM_NAME), (Object)cf.getInMemory()));
                            cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(COMPRESSION_PARAM_NAME), (Object)this.getCompressionName(cf.getCompression())));
                            if (cfa.hasJsonFamilyPath()) {
                                cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("jsonfamilypath"), (Object)cfa.getJsonFamilyPath()));
                            }
                            for (Dbserver.AccessControlExpression ace : cfa.getAcesList()) {
                                cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.cfPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                            }
                            if (!this.getParamBooleanValue(SHOW_COLUMNS_NAME, 0)) break block12;
                            break block13;
                        }
                        for (Dbserver.ColumnFamilyAttr cfa2 : mfs.listColumnFamily(new Path(tablePath), true)) {
                            Dbserver.SchemaFamily cf = cfa2.getSchFamily();
                            CommandOutput.OutputHierarchy.OutputNode cfNode2 = new CommandOutput.OutputHierarchy.OutputNode();
                            cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(CFNAME_PARAM_NAME), (Object)cf.getName()));
                            cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MAX_VERSIONS_PARAM_NAME), cf.getMaxVersions()));
                            cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MIN_VERSIONS_PARAM_NAME), cf.getMinVersions()));
                            cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(TTL_PARAM_NAME), this.getTtl(cf)));
                            cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(IN_MEMORY_PARAM_NAME), (Object)cf.getInMemory()));
                            cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(COMPRESSION_PARAM_NAME), (Object)this.getCompressionName(cf.getCompression())));
                            if (cfa2.hasJsonFamilyPath()) {
                                cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("jsonfamilypath"), (Object)cfa2.getJsonFamilyPath()));
                            }
                            for (Dbserver.AccessControlExpression ace : cfa2.getAcesList()) {
                                cfNode2.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.cfPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                            }
                            out.addNode(cfNode2);
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                        manager.deleteIfNotExist(tablePath, mfs);
                    }
                    return;
                }
                for (int i = 0; i < cfa.getColumnAttrCount(); ++i) {
                    Dbserver.ColumnAttr col = cfa.getColumnAttr(i);
                    CommandOutput.OutputHierarchy.OutputNode colNode = new CommandOutput.OutputHierarchy.OutputNode();
                    colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("name"), (Object)AceHelper.toInfix((String)col.getQualifier().toStringUtf8())));
                    for (Dbserver.AccessControlExpression ace : col.getAcesList()) {
                        colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.colPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                    }
                    cfNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(COLUMN_PERMISSIONS_PARAM_NAME), (Object)colNode));
                }
            }
            out.addNode(cfNode);
        }
        manager.moveToTop(tablePath);
    }

    private long getTtl(Dbserver.SchemaFamily cf) {
        long ttl = Integer.MAX_VALUE;
        if (cf.hasTtl()) {
            ttl = cf.getTtl() / 1000L;
        }
        return ttl;
    }

    private Dbserver.ColumnFamilyAttr getColumnFamily(String tablePath, String cfName) throws IOException, CLIProcessingException {
        final Dbserver.ColumnFamilyAttr.Builder ret = Dbserver.ColumnFamilyAttr.newBuilder();
        final String cfNameFinal = cfName;
        final String tablePathFinal = tablePath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for column family " + cfName));
        }
        new FileclientRun(this.getUserLoginId()){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                for (Dbserver.ColumnFamilyAttr cf : mfs.listColumnFamily(new Path(tablePathFinal), true)) {
                    if (!cf.getSchFamily().getName().equals(cfNameFinal)) continue;
                    ret.setSchFamily(cf.getSchFamily());
                    ret.addAllAces((Iterable)cf.getAcesList());
                    ret.addAllColumnAttr((Iterable)cf.getColumnAttrList());
                    if (!cf.hasJsonFamilyPath()) continue;
                    ret.setJsonFamilyPath(cf.getJsonFamilyPath());
                }
            }
        };
        if (ret.getSchFamily().getName().isEmpty()) {
            return null;
        }
        return ret.build();
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0)) ? verboseToTerseMap.get(verboseName) : verboseName;
    }

    private JSONArray toJSON(String json) throws JSONException {
        JSONTokener token = new JSONTokener(json);
        return new JSONArray(token);
    }

    private ArrayList<Dbserver.ColumnAttr> getColumnList(JSONArray columns, CommandOutput.OutputHierarchy out) {
        ArrayList<Dbserver.ColumnAttr> columnPermissions = new ArrayList<Dbserver.ColumnAttr>();
        try {
            for (int i = 0; i < columns.length(); ++i) {
                JSONObject column = columns.getJSONObject(i);
                Dbserver.ColumnAttr.Builder col = Dbserver.ColumnAttr.newBuilder();
                col.setQualifier(ByteString.copyFromUtf8((String)column.getString("name")));
                ArrayList ace = AceHelper.getColumnPermission((JSONObject)column);
                if (ace.size() > 0) {
                    col.addAllAces((Iterable)ace);
                }
                columnPermissions.add(col.build());
            }
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (JSONException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        return columnPermissions;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

