/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.JSONObjectInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import com.mapr.util.MapRFSUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String dbUrlParamName = "jm_db.url";
    public static final String dbUserParamName = "jm_db.user";
    public static final String dbPasswdParamName = "jm_db.passwd";
    public static final String dbSchemaParamName = "jm_db.schema";
    public static final String dbJobMaxRowsLimit = "jm_db.jobmaxrecords";
    public static final String dbTaskMaxRowsLimit = "jm_db.taskmaxrecords";
    public static final String jmConfigured = "jm_configured";
    public static final String centralConfigPath = "/var/mapr/configuration/default";
    public static final String KEYS_PARAM_NAME = "keys";
    public static final String VALUES_PARAM_NAME = "values";
    public static final String TEST_PARAM_NAME = "test";
    public final String SUPER_PARAM_PREFIX = "mapr.fs.permissions.";
    public final String ParamSuperUser = "mapr.fs.permissions.superuser";
    private static final String PassPhrase = "MapR_Random_$$_Phrase";
    private Properties CLDBProperties = new Properties();
    private static final Logger LOG = Logger.getLogger(ConfigCommands.class);
    static final CLICommand loadCmd = new CLICommand("load", "", ConfigCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"keys", (Object)new TextInputParameter("keys", "list of keys", true, "")).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("config load -keys <keys>");
    static final CLICommand saveCmd = new CLICommand("save", "", ConfigCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"values", (Object)new JSONObjectInputParameter("values", "JSON Object to comprise all config properties to save", true)).put((Object)"test", (Object)new IntegerInputParameter("test", "test only", true, Integer.valueOf(0))).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("config save -values <keyvalues>");
    public static final CLICommand configCmds = new CLICommand("config", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{loadCmd, saveCmd}).setShortUsage("config [load|save]");

    public ConfigCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    String encryptPassword(String p) throws Exception {
        DESKeySpec keySpec = new DESKeySpec(PassPhrase.getBytes("UTF8"));
        SecretKey PassKey = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
        Base64 base64encoder = new Base64();
        byte[] cleartext = p.getBytes("UTF8");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, PassKey);
        return new String(base64encoder.encode(cipher.doFinal(cleartext)));
    }

    boolean PushCLDBParams(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            byte[] replyData;
            CLDBProto.CLDBConfigRequest.Builder reqbuilder = CLDBProto.CLDBConfigRequest.newBuilder();
            reqbuilder.setLoad(false);
            if (this.getParamIntValue(TEST_PARAM_NAME, 0) == 1) {
                reqbuilder.setTest(true);
            }
            CLDBProto.CLDBConfigParams.Builder pBuilder = CLDBProto.CLDBConfigParams.newBuilder();
            for (Object o : this.CLDBProperties.keySet()) {
                String key = (String)o;
                CLDBProto.CLDBConfigParams.CLDBConfigParam param = CLDBProto.CLDBConfigParams.CLDBConfigParam.newBuilder().setKeys(key).setValues(this.CLDBProperties.getProperty(key)).build();
                pBuilder.addParams(param);
            }
            reqbuilder.setParams(pBuilder);
            CLDBProto.CLDBConfigRequest req = reqbuilder.setCreds(this.getUserCredentials()).build();
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)req, CLDBProto.CLDBConfigResponse.class);
            } else {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)req, CLDBProto.CLDBConfigResponse.class);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid response to RPC, from CLDB"));
                return false;
            }
            CLDBProto.CLDBConfigResponse resp = CLDBProto.CLDBConfigResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                String errorMsg = "Failed to save config: " + Errno.toString(resp.getStatus()) + ". ";
                if (resp.hasErrorString()) {
                    errorMsg = errorMsg + resp.getErrorString();
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
                return false;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception during config save"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            return false;
        }
        return true;
    }

    void LoadParam(String key, String val, CommandOutput.OutputHierarchy.OutputNode node) {
        if (val == null || val.isEmpty()) {
            return;
        }
        if (val.equalsIgnoreCase("true")) {
            val = "1";
        } else if (val.equalsIgnoreCase("false")) {
            val = "0";
        }
        if (key.indexOf("passw") >= 0) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(key, (Object)"****"));
        } else {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(key, (Object)val));
        }
    }

    void LoadParam(String key, CommandOutput.OutputHierarchy.OutputNode node) throws CLIProcessingException {
        try {
            if (key.equalsIgnoreCase("smtp") || key.equalsIgnoreCase("ldap") || key.equalsIgnoreCase("quota") || key.equalsIgnoreCase("super")) {
                for (Object o : this.CLDBProperties.keySet()) {
                    String k = (String)o;
                    if (!k.contains(key.subSequence(0, key.length() - 1))) continue;
                    this.LoadParam(k, this.CLDBProperties.getProperty(k), node);
                }
            } else {
                this.LoadParam(key, this.CLDBProperties.getProperty(key), node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String cmd;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        if ((cmd = this.cliCommand.getCommandName()).equalsIgnoreCase("load")) {
            int status;
            String maprInstallPath;
            String jmrolePath;
            File jmRoleFile;
            String keys = this.getParamTextValue(KEYS_PARAM_NAME, 0);
            if (keys == null || keys.isEmpty()) {
                int status2 = MapRCliUtil.fetchCLDBParams(cluster, this.CLDBProperties, this.getUserCredentials());
                if (status2 < 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unable to reach CLDB"));
                    return output;
                }
                if (status2 != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to load configuration - " + Errno.toString(status2)));
                    return output;
                }
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                boolean added = false;
                TreeSet<Object> ts = new TreeSet<Object>(this.CLDBProperties.keySet());
                for (Object o : ts) {
                    String key = (String)o;
                    this.LoadParam(key, node);
                    added = true;
                }
                if (added) {
                    out.addNode(node);
                }
                return output;
            }
            if ((keys.contains(dbUrlParamName) || keys.contains(dbUserParamName) || keys.contains(dbPasswdParamName) || keys.contains(dbJobMaxRowsLimit) || keys.contains(dbTaskMaxRowsLimit) || keys.contains(dbSchemaParamName)) && (jmRoleFile = new File(jmrolePath = (maprInstallPath = MapRCliUtil.getMapRInstallDir()) + "/roles/metrics")).isFile() && jmRoleFile.exists()) {
                String dbConfPath = maprInstallPath + "/conf/db.conf";
                Properties dbProperties = new Properties();
                try {
                    String dbTaskMaxRows;
                    String dbJobMaxRows;
                    String dbSchema;
                    String dbPasswd;
                    String dbUser;
                    dbProperties.load(new FileInputStream(dbConfPath));
                    String dbUrl = dbProperties.getProperty("db.url");
                    if (dbUrl != null) {
                        this.CLDBProperties.setProperty(dbUrlParamName, dbUrl);
                    }
                    if ((dbUser = dbProperties.getProperty("db.user")) != null) {
                        this.CLDBProperties.setProperty(dbUserParamName, dbUser);
                    }
                    if ((dbPasswd = dbProperties.getProperty("db.passwd")) != null) {
                        this.CLDBProperties.setProperty(dbPasswdParamName, dbPasswd);
                    }
                    if ((dbSchema = dbProperties.getProperty("db.schema")) != null) {
                        this.CLDBProperties.setProperty(dbSchemaParamName, dbSchema);
                    }
                    if ((dbJobMaxRows = dbProperties.getProperty("db.job.histogram.query.records.max")) != null) {
                        this.CLDBProperties.setProperty(dbJobMaxRowsLimit, dbJobMaxRows);
                    }
                    if ((dbTaskMaxRows = dbProperties.getProperty("db.task.histogram.query.records.max")) != null) {
                        this.CLDBProperties.setProperty(dbTaskMaxRowsLimit, dbTaskMaxRows);
                    }
                }
                catch (Throwable e) {
                    LOG.error((Object)("Exception while trying to read: " + dbConfPath), e);
                }
            }
            if ((status = MapRCliUtil.fetchCLDBParams(cluster, this.CLDBProperties, this.getUserCredentials())) < 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unable to reach CLDB"));
                return output;
            }
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to load configuration - " + Errno.toString(status)));
                return output;
            }
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            for (String key : keys.split(",")) {
                this.LoadParam(key, node);
            }
            out.addNode(node);
        } else if (cmd.equalsIgnoreCase("save")) {
            String jSonString = (String)this.input.getParameterByName(VALUES_PARAM_NAME).getParamValues().get(0);
            try {
                Map<String, String> keyValues = ConfigCommands.parseParamsFromJSONObject(jSonString);
                for (Map.Entry<String, String> keyValuesEntry : keyValues.entrySet()) {
                    String key = keyValuesEntry.getKey();
                    String value = keyValuesEntry.getValue().trim();
                    if (key.equalsIgnoreCase("mapr.fs.permissions.superuser")) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Cannot modify " + key));
                        continue;
                    }
                    if (key.contains("password")) {
                        try {
                            value = this.encryptPassword(value);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception during password encryption" + e.getLocalizedMessage()));
                            return output;
                        }
                    }
                    this.CLDBProperties.setProperty(key, value);
                }
                if (!this.CLDBProperties.isEmpty()) {
                    boolean isNeedDBStuff = this.isToAddCLDBDBCredentials();
                    if (this.PushCLDBParams(out) && isNeedDBStuff) {
                        this.handleDBCredentials();
                    }
                }
            }
            catch (JSONException e1) {
                LOG.error((Object)"JSON Exception during values parsing", (Throwable)e1);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "JSON Exception during values parsing"));
                return output;
            }
        }
        return output;
    }

    public static Map<String, String> parseParamsFromJSONObject(String jsonString) throws JSONException {
        JSONObject jO = new JSONObject(jsonString);
        HashMap<String, String> jM = new HashMap<String, String>();
        Iterator iter = jO.keys();
        while (iter.hasNext()) {
            String jK = (String)iter.next();
            String value = jO.getString(jK);
            jM.put(jK, value);
        }
        return jM;
    }

    private boolean isToAddCLDBDBCredentials() {
        String dbUrl = this.CLDBProperties.getProperty(dbUrlParamName);
        String dbUser = this.CLDBProperties.getProperty(dbUserParamName);
        String dbPasswd = this.CLDBProperties.getProperty(dbPasswdParamName);
        if (dbUrl == null || dbUser == null || dbPasswd == null || dbUrl.isEmpty() || dbUser.isEmpty() || dbPasswd.isEmpty()) {
            return false;
        }
        this.CLDBProperties.setProperty(jmConfigured, "1");
        return true;
    }

    private void handleDBCredentials() {
        FileOutputStream fos;
        String modfileLine;
        String fileLine;
        StringWriter strW;
        BufferedWriter bw;
        BufferedReader fr;
        String dbUrl = this.CLDBProperties.getProperty(dbUrlParamName);
        String dbUser = this.CLDBProperties.getProperty(dbUserParamName);
        String dbPasswd = this.CLDBProperties.getProperty(dbPasswdParamName);
        String dbSchema = this.CLDBProperties.getProperty(dbSchemaParamName);
        String dbJobMaxRows = this.CLDBProperties.getProperty(dbJobMaxRowsLimit);
        String dbTaskMaxRows = this.CLDBProperties.getProperty(dbTaskMaxRowsLimit);
        if (dbUrl == null || dbUser == null || dbPasswd == null) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        StringBuilder suffix = new StringBuilder(".");
        suffix.append(cal.get(1));
        suffix.append("-");
        suffix.append(cal.get(2) + 1);
        suffix.append("-");
        suffix.append(cal.get(5));
        suffix.append(".");
        suffix.append(cal.get(11));
        suffix.append("-");
        suffix.append(cal.get(12));
        String suffixStr = suffix.toString();
        String maprInstallPath = MapRCliUtil.getMapRInstallDir();
        String dbConfPath = maprInstallPath + "/conf/db.conf";
        String hibernateConfPath = maprInstallPath + "/conf/hibernate.cfg.xml";
        String jmrolePath = maprInstallPath + "/roles/metrics";
        String webRolePath = maprInstallPath + "/roles/webserver";
        File jmRoleFile = new File(jmrolePath);
        if (!jmRoleFile.isFile() || !jmRoleFile.exists()) {
            LOG.warn((Object)"mapr-metrics package is not installed. No DB params will be saved");
            return;
        }
        try {
            fr = new BufferedReader(new FileReader(dbConfPath));
            bw = new BufferedWriter(new FileWriter(dbConfPath + suffixStr));
            strW = new StringWriter();
            while ((fileLine = fr.readLine()) != null) {
                modfileLine = fileLine.replaceFirst("db.url=.*", "db.url=" + dbUrl);
                modfileLine = modfileLine.replaceFirst("db.user=.*", "db.user=" + dbUser);
                modfileLine = modfileLine.replaceFirst("db.passwd=.*", "db.passwd=" + dbPasswd);
                if (dbSchema != null) {
                    modfileLine = modfileLine.replaceFirst("db.schema=.*", "db.schema=" + dbSchema);
                }
                if (dbJobMaxRows != null) {
                    modfileLine = modfileLine.replaceFirst("db.job.histogram.query.records.max=.*", "db.job.histogram.query.records.max=" + dbJobMaxRows);
                }
                if (dbTaskMaxRows != null) {
                    modfileLine = modfileLine.replaceFirst("db.task.histogram.query.records.max=.*", "db.task.histogram.query.records.max=" + dbTaskMaxRows);
                }
                strW.write(modfileLine);
                strW.write(10);
                bw.write(fileLine);
                bw.write(10);
            }
            fr.close();
            bw.close();
            fos = new FileOutputStream(new File(dbConfPath));
            fos.write(strW.getBuffer().toString().getBytes());
            fos.close();
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while handling DB Credentials replacement in: " + dbConfPath), (Throwable)e);
        }
        try {
            fr = new BufferedReader(new FileReader(hibernateConfPath));
            bw = new BufferedWriter(new FileWriter(hibernateConfPath + suffixStr));
            strW = new StringWriter();
            while ((fileLine = fr.readLine()) != null) {
                modfileLine = fileLine.replaceFirst("jdbc:mysql://[a-zA-Z_0-9:.]*/", "jdbc:mysql://" + dbUrl + "/");
                if (dbSchema != null) {
                    modfileLine = modfileLine.replaceFirst(dbUrl + "/.*</property>", dbUrl + "/" + dbSchema + "</property>");
                }
                modfileLine = modfileLine.replaceFirst("\"connection.username\">.*<", "\"connection.username\">" + dbUser + "<");
                modfileLine = modfileLine.replaceFirst("\"connection.password\">.*<", "\"connection.password\">" + dbPasswd.replaceAll("&", "&amp;") + "<");
                strW.write(modfileLine);
                strW.write(10);
                bw.write(fileLine);
                bw.write(10);
            }
            fr.close();
            bw.close();
            fos = new FileOutputStream(new File(hibernateConfPath));
            fos.write(strW.getBuffer().toString().getBytes());
            fos.close();
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while handling DB Credentials replacement in: " + hibernateConfPath), (Throwable)e);
        }
        try {
            Path dbConfFSPath = new Path("/var/mapr/configuration/default/conf/db.conf");
            Path hibernateConfFSPath = new Path("/var/mapr/configuration/default/conf/hibernate.cfg.xml");
            boolean isPathCreated = MapRFSUtil.getMapRFileSystem().mkdirs(new Path("/var/mapr/configuration/default/conf"));
            if (isPathCreated) {
                MapRFSUtil.getMapRFileSystem().copyFromLocalFile(false, true, new Path(dbConfPath), dbConfFSPath);
                MapRFSUtil.getMapRFileSystem().setPermission(dbConfFSPath, FsPermission.createImmutable((short)448));
                File webRoleFile = new File(webRolePath);
                if (webRoleFile.isFile() && webRoleFile.exists()) {
                    MapRFSUtil.getMapRFileSystem().copyFromLocalFile(false, true, new Path(hibernateConfPath), hibernateConfFSPath);
                    MapRFSUtil.getMapRFileSystem().setPermission(hibernateConfFSPath, FsPermission.createImmutable((short)448));
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException while trying to update db.conf in centralconfig", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception while trying to process DB credentials", t);
        }
    }
}

