/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.ServerCommands;
import com.mapr.cli.ServiceLinkCommand;
import com.mapr.cli.common.AuthManager;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodeField;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AlarmCommands
extends ListCommand
implements CLIInterface {
    private static final int NUM_ALARMS_PER_RPC = 100;
    public static final String ALARM_NAME_PARAM_NAME = "alarm";
    public static final String ALARM_NEWNAME_PARAM_NAME = "newname";
    public static final String ALARM_TERSE_NAME_PARAM_NAME = "terse";
    public static final String ALARM_TYPE_PARAM_NAME = "type";
    public static final String ALARM_DISPLAY_NAME_PARAM_NAME = "displayName";
    public static final String ALARM_SERVICE_DISPLAY_NAME = "serviceName";
    public static final String ALARM_SERVICE_KEY_NAME = "service";
    public static final String ALARM_BASE_SERVICE_NAME = "baseService";
    public static final String ALARM_UI_DISPLAY_NAME = "uiDisplayName";
    public static final String ALARM_TOOLTIP_NAME = "tooltip";
    public static final String SUMMARY_PARAM_NAME = "summary";
    public static final String ENTITY_PARAM_NAME = "entity";
    public static final String VALUES_PARAM_NAME = "values";
    public static final String DESC_PARAM_NAME = "description";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String OUTPUT_PARAM_NAME = "output";
    private static final Logger LOG = Logger.getLogger(AlarmCommands.class);
    private AuthManager authManager = AuthManager.getInstance();
    public static final Map<String, Common.AlarmType> alarmNameMap = new ImmutableMap.Builder().put((Object)"cluster", (Object)Common.AlarmType.CLUSTER_ALARM).put((Object)"node", (Object)Common.AlarmType.NODE_ALARM).put((Object)"volume", (Object)Common.AlarmType.VOLUME_ALARM).put((Object)"ae", (Object)Common.AlarmType.AE_ALARM).build();
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand addCmd = new CLICommand("add", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", true, null)).put((Object)"terse", (Object)new TextInputParameter("terse", "alarm terse name", true, null)).put((Object)"displayName", (Object)new TextInputParameter("displayName", "alarm display name", false, null)).put((Object)"service", (Object)new TextInputParameter("service", "alarm service key", false, null)).put((Object)"serviceName", (Object)new TextInputParameter("serviceName", "alarm service name", false, null)).put((Object)"baseService", (Object)new BooleanInputParameter("baseService", "alarm base service", false, (Object)0)).put((Object)"uiDisplayName", (Object)new TextInputParameter("uiDisplayName", "alarm ui display name", false, null)).put((Object)"tooltip", (Object)new TextInputParameter("tooltip", "alarm ui tooltip content", false, null)).build(), null).setUsageInVisible(true);
    static final CLICommand editCmd = new CLICommand("edit", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", true, null)).put((Object)"newname", (Object)new TextInputParameter("newname", "new alarm name", false, null)).put((Object)"terse", (Object)new TextInputParameter("terse", "alarm terse name", true, null)).put((Object)"displayName", (Object)new TextInputParameter("displayName", "alarm display name", false, null)).build(), null).setShortUsage("edit");
    static final CLICommand deleteCmd = new CLICommand("delete", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", true, null)).build(), null).setUsageInVisible(true);
    static final CLICommand viewCmd = new CLICommand("view", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", false, "")).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"output", (Object)new TextInputParameter("output", "output", false, "verbose")).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).build(), null).setUsageInVisible(true);
    static final CLICommand listCmd = new CLICommand("list", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"summary", (Object)new BooleanInputParameter("summary", "summary", false, (Object)0)).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", false, null)).put((Object)"type", (Object)new TextInputParameter("type", "type (CLUSTER OR NODE OR VOLUME OR AE)", false, null)).put((Object)"entity", (Object)new TextInputParameter("entity", "entity (hostname OR volume name OR Ae name)", false, null)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"output", (Object)new TextInputParameter("output", "output", false, "verbose")).build(), null).setShortUsage("list");
    static final CLICommand raiseCmd = new CLICommand("raise", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm", true, null)).put((Object)"entity", (Object)new TextInputParameter("entity", "entity (hostname OR volume name OR Ae name)", false, null)).put((Object)"description", (Object)new TextInputParameter("description", "brief description", false, null)).build(), null).setShortUsage("raise");
    static final CLICommand clearCmd = new CLICommand("clear", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm", true, null)).put((Object)"entity", (Object)new TextInputParameter("entity", "entity (hostname OR volume name OR Ae name)", false, null)).build(), null).setShortUsage("clear");
    static final CLICommand clearAllCmd = new CLICommand("clearall", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("clearall");
    static final CLICommand configLoadCmd = new CLICommand("load", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"output", (Object)new TextInputParameter("output", "output", false, "verbose")).build(), null).setShortUsage("config load");
    static final CLICommand configSaveCmd = new CLICommand("save", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"values", (Object)new TextInputParameter("values", "values", true, "")).build(), null).setShortUsage("config save");
    static final CLICommand namesCmd = new CLICommand("names", "list of alarm names", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("names");
    public static final CLICommand[] configCmdsArray = new CLICommand[]{configLoadCmd, configSaveCmd};
    public static CLICommand configCmds = new CLICommand("config", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, configCmdsArray).setShortUsage("config [load|save]");
    public static final CLICommand alarmCmds = new CLICommand("alarm", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCmd, viewCmd, deleteCmd, listCmd, raiseCmd, clearCmd, clearAllCmd, configCmds, namesCmd}).setShortUsage("alarm [list|raise|clear|clearall|config|names]");
    public static String[] AlarmEntryFieldLongName = new String[]{"alarm name", "alarm type", "alarm state", "alarm statechange time", "description", "entity"};
    public static Map<AlarmEntryField, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)AlarmEntryField.an, (Object)new FieldInfo(AlarmEntryField.an.ordinal(), AlarmEntryField.an.name(), AlarmEntryFieldLongName[AlarmEntryField.an.ordinal()], String.class)).put((Object)AlarmEntryField.et, (Object)new FieldInfo(AlarmEntryField.et.ordinal(), AlarmEntryField.et.name(), AlarmEntryFieldLongName[AlarmEntryField.et.ordinal()], String.class)).put((Object)AlarmEntryField.st, (Object)new FieldInfo(AlarmEntryField.st.ordinal(), AlarmEntryField.st.name(), AlarmEntryFieldLongName[AlarmEntryField.st.ordinal()], String.class)).put((Object)AlarmEntryField.sct, (Object)new FieldInfo(AlarmEntryField.sct.ordinal(), AlarmEntryField.sct.name(), AlarmEntryFieldLongName[AlarmEntryField.sct.ordinal()], String.class)).put((Object)AlarmEntryField.des, (Object)new FieldInfo(AlarmEntryField.des.ordinal(), AlarmEntryField.des.name(), AlarmEntryFieldLongName[AlarmEntryField.des.ordinal()], String.class)).put((Object)AlarmEntryField.en, (Object)new FieldInfo(AlarmEntryField.en.ordinal(), AlarmEntryField.en.name(), AlarmEntryFieldLongName[AlarmEntryField.en.ordinal()], String.class)).build();

    public AlarmCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public static boolean isValidAlarmTypeName(String alarmTypeName) {
        return alarmNameMap.containsKey(alarmTypeName.toLowerCase());
    }

    private Common.AlarmType alarmNameToType(String alarmName) throws CLIProcessingException {
        if (alarmName.startsWith("CLUSTER")) {
            return Common.AlarmType.CLUSTER_ALARM;
        }
        if (alarmName.startsWith("NODE")) {
            return Common.AlarmType.NODE_ALARM;
        }
        if (alarmName.startsWith("VOLUME")) {
            return Common.AlarmType.VOLUME_ALARM;
        }
        if (alarmName.startsWith("AE")) {
            return Common.AlarmType.AE_ALARM;
        }
        throw new CLIProcessingException("Invalid Alarm name: " + alarmName);
    }

    public boolean validateInputParams(CommandOutput output) throws CLIProcessingException {
        String msg;
        String type;
        boolean result = true;
        CommandOutput.OutputHierarchy out = output.getOutput();
        if (this.isParamPresent(ALARM_TYPE_PARAM_NAME) && !AlarmCommands.isValidAlarmTypeName(type = this.getParamTextValue(ALARM_TYPE_PARAM_NAME, 0).toUpperCase())) {
            msg = "Invalid alarm type " + type;
            LOG.error((Object)msg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            result = false;
        }
        if (this.isParamPresent("cluster")) {
            String clusterName = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(clusterName)) {
                msg = "Invalid cluster name " + clusterName;
                LOG.error((Object)msg);
                output.getOutput().addError(new CommandOutput.OutputHierarchy.OutputError(133, msg));
                result = false;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!this.validateInputParams(output)) {
            return output;
        }
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            this.list(out);
            return output;
        } else if (cmd.equalsIgnoreCase("add")) {
            if (!this.verifyUserPermissions(out)) return output;
            this.addAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("view")) {
            this.lookupAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("edit")) {
            if (!this.verifyUserPermissions(out)) return output;
            this.editAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("delete")) {
            if (!this.verifyUserPermissions(out)) return output;
            this.deleteAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("raise") || cmd.equalsIgnoreCase("clear") || cmd.equalsIgnoreCase("clearall")) {
            try {
                CLDBProto.AlarmUpdateRequest req = null;
                if (cmd.equalsIgnoreCase("clearall")) {
                    req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setBulkState(false).build();
                } else {
                    Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder();
                    alarmBuilder.setAlarmState(cmd.equalsIgnoreCase("raise"));
                    if (this.isParamPresent(ALARM_NAME_PARAM_NAME)) {
                        String desc;
                        String alarm = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0).toUpperCase();
                        Common.AlarmId enumAlarmId = PluggableAlarmUtil.getAlarmId(alarm);
                        if (enumAlarmId != null) {
                            alarmBuilder.setAlarmId(enumAlarmId);
                        }
                        Common.AlarmType type = this.alarmNameToType(alarm);
                        alarmBuilder.setAlarmType(type);
                        alarmBuilder.setAlarmName(alarm);
                        if (this.isParamPresent(ENTITY_PARAM_NAME)) {
                            alarmBuilder.setAlarmEntity(this.getParamTextValue(ENTITY_PARAM_NAME, 0));
                        }
                        if (this.isParamPresent(DESC_PARAM_NAME) && (desc = this.getParamTextValue(DESC_PARAM_NAME, 0)) != null && !desc.isEmpty()) {
                            alarmBuilder.setAlarmDesc(desc);
                        }
                    }
                    req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).addAlarms(alarmBuilder).build();
                }
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
                    return output;
                }
                CLDBProto.AlarmUpdateResponse resp = CLDBProto.AlarmUpdateResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) return output;
                String errMsg = resp.getStatus() == 2 ? "No such entity" : (resp.getStatus() == 22 ? "Alarm not found" : Errno.toString(resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Operation failed. Error: " + errMsg));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
                return output;
            }
        } else if (cmd.equalsIgnoreCase("save")) {
            try {
                String values = this.getParamTextValue(VALUES_PARAM_NAME, 0);
                if (values == null || values.length() == 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid configuration"));
                    return output;
                }
                CLDBProto.AlarmUpdateRequest.Builder req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setConfigUpdate(true);
                String[] obj = values.split(",");
                for (int i = 0; i < obj.length; i += 3) {
                    int individual;
                    if (obj[i] == null || obj[i].isEmpty()) continue;
                    Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder();
                    Common.AlarmId alarmId = PluggableAlarmUtil.getAlarmId(obj[i]);
                    if (alarmId != null) {
                        alarmBuilder.setAlarmId(alarmId);
                    }
                    alarmBuilder.setAlarmName(obj[i]);
                    Common.AlarmConfigMsg.Builder cBuilder = Common.AlarmConfigMsg.newBuilder();
                    if (obj.length > i + 1 && obj[i + 1] != null && !obj[i + 1].isEmpty() && (individual = Integer.parseInt(obj[i + 1])) >= 0) {
                        cBuilder.setNeedIndividualEmail(individual > 0);
                    }
                    if (obj.length > i + 2 && obj[i + 2] != null) {
                        String email = obj[i + 2].trim();
                        if (!email.isEmpty() && !MapRCliUtil.validateEmail(email)) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid Email format in configuration"));
                        }
                        cBuilder.setEmail(email);
                    }
                    alarmBuilder.setAlarmConfigMsg(cBuilder);
                    req.addAlarms(alarmBuilder);
                }
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.AlarmUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.AlarmUpdateResponse.class);
                if (replyData != null) return output;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to an exception"));
                LOG.error((Object)("Exception: " + e.getMessage()));
                return output;
            }
        } else if (cmd.equalsIgnoreCase("load")) {
            try {
                this.doConfLookup(out);
                return output;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed " + e.getLocalizedMessage()));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            }
            return output;
        } else {
            if (!cmd.equalsIgnoreCase("names")) return output;
            for (Common.AlarmId alarmId : Common.AlarmId.values()) {
                System.out.println(alarmId.toString());
            }
            for (Common.PluggableAlarm pa : PluggableAlarmUtil.getAlarms(this.getUserCredentials(), 0, 50)) {
                System.out.println(pa.getName());
            }
        }
        return output;
    }

    private void addAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        ServerCommands.fieldTable = PluggableAlarmUtil.appendNodeMap(this.getUserCredentials(), ServerCommands.fieldTableBuilder);
        Common.PluggableAlarm.Builder builder = Common.PluggableAlarm.newBuilder();
        builder.setType("NODE");
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        String alarmTerseName = this.getParamTextValue(ALARM_TERSE_NAME_PARAM_NAME, 0);
        String alarmDisplayName = this.isParamPresent(ALARM_DISPLAY_NAME_PARAM_NAME) ? this.getParamTextValue(ALARM_DISPLAY_NAME_PARAM_NAME, 0) : alarmName;
        String alarmUiDisplayName = this.isParamPresent(ALARM_UI_DISPLAY_NAME) ? this.getParamTextValue(ALARM_UI_DISPLAY_NAME, 0) : alarmName;
        if (this.verifyAlarmParams(out, ServerCommands.fieldTable, alarmName, alarmDisplayName, alarmTerseName)) {
            builder.setName(alarmName);
            builder.setTerse(alarmTerseName);
            builder.setDisplayName(alarmDisplayName);
            builder.setUiLabel(alarmUiDisplayName);
            if (this.isParamPresent(ALARM_SERVICE_KEY_NAME)) {
                String service = this.getParamTextValue(ALARM_SERVICE_KEY_NAME, 0);
                if (this.isParamPresent(ALARM_SERVICE_DISPLAY_NAME)) {
                    builder.setServiceName(this.getParamTextValue(ALARM_SERVICE_DISPLAY_NAME, 0));
                } else {
                    builder.setServiceName(service);
                }
                builder.setService(service);
            }
            if (this.isParamPresent(ALARM_TOOLTIP_NAME)) {
                builder.setTooltip(this.getParamTextValue(ALARM_TOOLTIP_NAME, 0));
            }
            if (this.isParamPresent(ALARM_BASE_SERVICE_NAME)) {
                builder.setBaseService(this.getParamBooleanValue(ALARM_BASE_SERVICE_NAME, 0));
            }
            CLDBProto.AlarmAddRequest req = CLDBProto.AlarmAddRequest.newBuilder().setCreds(this.getUserCredentials()).setPluggableAlarm(builder.build()).build();
            try {
                byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmAddProc.getNumber(), (MessageLite)req, CLDBProto.AlarmAddResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
                } else {
                    CLDBProto.AlarmAddResponse resp = CLDBProto.AlarmAddResponse.parseFrom((byte[])replyData);
                    if (resp.getStatus() != 0) {
                        String errMsg = resp.getStatus() == 17 ? "Alarm name already exists. Cannot add duplicate alarm name." : "Did not successfully add alarm because of unknown errors";
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                    }
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmViewResponse proto object.", (Throwable)ipbe);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
    }

    private void editAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        Common.PluggableAlarm.Builder builder = Common.PluggableAlarm.newBuilder();
        if (this.isParamPresent(ALARM_NEWNAME_PARAM_NAME)) {
            builder.setName(this.getParamTextValue(ALARM_NEWNAME_PARAM_NAME, 0));
        } else {
            builder.setName(alarmName);
        }
        if (this.isParamPresent(ALARM_TERSE_NAME_PARAM_NAME)) {
            builder.setTerse(this.getParamTextValue(ALARM_TERSE_NAME_PARAM_NAME, 0));
        }
        if (this.isParamPresent(ALARM_DISPLAY_NAME_PARAM_NAME)) {
            builder.setDisplayName(this.getParamTextValue(ALARM_DISPLAY_NAME_PARAM_NAME, 0));
        }
        CLDBProto.AlarmEditRequest req = CLDBProto.AlarmEditRequest.newBuilder().setAlarmname(alarmName).setPluggableAlarm(builder.build()).setCreds(this.getUserCredentials()).build();
        CLDBProto.AlarmEditResponse resp = null;
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmEditProc.getNumber(), (MessageLite)req, CLDBProto.AlarmEditResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                resp = CLDBProto.AlarmEditResponse.parseFrom((byte[])replyData);
                if (resp != null) {
                    if (resp.getStatus() != 0) {
                        String errMsg = resp.getStatus() == 22 ? "Alarm not found" : "Could not modify alarm, unknown error";
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                    }
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Reply data did not get retrieved properly."));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmEditResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void deleteAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        CLDBProto.AlarmDeleteRequest req = CLDBProto.AlarmDeleteRequest.newBuilder().setAlarmname(alarmName).setCreds(this.getUserCredentials()).build();
        CLDBProto.AlarmDeleteResponse resp = null;
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmRemoveProc.getNumber(), (MessageLite)req, CLDBProto.AlarmDeleteResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                resp = CLDBProto.AlarmDeleteResponse.parseFrom((byte[])replyData);
                if (resp != null) {
                    if (resp.getStatus() != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not delete alarm, alarm not found"));
                    }
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Reply data did not get retrieved properly."));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmViewResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void lookupAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        PluggableAlarmUtil.resetCache();
        List<Common.PluggableAlarm> pluggableAlarm = PluggableAlarmUtil.getAlarms(this.getUserCredentials(), alarmName, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0));
        String clusterName = null;
        String zkConnectString = null;
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        if (this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        for (Common.PluggableAlarm pa : pluggableAlarm) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_NAME_PARAM_NAME, (Object)pa.getName()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_TERSE_NAME_PARAM_NAME, (Object)pa.getTerse()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_DISPLAY_NAME_PARAM_NAME, (Object)pa.getDisplayName()));
            if (pa.hasUiLabel()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_UI_DISPLAY_NAME, (Object)pa.getUiLabel()));
            }
            if (pa.hasTooltip()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_TOOLTIP_NAME, (Object)pa.getTooltip()));
            }
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_TYPE_PARAM_NAME, (Object)pa.getType()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("Id", pa.getId()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_SERVICE_DISPLAY_NAME, (Object)pa.getServiceName()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_SERVICE_KEY_NAME, (Object)pa.getService()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_BASE_SERVICE_NAME, pa.getBaseService() ? 1 : 0));
            String link = ServiceLinkCommand.getUrl(new CommandOutput.OutputHierarchy(), pa.getService(), clusterName, zkConnectString, false);
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("url", link != null ? 1 : 0));
            out.addNode(node);
        }
    }

    void doConfLookup(CommandOutput.OutputHierarchy out) throws Exception {
        String email;
        String individual;
        String alarm;
        CLDBProto.AlarmLookupRequest req = CLDBProto.AlarmLookupRequest.newBuilder().setCreds(this.getUserCredentials()).setSummary(true).build();
        byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class);
        if (replyData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            return;
        }
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        if (terse) {
            alarm = "an";
            individual = "ind";
            email = "em";
        } else {
            alarm = ALARM_NAME_PARAM_NAME;
            individual = "individual";
            email = "email";
        }
        CLDBProto.AlarmLookupResponse resp = CLDBProto.AlarmLookupResponse.parseFrom((byte[])replyData);
        for (Common.AlarmMsg respAlarmMsg : resp.getAlarmsList()) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(alarm, (Object)respAlarmMsg.getAlarmName()));
            Common.AlarmConfigMsg config = respAlarmMsg.getAlarmConfigMsg();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(individual, config.getNeedIndividualEmail() ? 1 : 0));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(email, (Object)(config.hasEmail() ? config.getEmail() : "")));
            out.addNode(node);
        }
    }

    private CLDBProto.AlarmLookupRequest.Builder getAlarmLookupRequestBuilder() throws CLIProcessingException {
        CLDBProto.AlarmLookupRequest.Builder reqBuilder = CLDBProto.AlarmLookupRequest.newBuilder().setCreds(this.getUserCredentials()).setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
        boolean summary = false;
        if (this.isParamPresent(SUMMARY_PARAM_NAME)) {
            summary = this.getParamBooleanValue(SUMMARY_PARAM_NAME, 0);
        }
        if (summary) {
            reqBuilder.setSummary(true);
        } else {
            Common.AlarmMsg.Builder alarmBuilder = this.getAlarmMsgBuilder();
            if (alarmBuilder != null) {
                reqBuilder.addAlarms(alarmBuilder);
            }
        }
        return reqBuilder;
    }

    private Common.AlarmMsg.Builder getAlarmMsgBuilder() throws CLIProcessingException {
        Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder();
        Common.AlarmType type = null;
        if (this.isParamPresent(ALARM_TYPE_PARAM_NAME)) {
            type = this.alarmNameToType(this.getParamTextValue(ALARM_TYPE_PARAM_NAME, 0).toUpperCase());
            alarmBuilder.setAlarmType(type);
        }
        if (this.isParamPresent(ALARM_NAME_PARAM_NAME)) {
            String alarm = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0).toUpperCase();
            Common.AlarmId enumAlarmId = PluggableAlarmUtil.getAlarmId(alarm);
            if (enumAlarmId != null) {
                alarmBuilder.setAlarmId(enumAlarmId);
            }
            alarmBuilder.setAlarmName(alarm);
            if (type == null) {
                type = this.alarmNameToType(alarm);
                alarmBuilder.setAlarmType(type);
            }
        }
        if (type != null && this.isParamPresent(ENTITY_PARAM_NAME)) {
            alarmBuilder.setAlarmEntity(this.getParamTextValue(ENTITY_PARAM_NAME, 0));
        }
        if (type != null) {
            return alarmBuilder;
        }
        return null;
    }

    private CLDBProto.AlarmLookupResponse getAlarmLookupResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.AlarmLookupResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmLookupResponse proto object.", (Throwable)ipbe);
        }
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.AlarmLookupRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.AlarmLookupRequest.newBuilder((CLDBProto.AlarmLookupRequest)((CLDBProto.AlarmLookupRequest)prevReq)) : this.getAlarmLookupRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.AlarmLookupResponse)prevResp).getAlarmsCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.AlarmLookupRequest)prevReq).getLimiter().getStart(), ((CLDBProto.AlarmLookupResponse)prevResp).getAlarmsCount());
    }

    private boolean displayInstanceInfo(Common.AlarmId alarmId) {
        return alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_DEBUG_LOGGING) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_HB_PROCESSING_SLOW) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_DISK_FAILURE) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_HIGH_MFS_MEMORY) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_NO_HEARTBEAT) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_TOO_MANY_CONTAINERS) == 0;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.AlarmLookupResponse resp = (CLDBProto.AlarmLookupResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        for (Common.AlarmMsg respAlarmMsg : resp.getAlarmsList()) {
            String desc;
            int index;
            if (!respAlarmMsg.getAlarmState()) continue;
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            String alarmName = respAlarmMsg.getAlarmName();
            Common.AlarmId alarmId = respAlarmMsg.getAlarmId();
            String entityName = null;
            entityName = respAlarmMsg.getAlarmEntity();
            if (entityName != null && entityName.length() != 0) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.en).getName(terse), (Object)entityName));
            }
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.an).getName(terse), (Object)alarmName));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.st).getName(terse), respAlarmMsg.getAlarmState() ? 1 : 0));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.sct).getName(terse), respAlarmMsg.getAlarmTimeStamp()));
            if (this.displayInstanceInfo(respAlarmMsg.getAlarmId())) {
                Iterator i$ = respAlarmMsg.getInstanceIdsList().iterator();
                while (i$.hasNext()) {
                    int port = (Integer)i$.next();
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode("instances", port));
                }
            }
            String alarmDesc = respAlarmMsg.getAlarmDesc();
            if (alarmName.equals("VOLUME_ALARM_TABLE_REPL_ERROR") || alarmName.equals("VOLUME_ALARM_TABLE_REPL_LAG_HIGH") || alarmName.equals("VOLUME_ALARM_TABLE_REPL_ASYNC")) {
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                index = alarmDesc.indexOf("Fids: ");
                if (index > 0) {
                    String[] fids;
                    String errPaths = "eg.";
                    desc = alarmDesc.substring(0, index);
                    String fidsStr = alarmDesc.substring(index + 6);
                    for (String fid : fids = fidsStr.split(" ")) {
                        String newPath = null;
                        try {
                            newPath = fs.getMountPathFid(fid);
                        }
                        catch (Exception e) {
                            newPath = null;
                        }
                        errPaths = newPath == null ? errPaths + " " + fid : errPaths + " " + newPath;
                    }
                    alarmDesc = desc + errPaths;
                }
            } else if (alarmName.equals("VOLUME_ALARM_LARGE_ROW_WARNING")) {
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                index = alarmDesc.indexOf("TFID:");
                if (index > 0) {
                    String fidStr = alarmDesc.substring(index + 5);
                    desc = alarmDesc.substring(0, index);
                    try {
                        String tablePath = fs.getMountPathFid(fidStr);
                        alarmDesc = desc + tablePath;
                    }
                    catch (Exception e) {
                        alarmDesc = desc + fidStr;
                    }
                }
            }
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.des).getName(terse), (Object)alarmDesc));
            out.addNode(node);
        }
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        byte[] replyData;
        CLDBProto.AlarmLookupRequest req = (CLDBProto.AlarmLookupRequest)request;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getAlarmLookupResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list alarms failed. No data returned");
        return null;
    }

    private boolean verifyUserPermissions(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        boolean isRoot;
        Security.CredentialsMsg creds = this.getUserCredentials();
        boolean bl = isRoot = creds.hasUid() && creds.getUid() == 0;
        if (isRoot) {
            return true;
        }
        return this.authManager.canPerformClusterActions(SecurityCommandHelper.CLUSTER_START_STOP_SERVICES_MASK, creds, out);
    }

    private boolean verifyAlarmParams(CommandOutput.OutputHierarchy out, Map<NodeField, FieldInfo> fieldTable, String alarmName, String alarmDisplayName, String alarmTerseName) {
        return true;
    }

    public static enum AlarmEntryField {
        an,
        et,
        st,
        sct,
        des,
        en;

    }
}

