/*
 * Decompiled with CFR 0.152.
 */
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import com.mapr.util.MapRFSUtil;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TestReadingHistoryTransactionDataNew {
    private static final Logger LOG = Logger.getLogger(TestReadingHistoryTransactionDataNew.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: <fileName>");
            System.exit(0);
        }
        String metricsFile = args[0];
        FSDataInputStream fsdis = null;
        long now = System.currentTimeMillis();
        int readMetrcisCount = 0;
        int readRequestsCount = 0;
        long readBytesCount = 0L;
        System.out.println("Start reading file: " + new Date(now));
        try {
            fsdis = MapRFSUtil.getMapRFileSystem().open(new Path(metricsFile));
            long jobSubmitTime = fsdis.readLong();
            System.out.println("Job submitTime: " + jobSubmitTime);
            TreeMap<Long, Long> hourlyMap = new TreeMap<Long, Long>();
            for (int indexPosition = 8; indexPosition < 1008; indexPosition += 8) {
                short hour = fsdis.readShort();
                indexPosition += 2;
                if (hour == 0) {
                    if (hourlyMap.isEmpty()) {
                        hourlyMap.put(1L, Long.MAX_VALUE);
                        break;
                    }
                    Map.Entry lastEntry = hourlyMap.lastEntry();
                    hourlyMap.put((Long)lastEntry.getKey() + 1L, Long.MAX_VALUE);
                    break;
                }
                System.out.println("Next time interval: " + hour);
                long newHourPosition = fsdis.readLong();
                System.out.println("Next position: " + newHourPosition);
                if (newHourPosition < 1008L) {
                    System.out.println("Bad position: " + newHourPosition);
                    continue;
                }
                hourlyMap.put(Long.valueOf(hour), newHourPosition);
            }
            fsdis.seek(1008L);
            long position = 1008L;
            for (Map.Entry entry : hourlyMap.entrySet()) {
                long hour = (Long)entry.getKey();
                long hourPosition = (Long)entry.getValue();
                System.out.println("Hour data: (" + hour + ", " + hourPosition + ")");
                while (position < hourPosition) {
                    int nexRecordbytesCount = fsdis.readInt();
                    LOG.info((Object)("written bytes: " + nexRecordbytesCount));
                    byte[] buf = new byte[nexRecordbytesCount];
                    int readBytes = fsdis.read(buf, 0, nexRecordbytesCount);
                    if (readBytes != nexRecordbytesCount) {
                        LOG.info((Object)("Number of read bytes : " + readBytes + " != written bytes: " + nexRecordbytesCount));
                    }
                    position += (long)(4 + readBytes);
                    readBytesCount += (long)readBytes;
                    ClusterMetricsProto.CombineMessageRequest.Builder requestBuilder = ClusterMetricsProto.CombineMessageRequest.newBuilder();
                    requestBuilder.mergeFrom(buf);
                    ++readRequestsCount;
                    int timedMetricsCount = requestBuilder.getTimedMetricCount();
                    long time = requestBuilder.getTimedMetric(0).getTimestamp();
                    System.out.println("Time: " + time + ", as Date: " + new Date(time));
                    for (ClusterMetricsProto.TimedMetric tMetric : requestBuilder.getTimedMetricList()) {
                        for (ClusterMetricsProto.Metric metric : tMetric.getMetricList()) {
                            ClusterMetricsProto.MetricAttributes mAttr;
                            if (metric.hasJobMetric()) {
                                ClusterMetricsProto.JobMetric jMetric = metric.getJobMetric();
                                if (jMetric.hasFinalMetric()) {
                                    // empty if block
                                }
                                if (jMetric.hasEventMetric()) {
                                    ClusterMetricsProto.JobMetric.EventMetric jEvent = jMetric.getEventMetric();
                                    if (jEvent.hasPriority()) {
                                        System.out.println("Priority : " + jEvent.getPriority());
                                    }
                                    if (jEvent.hasFailureInfo()) {
                                        System.out.println("FailInfo : " + jEvent.getFailureInfo());
                                    }
                                    if (jEvent.hasSchedulingInfo()) {
                                        System.out.println("ScheduleInfo : " + jEvent.getSchedulingInfo());
                                    }
                                    if (jEvent.hasStatus()) {
                                        System.out.println("Status : " + jEvent.getStatus());
                                    }
                                }
                                if (jMetric.hasAttributes()) {
                                    mAttr = jMetric.getAttributes();
                                    if (mAttr.hasJobId()) {
                                        System.out.println("Job ID : " + mAttr.getJobId());
                                    }
                                    if (mAttr.hasTaskId()) {
                                        System.out.println("Task ID : " + mAttr.getTaskId());
                                    }
                                    if (mAttr.hasTaskAttemptId()) {
                                        System.out.println("TAID : " + mAttr.getTaskAttemptId());
                                    }
                                }
                                for (ClusterMetricsProto.Counters counter : jMetric.getTimeBasedCountersList()) {
                                    System.out.println(counter.getCounterName() + " : " + counter.getCounterValue());
                                }
                            }
                            if (metric.hasTaskMetric()) {
                                ClusterMetricsProto.TaskMetric.EventMetric tEvent;
                                ClusterMetricsProto.TaskMetric taskMetric = metric.getTaskMetric();
                                if (taskMetric.hasFinalMetric()) {
                                    ClusterMetricsProto.TaskMetric.FinalMetric tFinal = taskMetric.getFinalMetric();
                                    if (tFinal.hasId()) {
                                        System.out.println("TASK ID : " + tFinal.getId());
                                    }
                                    if (tFinal.hasJobId()) {
                                        System.out.println("JOB ID : " + tFinal.getJobId());
                                    }
                                    if (tFinal.hasEndTime()) {
                                        System.out.println("Task End Time : " + tFinal.getEndTime());
                                    }
                                    if (tFinal.hasInputSplitInfo()) {
                                        System.out.println("InputSplit : " + tFinal.getInputSplitInfo());
                                    }
                                    if (tFinal.hasInputSplitLocations()) {
                                        System.out.println("InputSplitLoc : " + tFinal.getInputSplitLocations());
                                    }
                                    if (tFinal.hasStartTime()) {
                                        System.out.println("Task Start Time : " + tFinal.getStartTime());
                                    }
                                    if (tFinal.hasStatus()) {
                                        System.out.println("Task Status : " + tFinal.getStatus());
                                    }
                                    if (tFinal.hasSuccessTaskAttemptId()) {
                                        System.out.println("Success TA ID : " + tFinal.getSuccessTaskAttemptId());
                                    }
                                    if (tFinal.hasType()) {
                                        System.out.println("Task Type : " + tFinal.getType());
                                    }
                                }
                                if (taskMetric.hasEventMetric() && (tEvent = taskMetric.getEventMetric()).hasStatus()) {
                                    System.out.println("Task Status : " + tEvent.getStatus());
                                }
                            }
                            if (!metric.hasTAttemptMetric()) continue;
                            ClusterMetricsProto.TaskAttemptMetric taskAtMetric = metric.getTAttemptMetric();
                            if (taskAtMetric.hasAttributes() && (mAttr = taskAtMetric.getAttributes()).hasTaskAttemptId()) {
                                System.out.println("Task Attempt ID: " + mAttr.getTaskAttemptId());
                            }
                            if (taskAtMetric.hasProgressPercent()) {
                                System.out.println("TA Progress : " + taskAtMetric.getProgressPercent());
                            }
                            for (ClusterMetricsProto.Counters counter : taskAtMetric.getCountersList()) {
                                System.out.println(counter.getCounterName() + " : " + counter.getCounterValue());
                            }
                            if (taskAtMetric.hasEventMetric()) {
                                ClusterMetricsProto.TaskAttemptMetric.EventMetric tAEvent = taskAtMetric.getEventMetric();
                                if (tAEvent.hasState()) {
                                    System.out.println("Task Attempt State : " + tAEvent.getState());
                                }
                                if (tAEvent.hasStateString()) {
                                    System.out.println("Task Attempt State String : " + tAEvent.getStateString());
                                }
                                for (String diagn : tAEvent.getDiagnosticInfoList()) {
                                    System.out.println("DIAGNOSTIC : " + diagn);
                                }
                            }
                            if (!taskAtMetric.hasFinalMetric()) continue;
                            ClusterMetricsProto.TaskAttemptMetric.FinalMetric taFinal = taskAtMetric.getFinalMetric();
                            System.out.println("Task Attempt ID : " + taFinal.getId());
                            System.out.println("Task ID : " + taFinal.getTaskId());
                            if (taFinal.hasHost()) {
                                System.out.println("HOST : " + taFinal.getHost());
                            }
                            if (taFinal.hasFinishTime()) {
                                System.out.println("TA Finish : " + taFinal.getFinishTime());
                            }
                            if (taFinal.hasLogLocation()) {
                                System.out.println("Log Location : " + taFinal.getLogLocation());
                            }
                            if (taFinal.hasShuffleFinished()) {
                                System.out.println("Shuffle : " + taFinal.getShuffleFinished());
                            }
                            if (taFinal.hasSortFinished()) {
                                System.out.println("Sort : " + taFinal.getSortFinished());
                            }
                            if (taFinal.hasStartTime()) {
                                System.out.println("Start Time : " + taFinal.getStartTime());
                            }
                            if (taFinal.hasState()) {
                                System.out.println("Task Attempt State : " + taFinal.getState());
                            }
                            if (taFinal.hasType()) {
                                System.out.println("Type : " + taFinal.getType());
                            }
                            for (ClusterMetricsProto.Counters counter : taFinal.getCountersList()) {
                                System.out.println(counter.getCounterName() + " : " + counter.getCounterValue());
                            }
                        }
                    }
                    readMetrcisCount += timedMetricsCount;
                    LOG.info((Object)("MetricsCount: " + timedMetricsCount + ", at Time: " + new Date(time)));
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Metrics file not found. Path: " + metricsFile), (Throwable)e);
        }
        catch (EOFException e) {
            try {
                if (fsdis != null) {
                    fsdis.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("I/O Exception while reading metrics file. Path: " + metricsFile), (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception", t);
        }
        long after = System.currentTimeMillis();
        System.out.println("Time took to read file: " + (after - now) + " ms. for : " + readMetrcisCount + " of metrics" + ", requestsCount: " + readRequestsCount + ", readBytes: " + readBytesCount);
    }
}

