/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.schedulepolicy.commands;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchedulePolicyListCommand
extends CLIBaseClass
implements CLIInterface {
    private static final String SCHEDULE_LIST_PARAM = "list";
    public static final String CLDB_HOST = "cldbip";
    public static final String CLDB_PORT = "cldbport";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final Log LOG = LogFactory.getLog(SchedulePolicyListCommand.class);
    public static final CLICommand schedulePolicyListCommand = new CLICommand("list", "list available schedules ", SchedulePolicyListCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "output type: verbose or terse", false, "terse")).build(), null);

    public SchedulePolicyListCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        CLDBProto.SchedulePolicyProcRequest.Builder scheduleRequestBuilder = CLDBProto.SchedulePolicyProcRequest.newBuilder();
        scheduleRequestBuilder.setPolicyOp(CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP.LIST);
        CLDBProto.Policy.Builder policyBuilder = CLDBProto.Policy.newBuilder();
        scheduleRequestBuilder.setPolicy(policyBuilder.build());
        byte[] data = null;
        try {
            scheduleRequestBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class);
            if (data == null) {
                LOG.error((Object)"RPC Request to list Schedule Policies failed. No data returned");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return co;
            }
            CLDBProto.SchedulePolicyProcResponse resp = CLDBProto.SchedulePolicyProcResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 1) {
                LOG.error((Object)"RPC to list Schedule Policies failed");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Not enough privileges to view the list of schedules."));
                return co;
            }
            if (resp.getStatus() != 0) {
                LOG.error((Object)"RPC to list Schedule Policies failed");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to list Schedule Policies failed"));
                return co;
            }
            List policies = resp.getPoliciesList();
            for (CLDBProto.Policy policy : policies) {
                CommandOutput.OutputHierarchy.OutputNode mainNode = new CommandOutput.OutputHierarchy.OutputNode();
                CommandOutput.OutputHierarchy.OutputNode policyNodeId = new CommandOutput.OutputHierarchy.OutputNode("id", policy.getPolicyId());
                CommandOutput.OutputHierarchy.OutputNode policyNodeName = new CommandOutput.OutputHierarchy.OutputNode("name", (Object)policy.getPolicyName());
                CommandOutput.OutputHierarchy.OutputNode policyNodeInUse = new CommandOutput.OutputHierarchy.OutputNode("inuse", policy.getVolumeIdCount() > 0 ? 1 : 0);
                mainNode.addChild(policyNodeId);
                mainNode.addChild(policyNodeName);
                mainNode.addChild(policyNodeInUse);
                List rules = policy.getPolicyRulesList();
                mainNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("rules"));
                for (CLDBProto.PolicyRule rule : rules) {
                    CommandOutput.OutputHierarchy.OutputNode policyNodeRules = new CommandOutput.OutputHierarchy.OutputNode("rules");
                    policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("frequency", (Object)rule.getFrequency().name()));
                    if (rule.hasDate()) {
                        policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("date", (Object)rule.getDate()));
                    }
                    if (rule.hasTime()) {
                        policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("time", rule.getTime()));
                    }
                    if (rule.hasMinutes()) {
                        policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("minute", rule.getMinutes()));
                    }
                    policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("retain", (Object)(rule.getRetainTime().getNumberOfUnits() + rule.getRetainTime().getTimeUnitsEnum().name())));
                    mainNode.addChild(policyNodeRules);
                }
                ch.addNode(mainNode);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"RPC Request to list Schedule Policies failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to to list Schedule Policies. No data returned"));
            return co;
        }
        return co;
    }
}

