/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.marlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.streams.impl.admin.AssignInfo;
import com.mapr.streams.impl.admin.MarlinAdmin;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class AssignCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(AssignCommands.class);
    private static final String LISTENER_GROUP_PARAM_NAME = "consumergroup";
    private static final String PATH_PARAM_NAME = "path";
    private static final String TOPIC_PARAM_NAME = "topic";
    private static final String PARTITION_PARAM_NAME = "partition";
    private static final String DETAIL_PARAM_NAME = "detail";
    private static final CLICommand listCommand = new CLICommand("list", "usage: stream assign list -path <path> -consumergroup <consumer group Id> -topic <topic> -partition <partitionId>", AssignCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"consumergroup", (Object)new TextInputParameter("consumergroup", "Consumer Group ID", false, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", false, null)).put((Object)"partition", (Object)new IntegerInputParameter("partition", "Partition ID", false, null)).put((Object)"detail", (Object)new NoValueInputParameter("detail", "Detail", false, false)).build(), null).setShortUsage("stream assign list -path <path>");
    public static final CLICommand assignCommands = new CLICommand("assign", "assign [list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listCommand}).setShortUsage("stream assign [list]");

    public AssignCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listTopics(out);
        }
        return output;
    }

    private void listTopics(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            Configuration conf = new Configuration();
            String listenerGID = null;
            String topicName = null;
            int feedId = -1;
            if (this.isParamPresent(TOPIC_PARAM_NAME)) {
                topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            }
            if (this.isParamPresent(LISTENER_GROUP_PARAM_NAME)) {
                listenerGID = this.getParamTextValue(LISTENER_GROUP_PARAM_NAME, 0);
            }
            boolean detail = this.isParamPresent(DETAIL_PARAM_NAME);
            MarlinAdmin madmin = new MarlinAdmin(conf);
            List assignList = madmin.listAssigns(streamName, listenerGID, topicName);
            for (AssignInfo ci : assignList) {
                String[] listenerList = ci.listeners();
                for (int i = 0; i < ci.numListeners(); ++i) {
                    List assignments = ci.listenerAssignment(i);
                    CommandOutput.OutputHierarchy.OutputNode assignNode = new CommandOutput.OutputHierarchy.OutputNode();
                    assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(LISTENER_GROUP_PARAM_NAME, (Object)ci.listenerID()));
                    assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPIC_PARAM_NAME, (Object)ci.topic()));
                    if (detail) {
                        assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("assignseqnum", ci.assignSeqNum()));
                    }
                    String[] consumer = listenerList[i].split(":", 4);
                    int ipAdd = Integer.parseInt(consumer[1]);
                    byte[] bytes = BigInteger.valueOf(ipAdd).toByteArray();
                    InetAddress addr = InetAddress.getByAddress(bytes);
                    if (detail) {
                        assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumerguid", (Object)consumer[0]));
                    }
                    assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumer", (Object)consumer[3]));
                    assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumerip", (Object)addr.getHostAddress()));
                    assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumerpid", (Object)consumer[2]));
                    String assignStr = "";
                    boolean isFirst = true;
                    for (Integer p : assignments) {
                        if (isFirst) {
                            assignStr = "" + p;
                            isFirst = false;
                            continue;
                        }
                        assignStr = assignStr + "," + p;
                    }
                    assignNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("assignment", (Object)assignStr));
                    out.addNode(assignNode);
                }
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }
}

