/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.VolumeCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import org.apache.log4j.Logger;

public class VolumeContainerCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String VOLUME_CID_PARAM_NAME = "cid";
    private static final String VOLUME_FROMFS_PARAM_NAME = "fromfileserverid";
    private static final String VOLUME_TOFS_PARAM_NAME = "tofileserverid";
    private static final Logger LOG = Logger.getLogger(VolumeContainerCommands.class);
    public static final String moveContainerUsage = "volume container move [ -cluster cluster_name ] -cid cid -fromfileserverid fromfileserverid [ -tofileserverid tofileserverid ]";
    public static final String switchMasterUsage = "volume container switchmaster -cid cid";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand moveContainerCommand = new CLICommand("move", "", VolumeContainerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"cid", (Object)new IntegerInputParameter("cid", "cid", true, null)).put((Object)"fromfileserverid", (Object)new LongInputParameter("fromfileserverid", "fromfileserverid", true, null)).put((Object)"tofileserverid", (Object)new LongInputParameter("tofileserverid", "tofileserverid", false, null)).build(), null).setShortUsage("volume container move [ -cluster cluster_name ] -cid cid -fromfileserverid fromfileserverid [ -tofileserverid tofileserverid ]");
    static final CLICommand switchMasterCommand = new CLICommand("switchmaster", "usage : volume container switchmaster -cid cid", VolumeContainerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"cid", (Object)new IntegerInputParameter("cid", "cid", true, null)).build(), null).setShortUsage("volume container switchmaster -cid cid");
    public static CLICommand[] containerCommandsArray = new CLICommand[]{moveContainerCommand, switchMasterCommand};
    public static CLICommand containerCommands = new CLICommand("container", "containe", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, containerCommandsArray).setShortUsage("volume container [move]");
    static final CLICommand switchMaster = new CLICommand("switchmaster", "usage : volume container switchmaster -cid cid", VolumeContainerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"cid", (Object)new IntegerInputParameter("cid", "cid", true, null)).build(), null).setShortUsage("volume container switchmaster -cid cid");

    public VolumeContainerCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        if (!super.validateInput()) {
            return this.output;
        }
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(moveContainerCommand.getCommandName())) {
                return this.moveContainer();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(switchMasterCommand.getCommandName())) {
                return this.switchMaster();
            }
            return new TextCommandOutput("volume unknown sub-command".getBytes());
        }
        catch (Exception e) {
            throw new CLIProcessingException("Move Container Exception", (Throwable)e);
        }
    }

    private CommandOutput moveContainer() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        int cid = this.getParamIntValue(VOLUME_CID_PARAM_NAME, 0);
        long fromfsid = this.getParamLongValue(VOLUME_FROMFS_PARAM_NAME, 0);
        boolean done = false;
        CLDBProto.ContainerMoveReplicaRequest.Builder reqb = CLDBProto.ContainerMoveReplicaRequest.newBuilder().setCid(cid).setFromServer(fromfsid).setCreds(this.getUserCredentials());
        if (this.isParamPresent(VOLUME_TOFS_PARAM_NAME)) {
            long tofsid = this.getParamLongValue(VOLUME_TOFS_PARAM_NAME, 0);
            reqb.setToServer(tofsid);
        }
        CLDBProto.ContainerMoveReplicaRequest req = reqb.build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerMoveReplicaProc.getNumber(), (MessageLite)req, CLDBProto.ContainerMoveReplicaResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
                return output;
            }
            CLDBProto.ContainerMoveReplicaResponse resp = CLDBProto.ContainerMoveReplicaResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() == 0) {
                done = true;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "MoveContainer failed, Error : " + Errno.toString(resp.getStatus())));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Container move failed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
            return output;
        }
        if (done) {
            return new TextCommandOutput("MoveContainer done".getBytes());
        }
        return output;
    }

    private CommandOutput switchMaster() throws CLIProcessingException {
        String spid;
        byte[] replyData;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int cid = this.getParamIntValue(VOLUME_CID_PARAM_NAME, 0);
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
                return output;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Container lookup failed, Error : " + Errno.toString(resp.getStatus())));
                return output;
            }
            spid = resp.getContainers(0).getMServer().getSpInfo().getSpId();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
            return output;
        }
        boolean done = false;
        CLDBProto.ContainerSwitchMasterRequest req = CLDBProto.ContainerSwitchMasterRequest.newBuilder().setCid(cid).setMasterSpid(spid).setCreds(this.getUserCredentials()).build();
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerSwitchMasterProc.getNumber(), (MessageLite)req, CLDBProto.ContainerSwitchMasterResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
                return output;
            }
            CLDBProto.ContainerSwitchMasterResponse resp = CLDBProto.ContainerSwitchMasterResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() == 0) {
                done = true;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "switchmaster failed, Error : " + Errno.toString(resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container switchmaster failed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
            return output;
        }
        if (done) {
            return new TextCommandOutput("Switched master".getBytes());
        }
        return output;
    }
}

