/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.EulaCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.License;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UserConfigCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String USER_PARAM_NAME = "username";
    public static final String SUPERUSER_PARAM = "mapr.fs.permissions.superuser";
    private static final Logger LOG = Logger.getLogger(UserConfigCommands.class);
    Properties CLDBProperties = new Properties();
    long binding = 0L;
    static final CLICommand loadCmd = new CLICommand("load", "", UserConfigCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"username", (Object)new TextInputParameter("username", "username", true, "")).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("userconfig load -username <username>");
    public static final CLICommand userconfigCmds = new CLICommand("userconfig", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{loadCmd}).setUsageInVisible(true).setShortUsage("userconfig [load]");

    public UserConfigCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    void fetchUserInfo(String user, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(USER_PARAM_NAME, (Object)user));
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return;
            }
        }
        MapRCliUtil.fetchCLDBParams(cluster, this.CLDBProperties, this.getUserCredentials());
        int fsadmin = 0;
        String fsadminStr = this.CLDBProperties.getProperty(SUPERUSER_PARAM);
        if (fsadminStr != null && fsadminStr.equalsIgnoreCase(user)) {
            fsadmin = 1;
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("fsadmin", fsadmin));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("mradmin", 1));
        License.EulaShowAcceptResponse resp = EulaCommands.fetchEula(cluster);
        if (resp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString(status)));
        } else if (resp.hasAcceptedUser()) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("eulauser", (Object)resp.getAcceptedUser()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("eulatime", resp.getAcceptedTime()));
        }
        out.addNode(node);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String user;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("load") && (user = this.getParamTextValue(USER_PARAM_NAME, 0)) != null && !user.isEmpty()) {
            this.fetchUserInfo(user, out);
        }
        return output;
    }
}

