/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BlacklistCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String USER_BLACKLIST_CMD = "user";
    private static final String LIST_USERS_BLACKLIST_CMD = "listusers";
    private static final String TYPE_PARAM_NAME = "type";
    private static final String CLUSTER_PARAM_NAME = "cluster";
    private static final String NAME_PARAM = "name";
    private static final Logger LOG = Logger.getLogger(BlacklistCommands.class);
    private UnixUserGroupHelper userInfo;
    static final CLICommand userBlacklistCmd = new CLICommand("user", "Adds the entity to blacklist", BlacklistCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "username to be blacklisted", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "name of the cluster", false, null)).build(), null).setShortUsage("user -name usernameToBlacklist -cluster cluster name");
    static final CLICommand listUsersBlacklistCmd = new CLICommand("listusers", "lists blacklisted users", BlacklistCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "name of the cluster", false, null)).build(), null).setShortUsage("listusers -cluster clustername");
    static final CLICommand[] blacklistSubCommands = new CLICommand[]{userBlacklistCmd, listUsersBlacklistCmd};
    static final String usageStr = "blacklist [user|listusers]";
    public static final CLICommand blacklistCommands = new CLICommand("blacklist", "usage: blacklist [user|listusers]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, blacklistSubCommands).setShortUsage("blacklist [user|listusers]");

    public BlacklistCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase(USER_BLACKLIST_CMD)) {
            return this.addUserToBlacklist();
        }
        if (command.equalsIgnoreCase(LIST_USERS_BLACKLIST_CMD)) {
            return this.listBlacklistedUsers();
        }
        return new TextCommandOutput(("Blacklist command failed: unknown command " + command + " received.").getBytes());
    }

    private CommandOutput addUserToBlacklist() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        try {
            CLDBProto.BlacklistAddRequest.Builder addRequestBuilder = CLDBProto.BlacklistAddRequest.newBuilder();
            Security.CredentialsMsg creds = this.getUserCredentials();
            addRequestBuilder.setCreds(creds);
            String username = this.getParamTextValue(NAME_PARAM, 0);
            addRequestBuilder.setName(username);
            addRequestBuilder.setType(CLDBProto.BlacklistAddRequest.EntityType.USER);
            byte[] data = null;
            data = this.isParamPresent(CLUSTER_PARAM_NAME) ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue(CLUSTER_PARAM_NAME, 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.BlacklistAddProc.getNumber(), (MessageLite)addRequestBuilder.build(), CLDBProto.BlacklistAddResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.BlacklistAddProc.getNumber(), (MessageLite)addRequestBuilder.build(), CLDBProto.BlacklistAddResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not connect to CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.BlacklistAddResponse resp = CLDBProto.BlacklistAddResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, resp.getErrMsg()));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to blacklist a user"));
            output.setOutput(out);
            return output;
        }
        return output;
    }

    private CommandOutput listBlacklistedUsers() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        this.userInfo = new UnixUserGroupHelper();
        try {
            CLDBProto.BlacklistListRequest.Builder listRequestBuilder = CLDBProto.BlacklistListRequest.newBuilder();
            Security.CredentialsMsg creds = this.getUserCredentials();
            listRequestBuilder.setCreds(creds);
            listRequestBuilder.setType(CLDBProto.BlacklistListRequest.EntityType.USER);
            byte[] data = null;
            data = this.isParamPresent(CLUSTER_PARAM_NAME) ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue(CLUSTER_PARAM_NAME, 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.BlacklistListProc.getNumber(), (MessageLite)listRequestBuilder.build(), CLDBProto.BlacklistListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.BlacklistListProc.getNumber(), (MessageLite)listRequestBuilder.build(), CLDBProto.BlacklistListResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not connect to CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.BlacklistListResponse resp = CLDBProto.BlacklistListResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, resp.getErrMsg()));
                output.setOutput(out);
                return output;
            }
            String[] headers = new String[]{"Username", "BlacklistTime"};
            output.setNodeOrder(headers);
            int blacklistedAeCount = resp.getBlacklistedAesCount();
            CommandOutput.OutputHierarchy.OutputNode node = null;
            for (int index = 0; index < blacklistedAeCount; ++index) {
                node = new CommandOutput.OutputHierarchy.OutputNode();
                CLDBProto.BlacklistedAeMsg entry = resp.getBlacklistedAes(index);
                try {
                    node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Username", (Object)this.userInfo.getUsername(entry.getId())));
                }
                catch (SecurityException ignore) {
                    node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Username", (Object)("Unknown user id " + entry.getId())));
                }
                node.addNode(new CommandOutput.OutputHierarchy.OutputNode("BlacklistTime", (Object)new Date(entry.getBlacklistTime())));
                out.addNode(node);
            }
            output.setOutput(out);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            output.setOutput(out);
            return output;
        }
        return output;
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

