/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.FileOutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class UserSubjectTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void UserSubjectTest1() throws Exception {
        UserGroupInformation oldUser = UserGroupInformation.getCurrentUser();
        oldUser.addCredentials(new Credentials());
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)"testuser", (UserGroupInformation)oldUser);
        Void retNothing = (Void)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                UserGroupInformation newUser = UserGroupInformation.getCurrentUser();
                Credentials creds = newUser.getCredentials();
                System.out.println(creds);
                return null;
            }
        });
    }

    @Test
    public void generateTicketNewWay() throws Exception {
        Security.Key k = Security.GenerateRandomKey();
        MutableInt err = new MutableInt();
        byte[] fileData = Security.EncodeDataForWritingToKeyFile((byte[])k.toByteArray(), (MutableInt)err);
        FileOutputStream fout = new FileOutputStream("/tmp/cldb.key");
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.close();
        Security.Key serverKey = Security.GetServerKey((Security.Key)k, (long)0L);
        int[] gids2 = new int[]{0x7FFFFFF0, 42};
        Security.TicketAndKey serverTicketKey = UserSubjectTest.helperFunction(Security.ServerKeyType.CldbKey, k, gids2, 0x7FFFFFF0, "mapr", err);
        ByteString encrMaprServerTicket = serverTicketKey.getEncryptedTicket();
        Security.TicketAndKey maprTicketKey = UserSubjectTest.helperFunction(Security.ServerKeyType.ServerKey, serverKey, gids2, 0x7FFFFFF0, "mapr", err);
        ByteString encrMaprTicket = maprTicketKey.getEncryptedTicket();
        int[] gids = new int[]{0, 42};
        Security.TicketAndKey rootTicketEncryptedWithServerKey = UserSubjectTest.helperFunction(Security.ServerKeyType.ServerKey, serverKey, gids, 0, "root", err);
        ByteString encrRootTicket = rootTicketEncryptedWithServerKey.getEncryptedTicket();
        int[] gids1 = new int[]{1007};
        Security.TicketAndKey testTicketEncryptedWithServerKey = UserSubjectTest.helperFunction(Security.ServerKeyType.ServerKey, serverKey, gids1, 1006, "test", err);
        ByteString encrTestTicket = testTicketEncryptedWithServerKey.getEncryptedTicket();
    }

    private static Security.TicketAndKey helperFunction(Security.ServerKeyType keyType, Security.Key key, int[] gids, int uid, String userName, MutableInt err) {
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKeyUsingServerKey((Security.ServerKeyType)keyType, (Security.Key)key, (String)userName, (int)uid, (int[])gids, (long)(System.currentTimeMillis() / 1000L + 345600L), (long)0L, (boolean)false, (MutableInt)err);
        System.out.println(Security.TicketAndKeyToString((String)"TicketAndKey", (Security.TicketAndKey)ticketAndKey));
        try {
            byte[] fileData = Security.EncodeDataForWritingToKeyFile((byte[])ticketAndKey.toByteArray(), (MutableInt)err);
            System.out.println("Encoded data is " + new String(fileData, "US-ASCII"));
            String fileName = "/tmp/maprticket_" + uid;
            if (keyType == Security.ServerKeyType.CldbKey) {
                fileName = "/tmp/maprserverticket";
            }
            FileOutputStream fos = new FileOutputStream(fileName);
            fos.write("default ".getBytes("UTF-8"));
            fos.write(fileData);
            fos.close();
            Security.SetTicketAndKeyFile((String)("/tmp/maprticket_" + uid));
            Security.TicketAndKey ticketAndKey1 = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.CldbKey, (String)"default", (MutableInt)err);
            System.out.println(Security.TicketAndKeyToString((String)"TicketAndKey", (Security.TicketAndKey)ticketAndKey1));
            System.out.println("Ticket Expiry time (seconds since epoch) : " + ticketAndKey1.getExpiryTime() + "," + new Date(ticketAndKey1.getExpiryTime() * 1000L).toString());
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
        return ticketAndKey;
    }

    @Test
    public void getTicketFrommaprServerTicket() {
        MutableInt err = new MutableInt();
        Security.SetTicketAndKeyFile((String)"/tmp/maprserverticket");
        Security.TicketAndKey ticketKey = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.CldbKey, (String)"default", (MutableInt)err);
        Security.Key key = ticketKey.getUserKey();
        int[] gids2 = new int[]{0x7FFFFFF0, 42};
        Security.TicketAndKey maprTicketKey = UserSubjectTest.helperFunction(Security.ServerKeyType.MfsUtilKey, key, gids2, 0x7FFFFFF0, "mapr", err);
    }
}

