/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.schedulepolicy.commands;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchedulePolicyRemoveCommand
extends CLIBaseClass
implements CLIInterface {
    private static final String SCHEDULE_MODIFY_PARAM = "remove";
    private static final String SCHEDULE_ID_PARAM = "id";
    public static final String CLDB_HOST = "cldbip";
    public static final String CLDB_PORT = "cldbport";
    public static final Log LOG = LogFactory.getLog(SchedulePolicyRemoveCommand.class);
    public static final CLICommand schedulePolicyRemoveCommand = new CLICommand("remove", "modify schedule ", SchedulePolicyRemoveCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"id", (Object)new IntegerInputParameter("id", "id of schedule policy", true, null)).build(), null);

    public SchedulePolicyRemoveCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        CLDBProto.SchedulePolicyProcRequest.Builder scheduleRequestBuilder = CLDBProto.SchedulePolicyProcRequest.newBuilder();
        scheduleRequestBuilder.setPolicyOp(CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP.REMOVE);
        CLDBProto.Policy.Builder policyBuilder = CLDBProto.Policy.newBuilder();
        int policyId = this.getParamIntValue(SCHEDULE_ID_PARAM, 0);
        policyBuilder.setPolicyId(policyId);
        scheduleRequestBuilder.setPolicy(policyBuilder.build());
        byte[] data = null;
        try {
            scheduleRequestBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class);
            if (data == null) {
                LOG.error((Object)"RPC Request to create Schedule Policy failed. No data returned");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return co;
            }
            CLDBProto.SchedulePolicyProcResponse resp = CLDBProto.SchedulePolicyProcResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                if (resp.getStatus() == 1000) {
                    LOG.error((Object)"Cannot remove schedule, as some volumes are still using it.");
                    ch.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Can not remove schedule, as some volumes are still using it."));
                } else {
                    LOG.error((Object)("RPC Request to remove Schedule Policy failed with error: " + Errno.toString(resp.getStatus())));
                    ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to remove Schedule Policy with error: " + Errno.toString(resp.getStatus())));
                }
                return co;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"RPC Request to remove Schedule Policy failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to remove Schedule Policy failed. No data returned"));
            return co;
        }
        return co;
    }
}

