/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterProcessingException;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SnapshotCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(SnapshotCommands.class);
    private static final int NUM_SNAPSHOTS_PER_RPC = 40;
    public static final String SNAPSHOT_PARAM_VOL_NAME = "volume";
    public static final String SNAPSHOT_PARAM_VOL_PATH = "path";
    public static final String RW_VOLUME_PARAM_NAME = "volume";
    public static final String RW_VOLUME_PARAM_MOUNTDIR = "path";
    public static final String SNAPSHOT_PARAM_NAME = "snapshotname";
    public static final String SNAPSHOTS_ID_PARAM_NAME = "snapshots";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static int MAX_SNAPFIELDINFO = 0;
    public static String snapshotListUsage = "volume snapshot list [-filter filters -cluster clustername]";
    public static final String snapshotCreateUsage = "volume snapshot -volume volName -snapshot snapshotName [-cluster clustername]";
    public static String snapshotRemoveUsage = "volume snapshot remove [-volume volumename] [-snapshotname snapshotName] [-snapshots comma separated IDs of snapshots]";
    public static String snapshotPreserveUsage = "volume snapshot preserve [-volume volumenames] [-path volumepathes] [-snapshots comma separated IDs of snapshots]";
    static final CLICommand snapshotCreateCommand = new CLICommand("create", "usage : volume snapshot -volume volName -snapshot snapshotName [-cluster clustername]", SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"snapshotname", (Object)new TextInputParameter("snapshotname", "snapshotName", true, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "volume", true, null)).build(), null).setShortUsage("volume snapshot -volume volName -snapshot snapshotName [-cluster clustername]");
    static final CLICommand snapshotRemoveCommand = new CLICommand("remove", "usage : " + snapshotRemoveUsage, SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"snapshotname", (Object)new TextInputParameter("snapshotname", "snapshotName", false, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "volumeName", false, null)).put((Object)"snapshots", (Object)new TextInputParameter("snapshots", "comma separated IDs of snapshots", false, null)).build(), null).setShortUsage(snapshotRemoveUsage);
    static final CLICommand snapshotPreserveCommand = new CLICommand("preserve", "usage : " + snapshotPreserveUsage, SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "comma separated volume names to preserve snapshots for", false, null)).put((Object)"path", (Object)new TextInputParameter("path", "comma separated volume pathes to preserve snapshots for", false, null)).put((Object)"filter", (Object)new TextInputParameter("filter", "filter to preserve snapshots for", false, null)).put((Object)"snapshots", (Object)new TextInputParameter("snapshots", "comma separated IDs of snapshots to preserve", false, null)).build(), null).setShortUsage(snapshotPreserveUsage);
    static final CLICommand snapshotListCommand = new CLICommand("list", "usage : " + snapshotListUsage, SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "volume", false, null)).put((Object)"path", (Object)new TextInputParameter("path", "path", false, null)).put((Object)"sort", (Object)new TextInputParameter("sort", "none", false, "none").setInvisible(true)).put((Object)"dir", (Object)new TextInputParameter("dir", "none", false, "ASC").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose", false, "verbose")).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"filter", (Object)new TextInputParameter("filter", "none", false, "none")).put((Object)"columns", (Object)new TextInputParameter("columns", "none", false, "none")).build(), null).setShortUsage(snapshotListUsage);
    public static Map<CLDBProto.SnapshotInfoFields, FieldInfo> snapshotFieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.SnapshotInfoFields.rwVolumeId, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.rwVolumeId.getNumber(), "vid", "volumeid", Integer.class)).put((Object)CLDBProto.SnapshotInfoFields.snapshotId, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.snapshotId.getNumber(), "id", "snapshotid", Integer.class)).put((Object)CLDBProto.SnapshotInfoFields.snapshotName, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.snapshotName.getNumber(), "n", "snapshotname", String.class)).put((Object)CLDBProto.SnapshotInfoFields.rwVolumeName, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.rwVolumeName.getNumber(), "vn", "volumename", String.class)).put((Object)CLDBProto.SnapshotInfoFields.volumePath, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.volumePath.getNumber(), "vp", "volumepath", String.class)).put((Object)CLDBProto.SnapshotInfoFields.ownerName, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.ownerName.getNumber(), "on", "ownername", String.class)).put((Object)CLDBProto.SnapshotInfoFields.ownerType, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.ownerType.getNumber(), "ot", "ownertype", Integer.class)).put((Object)CLDBProto.SnapshotInfoFields.creationTime, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.creationTime.getNumber(), "ct", "creationtime", Long.class)).put((Object)CLDBProto.SnapshotInfoFields.expiryTime, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.expiryTime.getNumber(), "et", "expirytime", Long.class)).put((Object)CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB.getNumber(), "cs", "cumulativeReclaimSizeMB", Long.class)).build();
    public static CLICommand[] snapshotCommandsArray;
    public static CLICommand snapshotCommands;
    UnixUserGroupHelper uInfo = new UnixUserGroupHelper();

    public SnapshotCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        LOG.debug((Object)"Processing CLDBProcessing::executeRealCommand");
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            this.list(out);
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.snapshotCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                return this.snapshotRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("preserve")) {
            try {
                return this.snapshotPreserve();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Volume command failed".getBytes());
    }

    CommandOutput snapshotRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (this.isParamPresent(SNAPSHOTS_ID_PARAM_NAME)) {
            String[] ids;
            String snapshotIds = this.getParamTextValue(SNAPSHOTS_ID_PARAM_NAME, 0);
            for (String id : ids = snapshotIds.split(",")) {
                CLDBProto.SnapshotRemoveRequest.Builder snapshotRemove = CLDBProto.SnapshotRemoveRequest.newBuilder();
                try {
                    snapshotRemove.setSnapshotId(Integer.valueOf(id).intValue());
                }
                catch (NumberFormatException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing snapshot IDs"));
                    break;
                }
                int status = this.snapshotRemoveInternal(snapshotRemove);
                if (status == 0) {
                    LOG.info((Object)("Snapshot removed for " + id));
                    continue;
                }
                LOG.error((Object)("Snapshot remove failed with status " + status));
                if (status == 115) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Remove: Operation failed, snapshot can't be created or removed when mirroring is in progress for the volume"));
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Snapshot Remove:  " + Errno.toString(status)));
            }
        }
        if (this.isParamPresent("volume") && this.isParamPresent(SNAPSHOT_PARAM_NAME)) {
            String rwVolumeName = this.getParamTextValue("volume", 0);
            String snapshotName = this.getParamTextValue(SNAPSHOT_PARAM_NAME, 0);
            CLDBProto.SnapshotRemoveRequest.Builder snapshotRemove = CLDBProto.SnapshotRemoveRequest.newBuilder();
            snapshotRemove.setRemoveNow(true).setRwVolumeName(rwVolumeName).setSnapshotName(snapshotName);
            int status = this.snapshotRemoveInternal(snapshotRemove);
            if (status == 0) {
                LOG.info((Object)("Snapshot removed for volume " + rwVolumeName + " snapshot name " + snapshotName));
            } else {
                LOG.error((Object)("Snapshot for volume " + rwVolumeName + " snapshot name " + snapshotName + " failed with status " + status));
                if (status == 115) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Remove: Operation failed, snapshot can't be created or removed when mirroring is in progress for the volume"));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Snapshot Remove:  " + Errno.toString(status)));
                }
            }
        }
        if (!(this.isParamPresent("volume") && this.isParamPresent(SNAPSHOT_PARAM_NAME) || this.isParamPresent(SNAPSHOTS_ID_PARAM_NAME))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify both snapshot name and volume name, or just snapshot id.\n" + snapshotRemoveUsage));
        }
        return output;
    }

    private int snapshotRemoveInternal(CLDBProto.SnapshotRemoveRequest.Builder snapshotRemoveBuilder) throws CLIProcessingException {
        byte[] data = null;
        try {
            snapshotRemoveBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotRemoveProc.getNumber(), (MessageLite)snapshotRemoveBuilder.build(), CLDBProto.SnapshotRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotRemoveProc.getNumber(), (MessageLite)snapshotRemoveBuilder.build(), CLDBProto.SnapshotRemoveResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.SnapshotRemoveResponse resp = CLDBProto.SnapshotRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)"Snapshot removed succeded ");
                return 0;
            }
            LOG.error((Object)("Snapshot remove  failed with status " + resp.getStatus()));
            return resp.getStatus();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Send request Exception", (Throwable)e);
            return 10003;
        }
    }

    CommandOutput snapshotPreserve() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        boolean isVolumeParamPresent = this.isParamPresent("volume");
        boolean isPathParamPresent = this.isParamPresent("path");
        boolean isFilterParamPresent = this.isParamPresent(FILTER_PARAM_NAME);
        boolean isSnapshotIdspParamPresent = this.isParamPresent(SNAPSHOTS_ID_PARAM_NAME);
        if (!(isVolumeParamPresent || isPathParamPresent || isFilterParamPresent || isSnapshotIdspParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Neither of parameters is passed."));
            return output;
        }
        CLDBProto.SnapshotsPreserveRequest.Builder snapPreserveReqBuilder = CLDBProto.SnapshotsPreserveRequest.newBuilder();
        if (isVolumeParamPresent) {
            String volumeNamesStr = this.getParamTextValue("volume", 0);
            String[] volumeNames = volumeNamesStr.split(",");
            if (volumeNames == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volumes were not provided").setField("volume"));
                return output;
            }
            for (String volumeName : volumeNames) {
                CLDBProto.SnapshotInfo sInfo = CLDBProto.SnapshotInfo.newBuilder().setRwVolumeName(volumeName).build();
                snapPreserveReqBuilder.addSnapshotInfos(sInfo);
            }
        } else if (isSnapshotIdspParamPresent) {
            String snapshotStringIdsStr = this.getParamTextValue(SNAPSHOTS_ID_PARAM_NAME, 0);
            String[] snapshotStringIds = snapshotStringIdsStr.split(",");
            if (snapshotStringIds == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "SnapshotIds were not provided").setField(SNAPSHOTS_ID_PARAM_NAME));
                return output;
            }
            for (String snapshotIdStr : snapshotStringIds) {
                try {
                    Integer snapId = Integer.valueOf(snapshotIdStr);
                    CLDBProto.SnapshotInfo sInfo = CLDBProto.SnapshotInfo.newBuilder().setSnapshotId(snapId.intValue()).build();
                    snapPreserveReqBuilder.addSnapshotInfos(sInfo);
                }
                catch (NumberFormatException nfe) {
                    LOG.error((Object)("SnapshotID is not Integer: " + snapshotIdStr + ". Processing the rest"));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "SnapshotID is not Integer: " + snapshotIdStr + ". Processing the rest"));
                }
            }
        } else if (isFilterParamPresent) {
            List filters = new ArrayList();
            String filterString = this.getParamTextValue(FILTER_PARAM_NAME, 0);
            if (filterString != null && !filterString.equals("none")) {
                try {
                    ArrayList<String> filterStrings = new ArrayList<String>();
                    filterStrings.add(filterString);
                    filters = FilterUtil.compileFilter(snapshotFieldTable, filterStrings);
                }
                catch (FilterProcessingException fpe) {
                    LOG.error((Object)("Exception while processing filter parameter: " + filterString), (Throwable)fpe);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while processing filter parameter: " + filterString).setField(FILTER_PARAM_NAME));
                }
            }
            snapPreserveReqBuilder.addAllFilter(filters);
        } else if (isPathParamPresent) {
            String svolumePathesStr = this.getParamTextValue("path", 0);
            String[] volumePathes = svolumePathesStr.split(",");
            if (volumePathes == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Paths were not provided").setField("path"));
                return output;
            }
            snapPreserveReqBuilder.addAllRwVolumePath(Arrays.asList(volumePathes));
        }
        byte[] data = null;
        try {
            snapPreserveReqBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotsPreserveProc.getNumber(), (MessageLite)snapPreserveReqBuilder.build(), CLDBProto.SnapshotsPreserveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotsPreserveProc.getNumber(), (MessageLite)snapPreserveReqBuilder.build(), CLDBProto.SnapshotsPreserveResponse.class);
            if (data == null) {
                LOG.error((Object)"SnapshotPreserve : Exception while processing RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service to do SnapshotPreserve"));
                return output;
            }
            CLDBProto.SnapshotsPreserveResponse resp = CLDBProto.SnapshotsPreserveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0 || resp.getStatus() == 9) {
                if (resp.getVolumesWithoutPermsCount() > 0) {
                    String warnMsg = "Warning: Caller does not have permissions for volumes ";
                    boolean addComma = false;
                    for (String volName : resp.getVolumesWithoutPermsList()) {
                        if (addComma) {
                            warnMsg = warnMsg + ", " + volName;
                            continue;
                        }
                        warnMsg = warnMsg + volName;
                        addComma = true;
                    }
                    out.addMessage(warnMsg);
                }
            } else if (resp.getStatus() == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to preserve snapshots since the caller does not have privileges"));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshots Preserve Operation failed"));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while trying to preserve snapshots", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Exception while trying to preserve snapshots"));
        }
        return output;
    }

    private BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet(snapshotFieldTable.size());
        columns.set(0, MAX_SNAPFIELDINFO + 1);
        String columnsString = this.getParamTextValue(COLUMNS_PARAM_NAME, 0);
        if (columnsString != null && !columnsString.equals("none")) {
            columns = FilterUtil.getColumns(snapshotFieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    private CLDBProto.SnapshotListRequest.Builder getSnapshotListRequestBuilder() throws CLIProcessingException {
        CLDBProto.SnapshotListRequest.Builder snapList = CLDBProto.SnapshotListRequest.newBuilder();
        snapList.addAllFilter(this.getFilters(snapshotFieldTable, FILTER_PARAM_NAME));
        snapList.setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 40));
        snapList.setCreds(this.getUserCredentials());
        if (this.isParamPresent("volume")) {
            String volumeNames = this.getParamTextValue("volume", 0);
            snapList.addAllRwVolumeNames(Arrays.asList(volumeNames.split(",")));
        } else if (this.isParamPresent("path")) {
            String volumePaths = this.getParamTextValue("path", 0);
            snapList.addAllRwVolumePaths(Arrays.asList(volumePaths.split(",")));
        }
        return snapList;
    }

    private CLDBProto.SnapshotListResponse getSnapshotListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.SnapshotListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into SnapshotListResponse proto object.", (Throwable)ipbe);
        }
    }

    public CLDBProto.SnapshotListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.SnapshotListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.SnapshotListRequest.newBuilder((CLDBProto.SnapshotListRequest)((CLDBProto.SnapshotListRequest)prevReq)) : this.getSnapshotListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.SnapshotListResponse)prevResp).getSnapshotsCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 40));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.SnapshotListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.SnapshotListResponse)prevResp).getSnapshotsCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.SnapshotListResponse resp = (CLDBProto.SnapshotListResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equals("terse");
        BitSet columns = this.getColumns();
        if (resp.getStatus() == 0) {
            for (CLDBProto.SnapshotInfo s : resp.getSnapshotsList()) {
                try {
                    out.addNode(this.formatSnapshotInfo(s, terse, columns));
                }
                catch (CLIProcessingException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                }
            }
            if (resp.hasTotal()) {
                out.setTotal(resp.getTotal());
            }
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString(resp.getStatus())));
        }
    }

    public CLDBProto.SnapshotListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.SnapshotListRequest req = (CLDBProto.SnapshotListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotListProc.getNumber(), (MessageLite)req, CLDBProto.SnapshotListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotListProc.getNumber(), (MessageLite)req, CLDBProto.SnapshotListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getSnapshotListResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list Nodes failed. No data returned");
        return null;
    }

    CommandOutput snapshotCreate() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> rwVolumeNames = new ArrayList<String>();
        String name = this.getParamTextValue("volume", 0);
        if (name.contains(",")) {
            rwVolumeNames.addAll(Arrays.asList(name.split(",")));
        } else {
            rwVolumeNames.add(name);
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        for (String rwVolumeName : rwVolumeNames) {
            String snapshotName = this.getParamTextValue(SNAPSHOT_PARAM_NAME, 0);
            CLDBProto.VolumeInfo vInfo = this.volumeLookup(rwVolumeName);
            if (vInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Snapshot Create: Could not find information about Volume: '" + rwVolumeName + "'. " + Errno.toString(2)));
                LOG.error((Object)("SnapshotCreate: Could not find Volume Info of " + rwVolumeName));
                continue;
            }
            if (!VolumeUtils.isValidSnapshotNameLength((String)snapshotName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Snapshot Name " + snapshotName + ", Exceeds allowed length of " + VolumeUtils.validSnapshotNameLength() + " characters").setField(SNAPSHOT_PARAM_NAME));
                return output;
            }
            if (!VolumeUtils.isValidSnapshotName((String)snapshotName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "SnapshotCreate: Invalid Snapshot Name.  Allowed characters " + VolumeUtils.getValidName()).setField(SNAPSHOT_PARAM_NAME));
                output.setOutput(out);
                continue;
            }
            CLDBProto.ContainerInfo rootCInfo = vInfo.getRootContainer();
            if (!rootCInfo.hasMServer()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(61, "Snapshot Create: Could not find master server for root of Volume: " + rwVolumeName + Errno.toString(61)));
                LOG.error((Object)("SnapshotCreate: Could not find master server for Volume Info of " + rwVolumeName));
                continue;
            }
            int status = fs.createSnapshot(cluster, rwVolumeName, vInfo.getVolProperties().getVolumeId(), vInfo.getRootContainer().getContainerId(), snapshotName, false, this.getUserLoginId());
            if (status == 115) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Create: Operation failed, snapshot can't be created or removed when mirroring is in progress for the volume"));
                continue;
            }
            if (status == 0) continue;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Create: Operation failed, " + Errno.toString(status)));
        }
        return output;
    }

    CommandOutput.OutputHierarchy.OutputNode formatSnapshotInfo(CLDBProto.SnapshotInfo v, boolean terse, BitSet columns) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode snapshotInfo = new CommandOutput.OutputHierarchy.OutputNode();
        if (columns.get(CLDBProto.SnapshotInfoFields.ownerName.getNumber())) {
            int ownerId = v.getOwnerId();
            String ownerName = null;
            try {
                ownerName = this.uInfo.getUsername(ownerId);
            }
            catch (SecurityException se) {
                ownerName = "Uid " + ownerId;
            }
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.ownerName).getName(terse), (Object)ownerName));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.ownerType.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.ownerType).getName(terse), (Object)"1"));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.rwVolumeId.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.rwVolumeId).getName(terse), (Object)String.valueOf(v.getRwVolumeId())));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.rwVolumeName.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.rwVolumeName).getName(terse), (Object)v.getRwVolumeName()));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.volumePath.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.volumePath).getName(terse), (Object)v.getMountDir()));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.snapshotId.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.snapshotId).getName(terse), (Object)String.valueOf(v.getSnapshotId())));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.snapshotName.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.snapshotName).getName(terse), (Object)v.getSnapshotName()));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.creationTime.getNumber())) {
            String createTime = terse ? String.valueOf(v.getCreateTime()) : new Date(v.getCreateTime()).toString();
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.creationTime).getName(terse), (Object)createTime));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.expiryTime.getNumber())) {
            String expiryTime;
            String string = expiryTime = terse ? String.valueOf(v.getDeleteTime()) : new Date(v.getDeleteTime()).toString();
            if (terse || v.getDeleteTime() != 0L) {
                snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.expiryTime).getName(terse), (Object)expiryTime));
            }
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB).getName(terse), (Object)String.valueOf(v.getSnapshotCumulativeReclaimSizeMB())));
        }
        if (snapshotInfo.getChildren().isEmpty()) {
            throw new CLIProcessingException("No columns found in output");
        }
        return snapshotInfo;
    }

    private CLDBProto.VolumeInfo volumeLookup(String volumeName) throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp = null;
        byte[] data = null;
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                LOG.error((Object)("VolumeLookup RPC to CLDB failed for volume " + volumeName));
                return null;
            }
            resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getVolInfo();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during VolumeLookup RPC to CLDB " + e.getLocalizedMessage()));
            return null;
        }
        return null;
    }

    static {
        CLDBProto.SnapshotInfoFields[] values = CLDBProto.SnapshotInfoFields.values();
        int max = 0;
        for (CLDBProto.SnapshotInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_SNAPFIELDINFO = max;
        snapshotCommandsArray = new CLICommand[]{snapshotCreateCommand, snapshotRemoveCommand, snapshotPreserveCommand, snapshotListCommand};
        snapshotCommands = new CLICommand("snapshot", "snapshot", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, snapshotCommandsArray).setShortUsage("snapshot [create|list|remove|preserve]");
    }
}

