/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.ServiceManagingOperation;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.EnumInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.security.ACL;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Id;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class NodeServicesManagementCommand
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NodeServicesManagementCommand.class);
    public static final String FILTER_PARAM = "filter";
    public static final String NODES_PARAM = "nodes";
    public static final String SERVICE_NAME_PARAM = "name";
    public static final String SERVICE_MULTI_PARAM = "multi";
    public static final String SERVICE_ACTION_PARAM = "action";
    public static final String ZK_CONNECTSTRING = "zkconnect";
    public static final int TIMEOUT_SERVER = 30000;
    public static final int MAX_CHARS_COUNT = 60;
    public static final String NODES_SERVICES_MNGMNT_TOP_PATH = "/nodes";
    public static final String NODES_SERVICES_MNGMNT_SERVICE_PATH = "/services";
    public static List<org.apache.zookeeper.data.ACL> CREATOR_ALL_ACL_PLUS = new ArrayList<org.apache.zookeeper.data.ACL>();
    public static List<org.apache.zookeeper.data.ACL> CREATOR_ALL_ACL_PLUS_DIR = new ArrayList<org.apache.zookeeper.data.ACL>();
    public static List<org.apache.zookeeper.data.ACL> ZK_ACLS;
    public static List<org.apache.zookeeper.data.ACL> ZK_ACLS_DIR;
    public static final CLICommand nodeServices;

    public NodeServicesManagementCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        boolean isRoot;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        String zkConnectString = null;
        String clusterName = null;
        Security.CredentialsMsg creds = this.getUserCredentials();
        boolean bl = isRoot = creds.hasUid() && creds.getUid() == 0;
        if (!isRoot) {
            byte[] data;
            CLDBProto.SecurityGetAclRequest.Builder aclRequestBuilder = CLDBProto.SecurityGetAclRequest.newBuilder();
            aclRequestBuilder.setCreds(creds);
            aclRequestBuilder.setObjectType(CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER);
            Security.AccessControlList acl = null;
            try {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityGetAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityGetAclResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                co.setOutput(oh);
                return co;
            }
            try {
                CLDBProto.SecurityGetAclResponse aclResp = CLDBProto.SecurityGetAclResponse.parseFrom((byte[])data);
                int status = aclResp.getStatus();
                if (status != 0 && status == 1) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1) + ":" + "User not authorized on the cluster"));
                    co.setOutput(oh);
                    return co;
                }
                acl = aclResp.getAcl();
                ACL aclObj = new ACL(acl);
                boolean userIsClusterAdmin = false;
                if (aclResp.hasClusterAdmin() && creds.getUid() == aclResp.getClusterAdmin()) {
                    userIsClusterAdmin = true;
                }
                if (!userIsClusterAdmin && !aclObj.verifyPermissions(creds, SecurityCommandHelper.CLUSTER_START_STOP_SERVICES_MASK)) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1) + ":" + "User not authorized to start/stop services on the cluster"));
                    co.setOutput(oh);
                    return co;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
            }
            catch (Exception e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while check user privileges for this operation"));
                co.setOutput(oh);
                return co;
            }
        }
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
            zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect(clusterName);
        } else {
            zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
            clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        }
        if (JNISecurity.IsSecurityEnabled(clusterName)) {
            ZK_ACLS = CREATOR_ALL_ACL_PLUS;
            ZK_ACLS_DIR = CREATOR_ALL_ACL_PLUS_DIR;
        }
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent(ZK_CONNECTSTRING)) {
            zkConnectString = this.getParamTextValue(ZK_CONNECTSTRING, 0);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ZKConnectString: " + zkConnectString));
        }
        if (zkConnectString == null) {
            String errorMsg = "Unable to obtain the ZooKeeper connection string from the CLDB. Make sure that the CLDB is running and accessible.";
            if (this.isParamPresent(ServicesEnum.cldb.name())) {
                errorMsg = errorMsg + "\n If you are trying to start CLDB please specify valid Zookeeper connection string using " + ZK_CONNECTSTRING + " parameter";
            }
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, errorMsg));
            return co;
        }
        List<String> nodes = NodesCommonUtils.findNodeIps(zkConnectString);
        List<String> nodeHostNames = new ArrayList();
        if (this.isParamPresent(NODES_PARAM)) {
            nodeHostNames = this.input.getParameterByName(NODES_PARAM).getParamValues();
        } else if (this.isParamPresent(FILTER_PARAM)) {
            String filter = this.getParamTextValue(FILTER_PARAM, 0);
            try {
                nodeHostNames = NodesCommonUtils.findFilteredNodeIps(filter, zkConnectString);
            }
            catch (CLIProcessingException e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get nodes list. Can not do an action on service"));
                return co;
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Invalid parameters provided: neither \"filter\", nor \"nodes\" was specified"));
            return co;
        }
        if (nodeHostNames == null || nodeHostNames.isEmpty()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "No nodes matched input parameters"));
            return co;
        }
        List<String> nodeNames = NodesCommonUtils.convertHostToIpIncludingLocal(nodeHostNames);
        nodeNames.addAll(NodesCommonUtils.convertIpToHost(nodeHostNames));
        nodeNames.addAll(nodeHostNames);
        HashSet<String> nodeNamesSet = new HashSet<String>(nodeNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NodeNamesSet: " + nodeNamesSet));
        }
        nodeNamesSet.removeAll(nodes);
        nodeNames.removeAll(nodeNamesSet);
        HashSet<String> nodeNamesUnique = new HashSet<String>(nodeNames);
        if (nodeNamesUnique.isEmpty()) {
            StringBuilder outputErrorParams = new StringBuilder(nodeHostNames.toString());
            if (outputErrorParams.length() > 60) {
                outputErrorParams.delete(61, outputErrorParams.length());
                outputErrorParams.append("...");
            }
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any " + "cluster nodes.  Please specify a node in the same format shown in the " + "output of the \"maprcli node list\" command"));
            LOG.error((Object)("Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any " + "cluster nodes.  Please specify a node in the same format shown in the " + "output of the \"maprcli node list\" command"));
            return co;
        }
        if (nodeNamesUnique.size() < nodeHostNames.size()) {
            LOG.error((Object)("Not all input nodes were identified. Command will be executed only for: " + nodeNamesUnique));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Not all input nodes were identified. Command will be executed only for: " + nodeNamesUnique + ". Please specify nodes in the same format shown in the " + "output of the \"maprcli node list\" command"));
        }
        int retries = 0;
        if (retries++ < 3) {
            try {
                ZooKeeper s_zk = NodesCommonUtils.connect(zkConnectString);
                Map<String, List<String>> confServices = NodesCommonUtils.findServicesConfiguredHierarchy(zkConnectString);
                for (String node : nodeNamesUnique) {
                    List<String> confServicesPerNode;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Node: " + node));
                    }
                    if ((confServicesPerNode = confServices.get(node)) == null || confServicesPerNode.isEmpty()) {
                        LOG.error((Object)("Node: " + node + " does not have any service configured"));
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Node: " + node + " does not have any service configured"));
                        continue;
                    }
                    try {
                        s_zk.create(NODES_SERVICES_MNGMNT_TOP_PATH, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e1) {
                        // empty catch block
                    }
                    try {
                        s_zk.create("/nodes/" + node, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e1) {
                        // empty catch block
                    }
                    try {
                        s_zk.create("/nodes/" + node + NODES_SERVICES_MNGMNT_SERVICE_PATH, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e1) {
                        // empty catch block
                    }
                    for (ServicesEnum service : ServicesEnum.values()) {
                        if (!this.isParamPresent(service.name())) continue;
                        String serviceOperation = this.getParamTextValue(service.name(), 0);
                        try {
                            ServiceManagingOperation.valueOf(serviceOperation);
                        }
                        catch (IllegalArgumentException e) {
                            LOG.error((Object)("Service operation type for service: " + service.name() + " is not valid: " + serviceOperation));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10007, "Service operation type for service: " + service.name() + " is not valid: " + serviceOperation).setField(service.name()).setFieldValue(serviceOperation));
                            continue;
                        }
                        if (!confServicesPerNode.contains(service.name())) {
                            LOG.error((Object)("Service: " + service.name() + " is not configured on node: " + node));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + service.name() + " is not configured on node: " + node));
                            continue;
                        }
                        this.helperAction(s_zk, node, service.name(), serviceOperation, oh);
                    }
                    if (this.isParamPresent(SERVICE_NAME_PARAM)) {
                        String serviceName = this.getParamTextValue(SERVICE_NAME_PARAM, 0);
                        if (!this.isParamPresent(SERVICE_ACTION_PARAM)) {
                            LOG.error((Object)"action parameter has to be present when name is present");
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "action parameter has to be present when name is present"));
                            return co;
                        }
                        if (this.getParamObjectValue(SERVICE_ACTION_PARAM, 0) instanceof ServiceManagingOperation) {
                            ServiceManagingOperation action = (ServiceManagingOperation)((Object)this.getParamObjectValue(SERVICE_ACTION_PARAM, 0));
                            if (!confServicesPerNode.contains(serviceName)) {
                                LOG.error((Object)("Service: " + serviceName + " is not configured on node: " + node));
                                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " is not configured on node: " + node));
                                continue;
                            }
                            this.helperAction(s_zk, node, serviceName, action.name(), oh);
                        } else {
                            LOG.error((Object)("action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            return co;
                        }
                    }
                    if (!this.isParamPresent(SERVICE_MULTI_PARAM)) continue;
                    String multiParam = this.getParamTextValue(SERVICE_MULTI_PARAM, 0);
                    JSONTokener token = new JSONTokener(multiParam);
                    try {
                        JSONArray jarray = new JSONArray(token);
                        for (int i = 0; i < jarray.length(); ++i) {
                            JSONObject obj = jarray.getJSONObject(i);
                            String serviceName = obj.getString(SERVICE_NAME_PARAM);
                            if (!obj.has(SERVICE_ACTION_PARAM)) {
                                LOG.error((Object)"action parameter has to be present when name is present");
                                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "action parameter has to be present when name is present"));
                                return co;
                            }
                            String strAction = obj.getString(SERVICE_ACTION_PARAM);
                            ServiceManagingOperation action = null;
                            for (ServiceManagingOperation s : ServiceManagingOperation.values()) {
                                if (!s.name().equals(strAction)) continue;
                                action = s;
                                break;
                            }
                            if (action != null) {
                                if (!confServicesPerNode.contains(serviceName)) {
                                    LOG.error((Object)("Service: " + serviceName + " is not configured on node: " + node));
                                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " is not configured on node: " + node));
                                    continue;
                                }
                                this.helperAction(s_zk, node, serviceName, action.name(), oh);
                                continue;
                            }
                            LOG.error((Object)("action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            return co;
                        }
                    }
                    catch (JSONException e) {
                        LOG.error((Object)("Error parsing JSON string: " + multiParam));
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing JSON string"));
                    }
                }
            }
            catch (KeeperException e) {
                LOG.error((Object)"KeeperException while trying to create ZK struct for service management", (Throwable)e);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "KeeperException while trying to create ZK struct for service management" + e.getLocalizedMessage()));
                return co;
            }
            catch (InterruptedException e) {
                LOG.error((Object)"InterruptedException while trying to create ZK struct for service management", (Throwable)e);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "InterruptedException while trying to create ZK struct for service management" + e.getLocalizedMessage()));
                return co;
            }
        }
        return co;
    }

    private void helperAction(ZooKeeper s_zk, String node, String service, String serviceOperation, CommandOutput.OutputHierarchy oh) throws KeeperException, InterruptedException {
        try {
            s_zk.create("/nodes/" + node + NODES_SERVICES_MNGMNT_SERVICE_PATH + "/" + service, new byte[0], ZK_ACLS_DIR, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e1) {
            // empty catch block
        }
        try {
            byte[] data = String.valueOf(System.currentTimeMillis()).getBytes();
            String createdNode = s_zk.create("/nodes/" + node + NODES_SERVICES_MNGMNT_SERVICE_PATH + "/" + service + "/" + serviceOperation + "_", data, ZK_ACLS, CreateMode.PERSISTENT_SEQUENTIAL);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Created znode: " + createdNode + " to " + serviceOperation + " service " + service));
            }
        }
        catch (KeeperException.NodeExistsException e1) {
            LOG.warn((Object)("Please wait. The previous " + serviceOperation + " command for " + service + " is executing."));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Please wait. The previous " + serviceOperation + " command for " + service + " is executing.").setField(service).setFieldValue(serviceOperation));
        }
    }

    static {
        CREATOR_ALL_ACL_PLUS.add(new org.apache.zookeeper.data.ACL(30, ZooDefs.Ids.AUTH_IDS));
        CREATOR_ALL_ACL_PLUS.add(new org.apache.zookeeper.data.ACL(1, new Id("sasl", "anyone")));
        CREATOR_ALL_ACL_PLUS_DIR.add(new org.apache.zookeeper.data.ACL(31, new Id("sasl", "anyone")));
        ZK_ACLS = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        ZK_ACLS_DIR = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        nodeServices = new CLICommand("services", "service management command ", NodeServicesManagementCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)FILTER_PARAM, (Object)new TextInputParameter(FILTER_PARAM, "node names filter. Please put it in quotes\"\"", false, null)).put((Object)ZK_CONNECTSTRING, (Object)new TextInputParameter(ZK_CONNECTSTRING, "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)NODES_PARAM, (Object)new TextInputParameter(NODES_PARAM, "node names space separated", false, null)).put((Object)ServicesEnum.cldb.name(), (Object)new TextInputParameter(ServicesEnum.cldb.name(), "managing cldb service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.fileserver.name(), (Object)new TextInputParameter(ServicesEnum.fileserver.name(), "managing fileserver service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.hbmaster.name(), (Object)new TextInputParameter(ServicesEnum.hbmaster.name(), "managing hbmaster service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.hbregionserver.name(), (Object)new TextInputParameter(ServicesEnum.hbregionserver.name(), "managing hbregionserver service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.jobtracker.name(), (Object)new TextInputParameter(ServicesEnum.jobtracker.name(), "managing jobtracker service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.nfs.name(), (Object)new TextInputParameter(ServicesEnum.nfs.name(), "managing nfs service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.tasktracker.name(), (Object)new TextInputParameter(ServicesEnum.tasktracker.name(), "managing tasktracker service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.webserver.name(), (Object)new TextInputParameter(ServicesEnum.webserver.name(), "managing webserver service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)SERVICE_NAME_PARAM, (Object)new TextInputParameter(SERVICE_NAME_PARAM, "service name to perform action on", false, null)).put((Object)SERVICE_ACTION_PARAM, (Object)new EnumInputParameter(SERVICE_ACTION_PARAM, "service action. One of: " + Arrays.asList(ServiceManagingOperation.values()), false, ServiceManagingOperation.class, null)).put((Object)SERVICE_MULTI_PARAM, (Object)new TextInputParameter(SERVICE_MULTI_PARAM, "service json to parse to start/stop multiple services", false, null).setInvisible(true)).build(), null);
    }
}

