/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.security.ACL;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoginCommand
extends CLIBaseClass {
    private static final Logger LOG = Logger.getLogger(LoginCommand.class);
    public static final String USER_PARAM_NAME = "user";
    public static final CLICommand loginCommand = new CLICommand("login", "login -user", LoginCommand.class, CLICommand.ExecutionTypeEnum.NATIVE).setShortUsage("login -user").setUsageInVisible(true);

    public LoginCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private CommandOutput login() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CLDBProto.SecurityGetAclRequest.Builder aclRequestBuilder = CLDBProto.SecurityGetAclRequest.newBuilder();
        Map parameters = this.input.getAllParameters();
        if (parameters.containsKey(USER_PARAM_NAME)) {
            byte[] data;
            ProcessedInput.Parameter param = (ProcessedInput.Parameter)parameters.get(USER_PARAM_NAME);
            String user = (String)param.getParamValues().get(0);
            if (user == null || user.trim().isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid user  " + Errno.toString(22)));
                output.setOutput(out);
                return output;
            }
            CLDBProto.SecureObjectType objType = CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER;
            Security.CredentialsMsg creds = this.getUserCredentials();
            aclRequestBuilder.setCreds(creds);
            aclRequestBuilder.setObjectType(objType);
            Security.AccessControlList acl = null;
            try {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityGetAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityGetAclResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            try {
                CLDBProto.SecurityGetAclResponse aclResp = CLDBProto.SecurityGetAclResponse.parseFrom((byte[])data);
                int status = aclResp.getStatus();
                if (status != 0) {
                    if (status == 1) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1) + ":" + "Unauthorized user"));
                        output.setOutput(out);
                        return output;
                    }
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ACL lookup failed for " + CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER + " failed with error - " + aclResp.getErrorString()));
                    output.setOutput(out);
                    return output;
                }
                acl = aclResp.getAcl();
                ACL aclObj = new ACL(acl);
                if (!aclObj.verifyPermissions(creds, SecurityCommandHelper.CLUSTER_READ_MASK)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString(1) + ":" + "Unauthorized user"));
                    output.setOutput(out);
                    return output;
                }
                output.setOutput(out);
                return output;
            }
            catch (InvalidProtocolBufferException e) {
                throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get ACL"));
                output.setOutput(out);
                return output;
            }
        }
        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "user name required"));
        output.setOutput(out);
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        if (!super.validateInput()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Input"));
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("login")) {
            return this.login();
        }
        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown command"));
        output.setOutput(out);
        return output;
    }
}

