/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.DbGatewayCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.util.MapRFSUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ClusterCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String SETMODE_PARAM = "mode";
    public static final String centralConfigPath = "/var/mapr/configuration/default";
    public static final String versionFilePath = "/conf/hadoop_version";
    private static final String maprInstallPath = MapRCliUtil.getMapRInstallDir();
    private static final String hadoopVersionLocalFile = maprInstallPath + "/conf/hadoop_version";
    private static final String daemonConfFile = maprInstallPath + "/conf/daemon.conf";
    private static final String CLASSIC_VERSION_TOKEN = "classic_version";
    private static final String YARN_VERSION_TOKEN = "yarn_version";
    private static final String DEFAULT_MODE_TOKEN = "default_mode";
    private static final Logger LOG = Logger.getLogger(ClusterCommands.class);
    static final CLICommand mapreduceGetAllVersionCommand = new CLICommand("getall", "Get MapReduce Version values", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the MapReduce version info").setUsageInVisible(true);
    static final CLICommand mapreduceGetVersionCommand = new CLICommand("get", "Get Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the current cluster MapReduce default version");
    static final CLICommand mapreduceSetVersionCommand = new CLICommand("set", "Set Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"mode", (Object)new TextInputParameter("mode", "Sets the default MapReduce default version <classic|yarn>", true, null)).build(), null);
    public static final CLICommand mapreduceCommands = new CLICommand("mapreduce", "Get or Set Cluster wide MapReduce defaults such as version", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceGetAllVersionCommand, mapreduceGetVersionCommand, mapreduceSetVersionCommand});
    public static final CLICommand clusterCommands = new CLICommand("cluster", "cluster wide info such as mapreduce version", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceCommands, DbGatewayCommands.gatewayCommands}).setShortUsage("cluster [mapreduce [get|set] | gateway]");

    public ClusterCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        VersionFileContents contents;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(oh);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("set")) {
            String default_mode = this.getParamTextValue(SETMODE_PARAM, 0);
            if (!default_mode.equals("classic") && !default_mode.equals("yarn")) {
                LOG.error((Object)"Default MapReduce specified should be classic or yarn");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for Default Mapreduce Mode. It should be classic or yarn"));
                return output;
            }
            VersionFileContents newContents = this.setClusterDefaultMapReduceMode(default_mode);
            if (newContents != null) {
                this.addContentsToOutput(oh, newContents);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unable to set Mapreduce Mode. Check maprcli/adminuiapp log for more details."));
            }
        } else if (cmd.equalsIgnoreCase("get")) {
            VersionFileContents contents2 = ClusterCommands.readHadoopVersionFile();
            if (contents2 != null) {
                this.addContentsToOutput(oh, contents2);
            }
        } else if (cmd.equalsIgnoreCase("getall") && (contents = ClusterCommands.readHadoopVersionFile()) != null) {
            this.addAllContentsToOutput(oh, contents);
        }
        return output;
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        int host = Util.ipToInt((String)ipstr);
        Common.IPAddress server = Common.IPAddress.newBuilder().setHost(host).build();
        return server;
    }

    private void addAllContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLASSIC_VERSION_TOKEN, (Object)contents.classic_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(YARN_VERSION_TOKEN, (Object)contents.yarn_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        oh.addNode(node);
    }

    private void addContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        String version = "";
        if (contents.default_mode != null) {
            version = contents.default_mode.equals("classic") ? contents.classic_version : contents.yarn_version;
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("mapreduce_version", (Object)version));
        oh.addNode(node);
    }

    private VersionFileContents setClusterDefaultMapReduceMode(String defaultMode) {
        VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
        if (contents == null) {
            LOG.error((Object)"Error while reading Local Hadoop Version file");
            return null;
        }
        contents.default_mode = defaultMode;
        if (this.writeHadoopVersionFile(contents)) {
            this.copyToCentralConfig();
            return contents;
        }
        return null;
    }

    private void copyToCentralConfig() {
        String mapr_group;
        String mapr_user;
        Path versionFileFSPath = new Path("/var/mapr/configuration/default/conf/hadoop_version");
        try {
            Properties userInfoProps = new Properties();
            userInfoProps.load(new BufferedInputStream(new FileInputStream(daemonConfFile)));
            mapr_user = userInfoProps.getProperty("mapr.daemon.user");
            mapr_group = userInfoProps.getProperty("mapr.daemon.group");
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while trying to open " + daemonConfFile), (Throwable)e);
            return;
        }
        try {
            boolean isPathCreated = MapRFSUtil.getMapRFileSystem().mkdirs(new Path("/var/mapr/configuration/default/conf"));
            if (isPathCreated) {
                MapRFSUtil.getMapRFileSystem().setOwner(new Path("/var/mapr/configuration/default/conf"), mapr_user, mapr_group);
                MapRFSUtil.getMapRFileSystem().delete(versionFileFSPath, false);
                MapRFSUtil.getMapRFileSystem().copyFromLocalFile(false, true, new Path(hadoopVersionLocalFile), versionFileFSPath);
                MapRFSUtil.getMapRFileSystem().setOwner(versionFileFSPath, mapr_user, mapr_group);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException while copying to Central config location /var/mapr/configuration/default", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeHadoopVersionFile(VersionFileContents contents) {
        if (contents == null || contents.classic_version == null || contents.yarn_version == null) {
            LOG.error((Object)("Malformed hadoop_version local file. Please check the contents of " + hadoopVersionLocalFile));
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(hadoopVersionLocalFile));
            bw.write("classic_version=" + contents.classic_version + "\n");
            bw.write("yarn_version=" + contents.yarn_version + "\n");
            bw.write("default_mode=" + contents.default_mode + "\n");
            bw.close();
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while trying to write Hadoop version file " + hadoopVersionLocalFile), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionFileContents readHadoopVersionFile() {
        VersionFileContents contents = new VersionFileContents();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(hadoopVersionLocalFile));
            while ((line = br.readLine()) != null) {
                String[] tok = line.split("=");
                if (tok.length <= 1) continue;
                if (tok[0].equals(CLASSIC_VERSION_TOKEN)) {
                    contents.classic_version = tok[1];
                    continue;
                }
                if (tok[0].equals(YARN_VERSION_TOKEN)) {
                    contents.yarn_version = tok[1];
                    continue;
                }
                if (!tok[0].equals(DEFAULT_MODE_TOKEN)) continue;
                contents.default_mode = tok[1];
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while trying to read Hadoop version file " + hadoopVersionLocalFile), (Throwable)e);
            VersionFileContents versionFileContents = null;
            return versionFileContents;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return contents;
    }

    public static class VersionFileContents {
        String classic_version;
        String yarn_version;
        String default_mode;
    }
}

