/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AuditCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String AUDIT_DATA = "data";
    private static final String AUDIT_CLUSTER = "cluster";
    private static final String AUDIT_INFO = "info";
    private static final String ENABLED_PARAM_NAME = "enabled";
    private static final String MAXSIZE_PARAM_NAME = "maxsize";
    private static final String RETENTION_PARAM_NAME = "retention";
    private static final String REPLICAS_PARAM_NAME = "replicas";
    private static final String CLUSTER_PARAM_NAME = "cluster";
    private static final Logger LOG = Logger.getLogger(AuditCommands.class);
    private final String ParamAuditDataAccess = "mapr.audit.data.access";
    private final String ParamAuditClusterMgmtOps = "mapr.audit.cluster.mgmt.ops";
    private final String ParamAuditDataRetentionPeriod = "mapr.audit.data.retention.days";
    private final String ParamAuditClusterRetentionPeriod = "mapr.audit.cluster.retention.days";
    private final String ParamAuditDataVolumeSize = "mapr.audit.data.volume.size.mb";
    private final String ParamAuditClusterVolumeSize = "mapr.audit.cluster.volume.size.mb";
    private static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand dataAuditCmd = new CLICommand("data", "audit data access operations", AuditCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"enabled", (Object)new BooleanInputParameter("enabled", "enable audit for data access", false, null)).put((Object)"maxsize", (Object)new IntegerInputParameter("maxsize", "size of audit volume per node", false, null)).put((Object)"retention", (Object)new IntegerInputParameter("retention", "retention period of audit logs in days", false, null)).put((Object)"replicas", (Object)new IntegerInputParameter("replicas", "number of replicas for audit data", false, null).setInvisible(true)).build(), null).setShortUsage("data -enabled <true|false> -maxsize <GB>  -retention <days>");
    static final CLICommand clusterAuditCmd = new CLICommand("cluster", "audit cluster management operations", AuditCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"enabled", (Object)new BooleanInputParameter("enabled", "enable audit for cluster mgmt ops", false, null)).build(), null).setShortUsage("cluster -enabled <true|false> -maxsize <GB>  -retention <days> -replicas <count>");
    static final CLICommand auditInfoCmd = new CLICommand("info", "information about audit params", AuditCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("info");
    static final CLICommand[] auditSubCommands = new CLICommand[]{dataAuditCmd, clusterAuditCmd, auditInfoCmd};
    static final String usageStr = "audit [data|cluster|info]";
    public static final CLICommand auditCommands = new CLICommand("audit", "usage: audit [data|cluster|info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, auditSubCommands).setShortUsage("audit [data|cluster|info]");

    public AuditCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase(AUDIT_DATA)) {
            return this.auditDataAccess();
        }
        if (command.equalsIgnoreCase("cluster")) {
            return this.auditClusterMgmt();
        }
        if (command.equalsIgnoreCase(AUDIT_INFO)) {
            return this.auditInfo();
        }
        return new TextCommandOutput(("Audit command failed: unknown command " + command + " received.").getBytes());
    }

    private CommandOutput auditInfo() throws CLIProcessingException {
        int status;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Properties cldbProps = new Properties();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        if ((status = MapRCliUtil.fetchCLDBParams(cluster, cldbProps, this.getUserCredentials())) < 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unable to reach CLDB"));
            return output;
        }
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to load configuration - " + Errno.toString(status)));
            return output;
        }
        CommandOutput.OutputHierarchy.OutputNode finalNode = new CommandOutput.OutputHierarchy.OutputNode();
        String emptyValue = "-";
        CommandOutput.OutputHierarchy.OutputNode dNode = new CommandOutput.OutputHierarchy.OutputNode(AUDIT_DATA);
        String value = cldbProps.getProperty("mapr.audit.data.access");
        if (value == null) {
            value = emptyValue;
        }
        dNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENABLED_PARAM_NAME, (Object)value));
        value = cldbProps.getProperty("mapr.audit.data.volume.size.mb");
        if (value == null) {
            value = "-";
        } else {
            try {
                int sizeInMB = Integer.parseInt(value);
                value = Integer.toString(sizeInMB / 1024);
            }
            catch (NumberFormatException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for max size for data access logs"));
            }
        }
        dNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxSizeGB", (Object)value));
        value = cldbProps.getProperty("mapr.audit.data.retention.days");
        if (value == null) {
            value = "-";
        }
        dNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("retentionDays", (Object)value));
        finalNode.addChild(dNode);
        CommandOutput.OutputHierarchy.OutputNode cNode = new CommandOutput.OutputHierarchy.OutputNode("cluster");
        value = cldbProps.getProperty("mapr.audit.cluster.mgmt.ops");
        if (value == null) {
            value = emptyValue;
        }
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENABLED_PARAM_NAME, (Object)value));
        value = cldbProps.getProperty("mapr.audit.cluster.volume.size.mb");
        if (value == null) {
            value = "-";
        } else {
            try {
                int sizeInMB = Integer.parseInt(value);
                value = Integer.toString(sizeInMB / 1024);
            }
            catch (NumberFormatException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for max size for data access logs"));
            }
        }
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxSizeGB", (Object)"NA"));
        value = cldbProps.getProperty("mapr.audit.cluster.retention.days");
        if (value == null) {
            value = "-";
        }
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("retentionDays", (Object)"NA"));
        finalNode.addChild(cNode);
        out.addNode(finalNode);
        return output;
    }

    private CommandOutput auditDataAccess() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        try {
            CLDBProto.CLDBConfigParams.CLDBConfigParam param;
            CLDBProto.CLDBConfigRequest.Builder configReqBuilder = CLDBProto.CLDBConfigRequest.newBuilder();
            configReqBuilder.setLoad(false);
            Security.CredentialsMsg creds = this.getUserCredentials();
            configReqBuilder.setCreds(creds);
            CLDBProto.CLDBConfigParams.Builder pBuilder = CLDBProto.CLDBConfigParams.newBuilder();
            if (this.isParamPresent(ENABLED_PARAM_NAME)) {
                boolean enableDataAudit = this.getParamBooleanValue(ENABLED_PARAM_NAME, 0);
                param = CLDBProto.CLDBConfigParams.CLDBConfigParam.newBuilder().setKeys("mapr.audit.data.access").setValues(enableDataAudit ? "1" : "0").build();
                pBuilder.addParams(param);
            }
            if (this.isParamPresent(MAXSIZE_PARAM_NAME)) {
                int maxSize = this.getParamIntValue(MAXSIZE_PARAM_NAME, 0) * 1024;
                param = CLDBProto.CLDBConfigParams.CLDBConfigParam.newBuilder().setKeys("mapr.audit.data.volume.size.mb").setValues(Integer.toString(maxSize)).build();
                pBuilder.addParams(param);
            }
            if (this.isParamPresent(RETENTION_PARAM_NAME)) {
                int retention = this.getParamIntValue(RETENTION_PARAM_NAME, 0);
                param = CLDBProto.CLDBConfigParams.CLDBConfigParam.newBuilder().setKeys("mapr.audit.data.retention.days").setValues(Integer.toString(retention)).build();
                pBuilder.addParams(param);
            }
            if (pBuilder.getParamsCount() == 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify the param that needs change"));
                return output;
            }
            configReqBuilder.setParams(pBuilder);
            byte[] data = null;
            data = cluster != null && !cluster.isEmpty() ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)configReqBuilder.build(), CLDBProto.CLDBConfigResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)configReqBuilder.build(), CLDBProto.CLDBConfigResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not connect to CLDB service"));
                return output;
            }
            CLDBProto.CLDBConfigResponse resp = CLDBProto.CLDBConfigResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to save audit configuration : " + Errno.toString(status)));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to save audit data config"));
        }
        return output;
    }

    private CommandOutput auditClusterMgmt() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        try {
            CLDBProto.CLDBConfigRequest.Builder configReqBuilder = CLDBProto.CLDBConfigRequest.newBuilder();
            configReqBuilder.setLoad(false);
            Security.CredentialsMsg creds = this.getUserCredentials();
            configReqBuilder.setCreds(creds);
            CLDBProto.CLDBConfigParams.Builder pBuilder = CLDBProto.CLDBConfigParams.newBuilder();
            if (this.isParamPresent(ENABLED_PARAM_NAME)) {
                boolean enableClusterAudit = this.getParamBooleanValue(ENABLED_PARAM_NAME, 0);
                CLDBProto.CLDBConfigParams.CLDBConfigParam param = CLDBProto.CLDBConfigParams.CLDBConfigParam.newBuilder().setKeys("mapr.audit.cluster.mgmt.ops").setValues(enableClusterAudit ? "1" : "0").build();
                pBuilder.addParams(param);
            }
            if (pBuilder.getParamsCount() == 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify the param that needs to be changed"));
                return output;
            }
            configReqBuilder.setParams(pBuilder);
            byte[] data = null;
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)configReqBuilder.build(), CLDBProto.CLDBConfigResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not connect to CLDB service"));
                return output;
            }
            CLDBProto.CLDBConfigResponse resp = CLDBProto.CLDBConfigResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to save audit configuration : " + Errno.toString(status)));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to save audit cluster config"));
        }
        return output;
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

