/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import amazon.emr.metrics.MetricsSaver;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.hadoop.fs.s3native.ProgressableResettableBufferedFileInputStream;
import org.apache.hadoop.util.Progressable;

class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    public static final Log LOG = LogFactory.getLog(Jets3tNativeFileSystemStore.class);
    private AmazonS3 s3;
    private String bucket;
    protected Configuration conf;
    Cache<String, FileMetadata> metacache = null;

    Jets3tNativeFileSystemStore() {
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        this.bucket = uri.getHost();
        this.conf = conf;
        if (conf.getBoolean("fs.s3.buckets.create.enabled", true)) {
            this.ensureBucketExists(this.bucket, conf);
        }
        this.metacache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    private void ensureBucketExists(String bucket, Configuration conf) {
        if (!this.s3.doesBucketExist(bucket)) {
            MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
            this.s3.createBucket(bucket, conf.get("fs.s3.buckets.create.region"));
            MetricsSaver.addValue((String)"S3CreateBucketDelay", (long)stopWatch.elapsedTime());
        }
    }

    private CannedAccessControlList getAcl() {
        if (this.conf == null) {
            return null;
        }
        String aclName = this.conf.get("fs.s3.canned.acl");
        CannedAccessControlList acl = null;
        if (aclName != null) {
            try {
                acl = CannedAccessControlList.valueOf((String)aclName);
                return acl;
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("Invalid canned ACL name in fs.s3.canned.acl: " + aclName));
            }
        }
        return null;
    }

    @Override
    public void storeFile(String key, File file, byte[] md5Hash, Progressable progressable) throws IOException {
        ProgressableResettableBufferedFileInputStream in = null;
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        try {
            in = new ProgressableResettableBufferedFileInputStream(file, progressable);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType("binary/octet-stream");
            metadata.setContentLength(file.length());
            if (md5Hash != null) {
                metadata.setContentMD5(new String(Base64.encodeBase64((byte[])md5Hash)));
            }
            PutObjectRequest request = new PutObjectRequest(this.bucket, key, (InputStream)in, metadata);
            CannedAccessControlList acl = this.getAcl();
            if (acl != null) {
                request.setCannedAcl(acl);
            }
            this.s3.putObject(request);
            LOG.info((Object)("s3.putObject " + this.bucket + " " + key + " " + file.length()));
            MetricsSaver.addValue((String)"S3WriteDelay", (long)stopWatch.elapsedTime());
            MetricsSaver.addValue((String)"S3WriteBytes", (long)file.length());
            this.metacache.invalidate((Object)key);
        }
        catch (Exception e) {
            MetricsSaver.addValueWithError((String)"S3WriteDelay", (long)stopWatch.elapsedTime(), (Exception)e);
            throw new RuntimeException("exception in putObject", e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        this.storeFile(key, file, md5Hash, null);
    }

    @Override
    public void storeEmptyFile(String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("binary/octet-stream");
        metadata.setContentLength(0L);
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, (InputStream)new ByteArrayInputStream(new byte[0]), metadata);
        CannedAccessControlList acl = this.getAcl();
        if (acl != null) {
            request.setCannedAcl(acl);
        }
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        this.s3.putObject(request);
        MetricsSaver.addValue((String)"S3WriteDelay", (long)stopWatch.elapsedTime());
        this.metacache.invalidate((Object)key);
    }

    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        try {
            FileMetadata v = (FileMetadata)this.metacache.getIfPresent((Object)key);
            if (v != null) {
                return v;
            }
            MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
            ObjectMetadata metadata = this.s3.getObjectMetadata(this.bucket, key);
            MetricsSaver.addValue((String)"S3ReadDelay", (long)stopWatch.elapsedTime());
            v = new FileMetadata(key, metadata.getContentLength(), metadata.getLastModified().getTime());
            this.metacache.put((Object)key, (Object)v);
            return v;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        try {
            MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
            S3ObjectInputStream stream = this.s3.getObject(this.bucket, key).getObjectContent();
            MetricsSaver.addValue((String)"S3ReadDelay", (long)stopWatch.elapsedTime());
            return stream;
        }
        catch (AmazonServiceException e) {
            this.throwS3Exception(key, e);
            return null;
        }
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        try {
            FileMetadata metadata = this.retrieveMetadata(key);
            if (metadata == null) {
                throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
            }
            S3ObjectInputStream stream = this.s3.getObject(new GetObjectRequest(this.bucket, key).withRange(byteRangeStart, metadata.getLength())).getObjectContent();
            MetricsSaver.addValue((String)"S3ReadDelay", (long)stopWatch.elapsedTime());
            return stream;
        }
        catch (AmazonServiceException e) {
            MetricsSaver.addValueWithError((String)"S3ReadDelay", (long)stopWatch.elapsedTime(), (Exception)((Object)e));
            this.throwS3Exception(key, e);
            return null;
        }
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null, false);
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recurse) throws IOException {
        return this.list(prefix, recurse ? null : "/", maxListingLength, priorLastKey);
    }

    private PartialListing list(String prefix, String delimiter, int maxListingLength, String priorLastKey) throws IOException {
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        ObjectListing listing = this.s3.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withPrefix(prefix).withDelimiter(delimiter).withMaxKeys(Integer.valueOf(maxListingLength)).withMarker(priorLastKey));
        FileMetadata[] fileMetadata = new FileMetadata[listing.getObjectSummaries().size()];
        for (int i = 0; i < fileMetadata.length; ++i) {
            S3ObjectSummary summary = (S3ObjectSummary)listing.getObjectSummaries().get(i);
            fileMetadata[i] = new FileMetadata(summary.getKey(), summary.getSize(), summary.getLastModified().getTime());
        }
        MetricsSaver.addValue((String)"S3ReadDelay", (long)stopWatch.elapsedTime());
        return new PartialListing(listing.getNextMarker(), fileMetadata, listing.getCommonPrefixes().toArray(new String[0]));
    }

    @Override
    public void delete(String key) throws IOException {
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        try {
            this.s3.deleteObject(this.bucket, key);
            MetricsSaver.addValue((String)"S3WriteDelay", (long)stopWatch.elapsedTime());
        }
        catch (AmazonServiceException e) {
            MetricsSaver.addValueWithError((String)"S3WriteDelay", (long)stopWatch.elapsedTime(), (Exception)((Object)e));
            this.throwS3Exception(key, e);
        }
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        try {
            CopyObjectRequest request = new CopyObjectRequest(this.bucket, srcKey, this.bucket, dstKey);
            CannedAccessControlList acl = this.getAcl();
            if (acl != null) {
                request.setCannedAccessControlList(acl);
            }
            this.s3.copyObject(request);
            MetricsSaver.addValue((String)"S3WriteDelay", (long)stopWatch.elapsedTime());
        }
        catch (AmazonServiceException e) {
            MetricsSaver.addValueWithError((String)"S3WriteDelay", (long)stopWatch.elapsedTime(), (Exception)((Object)e));
            this.throwS3Exception(srcKey, e);
        }
    }

    @Override
    public void purge(String prefix) throws IOException {
        ObjectListing listing = this.s3.listObjects(this.bucket, prefix);
        for (S3ObjectSummary object : listing.getObjectSummaries()) {
            this.s3.deleteObject(this.bucket, object.getKey());
        }
    }

    @Override
    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder("S3 Native Filesystem, ");
        sb.append(this.bucket).append("\n");
        ObjectListing listing = this.s3.listObjects(this.bucket);
        for (S3ObjectSummary object : listing.getObjectSummaries()) {
            sb.append(object.getKey()).append("\n");
        }
        System.out.println(sb);
    }

    private void throwS3Exception(String key, AmazonServiceException e) throws IOException {
        if ("NoSuchKey".equals(e.getErrorCode())) {
            throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
        }
        throw e;
    }

    void setS3(AmazonS3 s3) {
        this.s3 = s3;
    }

    @Override
    public NativeFileSystemStore.InputStreamPair retrievePair(String key) throws IOException {
        return this.retrievePair(key, 0L);
    }

    @Override
    public NativeFileSystemStore.InputStreamPair retrievePair(String key, long byteRangeStart) throws IOException {
        MetricsSaver.StopWatch stopWatch = new MetricsSaver.StopWatch();
        try {
            NativeFileSystemStore.InputStreamPair pair = new NativeFileSystemStore.InputStreamPair();
            FileMetadata metadata = this.retrieveMetadata(key);
            if (metadata == null) {
                throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
            }
            S3Object s3Object = metadata.getLength() != 0L ? this.s3.getObject(new GetObjectRequest(this.bucket, key).withRange(byteRangeStart, metadata.getLength())) : this.s3.getObject(this.bucket, key);
            MetricsSaver.addValue((String)"S3ReadDelay", (long)stopWatch.elapsedTime());
            pair.in = s3Object.getObjectContent();
            pair.key = key;
            pair.contentLength = metadata.getLength();
            return pair;
        }
        catch (AmazonServiceException e) {
            MetricsSaver.addValueWithError((String)"S3ReadDelay", (long)stopWatch.elapsedTime(), (Exception)((Object)e));
            this.throwS3Exception(key, e);
            return null;
        }
    }
}

