
    package org.apache.drill.exec.expr.fn.impl.gcast;

    import org.apache.drill.exec.expr.DrillSimpleFunc;
    import org.apache.drill.exec.expr.annotations.FunctionTemplate;
    import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
    import org.apache.drill.exec.expr.annotations.Output;
    import org.apache.drill.exec.expr.annotations.Param;
    import org.apache.drill.exec.expr.holders.*;
    import org.apache.drill.exec.record.RecordBatch;
    import javax.inject.Inject;
    import io.netty.buffer.DrillBuf;

/**
 * This file is generated with Freemarker using the template exec/java-exec/src/main/codegen/templates/CastEmptyStringVarTypesToNullableNumeric.java
 */

@SuppressWarnings("unused")
@FunctionTemplate(name = "castEmptyStringNullableVarCharToNULLABLEINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL, isInternal=true)
public class CastEmptyStringNullableVarCharToNullableInt implements DrillSimpleFunc{

    @Param NullableVarCharHolder in;
    @Output NullableIntHolder out;

    public void setup() {}

    public void eval() {
        if(in.isSet == 0 || in.end == in.start) {
            out.isSet = 0;
        } else {
            out.isSet = 1;
            out.value = org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.varTypesToInt(in.start, in.end, in.buffer);
        }
        }
}

 

