

package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionCostCategory;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the CastStringTypesToDate.java template.
 */
@SuppressWarnings("unused")
@FunctionTemplate(name = "castEmptyStringNullableVarCharToNULLABLEDATE",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    nulls = NullHandling.INTERNAL,
    isInternal = true)
public class GCastNullableVarCharToNullableDate implements DrillSimpleFunc {

  @Param NullableVarCharHolder in;
  @Output NullableDateHolder out;
  
  public void setup() { }

  public void eval() {
    if(in.isSet == 0 || in.end == in.start) {
      out.isSet = 0;
      return;
    }
    out.isSet = 1;


    out.value = org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getDate(in.buffer, in.start, in.end);

  }
}
 
  

