

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareVarBinaryVsVarChar {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsVarCharNullHigh implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsVarCharNullLow implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsNullableVarCharNullHigh implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarBinaryVsNullableVarCharNullLow implements DrillSimpleFunc {

    @Param VarBinaryHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsVarCharNullHigh implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsVarCharNullLow implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsNullableVarCharNullHigh implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarBinaryVsNullableVarCharNullLow implements DrillSimpleFunc {

    @Param NullableVarBinaryHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanVarBinaryVsVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == -1 ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqVarBinaryVsVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp < 1 ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanVarBinaryVsVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == 1 ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqVarBinaryVsVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp > -1 ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsVarBinaryVsVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.equal(
              left.buffer, left.start, left.end, right.buffer, right.start, right.end);

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsVarBinaryVsVarChar implements DrillSimpleFunc {

      @Param VarBinaryHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == 0 ? 0 : 1;

      }
  }

}



