
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
/*
 * This class is generated using freemarker and the ComplexAggrFunctions1.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.MapUtility;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.*;

@SuppressWarnings("unused")

public class AnyValueComplexFunctions {
static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(AnyValueComplexFunctions.class);


@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class ListAnyValue implements DrillAggFunc{
  @Param ListHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class MapAnyValue implements DrillAggFunc{
  @Param MapHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createMap(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedBitAnyValue implements DrillAggFunc{
  @Param RepeatedBitHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedIntAnyValue implements DrillAggFunc{
  @Param RepeatedIntHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedBigIntAnyValue implements DrillAggFunc{
  @Param RepeatedBigIntHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedFloat4AnyValue implements DrillAggFunc{
  @Param RepeatedFloat4Holder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedFloat8AnyValue implements DrillAggFunc{
  @Param RepeatedFloat8Holder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedDateAnyValue implements DrillAggFunc{
  @Param RepeatedDateHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedTimeStampAnyValue implements DrillAggFunc{
  @Param RepeatedTimeStampHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedTimeAnyValue implements DrillAggFunc{
  @Param RepeatedTimeHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedIntervalDayAnyValue implements DrillAggFunc{
  @Param RepeatedIntervalDayHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedIntervalYearAnyValue implements DrillAggFunc{
  @Param RepeatedIntervalYearHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedIntervalAnyValue implements DrillAggFunc{
  @Param RepeatedIntervalHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedVarCharAnyValue implements DrillAggFunc{
  @Param RepeatedVarCharHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedVarBinaryAnyValue implements DrillAggFunc{
  @Param RepeatedVarBinaryHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedListAnyValue implements DrillAggFunc{
  @Param RepeatedListHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createRepeatedMapOrList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
  }
}

@FunctionTemplate(name = "any_value", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class RepeatedMapAnyValue implements DrillAggFunc{
  @Param RepeatedMapHolder inHolder;
  @Workspace BigIntHolder nonNullCount;
  @Output ComplexWriter writer;

  public void setup() {
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
  }

  @Override
  public void add() {
    if (nonNullCount.value == 0) {
      org.apache.drill.exec.expr.fn.impl.MappifyUtility.createRepeatedMapOrList(inHolder.reader, writer, "any_value");
    }
    nonNullCount.value = 1;
  }

  @Override
  public void output() {
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
  }
}
}
