
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

/*
 * This class is generated using freemarker and the DateIntervalAggrFunctions1.java template.
 */

@SuppressWarnings("unused")

public class MaxDateTypeFunctions {

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class DateMax implements DrillAggFunc{

  @Param DateHolder in;
  @Workspace DateHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableDateHolder out;

  public void setup() {
	  value = new DateHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableDateMax implements DrillAggFunc{

  @Param NullableDateHolder in;
  @Workspace DateHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableDateHolder out;

  public void setup() {
	  value = new DateHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeStampMax implements DrillAggFunc{

  @Param TimeStampHolder in;
  @Workspace TimeStampHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableTimeStampHolder out;

  public void setup() {
	  value = new TimeStampHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeStampMax implements DrillAggFunc{

  @Param NullableTimeStampHolder in;
  @Workspace TimeStampHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableTimeStampHolder out;

  public void setup() {
	  value = new TimeStampHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeMax implements DrillAggFunc{

  @Param TimeHolder in;
  @Workspace TimeHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableTimeHolder out;

  public void setup() {
	  value = new TimeHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeMax implements DrillAggFunc{

  @Param NullableTimeHolder in;
  @Workspace TimeHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableTimeHolder out;

  public void setup() {
	  value = new TimeHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalDayMax implements DrillAggFunc{

  @Param IntervalDayHolder in;
  @Workspace BigIntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalDayHolder out;

  public void setup() {
	  value = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    long inMS = (long) in.days * (org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.days = (int) (value.value / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
      out.milliseconds = (int) (value.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalDayMax implements DrillAggFunc{

  @Param NullableIntervalDayHolder in;
  @Workspace BigIntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalDayHolder out;

  public void setup() {
	  value = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    long inMS = (long) in.days * (org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.days = (int) (value.value / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
      out.milliseconds = (int) (value.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalYearMax implements DrillAggFunc{

  @Param IntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalYearHolder out;

  public void setup() {
	  value = new IntervalYearHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalYearMax implements DrillAggFunc{

  @Param NullableIntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalYearHolder out;

  public void setup() {
	  value = new IntervalYearHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalMax implements DrillAggFunc{

  @Param IntervalHolder in;
  @Workspace BigIntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
	  value = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    long inMS = (long) in.months * org.apache.drill.exec.vector.DateUtilities.monthsToMillis+
                       in.days * (org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.months = (int) (value.value / org.apache.drill.exec.vector.DateUtilities.monthsToMillis);
      value.value = value.value % org.apache.drill.exec.vector.DateUtilities.monthsToMillis;
      out.days = (int) (value.value / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
      out.milliseconds = (int) (value.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalMax implements DrillAggFunc{

  @Param NullableIntervalHolder in;
  @Workspace BigIntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
	  value = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    long inMS = (long) in.months * org.apache.drill.exec.vector.DateUtilities.monthsToMillis+
                       in.days * (org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.months = (int) (value.value / org.apache.drill.exec.vector.DateUtilities.monthsToMillis);
      value.value = value.value % org.apache.drill.exec.vector.DateUtilities.monthsToMillis;
      out.days = (int) (value.value / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
      out.milliseconds = (int) (value.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = Long.MIN_VALUE;
  }

 }

}
