
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareBigIntVsBigInt {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareBigIntVsBigIntNullHigh implements DrillSimpleFunc {

    @Param BigIntHolder left;
    @Param BigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareBigIntVsBigIntNullLow implements DrillSimpleFunc {

    @Param BigIntHolder left;
    @Param BigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareBigIntVsNullableBigIntNullHigh implements DrillSimpleFunc {

    @Param BigIntHolder left;
    @Param NullableBigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareBigIntVsNullableBigIntNullLow implements DrillSimpleFunc {

    @Param BigIntHolder left;
    @Param NullableBigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableBigIntVsBigIntNullHigh implements DrillSimpleFunc {

    @Param NullableBigIntHolder left;
    @Param BigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableBigIntVsBigIntNullLow implements DrillSimpleFunc {

    @Param NullableBigIntHolder left;
    @Param BigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableBigIntVsNullableBigIntNullHigh implements DrillSimpleFunc {

    @Param NullableBigIntHolder left;
    @Param NullableBigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableBigIntVsNullableBigIntNullLow implements DrillSimpleFunc {

    @Param NullableBigIntHolder left;
    @Param NullableBigIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanBigIntVsBigInt implements DrillSimpleFunc {

      @Param BigIntHolder left;
      @Param BigIntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) || ( Double.isNaN(left.value) && Double.isNaN(right.value))) {
          out.value=0;
        } else if (Double.isNaN(right.value) && !Double.isNaN(left.value)) {
          out.value = 1;
        } else {
          out.value = left.value < right.value ? 1 : 0;
        }

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqBigIntVsBigInt implements DrillSimpleFunc {

      @Param BigIntHolder left;
      @Param BigIntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(right.value)){
          out.value = 1;
        } else if (!Double.isNaN(right.value) && Double.isNaN(left.value)) {
          out.value = 0;
        } else {
          out.value = left.value <= right.value ? 1 : 0;
        }

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanBigIntVsBigInt implements DrillSimpleFunc {

      @Param BigIntHolder left;
      @Param BigIntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(right.value) || ( Double.isNaN(left.value) && Double.isNaN(right.value))) {
          out.value = 0;
        } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
          out.value = 1;
        } else {
          out.value = left.value > right.value ? 1 : 0;
        }

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqBigIntVsBigInt implements DrillSimpleFunc {

      @Param BigIntHolder left;
      @Param BigIntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value)){
          out.value=1;
        } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 0;
        } else {
          out.value = left.value >= right.value ? 1 : 0;
        }


      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsBigIntVsBigInt implements DrillSimpleFunc {

      @Param BigIntHolder left;
      @Param BigIntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 1;
        } else {
          out.value = left.value == right.value ? 1 : 0;
        }

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsBigIntVsBigInt implements DrillSimpleFunc {

      @Param BigIntHolder left;
      @Param BigIntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 0;
        } else {
          out.value = left.value != right.value ? 1 : 0;
        }

      }
  }

}


 



