/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven.toolchain;

import com.google.protobuf.maven.toolchain.DefaultProtobufToolchain;
import java.io.File;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.RequirementMatcherFactory;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ToolchainFactory.class, hint="protobuf", description="A default factory for 'protobuf' toolchains")
public class DefaultProtobufToolchainFactory
implements ToolchainFactory,
LogEnabled {
    private Logger logger;

    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        Xpp3Dom[] provides;
        if (model == null) {
            return null;
        }
        DefaultProtobufToolchain toolchain = new DefaultProtobufToolchain(model, this.logger);
        Xpp3Dom dom = (Xpp3Dom)model.getConfiguration();
        Xpp3Dom protocExecutable = dom.getChild("protocExecutable");
        if (protocExecutable == null) {
            throw new MisconfiguredToolchainException("Protobuf toolchain without the protocExecutable configuration element.");
        }
        File normal = new File(FileUtils.normalize((String)protocExecutable.getValue()));
        if (!normal.exists()) {
            throw new MisconfiguredToolchainException("Non-existing protoc executable at " + normal.getAbsolutePath());
        }
        toolchain.setProtocExecutable(FileUtils.normalize((String)protocExecutable.getValue()));
        dom = (Xpp3Dom)model.getProvides();
        for (Xpp3Dom provide : provides = dom.getChildren()) {
            String key = provide.getName();
            String value = provide.getValue();
            if (value == null) {
                throw new MisconfiguredToolchainException("Provides token '" + key + "' doesn't have any value configured.");
            }
            if ("version".equals(key)) {
                toolchain.addProvideToken(key, RequirementMatcherFactory.createVersionMatcher((String)value));
                continue;
            }
            toolchain.addProvideToken(key, RequirementMatcherFactory.createExactMatcher((String)value));
        }
        return toolchain;
    }

    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

