/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.maven.AbstractProtocMojo;
import com.google.protobuf.maven.Protoc;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="compile", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public final class ProtocCompileMojo
extends AbstractProtocMojo {
    @Parameter(required=true, defaultValue="${basedir}/src/main/proto")
    private File protoSourceRoot;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/protobuf/java")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-resources/protobuf/descriptor-sets")
    private File descriptorSetOutputDirectory;

    @Override
    protected void addProtocBuilderParameters(Protoc.Builder protocBuilder) {
        super.addProtocBuilderParameters(protocBuilder);
        protocBuilder.setJavaOutputDirectory(this.getOutputDirectory());
    }

    @Override
    protected List<Artifact> getDependencyArtifacts() {
        List compileArtifacts = this.project.getCompileArtifacts();
        return compileArtifacts;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getDescriptorSetOutputDirectory() {
        return this.descriptorSetOutputDirectory;
    }

    @Override
    protected File getProtoSourceRoot() {
        return this.protoSourceRoot;
    }

    @Override
    protected void attachFiles() {
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        this.projectHelper.addResource(this.project, this.protoSourceRoot.getAbsolutePath(), (List)ImmutableList.of((Object)"**/*.proto"), (List)ImmutableList.of());
        this.buildContext.refresh(this.outputDirectory);
    }
}

