/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.maven.ProtocPlugin;
import java.io.File;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Protoc {
    private static final String LOG_PREFIX = "[PROTOC] ";
    private final String executable;
    private final ImmutableSet<File> protoPathElements;
    private final ImmutableSet<File> protoFiles;
    private final File javaOutputDirectory;
    private final ImmutableSet<ProtocPlugin> plugins;
    private final File pluginDirectory;
    private final File cppOutputDirectory;
    private final File pythonOutputDirectory;
    private final File descriptorSetFile;
    private final boolean includeImportsInDescriptorSet;
    private final CommandLineUtils.StringStreamConsumer output;
    private final CommandLineUtils.StringStreamConsumer error;

    private Protoc(String executable, ImmutableSet<File> protoPath, ImmutableSet<File> protoFiles, File javaOutputDirectory, File cppOutputDirectory, File pythonOutputDirectory, File descriptorSetFile, boolean includeImportsInDescriptorSet, ImmutableSet<ProtocPlugin> plugins, File pluginDirectory) {
        this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
        this.protoPathElements = (ImmutableSet)Preconditions.checkNotNull(protoPath, (Object)"protoPath");
        this.protoFiles = (ImmutableSet)Preconditions.checkNotNull(protoFiles, (Object)"protoFiles");
        this.javaOutputDirectory = javaOutputDirectory;
        this.cppOutputDirectory = cppOutputDirectory;
        this.pythonOutputDirectory = pythonOutputDirectory;
        this.descriptorSetFile = descriptorSetFile;
        this.includeImportsInDescriptorSet = includeImportsInDescriptorSet;
        this.plugins = plugins;
        this.pluginDirectory = pluginDirectory;
        this.error = new CommandLineUtils.StringStreamConsumer();
        this.output = new CommandLineUtils.StringStreamConsumer();
    }

    public int execute() throws CommandLineException {
        Commandline cl = new Commandline();
        if (this.pluginDirectory != null) {
            try {
                Properties envVars = cl.getSystemEnvVars();
                String path = envVars.getProperty("PATH");
                cl.addEnvironment("PATH", this.pluginDirectory + File.pathSeparator + path);
            }
            catch (Exception e) {
                throw new CommandLineException("could not get environment variables", (Throwable)e);
            }
        }
        cl.setExecutable(this.executable);
        cl.addArguments((String[])this.buildProtocCommand().toArray((Object[])new String[0]));
        return CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)this.output, (StreamConsumer)this.error);
    }

    public ImmutableList<String> buildProtocCommand() {
        LinkedList command = Lists.newLinkedList();
        for (File protoPathElement : this.protoPathElements) {
            command.add("--proto_path=" + protoPathElement);
        }
        if (this.javaOutputDirectory != null) {
            command.add("--java_out=" + this.javaOutputDirectory);
            for (ProtocPlugin plugin : this.plugins) {
                command.add("--" + plugin.getId() + "_out=" + this.javaOutputDirectory);
            }
        }
        if (this.cppOutputDirectory != null) {
            command.add("--cpp_out=" + this.cppOutputDirectory);
        }
        if (this.pythonOutputDirectory != null) {
            command.add("--python_out=" + this.pythonOutputDirectory);
        }
        for (File protoFile : this.protoFiles) {
            command.add(protoFile.toString());
        }
        if (this.descriptorSetFile != null) {
            command.add("--descriptor_set_out=" + this.descriptorSetFile);
            if (this.includeImportsInDescriptorSet) {
                command.add("--include_imports");
            }
        }
        return ImmutableList.copyOf((Iterable)command);
    }

    public void logExecutionParameters(Log log) {
        if (log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)"[PROTOC] Executable: ");
                log.debug((CharSequence)("[PROTOC]  " + this.executable));
            }
            if (this.protoPathElements != null && !this.protoPathElements.isEmpty()) {
                log.debug((CharSequence)"[PROTOC] Protobuf import paths:");
                for (File protoPathElement : this.protoPathElements) {
                    log.debug((CharSequence)("[PROTOC]  " + protoPathElement));
                }
            }
            if (this.javaOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Java output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.javaOutputDirectory));
                if (this.plugins.size() > 0) {
                    log.debug((CharSequence)"[PROTOC] Plugins for Java output:");
                    for (ProtocPlugin plugin : this.plugins) {
                        log.debug((CharSequence)("[PROTOC]  " + plugin.getId()));
                    }
                }
            }
            if (this.pluginDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Plugin directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.pluginDirectory));
            }
            if (this.cppOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] C++ output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.cppOutputDirectory));
            }
            if (this.pythonOutputDirectory != null) {
                log.debug((CharSequence)"[PROTOC] Python output directory:");
                log.debug((CharSequence)("[PROTOC]  " + this.pythonOutputDirectory));
            }
            if (this.descriptorSetFile != null) {
                log.debug((CharSequence)"[PROTOC] Descriptor set output file:");
                log.debug((CharSequence)("[PROTOC]  " + this.descriptorSetFile));
                log.debug((CharSequence)"[PROTOC] Include imports:");
                log.debug((CharSequence)("[PROTOC]  " + this.includeImportsInDescriptorSet));
            }
            log.debug((CharSequence)"[PROTOC] Protobuf descriptors:");
            for (File protoFile : this.protoFiles) {
                log.debug((CharSequence)("[PROTOC]  " + protoFile));
            }
            ImmutableList<String> cl = this.buildProtocCommand();
            if (cl != null && !cl.isEmpty()) {
                log.debug((CharSequence)"[PROTOC] Command line options:");
                log.debug((CharSequence)(LOG_PREFIX + Joiner.on((char)' ').join(cl)));
            }
        }
    }

    public String getOutput() {
        return this.output.getOutput();
    }

    public String getError() {
        return this.error.getOutput();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Builder {
        private final String executable;
        private final Set<File> protopathElements;
        private final Set<File> protoFiles;
        private final Set<ProtocPlugin> plugins;
        private File pluginDirectory;
        private File javaOutputDirectory;
        private File cppOutputDirectory;
        private File pythonOutputDirectory;
        private File descriptorSetFile;
        private boolean includeImportsInDescriptorSet;

        Builder(String executable) {
            this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
            this.protoFiles = Sets.newHashSet();
            this.protopathElements = Sets.newHashSet();
            this.plugins = Sets.newHashSet();
        }

        public Builder setJavaOutputDirectory(File javaOutputDirectory) {
            this.javaOutputDirectory = (File)Preconditions.checkNotNull((Object)javaOutputDirectory, (Object)"'javaOutputDirectory' is null");
            Preconditions.checkArgument((boolean)javaOutputDirectory.isDirectory(), (Object)("'javaOutputDirectory' is not a directory: " + javaOutputDirectory));
            return this;
        }

        public Builder setCppOutputDirectory(File cppOutputDirectory) {
            this.cppOutputDirectory = (File)Preconditions.checkNotNull((Object)cppOutputDirectory, (Object)"'cppOutputDirectory' is null");
            Preconditions.checkArgument((boolean)cppOutputDirectory.isDirectory(), (Object)("'cppOutputDirectory' is not a directory: " + cppOutputDirectory));
            return this;
        }

        public Builder setPythonOutputDirectory(File pythonOutputDirectory) {
            this.pythonOutputDirectory = (File)Preconditions.checkNotNull((Object)pythonOutputDirectory, (Object)"'pythonOutputDirectory' is null");
            Preconditions.checkArgument((boolean)pythonOutputDirectory.isDirectory(), (Object)("'pythonOutputDirectory' is not a directory: " + pythonOutputDirectory));
            return this;
        }

        public Builder addProtoFile(File protoFile) {
            Preconditions.checkNotNull((Object)protoFile);
            Preconditions.checkArgument((boolean)protoFile.isFile());
            Preconditions.checkArgument((boolean)protoFile.getName().endsWith(".proto"));
            this.checkProtoFileIsInProtopath(protoFile);
            this.protoFiles.add(protoFile);
            return this;
        }

        public Builder addPlugin(ProtocPlugin plugin) {
            Preconditions.checkNotNull((Object)plugin);
            this.plugins.add(plugin);
            return this;
        }

        public Builder setPluginDirectory(File directory) {
            Preconditions.checkNotNull((Object)directory);
            Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)("Plugin directory " + directory + "does not exist"));
            this.pluginDirectory = directory;
            return this;
        }

        public Builder withDescriptorSetFile(File descriptorSetFile, boolean includeImports) {
            Preconditions.checkNotNull((Object)descriptorSetFile, (Object)"descriptorSetFile");
            Preconditions.checkArgument((boolean)descriptorSetFile.getParentFile().isDirectory());
            this.descriptorSetFile = descriptorSetFile;
            this.includeImportsInDescriptorSet = includeImports;
            return this;
        }

        private void checkProtoFileIsInProtopath(File protoFile) {
            assert (protoFile.isFile());
            Preconditions.checkState((boolean)this.checkProtoFileIsInProtopathHelper(protoFile.getParentFile()));
        }

        private boolean checkProtoFileIsInProtopathHelper(File directory) {
            assert (directory.isDirectory());
            if (this.protopathElements.contains(directory)) {
                return true;
            }
            File parentDirectory = directory.getParentFile();
            return parentDirectory != null && this.checkProtoFileIsInProtopathHelper(parentDirectory);
        }

        public Builder addProtoFiles(Iterable<File> protoFiles) {
            for (File protoFile : protoFiles) {
                this.addProtoFile(protoFile);
            }
            return this;
        }

        public Builder addProtoPathElement(File protopathElement) {
            Preconditions.checkNotNull((Object)protopathElement);
            Preconditions.checkArgument((boolean)protopathElement.isDirectory());
            this.protopathElements.add(protopathElement);
            return this;
        }

        public Builder addProtoPathElements(Iterable<File> protopathElements) {
            for (File protopathElement : protopathElements) {
                this.addProtoPathElement(protopathElement);
            }
            return this;
        }

        private void validateState() {
            Preconditions.checkState((!this.protoFiles.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((this.javaOutputDirectory != null || this.cppOutputDirectory != null || this.pythonOutputDirectory != null ? 1 : 0) != 0, (Object)"At least one of these properties must be set: 'javaOutputDirectory', 'cppOutputDirectory' or 'pythonOutputDirectory'");
        }

        public Protoc build() {
            this.validateState();
            return new Protoc(this.executable, ImmutableSet.copyOf(this.protopathElements), ImmutableSet.copyOf(this.protoFiles), this.javaOutputDirectory, this.cppOutputDirectory, this.pythonOutputDirectory, this.descriptorSetFile, this.includeImportsInDescriptorSet, ImmutableSet.copyOf(this.plugins), this.pluginDirectory);
        }
    }
}

