/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.maven;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.maven.Protoc;
import com.google.protobuf.maven.ProtocPlugin;
import com.google.protobuf.maven.ProtocPluginAssembler;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractProtocMojo
extends AbstractMojo {
    private static final String PROTO_FILE_SUFFIX = ".proto";
    private static final String DEFAULT_INCLUDES = "**/*.proto";
    @Component
    protected MavenProject project;
    @Component
    private MavenSession session;
    @Component
    protected BuildContext buildContext;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Parameter(required=true, readonly=true, property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(required=false, defaultValue="${project.build.directory}/protoc-plugins")
    private File protocPluginDirectory;
    @Parameter(required=false, property="protocExecutable")
    private String protocExecutable;
    @Parameter(required=false)
    private File[] additionalProtoPathElements = new File[0];
    @Parameter(required=true, defaultValue="${project.build.directory}/protoc-dependencies")
    private File temporaryProtoFileDirectory;
    @Parameter(required=true, defaultValue="true")
    private boolean hashDependentPaths;
    @Parameter(required=false)
    private Set<String> includes = ImmutableSet.of((Object)"**/*.proto");
    @Parameter(required=false)
    private Set<String> excludes = ImmutableSet.of();
    @Parameter(required=true, defaultValue="${project.build.finalName}.protobin")
    private String descriptorSetFileName;
    @Parameter(required=true, defaultValue="false")
    private boolean writeDescriptorSet;
    @Parameter(required=false, defaultValue="false")
    private boolean includeDependenciesInDescriptorSet;
    @Parameter(required=false)
    private List<ProtocPlugin> protocPlugins;
    @Parameter(required=false, defaultValue="0")
    private long staleMillis;
    @Parameter(required=false, defaultValue="false")
    private boolean checkStaleness;
    @Parameter(required=false, property="protoc.skip", defaultValue="false")
    private boolean skip;
    @Parameter(required=false, property="protoc.force", defaultValue="false")
    private boolean forceMojoExecution;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    AbstractProtocMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        this.checkParameters();
        File protoSourceRoot = this.getProtoSourceRoot();
        if (protoSourceRoot.exists()) {
            try {
                Toolchain tc;
                ImmutableSet<File> protoFiles = this.findProtoFilesInDirectory(protoSourceRoot);
                File outputDirectory = this.getOutputDirectory();
                ImmutableSet<File> outputFiles = AbstractProtocMojo.findGeneratedFilesInDirectory(this.getOutputDirectory());
                if (protoFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No proto files to compile.");
                }
                if (!this.hasDelta(protoFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because build context has no changes.");
                    this.attachFiles();
                }
                if (this.checkStaleness && this.checkFilesUpToDate(protoFiles, outputFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because target directory newer than sources.");
                    this.attachFiles();
                }
                ImmutableSet<File> derivedProtoPathElements = this.makeProtoPathFromJars(this.temporaryProtoFileDirectory, (Iterable<File>)this.getDependencyArtifactFiles());
                FileUtils.mkdir((String)outputDirectory.getAbsolutePath());
                FileUtils.cleanDirectory((File)outputDirectory);
                if (this.writeDescriptorSet) {
                    File descriptorSetOutputDirectory = this.getDescriptorSetOutputDirectory();
                    FileUtils.mkdir((String)descriptorSetOutputDirectory.getAbsolutePath());
                    FileUtils.cleanDirectory((File)descriptorSetOutputDirectory);
                }
                if (this.protocPlugins != null) {
                    this.createProtocPlugins();
                }
                if ((tc = this.toolchainManager.getToolchainFromBuildContext("protobuf", this.session)) != null) {
                    this.getLog().info((CharSequence)("Toolchain in protoc-plugin: " + tc));
                    if (this.protocExecutable != null) {
                        this.getLog().warn((CharSequence)("Toolchains are ignored, 'protocExecutable' parameter is set to " + this.protocExecutable));
                    } else {
                        this.protocExecutable = tc.findTool("protoc");
                    }
                }
                if (this.protocExecutable == null) {
                    this.getLog().warn((CharSequence)"No 'protocExecutable' parameter is configured, using the default: 'protoc'");
                    this.protocExecutable = "protoc";
                }
                Protoc.Builder protocBuilder = new Protoc.Builder(this.protocExecutable).addProtoPathElement(protoSourceRoot).addProtoPathElements((Iterable<File>)derivedProtoPathElements).addProtoPathElements(Arrays.asList(this.additionalProtoPathElements)).addProtoFiles((Iterable<File>)protoFiles);
                this.addProtocBuilderParameters(protocBuilder);
                Protoc protoc = protocBuilder.build();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Proto source root:");
                    this.getLog().debug((CharSequence)(" " + protoSourceRoot));
                    if (derivedProtoPathElements != null && !derivedProtoPathElements.isEmpty()) {
                        this.getLog().debug((CharSequence)"Derived proto paths:");
                        for (File path : derivedProtoPathElements) {
                            this.getLog().debug((CharSequence)(" " + path));
                        }
                    }
                    if (this.additionalProtoPathElements != null && this.additionalProtoPathElements.length > 0) {
                        this.getLog().debug((CharSequence)"Additional proto paths:");
                        for (File path : this.additionalProtoPathElements) {
                            this.getLog().debug((CharSequence)(" " + path));
                        }
                    }
                }
                protoc.logExecutionParameters(this.getLog());
                this.getLog().info((CharSequence)String.format("Compiling %d proto file(s) to %s", protoFiles.size(), outputDirectory));
                int exitStatus = protoc.execute();
                if (exitStatus != 0) {
                    this.getLog().error((CharSequence)("protoc failed output: " + protoc.getOutput()));
                    this.getLog().error((CharSequence)("protoc failed error: " + protoc.getError()));
                    throw new MojoFailureException("protoc did not exit cleanly. Review output for more information.");
                }
                this.attachFiles();
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occured", (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("protoc failed to execute because: " + e.getMessage(), (Throwable)e);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("An error occurred while invoking protoc.", (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)String.format("%s does not exist. Review the configuration or consider disabling the plugin.", protoSourceRoot));
        }
    }

    protected void createProtocPlugins() throws MojoExecutionException {
        String javaHome = this.detectJavaHome();
        for (ProtocPlugin plugin : this.protocPlugins) {
            if (plugin.getJavaHome() != null) {
                this.getLog().debug((CharSequence)("Using javaHome defined in plugin definition: " + javaHome));
            } else {
                this.getLog().debug((CharSequence)("Setting javaHome for plugin: " + javaHome));
                plugin.setJavaHome(javaHome);
            }
            this.getLog().info((CharSequence)("Building protoc plugin: " + plugin.getId()));
            ProtocPluginAssembler assembler = new ProtocPluginAssembler(plugin, this.project.getArtifact(), this.artifactFactory, this.artifactResolver, this.artifactMetadataSource, this.localRepository, this.remoteRepositories, this.protocPluginDirectory, this.getLog());
            assembler.execute();
        }
    }

    protected String detectJavaHome() {
        String javaHome = null;
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (tc != null) {
            if (tc instanceof DefaultJavaToolChain) {
                javaHome = ((DefaultJavaToolChain)tc).getJavaHome();
                if (javaHome != null) {
                    this.getLog().debug((CharSequence)("Using javaHome from toolchain: " + javaHome));
                }
            } else {
                File parent;
                String javaExecutable = tc.findTool("java");
                if (javaExecutable != null && (parent = new File(javaExecutable).getParentFile()) != null && (parent = parent.getParentFile()) != null && parent.isDirectory()) {
                    javaHome = parent.getAbsolutePath();
                    this.getLog().debug((CharSequence)("Using javaHome based on 'java' location returned by toolchain: " + javaHome));
                }
            }
        }
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
            this.getLog().debug((CharSequence)("Using javaHome from java.home system property: " + javaHome));
        }
        return javaHome;
    }

    protected void addProtocBuilderParameters(Protoc.Builder protocBuilder) {
        if (this.protocPlugins != null) {
            for (ProtocPlugin plugin : this.protocPlugins) {
                protocBuilder.addPlugin(plugin);
            }
            this.protocPluginDirectory.mkdirs();
            protocBuilder.setPluginDirectory(this.protocPluginDirectory);
        }
        if (this.writeDescriptorSet) {
            File descriptorSetFile = new File(this.getDescriptorSetOutputDirectory(), this.descriptorSetFileName);
            this.getLog().info((CharSequence)"Will write descriptor set:");
            this.getLog().info((CharSequence)(" " + descriptorSetFile.getAbsolutePath()));
            protocBuilder.withDescriptorSetFile(descriptorSetFile, this.includeDependenciesInDescriptorSet);
        }
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping protoc mojo execution");
            return true;
        }
        if (!this.forceMojoExecution && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping protoc mojo execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    protected static ImmutableSet<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return ImmutableSet.of();
        }
        List javaFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*.java", null);
        return ImmutableSet.copyOf((Iterable)javaFilesInDirectory);
    }

    protected static long lastModified(ImmutableSet<File> files) {
        long result = 0L;
        for (File file : files) {
            result = Math.max(result, file.lastModified());
        }
        return result;
    }

    protected boolean checkFilesUpToDate(ImmutableSet<File> sourceFiles, ImmutableSet<File> targetFiles) {
        return AbstractProtocMojo.lastModified(sourceFiles) + this.staleMillis < AbstractProtocMojo.lastModified(targetFiles);
    }

    protected boolean hasDelta(ImmutableSet<File> files) {
        for (File file : files) {
            if (!this.buildContext.hasDelta(file)) continue;
            return true;
        }
        return false;
    }

    protected void checkParameters() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project");
        Preconditions.checkNotNull((Object)this.projectHelper, (Object)"projectHelper");
        File protoSourceRoot = this.getProtoSourceRoot();
        Preconditions.checkNotNull((Object)protoSourceRoot);
        Preconditions.checkArgument((!protoSourceRoot.isFile() ? 1 : 0) != 0, (Object)"protoSourceRoot is a file, not a directory");
        Preconditions.checkNotNull((Object)this.temporaryProtoFileDirectory, (Object)"temporaryProtoFileDirectory");
        Preconditions.checkState((!this.temporaryProtoFileDirectory.isFile() ? 1 : 0) != 0, (Object)"temporaryProtoFileDirectory is a file, not a directory");
        File outputDirectory = this.getOutputDirectory();
        Preconditions.checkNotNull((Object)outputDirectory);
        Preconditions.checkState((!outputDirectory.isFile() ? 1 : 0) != 0, (Object)"the outputDirectory is a file, not a directory");
    }

    protected abstract File getProtoSourceRoot();

    protected abstract List<Artifact> getDependencyArtifacts();

    protected abstract File getOutputDirectory();

    protected abstract File getDescriptorSetOutputDirectory();

    protected abstract void attachFiles();

    protected ImmutableSet<File> getDependencyArtifactFiles() {
        HashSet dependencyArtifactFiles = Sets.newHashSet();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            dependencyArtifactFiles.add(artifact.getFile());
        }
        return ImmutableSet.copyOf((Iterable)dependencyArtifactFiles);
    }

    protected ImmutableSet<File> makeProtoPathFromJars(File temporaryProtoFileDirectory, Iterable<File> classpathElementFiles) throws IOException, MojoExecutionException {
        Preconditions.checkNotNull(classpathElementFiles, (Object)"classpathElementFiles");
        if (!classpathElementFiles.iterator().hasNext()) {
            return ImmutableSet.of();
        }
        if (temporaryProtoFileDirectory.exists()) {
            FileUtils.cleanDirectory((File)temporaryProtoFileDirectory);
        }
        HashSet protoDirectories = Sets.newHashSet();
        for (File classpathElementFile : classpathElementFiles) {
            List protoFiles;
            if (classpathElementFile.isFile() && classpathElementFile.canRead() && !classpathElementFile.getName().endsWith(".xml")) {
                JarFile classpathJar;
                try {
                    classpathJar = new JarFile(classpathElementFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("%s was not a readable artifact", classpathElementFile), e);
                }
                Enumeration<JarEntry> jarEntries = classpathJar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(PROTO_FILE_SUFFIX)) continue;
                    File jarDirectory = new File(temporaryProtoFileDirectory, this.truncatePath(classpathJar.getName()));
                    File uncompressedCopy = new File(jarDirectory, jarEntryName);
                    FileUtils.mkdir((String)uncompressedCopy.getParentFile().getAbsolutePath());
                    FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(classpathJar.getInputStream(jarEntry)), (File)uncompressedCopy);
                    protoDirectories.add(jarDirectory);
                }
                continue;
            }
            if (!classpathElementFile.isDirectory() || (protoFiles = FileUtils.getFiles((File)classpathElementFile, (String)DEFAULT_INCLUDES, null)).isEmpty()) continue;
            protoDirectories.add(classpathElementFile);
        }
        return ImmutableSet.copyOf((Iterable)protoDirectories);
    }

    protected ImmutableSet<File> findProtoFilesInDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{directory});
        Joiner joiner = Joiner.on((char)',');
        List protoFilesInDirectory = FileUtils.getFiles((File)directory, (String)joiner.join(this.includes), (String)joiner.join(this.excludes));
        return ImmutableSet.copyOf((Iterable)protoFilesInDirectory);
    }

    protected ImmutableSet<File> findProtoFilesInDirectories(Iterable<File> directories) throws IOException {
        Preconditions.checkNotNull(directories);
        HashSet protoFiles = Sets.newHashSet();
        for (File directory : directories) {
            protoFiles.addAll(this.findProtoFilesInDirectory(directory));
        }
        return ImmutableSet.copyOf((Iterable)protoFiles);
    }

    protected String truncatePath(String jarPath) throws MojoExecutionException {
        int colonIndex;
        String path;
        int repositoryIndex;
        if (this.hashDependentPaths) {
            try {
                return AbstractProtocMojo.toHexString(MessageDigest.getInstance("MD5").digest(jarPath.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new MojoExecutionException("Failed to expand dependent jar", (Exception)e);
            }
        }
        String repository = this.localRepository.getBasedir().replace('\\', '/');
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        if ((repositoryIndex = (path = jarPath.replace('\\', '/')).indexOf(repository)) != -1) {
            path = path.substring(repositoryIndex + repository.length());
        }
        if ((colonIndex = path.indexOf(58)) != -1) {
            path = path.substring(colonIndex + 2);
        }
        return path;
    }

    protected static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hexString.toString();
    }
}

