/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc.driver;

import com.cloudera.livy.Job;
import com.cloudera.livy.JobContext;
import com.cloudera.livy.rsc.driver.RSCDriver;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWrapper<T>
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(JobWrapper.class);
    public final String jobId;
    private final RSCDriver driver;
    private final Job<T> job;
    private final AtomicInteger completed;
    private Future<?> future;

    public JobWrapper(RSCDriver driver, String jobId, Job<T> job) {
        this.driver = driver;
        this.jobId = jobId;
        this.job = job;
        this.completed = new AtomicInteger();
    }

    @Override
    public Void call() throws Exception {
        try {
            this.jobStarted();
            Object result = this.job.call((JobContext)this.driver.jobContext());
            this.finished(result, null);
        }
        catch (Throwable t) {
            LOG.info("Failed to run job " + this.jobId, t);
            this.finished(null, t);
            throw new ExecutionException(t);
        }
        finally {
            this.driver.activeJobs.remove(this.jobId);
        }
        return null;
    }

    void submit(ExecutorService executor) {
        this.future = executor.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobDone() {
        AtomicInteger atomicInteger = this.completed;
        synchronized (atomicInteger) {
            this.completed.incrementAndGet();
            this.completed.notifyAll();
        }
    }

    boolean cancel() {
        return this.future != null ? this.future.cancel(true) : true;
    }

    protected void finished(T result, Throwable error) {
        if (error == null) {
            this.driver.jobFinished(this.jobId, result, null);
        } else {
            this.driver.jobFinished(this.jobId, null, error);
        }
    }

    protected void jobStarted() {
        this.driver.jobStarted(this.jobId);
    }
}

