/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.client.http;

import com.cloudera.livy.client.http.HttpConf;
import com.cloudera.livy.shaded.apache.http.HttpEntity;
import com.cloudera.livy.shaded.apache.http.auth.AuthScope;
import com.cloudera.livy.shaded.apache.http.auth.Credentials;
import com.cloudera.livy.shaded.apache.http.client.config.RequestConfig;
import com.cloudera.livy.shaded.apache.http.client.methods.CloseableHttpResponse;
import com.cloudera.livy.shaded.apache.http.client.methods.HttpDelete;
import com.cloudera.livy.shaded.apache.http.client.methods.HttpGet;
import com.cloudera.livy.shaded.apache.http.client.methods.HttpPatch;
import com.cloudera.livy.shaded.apache.http.client.methods.HttpPost;
import com.cloudera.livy.shaded.apache.http.client.methods.HttpPut;
import com.cloudera.livy.shaded.apache.http.client.methods.HttpRequestBase;
import com.cloudera.livy.shaded.apache.http.client.protocol.HttpClientContext;
import com.cloudera.livy.shaded.apache.http.entity.ByteArrayEntity;
import com.cloudera.livy.shaded.apache.http.entity.mime.MultipartEntityBuilder;
import com.cloudera.livy.shaded.apache.http.entity.mime.content.FileBody;
import com.cloudera.livy.shaded.apache.http.impl.NoConnectionReuseStrategy;
import com.cloudera.livy.shaded.apache.http.impl.client.BasicCredentialsProvider;
import com.cloudera.livy.shaded.apache.http.impl.client.CloseableHttpClient;
import com.cloudera.livy.shaded.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.livy.shaded.apache.http.impl.conn.BasicHttpClientConnectionManager;
import com.cloudera.livy.shaded.apache.http.util.EntityUtils;
import com.cloudera.livy.shaded.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.concurrent.TimeUnit;

class LivyConnection {
    static final String SESSIONS_URI = "/sessions";
    private static final String APPLICATION_JSON = "application/json";
    private final URI server;
    private final String uriRoot;
    private final CloseableHttpClient client;
    private final ObjectMapper mapper;

    LivyConnection(URI uri, final HttpConf config) {
        HttpClientContext ctx = HttpClientContext.create();
        int port = uri.getPort() > 0 ? uri.getPort() : 8998;
        String path = uri.getPath() != null ? uri.getPath() : "";
        this.uriRoot = path + SESSIONS_URI;
        RequestConfig reqConfig = new RequestConfig(){

            @Override
            public int getConnectTimeout() {
                return (int)config.getTimeAsMs(HttpConf.Entry.CONNETION_TIMEOUT);
            }

            @Override
            public int getSocketTimeout() {
                return (int)config.getTimeAsMs(HttpConf.Entry.SOCKET_TIMEOUT);
            }

            @Override
            public boolean isAuthenticationEnabled() {
                return true;
            }
        };
        Credentials dummyCredentials = new Credentials(){

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public Principal getUserPrincipal() {
                return null;
            }
        };
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, dummyCredentials);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAutomaticRetries().evictExpiredConnections().evictIdleConnections(config.getTimeAsMs(HttpConf.Entry.CONNECTION_IDLE_TIMEOUT), TimeUnit.MILLISECONDS).setConnectionManager(new BasicHttpClientConnectionManager()).setConnectionReuseStrategy(new NoConnectionReuseStrategy()).setDefaultRequestConfig(reqConfig).setMaxConnTotal(1).setDefaultCredentialsProvider(credsProvider).setUserAgent("livy-client-http");
        this.server = uri;
        this.client = builder.build();
        this.mapper = new ObjectMapper();
    }

    synchronized void close() throws IOException {
        this.client.close();
    }

    synchronized <V> V delete(Class<V> retType, String uri, Object ... uriParams) throws Exception {
        return this.sendJSONRequest(new HttpDelete(), retType, uri, uriParams);
    }

    synchronized <V> V get(Class<V> retType, String uri, Object ... uriParams) throws Exception {
        return this.sendJSONRequest(new HttpGet(), retType, uri, uriParams);
    }

    synchronized <V> V post(Object body, Class<V> retType, String uri, Object ... uriParams) throws Exception {
        HttpPost post = new HttpPost();
        if (body != null) {
            byte[] bodyBytes = this.mapper.writeValueAsBytes(body);
            post.setEntity(new ByteArrayEntity(bodyBytes));
        }
        return this.sendJSONRequest(post, retType, uri, uriParams);
    }

    synchronized <V> V post(File f, Class<V> retType, String paramName, String uri, Object ... uriParams) throws Exception {
        HttpPost post = new HttpPost();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addPart(paramName, new FileBody(f));
        post.setEntity(builder.build());
        return this.sendRequest(post, retType, uri, uriParams);
    }

    private <V> V sendJSONRequest(HttpRequestBase req, Class<V> retType, String uri, Object ... uriParams) throws Exception {
        req.setHeader("Accept", APPLICATION_JSON);
        req.setHeader("Content-Type", APPLICATION_JSON);
        req.setHeader("Content-Encoding", "UTF-8");
        return this.sendRequest(req, retType, uri, uriParams);
    }

    private <V> V sendRequest(HttpRequestBase req, Class<V> retType, String uri, Object ... uriParams) throws Exception {
        req.setURI(new URI(this.server.getScheme(), null, this.server.getHost(), this.server.getPort(), this.uriRoot + String.format(uri, uriParams), null, null));
        if (req instanceof HttpPost || req instanceof HttpDelete || req instanceof HttpPut || req instanceof HttpPatch) {
            req.addHeader("X-Requested-By", "livy");
        }
        Throwable throwable = null;
        try (CloseableHttpResponse res = this.client.execute(req);){
            int status = res.getStatusLine().getStatusCode() / 100 * 100;
            HttpEntity entity = res.getEntity();
            if (status == 200) {
                if (!Void.class.equals(retType)) {
                    V v = this.mapper.readValue(entity.getContent(), retType);
                    return v;
                }
                V v = null;
                return v;
            }
            try {
                String error = EntityUtils.toString(entity);
                throw new IOException(String.format("%s: %s", res.getStatusLine().getReasonPhrase(), error));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

